/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.api;

import java.util.LinkedList;
import java.util.regex.Pattern;
import org.netbeans.modules.parsing.spi.indexing.support.QuerySupport;
import org.netbeans.modules.php.editor.api.PhpElementKind;
import org.netbeans.modules.php.editor.api.QualifiedName;
import org.netbeans.modules.php.editor.api.QualifiedNameKind;
import org.netbeans.modules.php.editor.api.elements.AliasedElement;
import org.netbeans.modules.php.editor.api.elements.FullyQualifiedElement;
import org.netbeans.modules.php.editor.api.elements.PhpElement;
import org.openide.util.Parameters;

public class NameKind {
    private final QualifiedName query;
    private final QuerySupport.Kind queryKind;

    public static Exact forElement(PhpElement element) {
        if (element instanceof FullyQualifiedElement) {
            return new Exact(((FullyQualifiedElement)element).getFullyQualifiedName());
        }
        return new Exact(QualifiedName.create(element.getName()));
    }

    public static Empty empty() {
        return new Empty();
    }

    public static Exact exact(String query) {
        return new Exact(query);
    }

    public static Prefix prefix(String query) {
        return new Prefix(query);
    }

    public static Exact exact(QualifiedName query) {
        return new Exact(query);
    }

    public static Prefix prefix(QualifiedName query) {
        return new Prefix(query);
    }

    public static NameKind create(String query, QuerySupport.Kind queryKind) {
        switch (queryKind) {
            case PREFIX: {
                return new Prefix(query);
            }
            case EXACT: {
                return new Exact(query);
            }
        }
        if (query == null || query.isEmpty()) {
            assert (queryKind.equals((Object)QuerySupport.Kind.PREFIX) || queryKind.equals((Object)QuerySupport.Kind.CASE_INSENSITIVE_PREFIX)) : queryKind.toString();
            return new Empty();
        }
        return new NameKind(query, queryKind);
    }

    public static NameKind create(QualifiedName query, QuerySupport.Kind queryKind) {
        switch (queryKind) {
            case PREFIX: {
                return new Prefix(query);
            }
            case EXACT: {
                return new Exact(query);
            }
        }
        return new NameKind(query, queryKind);
    }

    public boolean isPrefix() {
        return this.getQueryKind().equals((Object)QuerySupport.Kind.PREFIX);
    }

    public boolean isExact() {
        return this.getQueryKind().equals((Object)QuerySupport.Kind.EXACT);
    }

    public boolean isEmpty() {
        return this.getQueryName().isEmpty();
    }

    public boolean matchesName(PhpElementKind elementKind, QualifiedName name) {
        if (name != null && NameKind.nameKindMatch(elementKind, name.getName(), this.queryKind, this.getQueryName())) {
            QualifiedNameKind kindOfQuery = this.getQuery().getKind();
            if (kindOfQuery.isUnqualified()) {
                return true;
            }
            LinkedList<String> nameSegments = name.toNamespaceName().getSegments();
            LinkedList<String> querySegments = this.getQuery().toNamespaceName().getSegments();
            int querySize = querySegments.size();
            int nameSize = nameSegments.size();
            int minSize = Math.min(nameSize, querySize);
            for (int i = 1; i <= minSize; ++i) {
                String queryItem = querySegments.get(querySize - i);
                String nameItem = nameSegments.get(nameSize - i);
                if (nameItem.equalsIgnoreCase(queryItem)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean matchesName(PhpElementKind elementKind, String name) {
        return name != null ? NameKind.nameKindMatch(elementKind, name, this.queryKind, this.getQueryName()) : false;
    }

    public boolean matchesName(PhpElement element) {
        if (element instanceof FullyQualifiedElement) {
            FullyQualifiedElement fqe = (FullyQualifiedElement)element;
            if (fqe instanceof AliasedElement) {
                return this.matchesName(element.getPhpElementKind(), fqe.getFullyQualifiedName()) || this.matchesName(element.getPhpElementKind(), ((AliasedElement)fqe).getFullyQualifiedName(AliasedElement.Trait.ALIAS));
            }
            return this.matchesName(element.getPhpElementKind(), fqe.getFullyQualifiedName());
        }
        return this.matchesName(element.getPhpElementKind(), element.getName());
    }

    public static boolean isCaseSensitive(PhpElementKind elementKind) {
        return NameKind.isDollared(elementKind);
    }

    public static boolean isDollared(PhpElementKind elementKind) {
        return elementKind.equals((Object)PhpElementKind.VARIABLE) || elementKind.equals((Object)PhpElementKind.FIELD);
    }

    NameKind(String name, QuerySupport.Kind kind) {
        this(QualifiedName.create(name), kind);
        Parameters.notNull((CharSequence)"name", (Object)this.query);
    }

    NameKind(QualifiedName name, QuerySupport.Kind kind) {
        this.query = name;
        this.queryKind = kind;
        Parameters.notNull((CharSequence)"name", (Object)this.query);
    }

    public QuerySupport.Kind getQueryKind() {
        return this.queryKind;
    }

    public QualifiedName getQuery() {
        return this.query;
    }

    public String getQueryName() {
        return this.query.getName();
    }

    private static boolean nameKindMatch(PhpElementKind elementKind, String text, QuerySupport.Kind nameKind, String query) {
        boolean forceCaseInsensitivity = !NameKind.isCaseSensitive(elementKind);
        boolean dollared = NameKind.isDollared(elementKind);
        if (dollared) {
            text = NameKind.getName(text, dollared);
            query = NameKind.getName(query, dollared);
        }
        switch (nameKind) {
            case CASE_INSENSITIVE_CAMEL_CASE: {
                return NameKind.camelCaseQueryToPattern(query.toUpperCase(), true).matcher(text).matches();
            }
            case CAMEL_CASE: {
                return NameKind.camelCaseQueryToPattern(query, false).matcher(text).matches();
            }
            case CASE_INSENSITIVE_REGEXP: {
                return Pattern.compile(query, 2).matcher(text).matches();
            }
            case REGEXP: {
                return Pattern.compile(query).matcher(text).matches();
            }
            case CASE_INSENSITIVE_PREFIX: {
                return text.toLowerCase().startsWith(query.toLowerCase());
            }
            case PREFIX: {
                return forceCaseInsensitivity ? text.toLowerCase().startsWith(query.toLowerCase()) : text.startsWith(query);
            }
            case EXACT: {
                return forceCaseInsensitivity ? text.equalsIgnoreCase(query) : text.equals(query);
            }
        }
        return false;
    }

    private static String getName(String name, boolean dollared) {
        boolean startsWithDollar = NameKind.isDollared(name);
        if (startsWithDollar == dollared) {
            return name;
        }
        return dollared ? String.format("%s%s", "$", name) : name.substring(1);
    }

    private static boolean isDollared(String name) {
        return name.startsWith("$");
    }

    private static Pattern camelCaseQueryToPattern(String query, boolean isCaseInsensitive) {
        StringBuilder sb = new StringBuilder();
        char[] chars = query.toCharArray();
        boolean incamel = false;
        if (!query.startsWith("$")) {
            sb.append("[$]*");
        }
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] == '?') {
                sb.append('.');
                continue;
            }
            if (chars[i] == '*') {
                sb.append(".*");
                continue;
            }
            if (Character.isUpperCase(chars[i])) {
                if (incamel) {
                    sb.append("[a-z0-9_]*");
                }
                sb.append(chars[i]);
                incamel = true;
                continue;
            }
            if (i == 0 && chars[i] == '$') {
                sb.append('\\').append(chars[i]);
                continue;
            }
            sb.append(Pattern.quote(String.valueOf(chars[i])));
        }
        sb.append(".*");
        String patternString = sb.toString();
        patternString = patternString.replaceAll(Pattern.quote(".."), ".");
        return isCaseInsensitive ? Pattern.compile(patternString, 2) : Pattern.compile(patternString);
    }

    public static final class Empty
    extends NameKind {
        private Empty() {
            super("", QuerySupport.Kind.PREFIX);
        }
    }

    public static final class Prefix
    extends NameKind {
        private Prefix(String name) {
            super(name, QuerySupport.Kind.PREFIX);
        }

        private Prefix(QualifiedName name) {
            super(name, QuerySupport.Kind.PREFIX);
        }
    }

    public static final class Exact
    extends NameKind {
        private Exact(String name) {
            super(name, QuerySupport.Kind.EXACT);
            Parameters.notWhitespace((CharSequence)"String name: can't be null or empty", (CharSequence)name);
        }

        private Exact(QualifiedName name) {
            super(name, QuerySupport.Kind.EXACT);
        }
    }
}

