/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.classview.model;

import java.awt.Image;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.classview.Diagnostic;
import org.netbeans.modules.cnd.classview.model.BaseNode;
import org.netbeans.modules.cnd.classview.model.NPNode;
import org.netbeans.modules.cnd.modelutil.CsmImageLoader;
import org.openide.nodes.Children;
import org.openide.util.Utilities;
import org.openide.util.actions.NodeAction;
import org.openide.util.lookup.Lookups;

public class ProjectNode
extends NPNode {
    public static final boolean EXPORT = Boolean.getBoolean("cnd.classview.export");
    protected static final boolean TEST_XREF = Boolean.getBoolean("test.xref.action");
    private boolean isLibrary;
    private CsmProject project;

    public ProjectNode(CsmProject project, Children.Array key) {
        super(key, Lookups.fixed((Object[])new Object[]{project}));
        this.project = project;
        this.isLibrary = project.isArtificial();
        this.init(project);
    }

    private void init(CsmProject project) {
        this.setName(((Object)project.getName()).toString());
        this.setDisplayName(project.getDisplayName());
    }

    public String getHtmlDisplayName() {
        return this.getProject().getHtmlDisplayName();
    }

    @Override
    protected CsmNamespace getNamespace() {
        CsmProject prj = this.getProject();
        if (prj != null) {
            return prj.getGlobalNamespace();
        }
        return null;
    }

    public Image getIcon(int param) {
        return CsmImageLoader.getProjectImage((boolean)this.isLibrary, (boolean)false);
    }

    public Image getOpenedIcon(int param) {
        return CsmImageLoader.getProjectImage((boolean)this.isLibrary, (boolean)true);
    }

    public CsmProject getProject() {
        return this.project;
    }

    public Action getPreferredAction() {
        if (Diagnostic.DEBUG) {
            return new TraverseAction();
        }
        if (EXPORT) {
            return new ExportAction();
        }
        return super.getPreferredAction();
    }

    public Action[] getActions(boolean context) {
        List list = Utilities.actionsForPath((String)"NativeProjects/Actions");
        ArrayList<AbstractAction> res = new ArrayList<AbstractAction>();
        for (Action action : list) {
            if (!(action instanceof NodeAction)) continue;
            NodeAction nodeAction = (NodeAction)action;
            if ("org.netbeans.modules.cnd.highlight.error.includes.FailedIncludesAction".equals(action.getClass().getName())) {
                res.add(new NodeActionImpl(nodeAction, this));
                continue;
            }
            if (!TEST_XREF) continue;
            res.add(new NodeActionImpl(nodeAction, this));
        }
        if (Diagnostic.DEBUG || EXPORT) {
            res.add(new TraverseAction());
            res.add(new ExportAction());
        }
        return res.toArray(new Action[res.size()]);
    }

    private static class NodeActionImpl
    extends AbstractAction {
        private final NodeAction na;
        private final ProjectNode node;

        public NodeActionImpl(NodeAction na, ProjectNode node) {
            this.na = na;
            this.node = node;
        }

        @Override
        public Object getValue(String key) {
            if ("Name".equals(key)) {
                return this.na.getName();
            }
            return null;
        }

        @Override
        public boolean isEnabled() {
            return this.na.createContextAwareInstance(Lookups.fixed((Object[])new Object[]{this.node})).isEnabled();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.na.createContextAwareInstance(Lookups.fixed((Object[])new Object[]{this.node})).actionPerformed(e);
        }
    }

    private class ExportAction
    extends AbstractAction {
        public ExportAction() {
            this.putValue("Name", "Export project node.");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ProjectNode.this.dump(System.out);
        }
    }

    private class TraverseAction
    extends AbstractAction {
        private Map<BaseNode, BaseNode> map;

        public TraverseAction() {
            this.putValue("Name", "Measure traverse project node time and memory.");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.map = new HashMap<BaseNode, BaseNode>();
            System.gc();
            long time = System.currentTimeMillis();
            long mem = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
            String message = "Creating a map.";
            if (Diagnostic.DEBUG) {
                Diagnostic.trace(message);
            } else {
                System.out.println(message);
            }
            ProjectNode.this.traverse(new BaseNode.Callback(){

                @Override
                public void call(BaseNode node) {
                    TraverseAction.this.map.put(node, node);
                }
            });
            time = System.currentTimeMillis() - time;
            System.gc();
            mem = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory() - mem;
            message = "A map is created. Used time: " + time + " Used Memory: " + mem / 1024L + " Kb";
            if (Diagnostic.DEBUG) {
                Diagnostic.trace(message);
            } else {
                System.out.println(message);
            }
            this.map = null;
        }

        public String getName() {
            return (String)this.getValue("Name");
        }
    }
}

