/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.faces.model.DataModel;
import org.primefaces.model.TreeNode;

public class TreeTableModel
extends DataModel
implements Serializable {
    private String SEPARATOR = "_";
    private Object wrappedData = null;
    private int rowIndex = -1;
    private TreeNode root;
    private List<TreeNode> list;

    public TreeTableModel() {
    }

    public TreeTableModel(TreeNode root) {
        this.wrappedData = root;
        this.root = root;
        this.list = new ArrayList<TreeNode>();
        this.index(this.root);
    }

    private void index(TreeNode node) {
        if (node.getParent() != null) {
            this.list.add(node);
        }
        for (TreeNode child : node.getChildren()) {
            this.index(child);
        }
    }

    public int getRowCount() {
        return this.list.size();
    }

    public Object getRowData() {
        if (this.list == null) {
            return null;
        }
        if (!this.isRowAvailable()) {
            throw new IllegalArgumentException();
        }
        return this.list.get(this.rowIndex).getData();
    }

    public TreeNode getRowNode() {
        if (this.list == null) {
            return null;
        }
        if (!this.isRowAvailable()) {
            throw new IllegalArgumentException();
        }
        return this.list.get(this.rowIndex);
    }

    public int getRowIndex() {
        return this.rowIndex;
    }

    public Object getWrappedData() {
        return this.wrappedData;
    }

    public boolean isRowAvailable() {
        return this.rowIndex >= 0 && this.rowIndex < this.list.size();
    }

    public void setRowIndex(int rowIndex) {
        this.rowIndex = rowIndex;
    }

    public void setWrappedData(Object wrappedData) {
        this.wrappedData = wrappedData;
    }

    public int getNodeIndex(TreeNode node) {
        return this.list.indexOf(node);
    }

    public TreeNode findTreeNode(String path) {
        String[] paths = path.split(this.SEPARATOR);
        if (paths.length == 0) {
            return null;
        }
        int currentIndex = Integer.parseInt(paths[0]);
        this.setRowIndex(currentIndex);
        TreeNode currentNode = (TreeNode)this.getWrappedData();
        if (paths.length == 1) {
            return currentNode;
        }
        String childPath = this.buildSubpath(paths);
        return this.findTreeNode(childPath);
    }

    private String buildSubpath(String[] path) {
        StringBuffer pathBuffer = new StringBuffer();
        for (int i = 1; i < path.length; ++i) {
            pathBuffer.append(path[i]);
            if (i == path.length - 1) continue;
            pathBuffer.append(this.SEPARATOR);
        }
        return pathBuffer.toString();
    }
}

