/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.panel;

import java.io.IOException;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.menu.Menu;
import org.primefaces.component.panel.Panel;
import org.primefaces.event.CloseEvent;
import org.primefaces.event.ToggleEvent;
import org.primefaces.model.Visibility;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.ComponentUtils;

public class PanelRenderer
extends CoreRenderer {
    public void decode(FacesContext context, UIComponent component) {
        String visibleParam;
        Panel panel = (Panel)component;
        String clientId = panel.getClientId(context);
        Map params = context.getExternalContext().getRequestParameterMap();
        String collapsedParam = (String)params.get(clientId + "_collapsed");
        if (collapsedParam != null) {
            panel.setCollapsed(Boolean.valueOf(collapsedParam));
        }
        if ((visibleParam = (String)params.get(clientId + "_visible")) != null) {
            panel.setVisible(Boolean.valueOf(visibleParam));
        }
        if (params.containsKey(clientId)) {
            if (params.containsKey(clientId + "_ajaxToggle")) {
                Visibility visibility = panel.isCollapsed() ? Visibility.HIDDEN : Visibility.VISIBLE;
                panel.queueEvent(new ToggleEvent((UIComponent)panel, visibility));
            }
            if (params.containsKey(clientId + "_ajaxClose")) {
                panel.setVisible(false);
                panel.queueEvent(new CloseEvent((UIComponent)panel));
            }
        }
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        Panel panel = (Panel)component;
        this.encodeMarkup(facesContext, panel);
        this.encodeScript(facesContext, panel);
    }

    protected void encodeScript(FacesContext context, Panel panel) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = panel.getClientId(context);
        writer.startElement("script", null);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.write(panel.resolveWidgetVar() + " = new PrimeFaces.widget.Panel('" + clientId + "', {");
        writer.write("visible:" + panel.isVisible());
        if (panel.isToggleable()) {
            writer.write(",toggleable:true");
            writer.write(",toggleSpeed:" + panel.getToggleSpeed());
            writer.write(",collapsed:" + panel.isCollapsed());
            if (panel.getToggleListener() != null) {
                writer.write(",ajaxToggle:true");
                if (panel.getOnToggleUpdate() != null) {
                    writer.write(",onToggleUpdate:'" + ComponentUtils.findClientIds(context, (UIComponent)panel, panel.getOnToggleUpdate()) + "'");
                }
            }
        }
        if (panel.isClosable()) {
            writer.write(",closable:true");
            writer.write(",closeSpeed:" + panel.getCloseSpeed());
            if (panel.getOnCloseStart() != null) {
                writer.write(",onCloseStart:" + panel.getOnCloseStart());
            }
            if (panel.getOnCloseComplete() != null) {
                writer.write(",onCloseComplete:" + panel.getOnCloseComplete());
            }
            if (panel.getCloseListener() != null) {
                writer.write(",ajaxClose:true");
                if (panel.getOnCloseUpdate() != null) {
                    writer.write(",onCloseUpdate:'" + ComponentUtils.findClientIds(context, (UIComponent)panel, panel.getOnCloseUpdate()) + "'");
                }
            }
        }
        if (panel.getToggleListener() != null || panel.getCloseListener() != null) {
            writer.write(",url:'" + this.getActionURL(context) + "'");
        }
        if (panel.getOptionsMenu() != null) {
            writer.write(",hasMenu:true");
        }
        writer.write("});");
        writer.endElement("script");
    }

    protected void encodeMarkup(FacesContext context, Panel panel) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = panel.getClientId(context);
        Menu optionsMenu = panel.getOptionsMenu();
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)clientId, null);
        String styleClass = panel.getStyleClass() != null ? "ui-panel ui-widget ui-widget-content ui-corner-all " + panel.getStyleClass() : "ui-panel ui-widget ui-widget-content ui-corner-all";
        writer.writeAttribute("class", (Object)styleClass, "styleClass");
        if (panel.getStyle() != null) {
            writer.writeAttribute("style", (Object)panel.getStyle(), "style");
        }
        this.encodeHeader(context, panel);
        this.encodeContent(context, panel);
        this.encodeFooter(context, panel);
        if (panel.isToggleable()) {
            this.encodeStateHolder(context, panel, clientId + "_collapsed", String.valueOf(panel.isCollapsed()));
        }
        if (panel.isClosable()) {
            this.encodeStateHolder(context, panel, clientId + "_visible", String.valueOf(panel.isVisible()));
        }
        if (optionsMenu != null) {
            optionsMenu.setPosition("dynamic");
            optionsMenu.setTrigger(clientId + "_menu");
            optionsMenu.setMy("left top");
            optionsMenu.setAt("left bottom");
            optionsMenu.encodeAll(context);
        }
        writer.endElement("div");
    }

    protected void encodeHeader(FacesContext context, Panel panel) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String widgetVar = panel.resolveWidgetVar();
        UIComponent header = panel.getFacet("header");
        String headerText = panel.getHeader();
        String clientId = panel.getClientId(context);
        if (headerText == null && header == null) {
            return;
        }
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)(panel.getClientId(context) + "_header"), null);
        writer.writeAttribute("class", (Object)"ui-panel-titlebar ui-widget-header ui-corner-all", null);
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)"ui-panel-title", null);
        if (header != null) {
            this.renderChild(context, header);
        } else if (headerText != null) {
            writer.write(headerText);
        }
        writer.endElement("span");
        if (panel.isClosable()) {
            this.encodeIcon(context, panel, "ui-icon-closethick", clientId + "_closer");
        }
        if (panel.isToggleable()) {
            String icon = panel.isCollapsed() ? "ui-icon-plusthick" : "ui-icon-minusthick";
            this.encodeIcon(context, panel, icon, clientId + "_toggler");
        }
        if (panel.getOptionsMenu() != null) {
            this.encodeIcon(context, panel, "ui-icon-gear", clientId + "_menu");
        }
        writer.endElement("div");
    }

    protected void encodeContent(FacesContext facesContext, Panel panel) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)(panel.getClientId() + "_content"), null);
        writer.writeAttribute("class", (Object)"ui-panel-content ui-widget-content", null);
        if (panel.isCollapsed()) {
            writer.writeAttribute("style", (Object)"display:none", null);
        }
        this.renderChildren(facesContext, (UIComponent)panel);
        writer.endElement("div");
    }

    protected void encodeFooter(FacesContext facesContext, Panel panel) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        UIComponent footer = panel.getFacet("footer");
        String footerText = panel.getFooter();
        if (footer != null || footerText != null) {
            writer.startElement("div", null);
            writer.writeAttribute("id", (Object)(panel.getClientId(facesContext) + "_footer"), null);
            writer.writeAttribute("class", (Object)"ui-panel-footer ui-widget-content", null);
            if (footer != null) {
                this.renderChild(facesContext, footer);
            } else if (footerText != null) {
                writer.write(footerText);
            }
            writer.endElement("div");
        }
    }

    protected void encodeIcon(FacesContext context, Panel panel, String iconClass, String id) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("a", null);
        writer.writeAttribute("href", (Object)"javascript:void(0)", null);
        writer.writeAttribute("class", (Object)"ui-panel-titlebar-icon ui-corner-all ui-state-default", null);
        writer.startElement("span", null);
        if (id != null) {
            writer.writeAttribute("id", (Object)id, null);
        }
        writer.writeAttribute("class", (Object)("ui-icon " + iconClass), null);
        writer.endElement("span");
        writer.endElement("a");
    }

    protected void encodeStateHolder(FacesContext context, Panel panel, String name, String value) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("input", null);
        writer.writeAttribute("type", (Object)"hidden", null);
        writer.writeAttribute("id", (Object)name, null);
        writer.writeAttribute("name", (Object)name, null);
        writer.writeAttribute("value", (Object)value, null);
        writer.endElement("input");
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }
}

