/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.dnd;

import java.io.IOException;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIData;
import javax.faces.component.UINamingContainer;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.dnd.Droppable;
import org.primefaces.event.DragDropEvent;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.ComponentUtils;

public class DroppableRenderer
extends CoreRenderer {
    public void decode(FacesContext context, UIComponent component) {
        Map params = context.getExternalContext().getRequestParameterMap();
        Droppable droppable = (Droppable)component;
        String clientId = droppable.getClientId(context);
        String datasourceId = droppable.getDatasource();
        if (params.containsKey(clientId)) {
            String dragId = (String)params.get(clientId + "_dragId");
            String dropId = (String)params.get(clientId + "_dropId");
            DragDropEvent event = null;
            if (datasourceId != null) {
                UIData datasource = this.findDatasource(context, droppable, datasourceId);
                String[] idTokens = dragId.split(String.valueOf(UINamingContainer.getSeparatorChar((FacesContext)context)));
                int rowIndex = Integer.parseInt(idTokens[idTokens.length - 2]);
                datasource.setRowIndex(rowIndex);
                Object data = datasource.getRowData();
                datasource.setRowIndex(-1);
                event = new DragDropEvent((UIComponent)droppable, dragId, dropId, data);
            } else {
                event = new DragDropEvent((UIComponent)droppable, dragId, dropId);
            }
            droppable.queueEvent(event);
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        Droppable droppable = (Droppable)component;
        String target = this.findTarget(context, droppable).getClientId(context);
        String clientId = droppable.getClientId(context);
        String onDropUpdate = droppable.getOnDropUpdate();
        writer.startElement("script", (UIComponent)droppable);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.write(droppable.resolveWidgetVar() + " = new PrimeFaces.widget.Droppable('" + clientId + "', {");
        writer.write("target:'" + target + "'");
        if (droppable.isDisabled()) {
            writer.write(",disabled:true");
        }
        if (droppable.getHoverStyleClass() != null) {
            writer.write(",hoverClass:'" + droppable.getHoverStyleClass() + "'");
        }
        if (droppable.getActiveStyleClass() != null) {
            writer.write(",activeClass:'" + droppable.getActiveStyleClass() + "'");
        }
        if (droppable.getOnDrop() != null) {
            writer.write(",onDrop:" + droppable.getOnDrop());
        }
        if (droppable.getAccept() != null) {
            writer.write(",accept:'" + droppable.getAccept() + "'");
        }
        if (droppable.getScope() != null) {
            writer.write(",scope:'" + droppable.getScope() + "'");
        }
        if (droppable.getTolerance() != null) {
            writer.write(",tolerance:'" + droppable.getTolerance() + "'");
        }
        if (droppable.getDropListener() != null && onDropUpdate != null) {
            UIComponent form = ComponentUtils.findParentForm(context, (UIComponent)droppable);
            if (form == null) {
                throw new FacesException("Droppable: '" + clientId + "' must be inside a form");
            }
            writer.write(",ajaxDrop:true");
            writer.write(",url:'" + this.getActionURL(context) + "'");
            writer.write(",formId:'" + form.getClientId(context) + "'");
            if (onDropUpdate != null) {
                writer.write(",onDropUpdate:'" + ComponentUtils.findClientIds(context, (UIComponent)droppable, onDropUpdate) + "'");
            }
        }
        writer.write("});");
        writer.endElement("script");
    }

    protected UIComponent findTarget(FacesContext facesContext, Droppable droppable) {
        String _for = droppable.getFor();
        if (_for != null) {
            UIComponent component = droppable.findComponent(_for);
            if (component == null) {
                throw new FacesException("Cannot find component \"" + _for + "\" in view.");
            }
            return component;
        }
        return droppable.getParent();
    }

    protected UIData findDatasource(FacesContext context, Droppable droppable, String datasourceId) {
        UIComponent datasource = droppable.findComponent(datasourceId);
        if (datasource == null) {
            throw new FacesException("Cannot find component \"" + datasourceId + "\" in view.");
        }
        return (UIData)datasource;
    }
}

