/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.carousel;

import java.io.IOException;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.carousel.Carousel;
import org.primefaces.renderkit.CoreRenderer;

public class CarouselRenderer
extends CoreRenderer {
    public void decode(FacesContext facesContext, UIComponent component) {
        Carousel carousel;
        String clientId;
        String firstParam;
        Map params = facesContext.getExternalContext().getRequestParameterMap();
        if (params.containsKey(firstParam = (clientId = (carousel = (Carousel)component).getClientId(facesContext)) + "_first")) {
            carousel.setFirst(Integer.parseInt((String)params.get(firstParam)));
        }
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        Carousel carousel = (Carousel)component;
        this.encodeMarkup(facesContext, carousel);
        this.encodeScript(facesContext, carousel);
    }

    private void encodeScript(FacesContext facesContext, Carousel carousel) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = carousel.getClientId(facesContext);
        String widgetVar = carousel.resolveWidgetVar();
        writer.startElement("script", null);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.write(widgetVar + " = new PrimeFaces.widget.Carousel('" + clientId + "', {");
        writer.write("isCircular:" + carousel.isCircular());
        if (carousel.getFirst() != 0) {
            writer.write(",firstVisible:" + carousel.getFirst());
        }
        if (carousel.isVertical()) {
            writer.write(",isVertical:" + carousel.isVertical());
        }
        if (carousel.getRows() != 0) {
            writer.write(",numVisible:" + carousel.getRows());
        }
        if (carousel.getAutoPlayInterval() != 0) {
            writer.write(",autoPlayInterval:" + carousel.getAutoPlayInterval());
        }
        if (carousel.getScrollIncrement() != 1) {
            writer.write(",scrollIncrement:" + carousel.getScrollIncrement());
        }
        if (carousel.getRevealAmount() != 0) {
            writer.write(",revealAmount:" + carousel.getRevealAmount());
        }
        if (carousel.getPagerPrefix() != null) {
            writer.write(",pagerPrefixText:'" + carousel.getPagerPrefix() + "'");
        }
        if (carousel.isAnimate()) {
            writer.write(",animation:{speed:" + carousel.getSpeed());
            if (carousel.getEffect() != null) {
                writer.write(",effect:YAHOO.util.Easing." + carousel.getEffect());
            }
            writer.write("}");
        }
        writer.write("});");
        if (carousel.isCircular() && carousel.getAutoPlayInterval() != 0) {
            writer.write(widgetVar + ".startAutoPlay();");
        }
        writer.endElement("script");
    }

    protected void encodeMarkup(FacesContext facesContext, Carousel carousel) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = carousel.getClientId(facesContext);
        String itemStyleClass = "ui-widget-content ui-corner-all";
        if (carousel.getItemStyleClass() != null) {
            itemStyleClass = itemStyleClass + " " + carousel.getItemStyleClass();
        }
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)clientId, null);
        if (carousel.getStyle() != null) {
            writer.writeAttribute("style", (Object)carousel.getStyle(), "style");
        }
        if (carousel.getStyleClass() != null) {
            writer.writeAttribute("class", (Object)carousel.getStyleClass(), "styleClass");
        }
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)(clientId + "_container"), null);
        writer.startElement("ol", null);
        if (carousel.getVar() != null) {
            carousel.setRowIndex(-1);
            for (int i = 0; i < carousel.getRowCount(); ++i) {
                carousel.setRowIndex(i);
                writer.startElement("li", null);
                writer.writeAttribute("class", (Object)itemStyleClass, "itemStyleClass");
                if (carousel.getItemStyle() != null) {
                    writer.writeAttribute("style", (Object)carousel.getItemStyle(), "itemStyle");
                }
                this.renderChildren(facesContext, (UIComponent)carousel);
                writer.endElement("li");
            }
            carousel.setRowIndex(-1);
        } else {
            for (UIComponent kid : carousel.getChildren()) {
                writer.startElement("li", null);
                writer.writeAttribute("class", (Object)itemStyleClass, "itemStyleClass");
                if (carousel.getItemStyle() != null) {
                    writer.writeAttribute("style", (Object)carousel.getItemStyle(), "itemStyle");
                }
                this.renderChild(facesContext, kid);
                writer.endElement("li");
            }
        }
        writer.endElement("ol");
        writer.endElement("div");
        this.encodeHiddenStateField(facesContext, clientId + "_first", String.valueOf(carousel.getFirst()));
        writer.endElement("div");
    }

    private void encodeHiddenStateField(FacesContext facesContext, String id, String value) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.startElement("input", null);
        writer.writeAttribute("id", (Object)id, null);
        writer.writeAttribute("name", (Object)id, null);
        writer.writeAttribute("type", (Object)"hidden", null);
        writer.writeAttribute("value", (Object)value, null);
        writer.endElement("input");
    }

    public boolean getRendersChildren() {
        return true;
    }

    public void encodeChildren(FacesContext facesContext, UIComponent component) throws IOException {
    }
}

