/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.breadcrumb;

import java.io.IOException;
import java.util.Iterator;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.breadcrumb.BreadCrumb;
import org.primefaces.component.menuitem.MenuItem;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.ComponentUtils;

public class BreadCrumbRenderer
extends CoreRenderer {
    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        BreadCrumb breadCrumb = (BreadCrumb)component;
        if (breadCrumb.shouldBuildFromModel()) {
            breadCrumb.buildMenuFromModel();
        }
        this.encodeMarkup(facesContext, breadCrumb);
        this.encodeScript(facesContext, breadCrumb);
    }

    protected void encodeScript(FacesContext facesContext, BreadCrumb breadCrumb) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = breadCrumb.getClientId(facesContext);
        writer.startElement("script", null);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.write("jQuery(PrimeFaces.escapeClientId('" + clientId + "')).jBreadCrumb({");
        writer.write("overlayClass:'ui-breadcrumb-chevron-overlay ui-icon ui-icon-triangle-1-e'");
        if (!breadCrumb.isPreview()) {
            int childCount = breadCrumb.getChildCount();
            writer.write(",endElementsToLeaveOpen:" + childCount);
            writer.write(",beginingElementsToLeaveOpen:" + childCount);
        } else {
            if (breadCrumb.getExpandedEndItems() != 1) {
                writer.write(",endElementsToLeaveOpen:" + breadCrumb.getExpandedEndItems());
            }
            if (breadCrumb.getExpandedBeginningItems() != 1) {
                writer.write(",beginingElementsToLeaveOpen:" + breadCrumb.getExpandedBeginningItems());
            }
        }
        if (breadCrumb.getPreviewWidth() != 5) {
            writer.write(",previewWidth:" + breadCrumb.getPreviewWidth());
        }
        if (breadCrumb.getExpandEffectDuration() != 800) {
            writer.write(",timeExpansionAnimation:" + breadCrumb.getExpandEffectDuration());
        }
        if (breadCrumb.getCollapseEffectDuration() != 500) {
            writer.write(",timeCompressionAnimation:" + breadCrumb.getCollapseEffectDuration());
        }
        if (breadCrumb.getInitialCollapseEffectDuration() != 600) {
            writer.write(",timeInitialCollapse:" + breadCrumb.getInitialCollapseEffectDuration());
        }
        writer.write("});");
        writer.endElement("script");
    }

    protected void encodeMarkup(FacesContext facesContext, BreadCrumb breadCrumb) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = breadCrumb.getClientId(facesContext);
        String defaultStyleClass = "ui-breadcrumb ui-module ui-widget ui-widget-header ui-corner-all";
        String styleClass = breadCrumb.getStyleClass() == null ? defaultStyleClass : defaultStyleClass + " " + breadCrumb.getStyleClass();
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.writeAttribute("class", (Object)styleClass, null);
        if (breadCrumb.getStyle() != null) {
            writer.writeAttribute("style", (Object)breadCrumb.getStyle(), null);
        }
        writer.startElement("ul", null);
        Iterator iterator = breadCrumb.getChildren().iterator();
        while (iterator.hasNext()) {
            UIComponent child = (UIComponent)iterator.next();
            if (!child.isRendered() || !(child instanceof MenuItem)) continue;
            writer.startElement("li", null);
            this.encodeMenuItem(facesContext, (MenuItem)child);
            if (iterator.hasNext()) {
                writer.startElement("span", null);
                writer.writeAttribute("class", (Object)"ui-breadcrumb-chevron ui-icon ui-icon-triangle-1-e", null);
                writer.endElement("span");
            }
            writer.endElement("li");
        }
        writer.endElement("ul");
        writer.endElement("div");
    }

    protected void encodeMenuItem(FacesContext facesContext, MenuItem menuItem) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        if (menuItem.shouldRenderChildren()) {
            this.renderChildren(facesContext, (UIComponent)menuItem);
        } else {
            String clientId = menuItem.getClientId(facesContext);
            writer.startElement("a", null);
            writer.writeAttribute("id", (Object)clientId, null);
            if (menuItem.getStyle() != null) {
                writer.writeAttribute("style", (Object)menuItem.getStyle(), null);
            }
            if (menuItem.getStyleClass() != null) {
                writer.writeAttribute("class", (Object)menuItem.getStyleClass(), null);
            }
            if (menuItem.getUrl() != null) {
                writer.writeAttribute("href", (Object)this.getResourceURL(facesContext, menuItem.getUrl()), null);
                if (menuItem.getOnclick() != null) {
                    writer.writeAttribute("onclick", (Object)menuItem.getOnclick(), null);
                }
                if (menuItem.getTarget() != null) {
                    writer.writeAttribute("target", (Object)menuItem.getTarget(), null);
                }
            } else {
                writer.writeAttribute("href", (Object)"javascript:void(0)", null);
                UIComponent form = ComponentUtils.findParentForm(facesContext, (UIComponent)menuItem);
                if (form == null) {
                    throw new FacesException("Breadcrumb must be inside a form element");
                }
                String formClientId = form.getClientId(facesContext);
                String command = menuItem.isAjax() ? this.buildAjaxRequest(facesContext, menuItem, formClientId, clientId) : this.buildNonAjaxRequest(facesContext, (UIComponent)menuItem, formClientId, clientId);
                command = menuItem.getOnclick() == null ? command : menuItem.getOnclick() + ";" + command;
                writer.writeAttribute("onclick", (Object)command, null);
            }
            if (menuItem.getValue() != null) {
                writer.write((String)menuItem.getValue());
            }
            writer.endElement("a");
        }
    }

    public void encodeChildren(FacesContext facesContext, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }
}

