/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.bridge.exportdiff;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.bugtracking.bridge.exportdiff.AttachPanel;
import org.netbeans.modules.bugtracking.spi.Issue;
import org.netbeans.modules.bugtracking.util.BugtrackingOwnerSupport;
import org.netbeans.modules.versioning.util.ExportDiffSupport;

public class ExportDiffProviderImpl
extends ExportDiffSupport.ExportDiffProvider
implements DocumentListener,
PropertyChangeListener {
    private BugtrackingOwnerSupport support = BugtrackingOwnerSupport.getInstance();
    private AttachPanel panel;
    private File[] files;
    private static Logger LOG = Logger.getLogger("org.netbeans.modules.bugtracking.exportdiff.AttachIssueProvider");

    protected void setContext(File[] files) {
        this.files = files;
    }

    public void handleDiffFile(File file) {
        LOG.log(Level.FINE, "handeDiff start for " + file);
        Issue issue = this.panel.getIssue();
        if (issue == null) {
            LOG.log(Level.FINE, " no issue set");
            return;
        }
        issue.attachPatch(file, this.panel.descriptionTextField.getText());
        issue.open();
        LOG.log(Level.FINE, "handeDiff end for " + file);
    }

    public JComponent createComponent() {
        assert (this.files != null);
        this.panel = new AttachPanel(this);
        this.panel.descriptionTextField.getDocument().addDocumentListener(this);
        this.panel.init(this.files.length > 0 ? this.files[0] : null);
        return this.panel;
    }

    public boolean isValid() {
        return !this.panel.descriptionTextField.getText().trim().equals("") && this.panel.getIssue() != null;
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.fireDataChanged();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.fireDataChanged();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.fireDataChanged();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("QuickSearchComboBar.issue.changed")) {
            this.fireDataChanged();
        }
    }
}

