/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.junit.wizards;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.SourceGroupModifier;
import org.netbeans.modules.junit.DefaultPlugin;
import org.netbeans.modules.junit.JUnitSettings;
import org.netbeans.modules.junit.TestUtil;
import org.netbeans.modules.junit.plugin.JUnitPlugin;
import org.netbeans.modules.junit.wizards.EmptyTestCaseWizardIterator;
import org.netbeans.modules.junit.wizards.StepProblemMessage;
import org.netbeans.modules.junit.wizards.TestSuiteStepLocation;
import org.netbeans.modules.junit.wizards.Utils;
import org.netbeans.spi.java.project.support.ui.templates.JavaTemplates;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.TemplateWizard;
import org.openide.util.NbBundle;

public class TestSuiteWizardIterator
implements TemplateWizard.Iterator {
    private static TestSuiteWizardIterator instance;
    private TemplateWizard wizard;
    private static final int INDEX_TARGET = 2;
    private final String nameTarget = NbBundle.getMessage(TestSuiteWizardIterator.class, (String)"LBL_panel_Target");
    private int current;
    private List<ChangeListener> changeListeners;
    private WizardDescriptor.Panel<WizardDescriptor> targetPanel;
    private Project lastSelectedProject = null;
    private WizardDescriptor.Panel optionsPanel;
    private SourceGroup[] testSrcGroups;

    public void addChangeListener(ChangeListener l) {
        if (this.changeListeners == null) {
            this.changeListeners = new ArrayList<ChangeListener>(2);
        }
        this.changeListeners.add(l);
    }

    public void removeChangeListener(ChangeListener l) {
        if (this.changeListeners != null) {
            this.changeListeners.remove(l);
            if (this.changeListeners.isEmpty()) {
                this.changeListeners = null;
            }
        }
    }

    private void fireChange() {
        if (this.changeListeners != null) {
            ChangeEvent e = new ChangeEvent(this);
            for (ChangeListener l : this.changeListeners) {
                l.stateChanged(e);
            }
        }
    }

    public boolean hasPrevious() {
        return this.current > 2;
    }

    public boolean hasNext() {
        return this.current < 2;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.current;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.current;
    }

    public WizardDescriptor.Panel<WizardDescriptor> current() {
        switch (this.current) {
            case 2: {
                return this.getTargetPanel();
            }
        }
        throw new IllegalStateException();
    }

    private WizardDescriptor.Panel<WizardDescriptor> getTargetPanel() {
        Project project = Templates.getProject((WizardDescriptor)this.wizard);
        if (project == null) {
            return new StepProblemMessage(project, NbBundle.getMessage(this.getClass(), (String)"MSG_UnsupportedPlugin"));
        }
        if (this.targetPanel == null || project != this.lastSelectedProject) {
            JUnitPlugin plugin = TestUtil.getPluginForProject(project);
            if (plugin.getClass() != DefaultPlugin.class) {
                this.targetPanel = new StepProblemMessage(project, NbBundle.getMessage(TestSuiteWizardIterator.class, (String)"MSG_UnsupportedPlugin"));
            } else {
                Collection sourceGroups = Utils.getTestTargets(project, true);
                if (sourceGroups.isEmpty() && SourceGroupModifier.createSourceGroup((Project)project, (String)"java", (String)"test") != null) {
                    sourceGroups = Utils.getTestTargets(project, true);
                }
                if (sourceGroups.isEmpty()) {
                    this.targetPanel = new StepProblemMessage(project, NbBundle.getMessage(TestSuiteWizardIterator.class, (String)"MSG_NoTestSourceGroup"));
                } else {
                    this.testSrcGroups = new SourceGroup[sourceGroups.size()];
                    sourceGroups.toArray(this.testSrcGroups);
                    if (this.optionsPanel == null) {
                        this.optionsPanel = new TestSuiteStepLocation();
                    }
                    this.targetPanel = JavaTemplates.createPackageChooser((Project)project, (SourceGroup[])this.testSrcGroups, (WizardDescriptor.Panel)this.optionsPanel);
                }
            }
            this.lastSelectedProject = project;
        }
        return this.targetPanel;
    }

    public String name() {
        switch (this.current) {
            case 2: {
                return this.nameTarget;
            }
        }
        throw new AssertionError(this.current);
    }

    private void loadSettings(TemplateWizard wizard) {
        JUnitSettings settings = JUnitSettings.getDefault();
        wizard.putProperty("SetUp", (Object)settings.isGenerateSetUp());
        wizard.putProperty("TearDown", (Object)settings.isGenerateTearDown());
        wizard.putProperty("Comments", (Object)settings.isBodyComments());
    }

    private void saveSettings(TemplateWizard wizard) {
        JUnitSettings settings = JUnitSettings.getDefault();
        settings.setGenerateSetUp(Boolean.TRUE.equals(wizard.getProperty("SetUp")));
        settings.setGenerateTearDown(Boolean.TRUE.equals(wizard.getProperty("TearDown")));
        settings.setBodyComments(Boolean.TRUE.equals(wizard.getProperty("Comments")));
    }

    public void initialize(TemplateWizard wiz) {
        this.wizard = wiz;
        this.current = 2;
        this.loadSettings(wiz);
        String[] panelNames = new String[]{NbBundle.getMessage(EmptyTestCaseWizardIterator.class, (String)"LBL_panel_chooseFileType"), NbBundle.getMessage(EmptyTestCaseWizardIterator.class, (String)"LBL_panel_Target")};
        ((JComponent)this.getTargetPanel().getComponent()).putClientProperty("WizardPanel_contentData", panelNames);
        ((JComponent)this.getTargetPanel().getComponent()).putClientProperty("WizardPanel_contentSelectedIndex", new Integer(0));
    }

    public void uninitialize(TemplateWizard wiz) {
        this.wizard = null;
        this.targetPanel = null;
        this.lastSelectedProject = null;
        this.optionsPanel = null;
        this.testSrcGroups = null;
        this.changeListeners = null;
    }

    public Set<DataObject> instantiate(TemplateWizard wiz) throws IOException {
        this.saveSettings(wiz);
        String name = Templates.getTargetName((WizardDescriptor)this.wizard);
        FileObject targetFolder = Templates.getTargetFolder((WizardDescriptor)this.wizard);
        FileObject testRootFolder = this.findTestRootFolder(targetFolder);
        assert (testRootFolder != null);
        DefaultPlugin defaultPlugin = new DefaultPlugin();
        if (!defaultPlugin.setupJUnitVersionByProject(targetFolder)) {
            return null;
        }
        DataObject suite = defaultPlugin.createSuiteTest(testRootFolder, targetFolder, name, TestUtil.getSettingsMap(true));
        if (suite != null) {
            return Collections.singleton(suite);
        }
        throw new IOException();
    }

    private FileObject findTestRootFolder(FileObject targetFolder) {
        for (int i = 0; i < this.testSrcGroups.length; ++i) {
            FileObject rootFolder = this.testSrcGroups[i].getRootFolder();
            if (rootFolder != targetFolder && !FileUtil.isParentOf((FileObject)rootFolder, (FileObject)targetFolder)) continue;
            return rootFolder;
        }
        return null;
    }

    public static TestSuiteWizardIterator singleton() {
        if (instance == null) {
            instance = new TestSuiteWizardIterator();
        }
        return instance;
    }
}

