/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.junit.output;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.Action;
import org.netbeans.modules.gsf.testrunner.api.TestsuiteNode;
import org.netbeans.modules.junit.output.JUnitTestSuite;
import org.netbeans.modules.junit.output.JumpAction;
import org.netbeans.modules.junit.output.OutputUtils;
import org.netbeans.modules.junit.output.TestMethodNodeAction;
import org.netbeans.spi.project.ActionProvider;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;

public class JUnitTestsuiteNode
extends TestsuiteNode {
    public JUnitTestsuiteNode(String suiteName, boolean filtered) {
        super(suiteName, filtered);
    }

    public Action[] getActions(boolean context) {
        FileObject testFO;
        ArrayList<Action> actions = new ArrayList<Action>();
        Action preferred = this.getPreferredAction();
        if (preferred != null) {
            actions.add(preferred);
        }
        if ((testFO = ((JUnitTestSuite)this.getSuite()).getSuiteFO()) != null) {
            ActionProvider actionProvider = OutputUtils.getActionProvider(testFO);
            DataObject testDO = null;
            try {
                testDO = DataObject.find((FileObject)testFO);
            }
            catch (DataObjectNotFoundException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            if (actionProvider != null && testDO != null) {
                List<String> supportedActions = Arrays.asList(actionProvider.getSupportedActions());
                Lookup nodeContext = Lookups.singleton((Object)testDO);
                if (supportedActions.contains("test.single") && actionProvider.isActionEnabled("test.single", nodeContext)) {
                    actions.add(new TestMethodNodeAction(actionProvider, nodeContext, "test.single", "LBL_RerunTest"));
                }
                if (supportedActions.contains("debug.test.single") && actionProvider.isActionEnabled("debug.test.single", nodeContext)) {
                    actions.add(new TestMethodNodeAction(actionProvider, nodeContext, "debug.test.single", "LBL_DebugTest"));
                }
            }
        }
        return actions.toArray(new Action[actions.size()]);
    }

    public Action getPreferredAction() {
        return new JumpAction((Node)this, null);
    }
}

