/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.lexer;

import org.netbeans.api.lexer.PartType;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenUtilities;
import org.netbeans.cnd.api.lexer.CndLexerUtilities;
import org.netbeans.cnd.api.lexer.CppTokenId;
import org.netbeans.cnd.api.lexer.Filter;
import org.netbeans.modules.cnd.lexer.CndLexer;
import org.netbeans.spi.lexer.LexerRestartInfo;

public final class PreprocLexer
extends CndLexer {
    private static final int INIT = 0;
    private static final int DIRECTIVE_NAME = 1;
    private static final int EXPRESSION = 2;
    private static final int INCLUDE_DIRECTIVE = 3;
    private static final int PRAGMA = 4;
    private static final int OMP = 5;
    private static final int OTHER = 6;
    private static final int SHIFT = 3;
    private static final int MASK = 7;
    private int state = 0;
    private final Filter<CppTokenId> preprocFilter = CndLexerUtilities.getPreprocFilter();
    private final Filter<CppTokenId> ompFilter = CndLexerUtilities.getOmpFilter();
    private final Filter<CppTokenId> keywordsFilter;

    public PreprocLexer(Filter<CppTokenId> defaultFilter, LexerRestartInfo<CppTokenId> info) {
        super(info);
        Filter<CppTokenId> filter = (Filter<CppTokenId>)info.getAttributeValue((Object)"lexer-filter");
        this.keywordsFilter = filter != null ? filter : defaultFilter;
        this.fromState((Integer)info.state());
    }

    @Override
    public Object state() {
        Integer baseState = super.getState();
        int baseValue = baseState == null ? 0 : baseState;
        int value = baseValue << 3 | this.state;
        return value;
    }

    private void fromState(Integer state) {
        if (state == null) {
            this.state = 0;
            super.setState(null);
        } else {
            this.state = state & 7;
            super.setState(state >> 3);
        }
    }

    @Override
    protected Token<CppTokenId> finishSharp() {
        if (this.state == 0) {
            return this.token(CppTokenId.PREPROCESSOR_START);
        }
        return super.finishSharp();
    }

    @Override
    protected Token<CppTokenId> finishDblQuote() {
        if (this.state == 3) {
            while (true) {
                switch (this.read(true)) {
                    case 34: {
                        return this.token(CppTokenId.PREPROCESSOR_USER_INCLUDE);
                    }
                    case 13: {
                        this.consumeNewline();
                    }
                    case -1: 
                    case 10: {
                        return this.tokenPart(CppTokenId.PREPROCESSOR_USER_INCLUDE, PartType.START);
                    }
                }
            }
        }
        return super.finishDblQuote();
    }

    @Override
    protected Token<CppTokenId> finishLT() {
        if (this.state == 3) {
            while (true) {
                switch (this.read(true)) {
                    case 62: {
                        return this.token(CppTokenId.PREPROCESSOR_SYS_INCLUDE);
                    }
                    case 13: {
                        this.consumeNewline();
                    }
                    case -1: 
                    case 10: {
                        return this.tokenPart(CppTokenId.PREPROCESSOR_SYS_INCLUDE, PartType.START);
                    }
                }
            }
        }
        return super.finishLT();
    }

    @Override
    protected CppTokenId getKeywordOrIdentifierID(CharSequence text) {
        CppTokenId id = null;
        switch (this.state) {
            case 1: {
                id = this.preprocFilter.check(text);
                break;
            }
            case 2: {
                if (TokenUtilities.textEquals((CharSequence)CppTokenId.PREPROCESSOR_DEFINED.fixedText(), (CharSequence)text)) {
                    id = CppTokenId.PREPROCESSOR_DEFINED;
                    break;
                }
            }
            case 4: {
                id = this.ompFilter.check(text) == CppTokenId.PRAGMA_OMP_START ? CppTokenId.PRAGMA_OMP_START : null;
                break;
            }
            case 5: {
                id = this.ompFilter.check(text);
                id = id != null ? id : this.keywordsFilter.check(text);
                break;
            }
            case 6: {
                id = this.keywordsFilter.check(text);
            }
        }
        return id != null ? id : CppTokenId.PREPROCESSOR_IDENTIFIER;
    }

    @Override
    protected void postTokenCreate(CppTokenId id) {
        assert (id != null);
        block0 : switch (this.state) {
            case 0: {
                assert (id == CppTokenId.PREPROCESSOR_START) : "in INIT state only CppTokenId.PREPROCESSOR_START is possible: " + (Object)((Object)id);
                this.state = 1;
                break;
            }
            case 1: {
                if ("whitespace".equals(id.primaryCategory()) || "comment".equals(id.primaryCategory())) break;
                switch (id) {
                    case PREPROCESSOR_IF: 
                    case PREPROCESSOR_ELIF: {
                        this.state = 2;
                        break block0;
                    }
                    case PREPROCESSOR_INCLUDE: 
                    case PREPROCESSOR_INCLUDE_NEXT: {
                        this.state = 3;
                        break block0;
                    }
                    case PREPROCESSOR_PRAGMA: {
                        this.state = 4;
                        break block0;
                    }
                }
                this.state = 6;
                break;
            }
            case 4: {
                if ("whitespace".equals(id.primaryCategory()) || "comment".equals(id.primaryCategory())) break;
                switch (id) {
                    case PRAGMA_OMP_START: {
                        this.state = 5;
                        break block0;
                    }
                }
                this.state = 6;
                break;
            }
        }
    }
}

