/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.cnd.api.lexer;

import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.api.lexer.InputAttributes;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.LanguagePath;
import org.netbeans.api.lexer.PartType;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.cnd.api.lexer.CndLexerUtilities;
import org.netbeans.cnd.api.lexer.CppStringTokenId;
import org.netbeans.cnd.api.lexer.DoxygenTokenId;
import org.netbeans.cnd.spi.lexer.CndLexerLanguageEmbeddingProvider;
import org.netbeans.modules.cnd.lexer.CppLexer;
import org.netbeans.modules.cnd.lexer.PreprocLexer;
import org.netbeans.spi.lexer.LanguageEmbedding;
import org.netbeans.spi.lexer.LanguageHierarchy;
import org.netbeans.spi.lexer.Lexer;
import org.netbeans.spi.lexer.LexerRestartInfo;
import org.openide.util.lookup.Lookups;

public enum CppTokenId implements TokenId
{
    ERROR(null, "error"),
    IDENTIFIER(null, "identifier"),
    ALIGNOF("alignof", "keyword"),
    __ALIGNOF__("__alignof__", "keyword"),
    ASM("asm", "keyword-directive"),
    _ASM("_asm", "keyword"),
    __ASM("__asm", "keyword"),
    __ASM__("__asm__", "keyword"),
    AUTO("auto", "keyword"),
    BIT("bit", "keyword"),
    BOOL("bool", "keyword"),
    BREAK("break", "keyword-directive"),
    CASE("case", "keyword-directive"),
    CATCH("catch", "keyword-directive"),
    CHAR("char", "keyword"),
    CLASS("class", "keyword"),
    CONST("const", "keyword"),
    __CONST("__const", "keyword"),
    __CONST__("__const__", "keyword"),
    CONST_CAST("const_cast", "keyword"),
    CONTINUE("continue", "keyword-directive"),
    DEFAULT("default", "keyword-directive"),
    DELETE("delete", "keyword"),
    DO("do", "keyword-directive"),
    DOUBLE("double", "keyword"),
    DYNAMIC_CAST("dynamic_cast", "keyword"),
    ELSE("else", "keyword-directive"),
    _ENDASM("_endasm", "keyword"),
    ENUM("enum", "keyword"),
    EXPLICIT("explicit", "keyword"),
    EXPORT("export", "keyword"),
    EXTERN("extern", "keyword"),
    FINALLY("finally", "keyword-directive"),
    FLOAT("float", "keyword"),
    FOR("for", "keyword-directive"),
    FRIEND("friend", "keyword"),
    __FUNC__("__func__", "keyword"),
    GOTO("goto", "keyword-directive"),
    IF("if", "keyword-directive"),
    INLINE("inline", "keyword"),
    _INLINE("_inline", "keyword"),
    __INLINE("__inline", "keyword"),
    __INLINE__("__inline__", "keyword"),
    INT("int", "keyword"),
    LONG("long", "keyword"),
    MUTABLE("mutable", "keyword"),
    NAMESPACE("namespace", "keyword"),
    NEW("new", "keyword"),
    OPERATOR("operator", "keyword"),
    PASCAL("pascal", "keyword"),
    _PASCAL("_pascal", "keyword"),
    __PASCAL("__pascal", "keyword"),
    PRIVATE("private", "keyword"),
    PROTECTED("protected", "keyword"),
    PUBLIC("public", "keyword"),
    REGISTER("register", "keyword"),
    REINTERPRET_CAST("reinterpret_cast", "keyword"),
    RESTRICT("restrict", "keyword"),
    RETURN("return", "keyword-directive"),
    SHORT("short", "keyword"),
    SIGNED("signed", "keyword"),
    __SIGNED("__signed", "keyword"),
    __SIGNED__("__signed__", "keyword"),
    SIZEOF("sizeof", "keyword"),
    STATIC("static", "keyword"),
    STATIC_CAST("static_cast", "keyword"),
    STRUCT("struct", "keyword"),
    SWITCH("switch", "keyword-directive"),
    TEMPLATE("template", "keyword"),
    THIS("this", "keyword"),
    THROW("throw", "keyword-directive"),
    TRY("try", "keyword-directive"),
    TYPEDEF("typedef", "keyword"),
    TYPEID("typeid", "keyword"),
    TYPENAME("typename", "keyword"),
    TYPEOF("typeof", "keyword"),
    __TYPEOF("__typeof", "keyword"),
    __TYPEOF__("__typeof__", "keyword"),
    UNION("union", "keyword"),
    UNSIGNED("unsigned", "keyword"),
    __UNSIGNED__("__unsigned__", "keyword"),
    USING("using", "keyword"),
    VIRTUAL("virtual", "keyword"),
    VOID("void", "keyword"),
    VOLATILE("volatile", "keyword"),
    __VOLATILE("__volatile", "keyword"),
    __VOLATILE__("__volatile__", "keyword"),
    WCHAR_T("wchar_t", "keyword"),
    WHILE("while", "keyword-directive"),
    __ATTRIBUTE__("__attribute__", "keyword"),
    __ATTRIBUTE("__attribute", "keyword"),
    _BOOL("_Bool", "keyword"),
    _CDECL("_cdecl", "keyword"),
    __CDECL("__cdecl", "keyword"),
    _COMPLEX("_Complex", "keyword"),
    __COMPLEX__("__complex__", "keyword"),
    _DECLSPEC("_declspec", "keyword"),
    __DECLSPEC("__declspec", "keyword"),
    __EXTENSION__("__extension__", "keyword"),
    _FAR("_far", "keyword"),
    __FAR("__far", "keyword"),
    _IMAGINARY("_Imaginary", "keyword"),
    __IMAG__("__imag__", "keyword"),
    _INT64("_int64", "keyword"),
    __INT64("__int64", "keyword"),
    __INTERRUPT("__interrupt", "keyword"),
    _NEAR("_near", "keyword"),
    __NEAR("__near", "keyword"),
    __REAL__("__real__", "keyword"),
    __RESTRICT("__restrict", "keyword"),
    _STDCALL("_stdcall", "keyword"),
    __STDCALL("__stdcall", "keyword"),
    __THREAD("__thread", "keyword"),
    __UNUSED__("__unused__", "keyword"),
    __W64("__w64", "keyword"),
    BUILT_IN_TYPE(null, "keyword"),
    TYPE_QUALIFIER(null, "keyword"),
    STORAGE_CLASS_SPECIFIER(null, "keyword"),
    INT_LITERAL(null, "number"),
    LONG_LITERAL(null, "number"),
    LONG_LONG_LITERAL(null, "number"),
    FLOAT_LITERAL(null, "number"),
    DOUBLE_LITERAL(null, "number"),
    UNSIGNED_LITERAL(null, "number"),
    UNSIGNED_LONG_LITERAL(null, "number"),
    UNSIGNED_LONG_LONG_LITERAL(null, "number"),
    CHAR_LITERAL(null, "character"),
    STRING_LITERAL(null, "string"),
    TRUE("true", "literal"),
    FALSE("false", "literal"),
    NULL("null", "literal"),
    LPAREN("(", "separator"),
    RPAREN(")", "separator"),
    LBRACE("{", "separator"),
    RBRACE("}", "separator"),
    LBRACKET("[", "separator"),
    RBRACKET("]", "separator"),
    SEMICOLON(";", "separator"),
    COMMA(",", "separator"),
    DOT(".", "separator"),
    DOTMBR(".*", "separator"),
    SCOPE("::", "separator"),
    ARROW("->", "separator"),
    ARROWMBR("->*", "separator"),
    EQ("=", "operator"),
    GT(">", "operator"),
    LT("<", "operator"),
    NOT("!", "operator"),
    TILDE("~", "operator"),
    QUESTION("?", "operator"),
    COLON(":", "operator"),
    EQEQ("==", "operator"),
    LTEQ("<=", "operator"),
    GTEQ(">=", "operator"),
    NOTEQ("!=", "operator"),
    AMPAMP("&&", "operator"),
    BARBAR("||", "operator"),
    PLUSPLUS("++", "operator"),
    MINUSMINUS("--", "operator"),
    PLUS("+", "operator"),
    MINUS("-", "operator"),
    STAR("*", "operator"),
    SLASH("/", "operator"),
    AMP("&", "operator"),
    BAR("|", "operator"),
    CARET("^", "operator"),
    PERCENT("%", "operator"),
    LTLT("<<", "operator"),
    GTGT(">>", "operator"),
    PLUSEQ("+=", "operator"),
    MINUSEQ("-=", "operator"),
    STAREQ("*=", "operator"),
    SLASHEQ("/=", "operator"),
    AMPEQ("&=", "operator"),
    BAREQ("|=", "operator"),
    CARETEQ("^=", "operator"),
    PERCENTEQ("%=", "operator"),
    LTLTEQ("<<=", "operator"),
    GTGTEQ(">>=", "operator"),
    ALTERNATE_AND("and", "keyword"),
    ALTERNATE_BITOR("bitor", "keyword"),
    ALTERNATE_OR("or", "keyword"),
    ALTERNATE_XOR("xor", "keyword"),
    ALTERNATE_COMPL("compl", "keyword"),
    ALTERNATE_BITAND("bitand", "keyword"),
    ALTERNATE_AND_EQ("and_eq", "keyword"),
    ALTERNATE_OR_EQ("or_eq", "keyword"),
    ALTERNATE_XOR_EQ("xor_eq", "keyword"),
    ALTERNATE_NOT("not", "keyword"),
    ALTERNATE_NOT_EQ("not_eq", "keyword"),
    ELLIPSIS("...", "special"),
    AT("@", "special"),
    GRAVE_ACCENT("`", "special"),
    DOLLAR("$", "special"),
    SHARP("#", "special"),
    DBL_SHARP("##", "special"),
    BACK_SLASH("\\", "special"),
    WHITESPACE(null, "whitespace"),
    ESCAPED_LINE(null, "whitespace"),
    ESCAPED_WHITESPACE(null, "whitespace"),
    NEW_LINE(null, "whitespace"),
    LINE_COMMENT(null, "comment"),
    BLOCK_COMMENT(null, "comment"),
    DOXYGEN_COMMENT(null, "comment"),
    DOXYGEN_LINE_COMMENT(null, "comment"),
    PREPROCESSOR_DIRECTIVE(null, "preprocessor"),
    PREPROCESSOR_START("#", "preprocessor"),
    PREPROCESSOR_IF("if", "preprocessor-keyword-directive"),
    PREPROCESSOR_IFDEF("ifdef", "preprocessor-keyword-directive"),
    PREPROCESSOR_IFNDEF("ifndef", "preprocessor-keyword-directive"),
    PREPROCESSOR_ELSE("else", "preprocessor-keyword-directive"),
    PREPROCESSOR_ELIF("elif", "preprocessor-keyword-directive"),
    PREPROCESSOR_ENDIF("endif", "preprocessor-keyword-directive"),
    PREPROCESSOR_DEFINE("define", "preprocessor-keyword-directive"),
    PREPROCESSOR_UNDEF("undef", "preprocessor-keyword-directive"),
    PREPROCESSOR_INCLUDE("include", "preprocessor-keyword-directive"),
    PREPROCESSOR_INCLUDE_NEXT("include_next", "preprocessor-keyword-directive"),
    PREPROCESSOR_LINE("line", "preprocessor-keyword-directive"),
    PREPROCESSOR_IDENT("ident", "preprocessor-keyword-directive"),
    PREPROCESSOR_PRAGMA("pragma", "preprocessor-keyword-directive"),
    PREPROCESSOR_WARNING("warning", "preprocessor-keyword-directive"),
    PREPROCESSOR_ERROR("error", "preprocessor-keyword-directive"),
    PREPROCESSOR_DEFINED("defined", "preprocessor-keyword"),
    PREPROCESSOR_USER_INCLUDE(null, "preprocessor-user-include-literal"),
    PREPROCESSOR_SYS_INCLUDE(null, "preprocessor-system-include-literal"),
    PREPROCESSOR_IDENTIFIER(null, "preprocessor-identifier"),
    PRAGMA_OMP(null, "pragma-omp"),
    PRAGMA_OMP_START("omp", "pragma-omp-keyword-directive"),
    PRAGMA_OMP_PARALLEL("parallel", "pragma-omp-keyword-directive"),
    PRAGMA_OMP_SECTIONS("sections", "pragma-omp-keyword-directive"),
    PRAGMA_OMP_NOWAIT("nowait", "pragma-omp-keyword-directive"),
    PRAGMA_OMP_ORDERED("ordered", "pragma-omp-keyword-directive"),
    PRAGMA_OMP_SCHEDULE("schedule", "pragma-omp-keyword-directive"),
    PRAGMA_OMP_DYNAMIC("dynamic", "pragma-omp-keyword-directive"),
    PRAGMA_OMP_GUIDED("guided", "pragma-omp-keyword-directive"),
    PRAGMA_OMP_RUNTIME("runtime", "pragma-omp-keyword-directive"),
    PRAGMA_OMP_SECTION("section", "pragma-omp-keyword-directive"),
    PRAGMA_OMP_SINGLE("single", "pragma-omp-keyword-directive"),
    PRAGMA_OMP_MASTER("master", "pragma-omp-keyword-directive"),
    PRAGMA_OMP_CRITICAL("critical", "pragma-omp-keyword-directive"),
    PRAGMA_OMP_BARRIER("barrier", "pragma-omp-keyword-directive"),
    PRAGMA_OMP_ATOMIC("atomic", "pragma-omp-keyword-directive"),
    PRAGMA_OMP_FLUSH("flush", "pragma-omp-keyword-directive"),
    PRAGMA_OMP_THREADPRIVATE("threadprivate", "pragma-omp-keyword-directive"),
    PRAGMA_OMP_PRIVATE("private", "pragma-omp-keyword-directive"),
    PRAGMA_OMP_FIRSTPRIVATE("firstprivate", "pragma-omp-keyword-directive"),
    PRAGMA_OMP_LASTPRIVATE("lastprivate", "pragma-omp-keyword-directive"),
    PRAGMA_OMP_SHARED("shared", "pragma-omp-keyword-directive"),
    PRAGMA_OMP_NONE("none", "pragma-omp-keyword-directive"),
    PRAGMA_OMP_REDUCTION("reduction", "pragma-omp-keyword-directive"),
    PRAGMA_OMP_COPYIN("copyin", "pragma-omp-keyword-directive"),
    PRAGMA_OMP_TASK("task", "pragma-omp-keyword-directive"),
    PRAGMA_OMP_TASKWAIT("taskwait", "pragma-omp-keyword-directive"),
    PRAGMA_OMP_COLLAPSE("collapse", "pragma-omp-keyword-directive"),
    PRAGMA_OMP_COPYPRIVATE("copyprivate", "pragma-omp-keyword-directive"),
    PRAGMA_OMP_DEFAULT("default", "pragma-omp-keyword-directive"),
    PRAGMA_OMP_STATIC("static", "pragma-omp-keyword-directive"),
    PRAGMA_OMP_IF("if", "pragma-omp-keyword-directive"),
    PRAGMA_OMP_FOR("for", "pragma-omp-keyword-directive"),
    PRAGMA_OMP_AUTO("auto", "pragma-omp-keyword-directive"),
    PRAGMA_OMP_NUM_THREADS("num_threads", "pragma-omp-keyword-directive"),
    PROC_DIRECTIVE(null, "proc"),
    PROC_SQL("sql", "proc-keyword-directive"),
    INVALID_COMMENT_END("*/", "error"),
    FLOAT_LITERAL_INVALID(null, "number");

    public static final String IDENTIFIER_CATEGORY = "identifier";
    public static final String WHITESPACE_CATEGORY = "whitespace";
    public static final String COMMENT_CATEGORY = "comment";
    public static final String KEYWORD_CATEGORY = "keyword";
    public static final String KEYWORD_DIRECTIVE_CATEGORY = "keyword-directive";
    public static final String ERROR_CATEGORY = "error";
    public static final String NUMBER_CATEGORY = "number";
    public static final String LITERAL_CATEGORY = "literal";
    public static final String CHAR_CATEGORY = "character";
    public static final String STRING_CATEGORY = "string";
    public static final String SEPARATOR_CATEGORY = "separator";
    public static final String OPERATOR_CATEGORY = "operator";
    public static final String SPECIAL_CATEGORY = "special";
    public static final String PREPROCESSOR_CATEGORY = "preprocessor";
    public static final String PREPROCESSOR_KEYWORD_CATEGORY = "preprocessor-keyword";
    public static final String PREPROCESSOR_KEYWORD_DIRECTIVE_CATEGORY = "preprocessor-keyword-directive";
    public static final String PREPROCESSOR_IDENTIFIER_CATEGORY = "preprocessor-identifier";
    public static final String PREPROCESSOR_USER_INCLUDE_CATEGORY = "preprocessor-user-include-literal";
    public static final String PREPROCESSOR_SYS_INCLUDE_CATEGORY = "preprocessor-system-include-literal";
    public static final String PRAGMA_OMP_CATEGORY = "pragma-omp";
    public static final String PRAGMA_OMP_KEYWORD_DIRECTIVE_CATEGORY = "pragma-omp-keyword-directive";
    private final String fixedText;
    private final String primaryCategory;
    private static final Language<CppTokenId> languageHeader;
    private static final Language<CppTokenId> languageC;
    private static final Language<CppTokenId> languageCpp;
    private static final Language<CppTokenId> languagePreproc;

    private CppTokenId(String fixedText, String primaryCategory) {
        this.fixedText = fixedText;
        this.primaryCategory = primaryCategory;
    }

    public String fixedText() {
        return this.fixedText;
    }

    public String primaryCategory() {
        return this.primaryCategory;
    }

    public static Language<CppTokenId> languageC() {
        return languageC;
    }

    public static Language<CppTokenId> languageCpp() {
        return languageCpp;
    }

    public static Language<CppTokenId> languagePreproc() {
        return languagePreproc;
    }

    public static Language<CppTokenId> languageHeader() {
        return languageHeader;
    }

    static {
        languageHeader = CppHierarchy.createHeaderLanguage();
        languageC = CppHierarchy.createCLanguage();
        languageCpp = CppHierarchy.createCppLanguage();
        languagePreproc = CppHierarchy.createPreprocLanguage();
    }

    private static final class CppHierarchy
    extends LanguageHierarchy<CppTokenId> {
        private final String mimeType;

        private CppHierarchy(String mimeType) {
            this.mimeType = mimeType;
        }

        private static Language<CppTokenId> createHeaderLanguage() {
            return new CppHierarchy("text/x-h").language();
        }

        private static Language<CppTokenId> createCppLanguage() {
            return new CppHierarchy("text/x-c++").language();
        }

        private static Language<CppTokenId> createCLanguage() {
            return new CppHierarchy("text/x-c").language();
        }

        private static Language<CppTokenId> createPreprocLanguage() {
            return new CppHierarchy("text/x-cpp+preprocessor").language();
        }

        protected String mimeType() {
            return this.mimeType;
        }

        protected Collection<CppTokenId> createTokenIds() {
            return EnumSet.allOf(CppTokenId.class);
        }

        protected Map<String, Collection<CppTokenId>> createTokenCategories() {
            HashMap<String, Collection<CppTokenId>> cats = new HashMap<String, Collection<CppTokenId>>();
            cats.put(CppTokenId.ERROR_CATEGORY, EnumSet.of(FLOAT_LITERAL_INVALID));
            EnumSet<CppTokenId[]> l = EnumSet.of(INT_LITERAL, new CppTokenId[]{LONG_LITERAL, LONG_LONG_LITERAL, FLOAT_LITERAL, DOUBLE_LITERAL, UNSIGNED_LITERAL, CHAR_LITERAL, STRING_LITERAL});
            cats.put(CppTokenId.LITERAL_CATEGORY, l);
            return cats;
        }

        protected Lexer<CppTokenId> createLexer(LexerRestartInfo<CppTokenId> info) {
            if ("text/x-cpp+preprocessor".equals(this.mimeType)) {
                return new PreprocLexer(CndLexerUtilities.getDefatultFilter(true), info);
            }
            if ("text/x-c".equals(this.mimeType)) {
                return new CppLexer(CndLexerUtilities.getDefatultFilter(false), info);
            }
            return new CppLexer(CndLexerUtilities.getDefatultFilter(true), info);
        }

        protected LanguageEmbedding<?> embedding(Token<CppTokenId> token, LanguagePath languagePath, InputAttributes inputAttributes) {
            switch ((CppTokenId)token.id()) {
                case DOXYGEN_COMMENT: {
                    return LanguageEmbedding.create(DoxygenTokenId.language(), (int)3, (int)(token.partType() == PartType.COMPLETE ? 2 : 0));
                }
                case DOXYGEN_LINE_COMMENT: {
                    return LanguageEmbedding.create(DoxygenTokenId.language(), (int)3, (int)0);
                }
                case STRING_LITERAL: {
                    return LanguageEmbedding.create(CppStringTokenId.languageDouble(), (int)0, (int)0);
                }
                case CHAR_LITERAL: {
                    return LanguageEmbedding.create(CppStringTokenId.languageSingle(), (int)0, (int)0);
                }
                case PREPROCESSOR_DIRECTIVE: {
                    return LanguageEmbedding.create((Language)languagePreproc, (int)0, (int)0);
                }
            }
            if (!CndLexerEmbeddingProviders.providers.isEmpty()) {
                for (CndLexerLanguageEmbeddingProvider provider : CndLexerEmbeddingProviders.providers) {
                    LanguageEmbedding<?> embedding = provider.createEmbedding(token, languagePath, inputAttributes);
                    if (embedding == null) continue;
                    return embedding;
                }
            }
            return null;
        }

        private static final class CndLexerEmbeddingProviders {
            private static final Collection<? extends CndLexerLanguageEmbeddingProvider> providers = Lookups.forPath((String)"CND/CndLexerLanguageEmbeddingProvider").lookupAll(CndLexerLanguageEmbeddingProvider.class);

            private CndLexerEmbeddingProviders() {
            }
        }
    }
}

