/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.cnd.api.lexer;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.lexer.PartType;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.cnd.api.lexer.CndAbstractTokenProcessor;
import org.netbeans.cnd.api.lexer.CndLexerUtilities;
import org.netbeans.cnd.api.lexer.CndTokenProcessor;
import org.netbeans.cnd.api.lexer.CppTokenId;
import org.netbeans.cnd.api.lexer.TokenItem;

public class CndTokenUtilities {
    private static final Set<String> skipWSCategories = new HashSet<String>(1);

    private CndTokenUtilities() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isInPreprocessorDirective(Document doc, int offset) {
        AbstractDocument aDoc = (AbstractDocument)doc;
        aDoc.readLock();
        try {
            TokenSequence<TokenId> cppTokenSequence = CndLexerUtilities.getCppTokenSequenceWithoutEmbeddings(doc, offset);
            if (cppTokenSequence != null) {
                boolean bl = cppTokenSequence.token().id() == CppTokenId.PREPROCESSOR_DIRECTIVE;
                return bl;
            }
        }
        finally {
            aDoc.readUnlock();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isInProCDirective(Document doc, int offset) {
        AbstractDocument aDoc = (AbstractDocument)doc;
        aDoc.readLock();
        try {
            TokenSequence<TokenId> cppTokenSequence = CndLexerUtilities.getCppTokenSequenceWithoutEmbeddings(doc, offset);
            if (cppTokenSequence != null) {
                boolean bl = cppTokenSequence.token().id() == CppTokenId.PROC_DIRECTIVE;
                return bl;
            }
        }
        finally {
            aDoc.readUnlock();
        }
        return false;
    }

    public static void processTokens(CndTokenProcessor<Token<TokenId>> tp, Document doc, int startOffset, int lastOffset) {
        TokenSequence<TokenId> cppTokenSequence = CndLexerUtilities.getCppTokenSequence(doc, startOffset, false, lastOffset < startOffset);
        if (cppTokenSequence == null) {
            TokenHierarchy hi = TokenHierarchy.get((Document)doc);
            TokenSequence ts = hi.tokenSequence();
            if (ts != null && CndLexerUtilities.isCppLanguage(ts.language(), true)) {
                tp.start(startOffset, startOffset, lastOffset);
                tp.end(lastOffset, lastOffset);
                return;
            }
            return;
        }
        int shift = cppTokenSequence.move(startOffset);
        tp.start(startOffset, startOffset - shift, lastOffset);
        if (CndTokenUtilities.processTokensImpl(tp, cppTokenSequence, startOffset, lastOffset, shift != 0)) {
            tp.end(lastOffset, cppTokenSequence.offset());
        } else {
            tp.end(lastOffset, lastOffset);
        }
    }

    public static <T extends TokenId> TokenItem<T> createTokenItem(TokenSequence<T> ts) {
        return TokenItemImpl.create(ts);
    }

    public static <T extends TokenId> TokenItem<T> createTokenItem(Token<T> token, int tokenOffset) {
        return TokenItemImpl.create(token, tokenOffset);
    }

    public static TokenItem<TokenId> getFirstNonWhiteBwd(Document doc, int offset) {
        SkipTokenProcessor tp = new SkipTokenProcessor(Collections.<TokenId>emptySet(), skipWSCategories, true);
        CndTokenUtilities.processTokens(tp, doc, offset, 0);
        return tp.getTokenItem();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getLastCommandSeparator(Document doc, int pos) throws BadLocationException {
        if (pos < 0 || pos > doc.getLength()) {
            throw new BadLocationException("position is out of range[0-" + doc.getLength() + "]", pos);
        }
        if (pos == 0) {
            return 0;
        }
        AbstractDocument aDoc = (AbstractDocument)doc;
        aDoc.readLock();
        try {
            TokenSequence<TokenId> ts = CndLexerUtilities.getCppTokenSequence(doc, pos, true, true);
            if (ts == null) {
                int n = 0;
                return n;
            }
            do {
                TokenId id;
                if (!((id = ts.token().id()) instanceof CppTokenId)) continue;
                switch ((CppTokenId)id) {
                    case SEMICOLON: 
                    case LBRACE: 
                    case RBRACE: {
                        int n = ts.offset();
                        return n;
                    }
                }
            } while (ts.movePrevious());
            ts.moveStart();
            if (ts.moveNext()) {
                int n = ts.offset();
                return n;
            }
        }
        finally {
            aDoc.readUnlock();
        }
        return 0;
    }

    public static boolean moveToPreprocKeyword(TokenSequence<TokenId> ts) {
        if (ts != null) {
            TokenId id;
            ts.moveStart();
            ts.moveNext();
            if (!ts.moveNext()) {
                return false;
            }
            if (CndTokenUtilities.shiftToNonWhite(ts, false) && (id = ts.token().id()) instanceof CppTokenId) {
                switch ((CppTokenId)id) {
                    case PREPROCESSOR_DEFINE: 
                    case PREPROCESSOR_ELIF: 
                    case PREPROCESSOR_ELSE: 
                    case PREPROCESSOR_ENDIF: 
                    case PREPROCESSOR_ERROR: 
                    case PREPROCESSOR_IDENT: 
                    case PREPROCESSOR_IF: 
                    case PREPROCESSOR_IFDEF: 
                    case PREPROCESSOR_IFNDEF: 
                    case PREPROCESSOR_INCLUDE: 
                    case PREPROCESSOR_INCLUDE_NEXT: 
                    case PREPROCESSOR_LINE: 
                    case PREPROCESSOR_PRAGMA: 
                    case PREPROCESSOR_UNDEF: 
                    case PREPROCESSOR_WARNING: {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public static boolean shiftToNonWhite(TokenSequence<TokenId> ts, boolean backward) {
        do {
            TokenId id;
            if (!((id = ts.token().id()) instanceof CppTokenId)) continue;
            switch ((CppTokenId)id) {
                case WHITESPACE: 
                case BLOCK_COMMENT: 
                case DOXYGEN_COMMENT: 
                case DOXYGEN_LINE_COMMENT: 
                case LINE_COMMENT: 
                case ESCAPED_LINE: 
                case ESCAPED_WHITESPACE: 
                case NEW_LINE: {
                    break;
                }
                default: {
                    return true;
                }
            }
        } while (!backward ? ts.moveNext() : ts.movePrevious());
        return false;
    }

    public static TokenItem<TokenId> getTokenCheckPrev(Document doc, int offset) {
        return CndTokenUtilities.getTokenImpl(doc, offset, true, true);
    }

    public static TokenItem<TokenId> getToken(Document doc, int offset, boolean tokenizePP) {
        return CndTokenUtilities.getTokenImpl(doc, offset, tokenizePP, false);
    }

    private static TokenItem<TokenId> getTokenImpl(Document doc, int offset, boolean tokenizePP, boolean checkPrevious) {
        TokenSequence<TokenId> cppTokenSequence = CndLexerUtilities.getCppTokenSequence(doc, offset, tokenizePP, false);
        if (cppTokenSequence == null) {
            return null;
        }
        TokenItem<TokenId> offsetToken = CndTokenUtilities.getTokenImpl(cppTokenSequence, offset, checkPrevious);
        return offsetToken;
    }

    private static TokenItem<TokenId> getTokenImpl(TokenSequence<TokenId> cppTokenSequence, int offset, boolean checkPrevious) {
        if (cppTokenSequence == null) {
            return null;
        }
        int shift = cppTokenSequence.move(offset);
        TokenItem offsetToken = null;
        boolean checkPrev = false;
        if (cppTokenSequence.moveNext() && cppTokenSequence.token().id() instanceof TokenId) {
            String category;
            offsetToken = TokenItemImpl.create(cppTokenSequence);
            if (checkPrevious && shift == 0 && ("whitespace".equals(category = offsetToken.id().primaryCategory()) || "comment".equals(category) || "separator".equals(category) || "operator".equals(category))) {
                checkPrev = true;
            }
        }
        if (checkPrev && cppTokenSequence.movePrevious()) {
            offsetToken = TokenItemImpl.create(cppTokenSequence);
        }
        return offsetToken;
    }

    private static boolean processTokensImpl(CndTokenProcessor<Token<TokenId>> tp, TokenSequence<TokenId> cppTokenSequence, int startOffset, int lastOffset, boolean adjust) {
        boolean moved;
        boolean processedToken = false;
        boolean bwd = lastOffset < startOffset;
        boolean adjustOnFirstIteration = adjust;
        while (!tp.isStopped() && (moved = adjustOnFirstIteration || !bwd ? cppTokenSequence.moveNext() : cppTokenSequence.movePrevious())) {
            adjustOnFirstIteration = false;
            Token token = cppTokenSequence.token();
            if (!bwd ? cppTokenSequence.offset() >= lastOffset : cppTokenSequence.offset() + token.length() < lastOffset) break;
            if (tp.token((Token<TokenId>)token, cppTokenSequence.offset())) {
                TokenSequence embedded = cppTokenSequence.embedded();
                if (embedded == null) continue;
                int shift = 0;
                if (cppTokenSequence.offset() < startOffset) {
                    shift = embedded.move(startOffset);
                }
                processedToken |= CndTokenUtilities.processTokensImpl(tp, (TokenSequence<TokenId>)embedded, startOffset, lastOffset, shift != 0);
                continue;
            }
            processedToken = true;
        }
        return processedToken;
    }

    static {
        skipWSCategories.add("whitespace");
    }

    private static final class TokenItemImpl<T extends TokenId>
    extends TokenItem.AbstractItem<T> {
        public TokenItemImpl(T tokenID, PartType pt, int offset, CharSequence text) {
            super(tokenID, pt, offset, text);
        }

        private static <T extends TokenId> TokenItem<T> create(TokenSequence<T> ts) {
            Token token = ts.token();
            return new TokenItemImpl<TokenId>(token.id(), token.partType(), ts.offset(), token.text());
        }

        private static <T extends TokenId> TokenItem<T> create(Token<T> token, int offset) {
            return new TokenItemImpl<TokenId>(token.id(), token.partType(), offset, token.text());
        }
    }

    private static class SkipTokenProcessor
    extends CndAbstractTokenProcessor<Token<TokenId>> {
        private boolean stopped = false;
        private TokenItem<TokenId> tokenItem = null;
        private Token<TokenId> lastToken = null;
        private final Set<TokenId> skipTokenIds;
        private final Set<String> skipTokenCategories;
        private final boolean processPP;

        public SkipTokenProcessor(Set<TokenId> skipTokenIds, Set<String> skipTokenCategories, boolean processPP) {
            this.skipTokenIds = skipTokenIds;
            this.skipTokenCategories = skipTokenCategories;
            this.processPP = processPP;
        }

        @Override
        public boolean token(Token<TokenId> token, int tokenOffset) {
            this.lastToken = token;
            if (token.id() == CppTokenId.PREPROCESSOR_DIRECTIVE) {
                return this.processPP;
            }
            if (!this.skipTokenIds.contains(token.id()) && !this.skipTokenCategories.contains(token.id().primaryCategory())) {
                this.stopped = true;
            }
            return false;
        }

        @Override
        public boolean isStopped() {
            return this.stopped;
        }

        public TokenItem<TokenId> getTokenItem() {
            return this.tokenItem;
        }

        @Override
        public void end(int offset, int lastTokenOffset) {
            super.end(offset, lastTokenOffset);
            if (this.lastToken != null) {
                this.tokenItem = TokenItemImpl.create(this.lastToken, lastTokenOffset);
            }
        }
    }
}

