/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.indexing;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.tools.javac.api.BasicJavacTask;
import com.sun.tools.javac.api.JavacTaskImpl;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeScanner;
import com.sun.tools.javac.util.CancelAbort;
import com.sun.tools.javac.util.CancelService;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.CouplingAbort;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.MissingPlatformError;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import javax.lang.model.element.TypeElement;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.modules.java.source.TreeLoader;
import org.netbeans.modules.java.source.indexing.APTUtils;
import org.netbeans.modules.java.source.indexing.CompileWorker;
import org.netbeans.modules.java.source.indexing.DiagnosticListenerImpl;
import org.netbeans.modules.java.source.indexing.JavaCustomIndexer;
import org.netbeans.modules.java.source.indexing.JavaIndex;
import org.netbeans.modules.java.source.indexing.JavaParsingContext;
import org.netbeans.modules.java.source.parsing.FileObjects;
import org.netbeans.modules.java.source.parsing.InferableJavaFileObject;
import org.netbeans.modules.java.source.parsing.JavacParser;
import org.netbeans.modules.java.source.parsing.OutputFileManager;
import org.netbeans.modules.java.source.usages.ClassNamesForFileOraculumImpl;
import org.netbeans.modules.java.source.usages.ClasspathInfoAccessor;
import org.netbeans.modules.java.source.usages.ExecutableFilesIndex;
import org.netbeans.modules.java.source.usages.Pair;
import org.netbeans.modules.parsing.lucene.support.LowMemoryWatcher;
import org.netbeans.modules.parsing.spi.indexing.Indexable;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

final class OnePassCompileWorker
extends CompileWorker {
    OnePassCompileWorker() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    CompileWorker.ParsingOutput compile(CompileWorker.ParsingOutput previous, final org.netbeans.modules.parsing.spi.indexing.Context context, JavaParsingContext javaContext, Iterable<? extends JavaCustomIndexer.CompileTuple> files) {
        ClassPath sourcePath;
        ClassPath classPath;
        ClassPath bootPath;
        JavaFileManager fileManager = ClasspathInfoAccessor.getINSTANCE().getFileManager(javaContext.cpInfo);
        HashMap<JavaFileObject, List<String>> file2FQNs = previous != null ? previous.file2FQNs : new HashMap<JavaFileObject, List<String>>();
        HashSet<ElementHandle<TypeElement>> addedTypes = previous != null ? previous.addedTypes : new HashSet<ElementHandle<TypeElement>>();
        HashSet<File> createdFiles = previous != null ? previous.createdFiles : new HashSet<File>();
        final HashSet<Indexable> finished = previous != null ? previous.finishedFiles : new HashSet<Indexable>();
        HashSet<ElementHandle<TypeElement>> modifiedTypes = previous != null ? previous.modifiedTypes : new HashSet<ElementHandle<TypeElement>>();
        HashSet<JavaCustomIndexer.CompileTuple> aptGenerated = previous != null ? previous.aptGenerated : new HashSet<JavaCustomIndexer.CompileTuple>();
        ClassNamesForFileOraculumImpl cnffOraculum = new ClassNamesForFileOraculumImpl(file2FQNs);
        LowMemoryWatcher mem = LowMemoryWatcher.getInstance();
        DiagnosticListenerImpl dc = new DiagnosticListenerImpl();
        final HashMap<InferableJavaFileObject, Pair<CompilationUnitTree, JavaCustomIndexer.CompileTuple>> jfo2units = new HashMap<InferableJavaFileObject, Pair<CompilationUnitTree, JavaCustomIndexer.CompileTuple>>();
        LinkedList<Pair<CompilationUnitTree, JavaCustomIndexer.CompileTuple>> units = new LinkedList<Pair<CompilationUnitTree, JavaCustomIndexer.CompileTuple>>();
        BasicJavacTask jt = null;
        for (JavaCustomIndexer.CompileTuple compileTuple : files) {
            if (context.isCancelled()) {
                return null;
            }
            try {
                if (mem.isLowMemory()) {
                    jt = null;
                    units = null;
                    dc.cleanDiagnostics();
                    System.gc();
                }
                if (jt == null) {
                    jt = JavacParser.createJavacTask(javaContext.cpInfo, dc, javaContext.sourceLevel, cnffOraculum, javaContext.fqn2Files, new CancelService(){

                        public boolean isCanceled() {
                            return context.isCancelled();
                        }
                    }, APTUtils.get(context.getRoot()));
                }
                for (CompilationUnitTree cut : jt.parse(new JavaFileObject[]{compileTuple.jfo})) {
                    if (units != null) {
                        Pair<CompilationUnitTree, JavaCustomIndexer.CompileTuple> unit = Pair.of(cut, compileTuple);
                        units.add(unit);
                        jfo2units.put(compileTuple.jfo, unit);
                    }
                    this.computeFQNs(file2FQNs, cut, compileTuple);
                }
                Log.instance((Context)jt.getContext()).nerrors = 0;
            }
            catch (CancelAbort ca) {
                if (!JavaIndex.LOG.isLoggable(Level.FINEST)) continue;
                JavaIndex.LOG.log(Level.FINEST, "OnePassCompileWorker was canceled in root: " + FileUtil.getFileDisplayName((FileObject)context.getRoot()), ca);
            }
            catch (Throwable t) {
                if (JavaIndex.LOG.isLoggable(Level.WARNING)) {
                    ClassPath bootPath2 = javaContext.cpInfo.getClassPath(ClasspathInfo.PathKind.BOOT);
                    ClassPath classPath2 = javaContext.cpInfo.getClassPath(ClasspathInfo.PathKind.COMPILE);
                    ClassPath sourcePath2 = javaContext.cpInfo.getClassPath(ClasspathInfo.PathKind.SOURCE);
                    String message = String.format("OnePassCompileWorker caused an exception\nFile: %s\nRoot: %s\nBootpath: %s\nClasspath: %s\nSourcepath: %s", compileTuple.indexable.getURL().toString(), FileUtil.getFileDisplayName((FileObject)context.getRoot()), bootPath2 == null ? null : bootPath2.toString(), classPath2 == null ? null : classPath2.toString(), sourcePath2 == null ? null : sourcePath2.toString());
                    JavaIndex.LOG.log(Level.WARNING, message, t);
                }
                if (t instanceof ThreadDeath) {
                    throw (ThreadDeath)t;
                }
                jt = null;
                units = null;
                dc.cleanDiagnostics();
                System.gc();
            }
        }
        if (units == null) return new CompileWorker.ParsingOutput(false, file2FQNs, addedTypes, createdFiles, finished, modifiedTypes, aptGenerated);
        if (JavaCustomIndexer.NO_ONE_PASS_COMPILE_WORKER) {
            return new CompileWorker.ParsingOutput(false, file2FQNs, addedTypes, createdFiles, finished, modifiedTypes, aptGenerated);
        }
        JavaCustomIndexer.CompileTuple active = null;
        Iterable iterable = jt != null ? jt.getProcessors() : null;
        boolean aptEnabled = iterable != null && iterable.iterator().hasNext();
        try {
            block11: while (!units.isEmpty()) {
                if (context.isCancelled()) {
                    return null;
                }
                Pair unit = (Pair)units.removeFirst();
                active = (JavaCustomIndexer.CompileTuple)unit.second;
                if (finished.contains(active.indexable)) continue;
                if (mem.isLowMemory()) {
                    units = null;
                    System.gc();
                    return new CompileWorker.ParsingOutput(false, file2FQNs, addedTypes, createdFiles, finished, modifiedTypes, aptGenerated);
                }
                Iterable types = jt.enterTrees(Collections.singletonList(unit.first));
                if (jfo2units.remove(active.jfo) != null) {
                    final Types ts = Types.instance(jt.getContext());
                    final Indexable activeIndexable = active.indexable;
                    class ScanNested
                    extends TreeScanner {
                        Set<Pair<CompilationUnitTree, JavaCustomIndexer.CompileTuple>> dependencies = new LinkedHashSet<Pair<CompilationUnitTree, JavaCustomIndexer.CompileTuple>>();

                        ScanNested() {
                        }

                        @Override
                        public void visitClassDef(JCTree.JCClassDecl node) {
                            if (node.sym != null) {
                                Type st = ts.supertype(node.sym.type);
                                if (st.tag == 10) {
                                    Symbol.ClassSymbol c = st.tsym.outermostClass();
                                    Pair u = (Pair)jfo2units.remove(c.sourcefile);
                                    if (u != null && !finished.contains(((JavaCustomIndexer.CompileTuple)u.second).indexable) && !((JavaCustomIndexer.CompileTuple)u.second).indexable.equals((Object)activeIndexable) && this.dependencies.add(u)) {
                                        this.scan((JCTree.JCCompilationUnit)u.first);
                                    }
                                }
                            }
                            super.visitClassDef(node);
                        }
                    }
                    ScanNested scanNested = new ScanNested();
                    scanNested.scan((JCTree.JCCompilationUnit)unit.first);
                    if (!scanNested.dependencies.isEmpty()) {
                        units.addFirst(unit);
                        Iterator<Pair<CompilationUnitTree, JavaCustomIndexer.CompileTuple>> i$ = scanNested.dependencies.iterator();
                        while (true) {
                            if (!i$.hasNext()) continue block11;
                            Pair<CompilationUnitTree, JavaCustomIndexer.CompileTuple> pair = i$.next();
                            units.addFirst(pair);
                        }
                    }
                }
                if (mem.isLowMemory()) {
                    units = null;
                    System.gc();
                    return new CompileWorker.ParsingOutput(false, file2FQNs, addedTypes, createdFiles, finished, modifiedTypes, aptGenerated);
                }
                ((JavacTaskImpl)jt).analyze(types);
                if (aptEnabled) {
                    JavaCustomIndexer.addAptGenerated(context, javaContext, active.indexable.getRelativePath(), aptGenerated);
                }
                if (mem.isLowMemory()) {
                    units = null;
                    System.gc();
                    return new CompileWorker.ParsingOutput(false, file2FQNs, addedTypes, createdFiles, finished, modifiedTypes, aptGenerated);
                }
                javaContext.fqn2Files.set(types, active.indexable.getURL());
                boolean[] main = new boolean[1];
                if (javaContext.checkSums.checkAndSet(active.indexable.getURL(), types, jt.getElements()) || context.isSupplementaryFilesIndexing()) {
                    javaContext.sa.analyse(Collections.singleton(unit.first), (JavacTaskImpl)jt, fileManager, (JavaCustomIndexer.CompileTuple)unit.second, addedTypes, main);
                } else {
                    HashSet aTypes = new HashSet();
                    javaContext.sa.analyse(Collections.singleton(unit.first), (JavacTaskImpl)jt, fileManager, (JavaCustomIndexer.CompileTuple)unit.second, aTypes, main);
                    addedTypes.addAll(aTypes);
                    modifiedTypes.addAll(aTypes);
                }
                ExecutableFilesIndex.DEFAULT.setMainClass(context.getRoot().getURL(), active.indexable.getURL(), main[0]);
                for (JavaFileObject javaFileObject : ((JavacTaskImpl)jt).generate(types)) {
                    if (!(javaFileObject instanceof FileObjects.FileBase)) continue;
                    createdFiles.add(((FileObjects.FileBase)javaFileObject).getFile());
                }
                JavaCustomIndexer.setErrors(context, active, dc);
                Log.instance((Context)jt.getContext()).nerrors = 0;
                finished.add(active.indexable);
            }
            return new CompileWorker.ParsingOutput(true, file2FQNs, addedTypes, createdFiles, finished, modifiedTypes, aptGenerated);
        }
        catch (CouplingAbort ca) {
            TreeLoader.dumpCouplingAbort(ca, null);
            return new CompileWorker.ParsingOutput(false, file2FQNs, addedTypes, createdFiles, finished, modifiedTypes, aptGenerated);
        }
        catch (OutputFileManager.InvalidSourcePath isp) {
            if (!JavaIndex.LOG.isLoggable(Level.FINEST)) return new CompileWorker.ParsingOutput(false, file2FQNs, addedTypes, createdFiles, finished, modifiedTypes, aptGenerated);
            bootPath = javaContext.cpInfo.getClassPath(ClasspathInfo.PathKind.BOOT);
            classPath = javaContext.cpInfo.getClassPath(ClasspathInfo.PathKind.COMPILE);
            sourcePath = javaContext.cpInfo.getClassPath(ClasspathInfo.PathKind.SOURCE);
            String string = String.format("OnePassCompileWorker caused an exception\nFile: %s\nRoot: %s\nBootpath: %s\nClasspath: %s\nSourcepath: %s", active.jfo.toUri().toString(), FileUtil.getFileDisplayName((FileObject)context.getRoot()), bootPath == null ? null : bootPath.toString(), classPath == null ? null : classPath.toString(), sourcePath == null ? null : sourcePath.toString());
            JavaIndex.LOG.log(Level.FINEST, string, isp);
            return new CompileWorker.ParsingOutput(false, file2FQNs, addedTypes, createdFiles, finished, modifiedTypes, aptGenerated);
        }
        catch (MissingPlatformError mpe) {
            if (!JavaIndex.LOG.isLoggable(Level.FINEST)) return new CompileWorker.ParsingOutput(false, file2FQNs, addedTypes, createdFiles, finished, modifiedTypes, aptGenerated);
            bootPath = javaContext.cpInfo.getClassPath(ClasspathInfo.PathKind.BOOT);
            classPath = javaContext.cpInfo.getClassPath(ClasspathInfo.PathKind.COMPILE);
            sourcePath = javaContext.cpInfo.getClassPath(ClasspathInfo.PathKind.SOURCE);
            String string = String.format("OnePassCompileWorker caused an exception\nFile: %s\nRoot: %s\nBootpath: %s\nClasspath: %s\nSourcepath: %s", active.jfo.toUri().toString(), FileUtil.getFileDisplayName((FileObject)context.getRoot()), bootPath == null ? null : bootPath.toString(), classPath == null ? null : classPath.toString(), sourcePath == null ? null : sourcePath.toString());
            JavaIndex.LOG.log(Level.FINEST, string, mpe);
            return new CompileWorker.ParsingOutput(false, file2FQNs, addedTypes, createdFiles, finished, modifiedTypes, aptGenerated);
        }
        catch (CancelAbort ca) {
            if (!JavaIndex.LOG.isLoggable(Level.FINEST)) return new CompileWorker.ParsingOutput(false, file2FQNs, addedTypes, createdFiles, finished, modifiedTypes, aptGenerated);
            JavaIndex.LOG.log(Level.FINEST, "OnePassCompileWorker was canceled in root: " + FileUtil.getFileDisplayName((FileObject)context.getRoot()), ca);
            return new CompileWorker.ParsingOutput(false, file2FQNs, addedTypes, createdFiles, finished, modifiedTypes, aptGenerated);
        }
        catch (Throwable t) {
            if (t instanceof ThreadDeath) {
                throw (ThreadDeath)t;
            }
            if (!JavaIndex.LOG.isLoggable(Level.WARNING)) return new CompileWorker.ParsingOutput(false, file2FQNs, addedTypes, createdFiles, finished, modifiedTypes, aptGenerated);
            bootPath = javaContext.cpInfo.getClassPath(ClasspathInfo.PathKind.BOOT);
            classPath = javaContext.cpInfo.getClassPath(ClasspathInfo.PathKind.COMPILE);
            sourcePath = javaContext.cpInfo.getClassPath(ClasspathInfo.PathKind.SOURCE);
            String string = String.format("OnePassCompileWorker caused an exception\nFile: %s\nRoot: %s\nBootpath: %s\nClasspath: %s\nSourcepath: %s", active.jfo.toUri().toString(), FileUtil.getFileDisplayName((FileObject)context.getRoot()), bootPath == null ? null : bootPath.toString(), classPath == null ? null : classPath.toString(), sourcePath == null ? null : sourcePath.toString());
            JavaIndex.LOG.log(Level.WARNING, string, t);
        }
        return new CompileWorker.ParsingOutput(false, file2FQNs, addedTypes, createdFiles, finished, modifiedTypes, aptGenerated);
    }
}

