/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.classpath;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.net.URL;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.queries.AnnotationProcessingQuery;
import org.netbeans.modules.java.source.classpath.AptCacheForSourceQuery;
import org.netbeans.modules.java.source.indexing.JavaIndex;
import org.netbeans.modules.java.source.usages.ClassIndexManager;
import org.netbeans.modules.java.source.usages.ClassIndexManagerEvent;
import org.netbeans.modules.java.source.usages.ClassIndexManagerListener;
import org.netbeans.spi.java.classpath.ClassPathFactory;
import org.netbeans.spi.java.classpath.ClassPathImplementation;
import org.netbeans.spi.java.classpath.FilteringPathResourceImplementation;
import org.netbeans.spi.java.classpath.PathResourceImplementation;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.filesystems.FileObject;
import org.openide.util.Parameters;
import org.openide.util.WeakListeners;

public class SourcePath
implements ClassPathImplementation,
ClassIndexManagerListener,
PropertyChangeListener {
    private final PropertyChangeSupport listeners = new PropertyChangeSupport(this);
    private final ClassPath delegate;
    private final ClassIndexManager manager;
    private final Function<List<ClassPath.Entry>, List<PathResourceImplementation>> f;
    private List<PathResourceImplementation> resources;
    private long eventId;

    private SourcePath(@NonNull ClassPath delegate, @NonNull Function<List<ClassPath.Entry>, List<PathResourceImplementation>> f) {
        assert (delegate != null);
        assert (f != null);
        this.delegate = delegate;
        this.f = f;
        this.manager = ClassIndexManager.getDefault();
        this.manager.addClassIndexManagerListener((ClassIndexManagerListener)WeakListeners.create(ClassIndexManagerListener.class, (EventListener)this, (Object)this.manager));
        delegate.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)delegate));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<? extends PathResourceImplementation> getResources() {
        long currentEventId;
        SourcePath sourcePath = this;
        synchronized (sourcePath) {
            if (this.resources != null) {
                return this.resources;
            }
            currentEventId = this.eventId;
        }
        List<PathResourceImplementation> res = this.f.apply(this.delegate.entries());
        SourcePath sourcePath2 = this;
        synchronized (sourcePath2) {
            if (currentEventId == this.eventId) {
                if (this.resources == null) {
                    this.resources = res;
                } else {
                    res = this.resources;
                }
            }
        }
        assert (res != null);
        return res;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        Parameters.notNull((CharSequence)"listener", (Object)listener);
        this.listeners.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        Parameters.notNull((CharSequence)"listener", (Object)listener);
        this.listeners.removePropertyChangeListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void classIndexAdded(ClassIndexManagerEvent event) {
        ClassPath.Entry entry;
        if (this.f.forcePrefSources) {
            return;
        }
        Set<? extends URL> newRoots = event.getRoots();
        boolean changed = false;
        Iterator i$ = this.delegate.entries().iterator();
        while (i$.hasNext() && !(changed = newRoots.contains((entry = (ClassPath.Entry)i$.next()).getURL()))) {
        }
        if (changed) {
            SourcePath sourcePath = this;
            synchronized (sourcePath) {
                this.resources = null;
                ++this.eventId;
            }
            this.listeners.firePropertyChange("resources", null, null);
        }
    }

    @Override
    public void classIndexRemoved(ClassIndexManagerEvent event) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propertyChange(PropertyChangeEvent event) {
        SourcePath sourcePath = this;
        synchronized (sourcePath) {
            this.resources = null;
            ++this.eventId;
        }
        this.listeners.firePropertyChange("resources", null, null);
    }

    public static ClassPath sources(ClassPath cp, boolean bkgComp) {
        assert (cp != null);
        return ClassPathFactory.createClassPath((ClassPathImplementation)new SourcePath(cp, new MapToSources(bkgComp)));
    }

    public static ClassPath apt(ClassPath cp, boolean bkgComp) {
        assert (cp != null);
        return ClassPathFactory.createClassPath((ClassPathImplementation)new SourcePath(cp, new MapToAptCache(bkgComp)));
    }

    public static ClassPath aptOputput(ClassPath cp, boolean bkgComp) {
        assert (cp != null);
        return ClassPathFactory.createClassPath((ClassPathImplementation)new SourcePath(cp, new MapToAptGenerated(bkgComp)));
    }

    @NonNull
    static Set<? extends URL> getAptBuildGeneratedFolders(@NonNull List<ClassPath.Entry> entries) {
        HashSet<URL> roots = new HashSet<URL>();
        LinkedHashSet<URL> aptRoots = new LinkedHashSet<URL>();
        for (ClassPath.Entry entry : entries) {
            roots.add(entry.getURL());
        }
        for (ClassPath.Entry entry : entries) {
            URL aptRoot;
            FileObject fo = entry.getRoot();
            if (fo == null || !roots.contains(aptRoot = AnnotationProcessingQuery.getAnnotationProcessingOptions((FileObject)fo).sourceOutputDirectory())) continue;
            aptRoots.add(aptRoot);
        }
        return aptRoots;
    }

    private static class MapToAptGenerated
    extends Function<List<ClassPath.Entry>, List<PathResourceImplementation>> {
        private MapToAptGenerated(boolean forcePrefSources) {
            super(forcePrefSources);
        }

        @Override
        List<PathResourceImplementation> apply(List<ClassPath.Entry> entries) {
            Set<? extends URL> aptGenerated = SourcePath.getAptBuildGeneratedFolders(entries);
            ArrayList<PathResourceImplementation> resources = new ArrayList<PathResourceImplementation>(aptGenerated.size());
            for (URL uRL : aptGenerated) {
                resources.add(ClassPathSupport.createResource((URL)uRL));
            }
            return resources;
        }
    }

    private static class MapToAptCache
    extends Function<List<ClassPath.Entry>, List<PathResourceImplementation>> {
        private MapToAptCache(boolean forcePrefSources) {
            super(forcePrefSources);
        }

        @Override
        List<PathResourceImplementation> apply(List<ClassPath.Entry> entries) {
            ArrayList<PathResourceImplementation> res = new ArrayList<PathResourceImplementation>();
            for (ClassPath.Entry entry : entries) {
                URL aptRoot;
                if (!this.forcePrefSources && JavaIndex.isLibrary(entry.getURL()) || (aptRoot = AptCacheForSourceQuery.getAptFolder(entry.getURL())) == null) continue;
                res.add(ClassPathSupport.createResource((URL)aptRoot));
            }
            return res;
        }
    }

    private static class MapToSources
    extends Function<List<ClassPath.Entry>, List<PathResourceImplementation>> {
        private MapToSources(boolean forcePrefSources) {
            super(forcePrefSources);
        }

        @Override
        List<PathResourceImplementation> apply(List<ClassPath.Entry> entries) {
            ArrayList<PathResourceImplementation> res = new ArrayList<PathResourceImplementation>();
            Set<? extends URL> aptBuildGenerated = SourcePath.getAptBuildGeneratedFolders(entries);
            for (ClassPath.Entry entry : entries) {
                if (!this.forcePrefSources && JavaIndex.isLibrary(entry.getURL()) || aptBuildGenerated.contains(entry.getURL())) continue;
                res.add((PathResourceImplementation)new FR(entry));
            }
            return res;
        }
    }

    private static abstract class Function<P, R> {
        protected final boolean forcePrefSources;

        public Function(boolean forcePrefSources) {
            this.forcePrefSources = forcePrefSources;
        }

        abstract R apply(P var1);
    }

    private static class FR
    implements FilteringPathResourceImplementation,
    PropertyChangeListener {
        private final ClassPath classPath;
        private final ClassPath.Entry entry;
        private final PropertyChangeSupport support;
        private final URL[] cache;

        public FR(ClassPath.Entry entry) {
            assert (entry != null);
            this.support = new PropertyChangeSupport(this);
            this.entry = entry;
            this.classPath = entry.getDefiningClassPath();
            this.classPath.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.classPath));
            this.cache = new URL[]{entry.getURL()};
        }

        public boolean includes(URL root, String resource) {
            assert (this.cache[0].equals(root));
            return this.entry.includes(resource);
        }

        public URL[] getRoots() {
            return this.cache;
        }

        public ClassPathImplementation getContent() {
            return null;
        }

        public void addPropertyChangeListener(PropertyChangeListener listener) {
            this.support.addPropertyChangeListener(listener);
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
            this.support.removePropertyChangeListener(listener);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("includes".equals(evt.getPropertyName())) {
                this.support.firePropertyChange("includes", null, null);
            }
        }
    }
}

