/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.java.source.support;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.JTextComponent;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.JavaSourceTaskFactory;
import org.netbeans.api.java.source.support.OpenedEditors;
import org.openide.filesystems.FileObject;
import org.openide.util.RequestProcessor;

public abstract class CaretAwareJavaSourceTaskFactory
extends JavaSourceTaskFactory {
    private static final int DEFAULT_RESCHEDULE_TIMEOUT = 300;
    private static final RequestProcessor WORKER = new RequestProcessor("CaretAwareJavaSourceTaskFactory worker");
    private int timeout;
    private String[] supportedMimeTypes;
    private Map<JTextComponent, ComponentListener> component2Listener = new WeakHashMap<JTextComponent, ComponentListener>();
    private static Map<FileObject, Integer> file2LastPosition = new WeakHashMap<FileObject, Integer>();

    public CaretAwareJavaSourceTaskFactory(JavaSource.Phase phase, JavaSource.Priority priority) {
        this(phase, priority, null);
    }

    public CaretAwareJavaSourceTaskFactory(JavaSource.Phase phase, JavaSource.Priority priority, String ... supportedMimeTypes) {
        super(phase, priority);
        OpenedEditors.getDefault().addChangeListener(new ChangeListenerImpl());
        this.timeout = 300;
        this.supportedMimeTypes = supportedMimeTypes != null ? (String[])supportedMimeTypes.clone() : null;
    }

    public List<FileObject> getFileObjects() {
        List<FileObject> files = OpenedEditors.filterSupportedMIMETypes(OpenedEditors.getDefault().getVisibleEditorsFiles(), this.supportedMimeTypes);
        return files;
    }

    public static synchronized int getLastPosition(FileObject file) {
        if (file == null) {
            throw new NullPointerException("Cannot pass null file!");
        }
        Integer position = file2LastPosition.get(file);
        if (position == null) {
            return 0;
        }
        return position;
    }

    static synchronized void setLastPosition(FileObject file, int position) {
        file2LastPosition.put(file, position);
    }

    private class ComponentListener
    implements CaretListener,
    Runnable {
        private final Reference<JTextComponent> component;
        private final RequestProcessor.Task rescheduleTask;

        public ComponentListener(JTextComponent component) {
            this.component = new WeakReference<JTextComponent>(component);
            this.rescheduleTask = WORKER.create((Runnable)this);
        }

        @Override
        public void run() {
            JTextComponent c = this.component.get();
            if (c == null) {
                return;
            }
            FileObject file = OpenedEditors.getFileObject(c);
            if (file != null) {
                CaretAwareJavaSourceTaskFactory.this.reschedule(file);
            }
        }

        @Override
        public void caretUpdate(CaretEvent e) {
            JTextComponent c = this.component.get();
            if (c == null) {
                return;
            }
            FileObject file = OpenedEditors.getFileObject(c);
            if (file != null) {
                CaretAwareJavaSourceTaskFactory.setLastPosition(file, c.getCaretPosition());
                this.rescheduleTask.schedule(CaretAwareJavaSourceTaskFactory.this.timeout);
            }
        }
    }

    private class ChangeListenerImpl
    implements ChangeListener {
        private ChangeListenerImpl() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            ArrayList<JTextComponent> added = new ArrayList<JTextComponent>(OpenedEditors.getDefault().getVisibleEditors());
            ArrayList removed = new ArrayList(CaretAwareJavaSourceTaskFactory.this.component2Listener.keySet());
            added.removeAll(CaretAwareJavaSourceTaskFactory.this.component2Listener.keySet());
            removed.removeAll(OpenedEditors.getDefault().getVisibleEditors());
            for (JTextComponent c : removed) {
                c.removeCaretListener((CaretListener)CaretAwareJavaSourceTaskFactory.this.component2Listener.remove(c));
            }
            for (JTextComponent c : added) {
                ComponentListener l = new ComponentListener(c);
                c.addCaretListener(l);
                CaretAwareJavaSourceTaskFactory.this.component2Listener.put(c, l);
                CaretAwareJavaSourceTaskFactory.setLastPosition(OpenedEditors.getFileObject(c), c.getCaretPosition());
            }
            CaretAwareJavaSourceTaskFactory.this.fileObjectsChanged();
        }
    }
}

