/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.java.source;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.Scope;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import com.sun.tools.javac.code.Scope;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.comp.Check;
import com.sun.tools.javac.model.JavacElements;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Context;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.processing.Completion;
import javax.annotation.processing.Processor;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.ElementScanner6;
import javax.swing.SwingUtilities;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.SuppressWarnings;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.classpath.GlobalPathRegistry;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.ElementUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.java.preprocessorbridge.spi.ImportProcessor;
import org.netbeans.modules.java.source.JavadocHelper;
import org.netbeans.modules.java.source.indexing.JavaCustomIndexer;
import org.netbeans.modules.java.source.parsing.ClasspathInfoProvider;
import org.netbeans.modules.java.source.parsing.FileObjects;
import org.netbeans.modules.java.source.usages.ClassIndexImpl;
import org.netbeans.modules.java.source.usages.ClassIndexManager;
import org.netbeans.modules.java.source.usages.ClasspathInfoAccessor;
import org.netbeans.modules.java.source.usages.ExecutableFilesIndex;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.api.indexing.IndexingManager;
import org.netbeans.modules.parsing.impl.indexing.friendapi.IndexingController;
import org.netbeans.modules.parsing.lucene.support.IndexManager;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.Parameters;
import org.openide.util.Utilities;

public class SourceUtils {
    private static final Logger LOG = Logger.getLogger(SourceUtils.class.getName());
    private static final int MAX_LEN = 6;
    private static char[] VOWELS = new char[]{'a', 'e', 'i', 'o', 'u', 'y', '\u00e9', '\u00ea', '\u00e8', '\u00e1', '\u00e2', '\u00e6', '\u00e0', '\u03b1', '\u00e3', '\u00e5', '\u00e4', '\u00eb', '\u00f3', '\u00f4', '\u0153', '\u00f2', '\u03bf', '\u00f5', '\u00f6', '\u00ed', '\u00ee', '\u00ec', '\u03b9', '\u00ef', '\u00fa', '\u00fb', '\u00f9', '\u03d2', '\u03c5', '\u00fc', '\u0430', '\u043e', '\u044f', '\u0438', '\u0439', '\u0435', '\u044b', '\u044d', '\u0443', '\u044e'};

    private SourceUtils() {
    }

    public static TokenSequence<JavaTokenId> getJavaTokenSequence(TokenHierarchy hierarchy, int offset) {
        if (hierarchy != null) {
            for (TokenSequence ts = hierarchy.tokenSequence(); ts != null && (offset == 0 || ts.moveNext()); ts = ts.embedded()) {
                ts.move(offset);
                if (ts.language() == JavaTokenId.language()) {
                    return ts;
                }
                if (ts.moveNext() || ts.movePrevious()) continue;
                return null;
            }
        }
        return null;
    }

    public static boolean checkTypesAssignable(CompilationInfo info, TypeMirror from, TypeMirror to) {
        Context c = info.impl.getJavacTask().getContext();
        if (from.getKind() == TypeKind.WILDCARD) {
            from = Types.instance(c).upperBound((Type)from);
        }
        return Check.instance(c).checkType(null, (Type)from, (Type)to).getKind() != TypeKind.ERROR;
    }

    public static TypeMirror getBound(WildcardType wildcardType) {
        Type.TypeVar bound = ((Type.WildcardType)wildcardType).bound;
        return bound != null ? bound.bound : null;
    }

    public static List<? extends Completion> getAttributeValueCompletions(CompilationInfo info, Element element, AnnotationMirror annotation, ExecutableElement member, String userText) {
        LinkedList<Completion> completions = new LinkedList<Completion>();
        if (info.getPhase().compareTo(JavaSource.Phase.ELEMENTS_RESOLVED) >= 0) {
            String fqn = ((TypeElement)annotation.getAnnotationType().asElement()).getQualifiedName().toString();
            Iterable processors = info.impl.getJavacTask().getProcessors();
            if (processors != null) {
                for (Processor processor : processors) {
                    boolean match = false;
                    for (String string : processor.getSupportedAnnotationTypes()) {
                        if ("*".equals(string)) {
                            match = true;
                            break;
                        }
                        if (string.endsWith(".*")) {
                            String string2 = string.substring(0, string.length() - 1);
                            if (!fqn.startsWith(string2)) continue;
                            match = true;
                            break;
                        }
                        if (!fqn.equals(string)) continue;
                        match = true;
                        break;
                    }
                    if (!match) continue;
                    try {
                        for (Completion completion : processor.getCompletions(element, annotation, member, userText)) {
                            completions.add(completion);
                        }
                    }
                    catch (Exception e) {
                        Logger.getLogger(processor.getClass().getName()).log(Level.INFO, e.getMessage(), e);
                    }
                }
            }
        }
        return completions;
    }

    @Deprecated
    public static TypeElement getEnclosingTypeElement(Element element) throws IllegalArgumentException {
        return ElementUtilities.enclosingTypeElementImpl(element);
    }

    public static TypeElement getOutermostEnclosingTypeElement(Element element) {
        Element ec = SourceUtils.getEnclosingTypeElement(element);
        if (ec == null) {
            ec = element;
        }
        while (ec.getEnclosingElement().getKind().isClass() || ec.getEnclosingElement().getKind().isInterface()) {
            ec = ec.getEnclosingElement();
        }
        return (TypeElement)ec;
    }

    public static String resolveImport(final CompilationInfo info, TreePath context, final String fqn) throws NullPointerException, IOException {
        if (info == null) {
            throw new NullPointerException();
        }
        if (context == null) {
            throw new NullPointerException();
        }
        if (fqn == null) {
            throw new NullPointerException();
        }
        CompilationUnitTree cut = info.getCompilationUnit();
        final Trees trees = info.getTrees();
        final Scope scope = trees.getScope(context);
        String qName = fqn;
        StringBuilder sqName = new StringBuilder();
        String sName = null;
        boolean clashing = false;
        ElementUtilities eu = info.getElementUtilities();
        ElementUtilities.ElementAcceptor acceptor = new ElementUtilities.ElementAcceptor(){

            @Override
            public boolean accept(Element e, TypeMirror type) {
                return (e.getKind().isClass() || e.getKind().isInterface()) && trees.isAccessible(scope, (TypeElement)e);
            }
        };
        while (qName != null && qName.length() > 0) {
            int lastDot = qName.lastIndexOf(46);
            String simple = qName.substring(lastDot < 0 ? 0 : lastDot + 1);
            if (sName == null) {
                sName = simple;
            } else {
                sqName.insert(0, '.');
            }
            sqName.insert(0, simple);
            if (info.getElements().getTypeElement(qName) != null) {
                boolean matchFound = false;
                for (Element element : eu.getLocalMembersAndVars(scope, acceptor)) {
                    if (!simple.contentEquals(element.getSimpleName())) continue;
                    if (qName.contentEquals(((TypeElement)element).getQualifiedName())) {
                        return sqName.toString();
                    }
                    if (fqn == qName) {
                        clashing = true;
                    }
                    matchFound = true;
                    break;
                }
                if (!matchFound) {
                    for (TypeElement typeElement : eu.getGlobalTypes(acceptor)) {
                        if (!simple.contentEquals(typeElement.getSimpleName())) continue;
                        if (qName.contentEquals(typeElement.getQualifiedName())) {
                            return sqName.toString();
                        }
                        if (fqn != qName) break;
                        clashing = true;
                        break;
                    }
                }
            }
            qName = lastDot < 0 ? null : qName.substring(0, lastDot);
        }
        if (clashing) {
            return fqn;
        }
        String topLevelLanguageMIMEType = info.getFileObject().getMIMEType();
        if ("text/x-java".equals(topLevelLanguageMIMEType)) {
            if (info instanceof WorkingCopy) {
                CompilationUnitTree nue = (CompilationUnitTree)((WorkingCopy)info).getChangeSet().get(cut);
                cut = nue != null ? nue : cut;
                ((WorkingCopy)info).rewrite(info.getCompilationUnit(), SourceUtils.addImports(cut, Collections.singletonList(fqn), ((WorkingCopy)info).getTreeMaker()));
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            ModificationResult.runModificationTask(Collections.singletonList(info.getSnapshot().getSource()), new UserTask(){

                                public void run(ResultIterator resultIterator) throws Exception {
                                    WorkingCopy copy = WorkingCopy.get(resultIterator.getParserResult());
                                    copy.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                                    copy.rewrite(copy.getCompilationUnit(), SourceUtils.addImports(copy.getCompilationUnit(), Collections.singletonList(fqn), copy.getTreeMaker()));
                                }
                            }).commit();
                        }
                        catch (Exception e) {
                            Exceptions.printStackTrace((Throwable)e);
                        }
                    }
                });
            }
        } else {
            Lookup lookup = MimeLookup.getLookup((MimePath)MimePath.get((String)topLevelLanguageMIMEType));
            Collection instances = lookup.lookupAll(ImportProcessor.class);
            for (ImportProcessor importProcessor : instances) {
                importProcessor.addImport(info.getDocument(), fqn);
            }
        }
        TypeElement te = info.getElements().getTypeElement(fqn);
        if (te != null) {
            JCTree.JCCompilationUnit unit = (JCTree.JCCompilationUnit)info.getCompilationUnit();
            Scope.ImportScope importScope = new Scope.ImportScope(unit.namedImportScope.owner);
            for (Symbol symbol : unit.namedImportScope.getElements()) {
                importScope.enter(symbol);
            }
            unit.namedImportScope = importScope;
            unit.namedImportScope.enterIfAbsent((Symbol)((Object)te));
        }
        return sName;
    }

    private static CompilationUnitTree addImports(CompilationUnitTree cut, List<String> toImport, TreeMaker make) throws IOException {
        toImport = new ArrayList<String>(toImport);
        Collections.sort(toImport);
        ArrayList<? extends ImportTree> imports = new ArrayList<ImportTree>(cut.getImports());
        int currentToImport = toImport.size() - 1;
        int currentExisting = imports.size() - 1;
        while (currentToImport >= 0 && currentExisting >= 0) {
            String currentToImportText = toImport.get(currentToImport);
            while (currentExisting >= 0 && (((ImportTree)imports.get(currentExisting)).isStatic() || ((ImportTree)imports.get(currentExisting)).getQualifiedIdentifier().toString().compareTo(currentToImportText) > 0)) {
                --currentExisting;
            }
            if (currentExisting < 0) continue;
            imports.add(currentExisting + 1, make.Import(make.Identifier(currentToImportText), false));
            --currentToImport;
        }
        while (currentToImport >= 0) {
            String importText = toImport.get(currentToImport);
            imports.add(0, make.Import(make.Identifier(importText), false));
            --currentToImport;
        }
        return make.CompilationUnit(cut.getPackageAnnotations(), cut.getPackageName(), imports, cut.getTypeDecls(), cut.getSourceFile());
    }

    public static FileObject getFile(Element element, ClasspathInfo cpInfo) {
        Element prev;
        Parameters.notNull((CharSequence)"element", (Object)element);
        Parameters.notNull((CharSequence)"cpInfo", (Object)cpInfo);
        Element element2 = prev = element.getKind() == ElementKind.PACKAGE ? element : null;
        while (element.getKind() != ElementKind.PACKAGE) {
            prev = element;
            element = element.getEnclosingElement();
        }
        ElementKind kind = prev.getKind();
        if (!kind.isClass() && !kind.isInterface() && kind != ElementKind.PACKAGE) {
            return null;
        }
        ElementHandle<Element> handle = ElementHandle.create(prev);
        return SourceUtils.getFile(handle, cpInfo);
    }

    public static FileObject getFile(ElementHandle<? extends Element> handle, ClasspathInfo cpInfo) {
        Parameters.notNull((CharSequence)"handle", handle);
        Parameters.notNull((CharSequence)"cpInfo", (Object)cpInfo);
        try {
            String pkgName;
            boolean pkg = handle.getKind() == ElementKind.PACKAGE;
            String[] signature = handle.getSignature();
            assert (signature.length >= 1);
            ClassPath cp = ClassPathSupport.createProxyClassPath((ClassPath[])new ClassPath[]{cpInfo.getClassPath(ClasspathInfo.PathKind.SOURCE), SourceUtils.createClassPath(cpInfo, ClasspathInfo.PathKind.OUTPUT), SourceUtils.createClassPath(cpInfo, ClasspathInfo.PathKind.BOOT), SourceUtils.createClassPath(cpInfo, ClasspathInfo.PathKind.COMPILE)});
            String className = null;
            if (pkg) {
                pkgName = FileObjects.convertPackage2Folder(signature[0]);
            } else {
                int index = signature[0].lastIndexOf(46);
                if (index < 0) {
                    pkgName = "";
                    className = signature[0];
                } else {
                    pkgName = FileObjects.convertPackage2Folder(signature[0].substring(0, index));
                    className = signature[0].substring(index + 1);
                }
            }
            List fos = cp.findAllResources(pkgName);
            for (FileObject fo : fos) {
                FileObject root = cp.findOwnerRoot(fo);
                if (root == null) continue;
                FileObject[] sourceRoots = SourceForBinaryQuery.findSourceRoots((URL)root.getURL()).getRoots();
                ClassPath sourcePath = ClassPathSupport.createClassPath((FileObject[])sourceRoots);
                LinkedList<FileObject> folders = new LinkedList<FileObject>(sourcePath.findAllResources(pkgName));
                if (pkg) {
                    return folders.isEmpty() ? fo : (FileObject)folders.get(0);
                }
                boolean caseSensitive = SourceUtils.isCaseSensitive();
                String sourceFileName = SourceUtils.getSourceFileName(className);
                Match matchSet = caseSensitive ? new CaseSensitiveMatch(sourceFileName) : new CaseInsensitiveMatch(sourceFileName);
                folders.addFirst(fo);
                for (FileObject folder : folders) {
                    for (FileObject child : folder.getChildren()) {
                        if (!matchSet.apply(child)) continue;
                        return child;
                    }
                }
                FileObject foundFo = sourceRoots.length == 0 ? SourceUtils.findSource(signature[0], root) : SourceUtils.findSource(signature[0], sourceRoots);
                if (foundFo == null) continue;
                return foundFo;
            }
        }
        catch (IOException e) {
            Exceptions.printStackTrace((Throwable)e);
        }
        return null;
    }

    private static FileObject findSource(final String binaryName, final FileObject ... fos) throws IOException {
        final ClassIndexManager cim = ClassIndexManager.getDefault();
        try {
            return (FileObject)IndexManager.readAccess((IndexManager.Action)new IndexManager.Action<FileObject>(){

                public FileObject run() throws IOException, InterruptedException {
                    for (FileObject fo : fos) {
                        FileObject result;
                        String sourceName;
                        ClassIndexImpl ci = cim.getUsagesQuery(fo.getURL(), true);
                        if (ci == null || (sourceName = ci.getSourceName(binaryName)) == null || (result = fo.getFileObject(sourceName)) == null) continue;
                        return result;
                    }
                    return null;
                }
            });
        }
        catch (InterruptedException e) {
            return null;
        }
    }

    public static URL getJavadoc(Element element, ClasspathInfo cpInfo) {
        JavadocHelper.TextStream page = JavadocHelper.getJavadoc(element);
        if (page == null) {
            return null;
        }
        page.close();
        return page.getLocation();
    }

    public static boolean isScanInProgress() {
        return IndexingManager.getDefault().isIndexing();
    }

    public static void waitScanFinished() throws InterruptedException {
        try {
            class T
            extends UserTask
            implements ClasspathInfoProvider {
                private final ClassPath EMPTY_PATH = ClassPathSupport.createClassPath((URL[])new URL[0]);
                private final ClasspathInfo cpinfo = ClasspathInfo.create(this.EMPTY_PATH, this.EMPTY_PATH, this.EMPTY_PATH);

                T() {
                }

                public void run(ResultIterator resultIterator) throws Exception {
                }

                @Override
                public ClasspathInfo getClasspathInfo() {
                    return this.cpinfo;
                }
            }
            Future f = ParserManager.parseWhenScanFinished((String)"text/x-java", (UserTask)new T());
            if (!f.isDone()) {
                f.get();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @SuppressWarnings(value={"DMI_COLLECTION_OF_URLS"})
    public static Set<URL> getDependentRoots(URL root) {
        Map sourceDeps = IndexingController.getDefault().getRootDependencies();
        Map binaryDeps = IndexingController.getDefault().getBinaryRootDependencies();
        return SourceUtils.getDependentRootsImpl(root, sourceDeps, binaryDeps);
    }

    @SuppressWarnings(value={"DMI_COLLECTION_OF_URLS"})
    static Set<URL> getDependentRootsImpl(URL root, Map<URL, List<URL>> sourceDeps, Map<URL, List<URL>> binaryDeps) {
        Set<URL> urls;
        if (sourceDeps.containsKey(root)) {
            urls = SourceUtils.findReverseSourceRoots(root, sourceDeps);
        } else {
            FileObject rootFO = URLMapper.findFileObject((URL)root);
            if (rootFO != null) {
                urls = new HashSet<URL>();
                for (URL binary : SourceUtils.findBinaryRootsForSourceRoot(rootFO, binaryDeps)) {
                    List<URL> deps = binaryDeps.get(binary);
                    if (deps == null) continue;
                    urls.addAll(deps);
                }
            } else {
                urls = new HashSet<URL>();
            }
        }
        Set cps = GlobalPathRegistry.getDefault().getPaths("classpath/source");
        HashSet<URL> toRetain = new HashSet<URL>();
        for (ClassPath cp : cps) {
            for (ClassPath.Entry e : cp.entries()) {
                toRetain.add(e.getURL());
            }
        }
        urls.retainAll(toRetain);
        return urls;
    }

    private static Set<URL> findReverseSourceRoots(URL thisSourceRoot, Map<URL, List<URL>> deps) {
        HashMap<URL, ArrayList<URL>> inverseDeps = new HashMap<URL, ArrayList<URL>>();
        for (Map.Entry<URL, List<URL>> entry : deps.entrySet()) {
            URL u1 = entry.getKey();
            List<URL> l1 = entry.getValue();
            for (URL u2 : l1) {
                ArrayList<URL> l2 = (ArrayList<URL>)inverseDeps.get(u2);
                if (l2 == null) {
                    l2 = new ArrayList<URL>();
                    inverseDeps.put(u2, l2);
                }
                l2.add(u1);
            }
        }
        HashSet<URL> result = new HashSet<URL>();
        LinkedList<URL> todo = new LinkedList<URL>();
        todo.add(thisSourceRoot);
        while (!todo.isEmpty()) {
            URL u = (URL)todo.removeFirst();
            if (result.contains(u)) continue;
            result.add(u);
            List ideps = (List)inverseDeps.get(u);
            if (ideps == null) continue;
            todo.addAll(ideps);
        }
        return result;
    }

    private static Set<URL> findBinaryRootsForSourceRoot(FileObject sourceRoot, Map<URL, List<URL>> binaryDeps) {
        HashSet<URL> result = new HashSet<URL>();
        for (URL bin : binaryDeps.keySet()) {
            for (FileObject s : SourceForBinaryQuery.findSourceRoots((URL)bin).getRoots()) {
                if (s != sourceRoot) continue;
                result.add(bin);
            }
        }
        return result;
    }

    public static Collection<ElementHandle<TypeElement>> getMainClasses(FileObject fo) {
        if (fo == null || !fo.isValid() || fo.isVirtual()) {
            throw new IllegalArgumentException();
        }
        JavaSource js = JavaSource.forFileObject(fo);
        if (js == null) {
            throw new IllegalArgumentException();
        }
        try {
            final LinkedList<ElementHandle<TypeElement>> result = new LinkedList<ElementHandle<TypeElement>>();
            js.runUserActionTask(new Task<CompilationController>(){

                @Override
                public void run(CompilationController control) throws Exception {
                    if (control.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED).compareTo(JavaSource.Phase.ELEMENTS_RESOLVED) >= 0) {
                        final ArrayList types = new ArrayList();
                        ElementScanner6<Void, Void> visitor = new ElementScanner6<Void, Void>(){

                            @Override
                            public Void visitType(TypeElement e, Void p) {
                                if (e.getEnclosingElement().getKind() == ElementKind.PACKAGE || e.getModifiers().contains((Object)Modifier.STATIC)) {
                                    types.add(e);
                                    return (Void)super.visitType(e, p);
                                }
                                return null;
                            }
                        };
                        visitor.scan(control.getTopLevelElements(), null);
                        for (TypeElement type : types) {
                            for (ExecutableElement exec : ElementFilter.methodsIn(control.getElements().getAllMembers(type))) {
                                if (!SourceUtils.isMainMethod(exec)) continue;
                                result.add(ElementHandle.create(type));
                            }
                        }
                    }
                }
            }, true);
            return result;
        }
        catch (IOException ioe) {
            Exceptions.printStackTrace((Throwable)ioe);
            return Collections.emptySet();
        }
    }

    public static boolean isMainClass(String qualifiedName, ClasspathInfo cpInfo) {
        return SourceUtils.isMainClass(qualifiedName, cpInfo, false);
    }

    public static boolean isMainClass(final String qualifiedName, ClasspathInfo cpInfo, boolean optimistic) {
        if (qualifiedName == null || cpInfo == null) {
            throw new IllegalArgumentException();
        }
        block6: for (ClassPath.Entry entry : cpInfo.getClassPath(ClasspathInfo.PathKind.SOURCE).entries()) {
            Iterable<? extends URL> mainClasses = ExecutableFilesIndex.DEFAULT.getMainClasses(entry.getURL());
            try {
                URI root = entry.getURL().toURI();
                for (URL uRL : mainClasses) {
                    try {
                        URI relative = root.relativize(uRL.toURI());
                        String resourceNameNoExt = FileObjects.stripExtension(relative.getPath());
                        String ffqn = FileObjects.convertFolder2Package(resourceNameNoExt, '/');
                        if (!qualifiedName.equals(ffqn)) continue;
                        ClassPath bootCp = cpInfo.getClassPath(ClasspathInfo.PathKind.BOOT);
                        if (bootCp.findResource(resourceNameNoExt + '.' + "class") != null) continue block6;
                        return true;
                    }
                    catch (URISyntaxException e) {
                        LOG.info("Ignoring fast check for file: " + uRL.toString() + " due to: " + e.getMessage());
                    }
                }
            }
            catch (URISyntaxException e) {
                LOG.info("Ignoring fast check for root: " + entry.getURL().toString() + " due to: " + e.getMessage());
            }
        }
        final boolean[] result = new boolean[]{false};
        if (!optimistic) {
            JavaSource js = JavaSource.create(cpInfo, new FileObject[0]);
            try {
                js.runUserActionTask(new Task<CompilationController>(){

                    @Override
                    public void run(CompilationController control) throws Exception {
                        JavacElements elms = (JavacElements)control.getElements();
                        Symbol.ClassSymbol type = elms.getTypeElementByBinaryName(qualifiedName);
                        if (type == null) {
                            return;
                        }
                        List<ExecutableElement> methods = ElementFilter.methodsIn(elms.getAllMembers(type));
                        for (ExecutableElement method : methods) {
                            if (!SourceUtils.isMainMethod(method)) continue;
                            result[0] = true;
                            break;
                        }
                    }
                }, true);
            }
            catch (IOException ioe) {
                Exceptions.printStackTrace((Throwable)ioe);
            }
        }
        return result[0];
    }

    public static boolean isMainMethod(ExecutableElement method) {
        if (!"main".contentEquals(method.getSimpleName())) {
            return false;
        }
        long flags = ((Symbol.MethodSymbol)method).flags();
        if ((flags & 1L) == 0L || (flags & 8L) == 0L) {
            return false;
        }
        if (method.getReturnType().getKind() != TypeKind.VOID) {
            return false;
        }
        List<? extends VariableElement> params = method.getParameters();
        if (params.size() != 1) {
            return false;
        }
        TypeMirror param = params.get(0).asType();
        if (param.getKind() != TypeKind.ARRAY) {
            return false;
        }
        ArrayType array = (ArrayType)param;
        TypeMirror compound = array.getComponentType();
        if (compound.getKind() != TypeKind.DECLARED) {
            return false;
        }
        return "java.lang.String".contentEquals(((TypeElement)((DeclaredType)compound).asElement()).getQualifiedName());
    }

    public static Collection<ElementHandle<TypeElement>> getMainClasses(FileObject[] sourceRoots) {
        final LinkedList<ElementHandle<TypeElement>> result = new LinkedList<ElementHandle<TypeElement>>();
        for (final FileObject root : sourceRoots) {
            try {
                final File rootFile = FileUtil.toFile((FileObject)root);
                ClassPath bootPath = ClassPath.getClassPath((FileObject)root, (String)"classpath/boot");
                ClassPath compilePath = ClassPath.getClassPath((FileObject)root, (String)"classpath/compile");
                ClassPath srcPath = ClassPathSupport.createClassPath((FileObject[])new FileObject[]{root});
                ClasspathInfo cpInfo = ClasspathInfo.create(bootPath, compilePath, srcPath);
                JavaSource js = JavaSource.create(cpInfo, new FileObject[0]);
                js.runUserActionTask(new Task<CompilationController>(){

                    @Override
                    public void run(CompilationController control) throws Exception {
                        URL rootURL = root.getURL();
                        Iterable<? extends URL> mainClasses = ExecutableFilesIndex.DEFAULT.getMainClasses(rootURL);
                        LinkedList<? extends ElementHandle<TypeElement>> classes = new LinkedList<ElementHandle<TypeElement>>();
                        for (URL uRL : mainClasses) {
                            File mainFo = new File(URI.create(uRL.toExternalForm()));
                            if (!mainFo.exists()) continue;
                            classes.addAll(JavaCustomIndexer.getRelatedTypes(mainFo, rootFile));
                        }
                        block1: for (ElementHandle elementHandle : classes) {
                            TypeElement te = (TypeElement)elementHandle.resolve(control);
                            if (te == null) continue;
                            List<ExecutableElement> methods = ElementFilter.methodsIn(te.getEnclosedElements());
                            for (ExecutableElement method : methods) {
                                if (!SourceUtils.isMainMethod(method)) continue;
                                if (!SourceUtils.isIncluded(elementHandle, control.getClasspathInfo())) continue block1;
                                result.add(elementHandle);
                                continue block1;
                            }
                        }
                    }
                }, false);
            }
            catch (IOException ioe) {
                Exceptions.printStackTrace((Throwable)ioe);
                return Collections.emptySet();
            }
        }
        return result;
    }

    private static boolean isIncluded(ElementHandle<TypeElement> element, ClasspathInfo cpInfo) {
        FileObject fobj = SourceUtils.getFile(element, cpInfo);
        if (fobj == null) {
            return true;
        }
        ClassPath sourcePath = cpInfo.getClassPath(ClasspathInfo.PathKind.SOURCE);
        for (ClassPath.Entry e : sourcePath.entries()) {
            FileObject root = e.getRoot();
            if (root == null || !FileUtil.isParentOf((FileObject)root, (FileObject)fobj)) continue;
            return e.includes(fobj);
        }
        return true;
    }

    private static boolean isCaseSensitive() {
        return !new File("a").equals(new File("A"));
    }

    private static String getSourceFileName(String classFileName) {
        int index = classFileName.indexOf(36);
        return index == -1 ? classFileName : classFileName.substring(0, index);
    }

    public static WildcardType resolveCapturedType(TypeMirror type) {
        if (type instanceof Type.CapturedType) {
            return ((Type.CapturedType)type).wildcard;
        }
        return null;
    }

    private static ClassPath createClassPath(ClasspathInfo cpInfo, ClasspathInfo.PathKind kind) throws MalformedURLException {
        return ClasspathInfoAccessor.getINSTANCE().getCachedClassPath(cpInfo, kind);
    }

    @NonNull
    static String generateReadableParameterName(@NonNull String typeName, @NonNull Set<String> used) {
        boolean arr = typeName.indexOf("[") > 0 || typeName.endsWith("...");
        typeName = SourceUtils.trimToSimpleName(typeName);
        String result = typeName.toLowerCase();
        if (typeName.endsWith("Listener")) {
            result = Character.toLowerCase(typeName.charAt(0)) + "l";
        } else if ("Object".equals(typeName)) {
            result = "o";
        } else if ("Class".equals(typeName)) {
            result = "type";
        } else if ("InputStream".equals(typeName)) {
            result = "in";
        } else if ("OutputStream".equals(typeName)) {
            result = "out";
        } else if ("Runnable".equals(typeName)) {
            result = "r";
        } else if ("Lookup".equals(typeName)) {
            result = "lkp";
        } else if (typeName.endsWith("Stream")) {
            result = "stream";
        } else if (typeName.endsWith("Writer")) {
            result = "writer";
        } else if (typeName.endsWith("Reader")) {
            result = "reader";
        } else if (typeName.endsWith("Panel")) {
            result = "pnl";
        } else if (typeName.endsWith("Action")) {
            result = "action";
        }
        if (result.length() > 6 && (result = SourceUtils.tryToMakeAcronym(typeName)).length() > 6 && (result = SourceUtils.elideVowelsAndRepetitions(result)).length() > 6) {
            result = ("" + result.charAt(0)).toLowerCase();
        }
        if (result.trim().length() == 0) {
            result = "value";
        }
        if (arr) {
            result = result + "s";
        }
        if (SourceUtils.isPrimitiveTypeName(result) || !Utilities.isJavaIdentifier((String)result)) {
            StringBuilder sb = new StringBuilder();
            sb.append(result.charAt(0));
            result = sb.toString();
        }
        String test = result;
        int revs = 0;
        while (used.contains(test)) {
            test = result + ++revs;
        }
        result = test;
        used.add(result);
        return result;
    }

    private static String trimToSimpleName(String typeName) {
        String result = typeName;
        int ix = result.indexOf("<");
        if (ix > 0 && ix != typeName.length() - 1) {
            result = typeName.substring(0, ix);
        }
        if (result.endsWith("...")) {
            result = result.substring(0, result.length() - 3);
        }
        if ((ix = result.lastIndexOf("$")) > 0 && ix != result.length() - 1) {
            result = result.substring(ix + 1);
        } else {
            ix = result.lastIndexOf(".");
            if (ix > 0 && ix != result.length() - 1) {
                result = result.substring(ix + 1);
            }
        }
        ix = result.indexOf("[");
        if (ix > 0) {
            result = result.substring(0, ix);
        }
        return result;
    }

    private static String elideVowelsAndRepetitions(String name) {
        char[] chars = name.toCharArray();
        StringBuilder sb = new StringBuilder();
        char last = '\u0000';
        char lastUsed = '\u0000';
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (Character.isDigit(c)) continue;
            if (i == 0 || Character.isUpperCase(c)) {
                if (lastUsed != c) {
                    sb.append(c);
                    lastUsed = c;
                }
            } else if (c != last && !SourceUtils.isVowel(c) && lastUsed != c) {
                sb.append(c);
                lastUsed = c;
            }
            last = c;
        }
        return sb.toString();
    }

    private static boolean isVowel(char c) {
        return Arrays.binarySearch(VOWELS, c) >= 0;
    }

    private static boolean isPrimitiveTypeName(String typeName) {
        return "void".equals(typeName) || "int".equals(typeName) || "long".equals(typeName) || "float".equals(typeName) || "double".equals(typeName) || "short".equals(typeName) || "char".equals(typeName) || "boolean".equals(typeName);
    }

    private static String tryToMakeAcronym(String s) {
        char[] c = s.toCharArray();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < c.length; ++i) {
            if (!Character.isUpperCase(c[i])) continue;
            sb.append(c[i]);
        }
        if (sb.length() > 1) {
            return sb.toString().toLowerCase();
        }
        return s.toLowerCase();
    }

    private static class CaseInsensitiveMatch
    extends Match {
        CaseInsensitiveMatch(String name) {
            super(name);
        }

        @Override
        protected boolean match(String name1, String name2) {
            return name1.equalsIgnoreCase(name2);
        }
    }

    private static class CaseSensitiveMatch
    extends Match {
        CaseSensitiveMatch(String name) {
            super(name);
        }

        @Override
        protected boolean match(String name1, String name2) {
            return name1.equals(name2);
        }
    }

    private static abstract class Match {
        private final String name;

        Match(String names) {
            this.name = names;
        }

        final boolean apply(FileObject fo) {
            String foName = fo.getName();
            return this.match(foName, this.name) && this.isJava(fo);
        }

        protected abstract boolean match(String var1, String var2);

        private boolean isJava(FileObject fo) {
            return "java".equalsIgnoreCase(fo.getExt()) && fo.isData();
        }
    }
}

