/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.wsitconf.refactoring;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.fileinfo.NonRecursiveFolder;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.MoveRefactoring;
import org.netbeans.modules.refactoring.api.RenameRefactoring;
import org.netbeans.modules.refactoring.api.SafeDeleteRefactoring;
import org.netbeans.modules.refactoring.spi.RefactoringPlugin;
import org.netbeans.modules.refactoring.spi.RefactoringPluginFactory;
import org.netbeans.modules.websvc.wsitconf.refactoring.WSITMoveRefactoringPlugin;
import org.netbeans.modules.websvc.wsitconf.refactoring.WSITRenamePackagePlugin;
import org.netbeans.modules.websvc.wsitconf.refactoring.WSITRenameRefactoringPlugin;
import org.netbeans.modules.websvc.wsitconf.refactoring.WSITSafeDeleteRefactoringPlugin;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class WSITRefactoringFactory
implements RefactoringPluginFactory {
    private static final Logger LOGGER = Logger.getLogger("org.netbeans.modules.websvc.wsitconf.refactoring");

    public RefactoringPlugin createInstance(AbstractRefactoring abstractRefactoring) {
        boolean bl;
        LOGGER.log(Level.FINE, "Create instance called: " + abstractRefactoring);
        NonRecursiveFolder nonRecursiveFolder = (NonRecursiveFolder)abstractRefactoring.getRefactoringSource().lookup(NonRecursiveFolder.class);
        boolean bl2 = bl = nonRecursiveFolder != null && WSITRefactoringFactory.isOnSourceClasspath(nonRecursiveFolder.getFolder());
        if (bl && abstractRefactoring instanceof RenameRefactoring) {
            LOGGER.log(Level.FINE, "Rename package refactoring");
            return new WSITRenamePackagePlugin((RenameRefactoring)abstractRefactoring);
        }
        if (abstractRefactoring instanceof MoveRefactoring) {
            return new WSITMoveRefactoringPlugin((MoveRefactoring)abstractRefactoring);
        }
        TreePathHandle treePathHandle = (TreePathHandle)abstractRefactoring.getRefactoringSource().lookup(TreePathHandle.class);
        if (treePathHandle == null) {
            return null;
        }
        if (abstractRefactoring instanceof RenameRefactoring) {
            LOGGER.log(Level.FINE, "Rename refactoring");
            return new WSITRenameRefactoringPlugin((RenameRefactoring)abstractRefactoring);
        }
        if (abstractRefactoring instanceof SafeDeleteRefactoring) {
            LOGGER.log(Level.FINE, "Safe delete refactoring");
            return new WSITSafeDeleteRefactoringPlugin((SafeDeleteRefactoring)abstractRefactoring);
        }
        return null;
    }

    private static boolean isOnSourceClasspath(FileObject fileObject) {
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        if (project == null) {
            return false;
        }
        if (OpenProjects.getDefault().isProjectOpen(project)) {
            SourceGroup[] sourceGroupArray = ProjectUtils.getSources((Project)project).getSourceGroups("java");
            for (int i = 0; i < sourceGroupArray.length; ++i) {
                if (fileObject == sourceGroupArray[i].getRootFolder()) {
                    return true;
                }
                if (!FileUtil.isParentOf((FileObject)sourceGroupArray[i].getRootFolder(), (FileObject)fileObject)) continue;
                return true;
            }
            return false;
        }
        return false;
    }
}

