/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seplatform.platformdefinition;

import java.io.File;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.Specification;
import org.netbeans.modules.java.j2seplatform.platformdefinition.Util;
import org.netbeans.spi.java.classpath.PathResourceImplementation;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.Exceptions;
import org.openide.util.Utilities;

public class J2SEPlatformImpl
extends JavaPlatform {
    public static final String PROP_ANT_NAME = "antName";
    public static final String PLATFORM_J2SE = "j2se";
    protected static final String PLAT_PROP_ANT_NAME = "platform.ant.name";
    protected static final String PLAT_PROP_ARCH_FOLDER = "platform.arch.folder";
    protected static final String SYSPROP_BOOT_CLASSPATH = "sun.boot.class.path";
    protected static final String SYSPROP_JAVA_CLASS_PATH = "java.class.path";
    protected static final String SYSPROP_JAVA_EXT_PATH = "java.ext.dirs";
    protected static final String SYSPROP_USER_DIR = "user.dir";
    private static final String PROP_NO_DEFAULT_JAVADOC = "no.default.javadoc";
    private static final Logger LOG = Logger.getLogger(J2SEPlatformImpl.class.getName());
    private String displayName;
    private Map<String, String> properties;
    private ClassPath sources;
    private List<URL> javadoc;
    private List<URL> installFolders;
    Reference<ClassPath> bootstrap = new WeakReference<Object>(null);
    Reference<ClassPath> standardLibs = new WeakReference<Object>(null);
    private Specification spec;
    private static final Map<String, String> OFFICIAL_JAVADOC = new HashMap<String, String>();

    J2SEPlatformImpl(String dispName, List<URL> installFolders, Map<String, String> initialProperties, Map<String, String> sysProperties, List<URL> sources, List<URL> javadoc) {
        this.displayName = dispName;
        if (installFolders != null) {
            this.installFolders = installFolders;
        } else {
            String home = initialProperties.remove("platform.home");
            if (home != null) {
                this.installFolders = new ArrayList<URL>();
                StringTokenizer tk = new StringTokenizer(home, File.pathSeparator);
                while (tk.hasMoreTokens()) {
                    File f = new File(tk.nextToken());
                    try {
                        this.installFolders.add(f.toURI().toURL());
                    }
                    catch (MalformedURLException mue) {
                        LOG.log(Level.INFO, null, mue);
                    }
                }
            } else {
                throw new IllegalArgumentException("Invalid platform, platform must have install folder.");
            }
        }
        this.properties = initialProperties;
        this.sources = J2SEPlatformImpl.createClassPath(sources);
        if (javadoc != null) {
            this.javadoc = Collections.unmodifiableList(javadoc);
        }
        this.setSystemProperties(J2SEPlatformImpl.filterProbe(sysProperties));
    }

    protected J2SEPlatformImpl(String dispName, String antName, List<URL> installFolders, Map<String, String> initialProperties, Map<String, String> sysProperties, List<URL> sources, List<URL> javadoc) {
        this(dispName, installFolders, initialProperties, sysProperties, sources, javadoc);
        this.properties.put(PLAT_PROP_ANT_NAME, antName);
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String name) {
        this.displayName = name;
        this.firePropertyChange("displayName", null, null);
    }

    protected final void internalSetDisplayName(String name) {
        this.displayName = name;
    }

    public String getAntName() {
        return this.properties.get(PLAT_PROP_ANT_NAME);
    }

    public void setAntName(String antName) {
        if (antName == null || antName.length() == 0) {
            throw new IllegalArgumentException();
        }
        this.properties.put(PLAT_PROP_ANT_NAME, antName);
        this.firePropertyChange(PROP_ANT_NAME, null, null);
    }

    public void setArchFolder(String folder) {
        if (folder == null || folder.length() == 0) {
            throw new IllegalArgumentException();
        }
        this.properties.put(PLAT_PROP_ARCH_FOLDER, folder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassPath getBootstrapLibraries() {
        J2SEPlatformImpl j2SEPlatformImpl = this;
        synchronized (j2SEPlatformImpl) {
            String extPathSpec;
            ClassPath cp;
            ClassPath classPath = cp = this.bootstrap == null ? null : this.bootstrap.get();
            if (cp != null) {
                return cp;
            }
            String pathSpec = (String)this.getSystemProperties().get(SYSPROP_BOOT_CLASSPATH);
            if (pathSpec == null) {
                LOG.log(Level.WARNING, "No sun.boot.class.path property in platform {0}, broken platform?", this.getDisplayName());
                pathSpec = "";
            }
            if ((extPathSpec = Util.getExtensions((String)this.getSystemProperties().get(SYSPROP_JAVA_EXT_PATH))) != null) {
                pathSpec = pathSpec + File.pathSeparator + extPathSpec;
            }
            cp = Util.createClassPath(pathSpec);
            this.bootstrap = new WeakReference<ClassPath>(cp);
            return cp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassPath getStandardLibraries() {
        J2SEPlatformImpl j2SEPlatformImpl = this;
        synchronized (j2SEPlatformImpl) {
            ClassPath cp;
            ClassPath classPath = cp = this.standardLibs == null ? null : this.standardLibs.get();
            if (cp != null) {
                return cp;
            }
            String pathSpec = (String)this.getSystemProperties().get(SYSPROP_JAVA_CLASS_PATH);
            cp = pathSpec == null ? ClassPathSupport.createClassPath((URL[])new URL[0]) : Util.createClassPath(pathSpec);
            this.standardLibs = new WeakReference<ClassPath>(cp);
            return cp;
        }
    }

    public final Collection<FileObject> getInstallFolders() {
        ArrayList<FileObject> result = new ArrayList<FileObject>();
        for (URL url : this.installFolders) {
            FileObject root = URLMapper.findFileObject((URL)url);
            if (root == null) continue;
            result.add(root);
        }
        return result;
    }

    public final FileObject findTool(String toolName) {
        String archFolder = this.getProperties().get(PLAT_PROP_ARCH_FOLDER);
        FileObject tool = null;
        if (archFolder != null) {
            tool = Util.findTool(toolName, this.getInstallFolders(), archFolder);
        }
        if (tool == null) {
            tool = Util.findTool(toolName, this.getInstallFolders());
        }
        return tool;
    }

    public final ClassPath getSourceFolders() {
        return this.sources;
    }

    public final void setSourceFolders(ClassPath c) {
        assert (c != null);
        this.sources = c;
        this.firePropertyChange("sourceFolders", null, null);
    }

    public final List<URL> getJavadocFolders() {
        if (this.javadoc == null) {
            this.javadoc = this.shouldAddDefaultJavadoc() ? J2SEPlatformImpl.defaultJavadoc(this) : Collections.emptyList();
        }
        return this.javadoc;
    }

    public final void setJavadocFolders(List<URL> c) {
        assert (c != null);
        List<URL> safeCopy = Collections.unmodifiableList(new ArrayList<URL>(c));
        for (URL url : safeCopy) {
            if ("jar".equals(url.getProtocol()) || !FileUtil.isArchiveFile((URL)url)) continue;
            throw new IllegalArgumentException("JavadocFolder must be a folder.");
        }
        List<URL> oldJavaDoc = this.javadoc;
        if (c.isEmpty()) {
            if (((Object)oldJavaDoc).equals(J2SEPlatformImpl.defaultJavadoc(this))) {
                this.properties.put(PROP_NO_DEFAULT_JAVADOC, Boolean.TRUE.toString());
            }
        } else {
            this.properties.remove(PROP_NO_DEFAULT_JAVADOC);
        }
        this.javadoc = safeCopy;
        this.firePropertyChange("javadocFolders", null, null);
    }

    public String getVendor() {
        String s = (String)this.getSystemProperties().get("java.vm.vendor");
        return s == null ? "" : s;
    }

    public Specification getSpecification() {
        if (this.spec == null) {
            this.spec = new Specification(PLATFORM_J2SE, Util.getSpecificationVersion(this));
        }
        return this.spec;
    }

    public Map<String, String> getProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    Collection getInstallFolderURLs() {
        return Collections.unmodifiableList(this.installFolders);
    }

    protected static String filterProbe(String v, String probePath) {
        if (v != null) {
            String[] pes = PropertyUtils.tokenizePath((String)v);
            StringBuilder sb = new StringBuilder();
            for (String pe : pes) {
                if (probePath == null ? pe != null && pe.endsWith("org-netbeans-modules-java-j2seplatform-probe.jar") : probePath.equals(pe)) continue;
                if (sb.length() > 0) {
                    sb.append(File.pathSeparatorChar);
                }
                sb.append(pe);
            }
            v = sb.toString();
        }
        return v;
    }

    private static Map<String, String> filterProbe(Map<String, String> p) {
        String val;
        if (p != null && (val = p.get(SYSPROP_JAVA_CLASS_PATH)) != null) {
            p.put(SYSPROP_JAVA_CLASS_PATH, J2SEPlatformImpl.filterProbe(val, null));
        }
        return p;
    }

    private static ClassPath createClassPath(List<? extends URL> urls) {
        ArrayList<PathResourceImplementation> resources = new ArrayList<PathResourceImplementation>();
        if (urls != null) {
            for (URL uRL : urls) {
                resources.add(ClassPathSupport.createResource((URL)uRL));
            }
        }
        return ClassPathSupport.createClassPath(resources);
    }

    private boolean shouldAddDefaultJavadoc() {
        return !Boolean.parseBoolean(this.getProperties().get(PROP_NO_DEFAULT_JAVADOC));
    }

    public static List<URL> defaultJavadoc(JavaPlatform platform) {
        String location;
        ArrayList<URL> result = new ArrayList<URL>();
        for (FileObject folder : platform.getInstallFolders()) {
            FileObject docs = folder.getFileObject("docs");
            if (docs != null && docs.isFolder() && docs.canRead()) {
                try {
                    result.add(docs.getURL());
                }
                catch (FileStateInvalidException x) {
                    LOG.log(Level.INFO, null, x);
                }
            }
            if (!Utilities.isMac()) continue;
            try {
                FileObject appleDocsJar;
                FileObject docsJar = folder.getFileObject("docs.jar");
                if (docsJar != null && docsJar.canRead() && FileUtil.isArchiveFile((FileObject)docsJar)) {
                    URL rootURL = FileUtil.getArchiveRoot((URL)docsJar.getURL());
                    result.add(new URL(rootURL.toExternalForm() + "docs/api/"));
                    result.add(new URL(rootURL.toExternalForm() + "docs/jdk/api/"));
                    result.add(new URL(rootURL.toExternalForm() + "docs/jre/api/"));
                }
                if ((appleDocsJar = folder.getFileObject("appledocs.jar")) == null || !appleDocsJar.canRead() || !FileUtil.isArchiveFile((FileObject)appleDocsJar)) continue;
                result.add(new URL(FileUtil.getArchiveRoot((URL)appleDocsJar.getURL()).toExternalForm() + "appledoc/api/"));
            }
            catch (MalformedURLException mue) {
                Exceptions.printStackTrace((Throwable)mue);
            }
            catch (FileStateInvalidException fsi) {
                Exceptions.printStackTrace((Throwable)fsi);
            }
        }
        if (!result.isEmpty()) {
            return Collections.unmodifiableList(result);
        }
        String version = platform.getSpecification().getVersion().toString();
        if (!OFFICIAL_JAVADOC.containsKey(version)) {
            LOG.log(Level.WARNING, "unrecognized Java spec version: {0}", version);
        }
        if ((location = OFFICIAL_JAVADOC.get(version)) != null) {
            try {
                return Collections.singletonList(new URL(location));
            }
            catch (MalformedURLException x) {
                LOG.log(Level.INFO, null, x);
            }
        }
        return Collections.emptyList();
    }

    static {
        OFFICIAL_JAVADOC.put("1.0", null);
        OFFICIAL_JAVADOC.put("1.1", null);
        OFFICIAL_JAVADOC.put("1.2", null);
        OFFICIAL_JAVADOC.put("1.3", "http://download.oracle.com/javase/1.3/docs/api/");
        OFFICIAL_JAVADOC.put("1.4", "http://download.oracle.com/javase/1.4.2/docs/api/");
        OFFICIAL_JAVADOC.put("1.5", "http://download.oracle.com/javase/1.5.0/docs/api/");
        OFFICIAL_JAVADOC.put("1.6", "http://download.oracle.com/javase/6/docs/api/");
        OFFICIAL_JAVADOC.put("1.7", "http://download.oracle.com/javase/7/docs/api/");
    }
}

