/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seplatform.api;

import java.io.IOException;
import java.util.Map;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.modules.java.j2seplatform.platformdefinition.PlatformConvertor;
import org.netbeans.modules.java.j2seplatform.wizard.NewJ2SEPlatform;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;

public class J2SEPlatformCreator {
    private J2SEPlatformCreator() {
    }

    public static JavaPlatform createJ2SEPlatform(FileObject installFolder) throws IOException {
        NewJ2SEPlatform plat = NewJ2SEPlatform.create(installFolder);
        plat.run();
        if (!plat.isValid()) {
            throw new IOException("Invalid J2SE platform in " + installFolder);
        }
        String displayName = J2SEPlatformCreator.createPlatformDisplayName(plat);
        String antName = J2SEPlatformCreator.createPlatformAntName(displayName);
        plat.setDisplayName(displayName);
        plat.setAntName(antName);
        FileObject platformsFolder = FileUtil.getConfigFile((String)"Services/Platforms/org-netbeans-api-java-Platform");
        assert (platformsFolder != null);
        DataObject dobj = PlatformConvertor.create(plat, DataFolder.findFolder((FileObject)platformsFolder), antName);
        return (JavaPlatform)dobj.getLookup().lookup(JavaPlatform.class);
    }

    private static String createPlatformDisplayName(JavaPlatform plat) {
        Map m = plat.getSystemProperties();
        String vmVersion = (String)m.get("java.specification.version");
        StringBuffer displayName = new StringBuffer("JDK ");
        if (vmVersion != null) {
            displayName.append(vmVersion);
        }
        return displayName.toString();
    }

    private static String createPlatformAntName(String displayName) {
        assert (displayName != null && displayName.length() > 0);
        String antName = PropertyUtils.getUsablePropertyName((String)displayName);
        if (J2SEPlatformCreator.platformExists(antName)) {
            String baseName = antName;
            int index = 1;
            antName = baseName + Integer.toString(index);
            while (J2SEPlatformCreator.platformExists(antName)) {
                antName = baseName + Integer.toString(++index);
            }
        }
        return antName;
    }

    private static boolean platformExists(String antName) {
        assert (antName != null && antName.length() > 0);
        for (JavaPlatform p : JavaPlatformManager.getDefault().getInstalledPlatforms()) {
            String otherName = (String)p.getProperties().get("platform.ant.name");
            if (!antName.equals(otherName)) continue;
            return true;
        }
        return false;
    }
}

