/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.i18n.form;

import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyEditorSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.IOException;
import java.util.HashMap;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.Project;
import org.netbeans.modules.form.FormAwareEditor;
import org.netbeans.modules.form.FormDataObject;
import org.netbeans.modules.form.FormEditorSupport;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.form.FormProperty;
import org.netbeans.modules.form.NamedPropertyEditor;
import org.netbeans.modules.i18n.I18nPanel;
import org.netbeans.modules.i18n.I18nString;
import org.netbeans.modules.i18n.I18nUtil;
import org.netbeans.modules.i18n.Util;
import org.netbeans.modules.i18n.form.FormI18nString;
import org.netbeans.modules.i18n.form.FormI18nSupport;
import org.netbeans.modules.i18n.java.JavaI18nSupport;
import org.openide.explorer.propertysheet.ExPropertyEditor;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.explorer.propertysheet.editors.XMLPropertyEditor;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.HelpCtx;
import org.openide.util.MapFormat;
import org.openide.util.NbBundle;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FormI18nStringEditor
extends PropertyEditorSupport
implements FormAwareEditor,
NamedPropertyEditor,
XMLPropertyEditor,
ExPropertyEditor {
    private FormDataObject sourceDataObject;
    private PropertyEnv env;
    public static final String XML_RESOURCESTRING = "ResourceString";
    private static final String XML_PLAINSTRING = "PlainString";
    public static final String XML_ARGUMENT = "Argument";
    public static final String ATTR_BUNDLE = "bundle";
    public static final String ATTR_KEY = "key";
    private static final String ATTR_VALUE = "value";
    public static final String ATTR_IDENTIFIER = "identifier";
    public static final String ATTR_REPLACE_FORMAT = "replaceFormat";
    public static final String ATTR_INDEX = "index";
    public static final String ATTR_JAVACODE = "javacode";
    private static final int MAX_INDEX = 1000;
    private static final String CODE_MARK_END = "*/\n\\0";
    private static final String CODE_MARK_LINE_COMMENT = "*/\n\\1";
    private static final String CODE_MARK_VARIABLE_SUBST = "*/\n\\2";

    @Override
    public String[] getTags() {
        return null;
    }

    @Override
    public void setAsText(String text) {
        this.setValue(text);
    }

    private FormI18nString updateValue(FormI18nString value) {
        String key = value.getKey();
        value.setValue(value.getSupport().getResourceHolder().getValueForKey(key));
        return value;
    }

    @Override
    public String getAsText() {
        Object value = this.getValue();
        if (value instanceof String || value == null) {
            return (String)value;
        }
        FormI18nString i18nString = (FormI18nString)((Object)value);
        return i18nString.getValue();
    }

    @Override
    public String getJavaInitializationString() {
        int end;
        Object value = this.getValue();
        if (!(value instanceof FormI18nString)) {
            if (value != null) {
                return "\"" + FormI18nSupport.toAscii((String)value) + "\"";
            }
            return "null";
        }
        FormI18nString i18nString = (FormI18nString)((Object)value);
        String javaString = i18nString.getReplaceString();
        if (javaString == null) {
            return "\"" + FormI18nSupport.toAscii((String)i18nString.getValue()) + "\"";
        }
        StringBuilder buf = new StringBuilder();
        buf.append("*/\n\\1NOI18N");
        if (javaString.startsWith("java.util.ResourceBundle.getBundle(") && (end = javaString.lastIndexOf(").get") + 1) > 0) {
            buf.append(CODE_MARK_VARIABLE_SUBST);
            buf.append(javaString.substring(0, end));
            buf.append(CODE_MARK_VARIABLE_SUBST);
            buf.append("java.util.ResourceBundle");
            buf.append(CODE_MARK_VARIABLE_SUBST);
            buf.append(ATTR_BUNDLE);
            javaString = javaString.substring(end);
        }
        buf.append(CODE_MARK_END);
        buf.append(javaString);
        return buf.toString();
    }

    @Override
    public Component getCustomEditor() {
        FormI18nString formI18nString;
        Object value = this.getValue();
        if (value instanceof FormI18nString) {
            formI18nString = new FormI18nString((FormI18nString)((Object)value));
        } else {
            DataObject lastResource;
            formI18nString = this.createFormI18nString();
            if (value instanceof String) {
                formI18nString.setValue((String)value);
            }
            if ((lastResource = I18nUtil.getOptions().getLastResource2((DataObject)this.sourceDataObject)) != null) {
                FileObject sourceFile = this.sourceDataObject.getPrimaryFile();
                FileObject bundleFile = lastResource.getPrimaryFile();
                ClassPath sourceClassPath = ClassPath.getClassPath((FileObject)sourceFile, (String)"classpath/source");
                if (sourceClassPath.contains(bundleFile)) {
                    formI18nString.getSupport().getResourceHolder().setResource(lastResource);
                }
            }
        }
        return new CustomEditor((I18nString)formI18nString, this.getProject(), this.sourceDataObject.getPrimaryFile());
    }

    private Project getProject() {
        return Util.getProjectFor((DataObject)this.sourceDataObject);
    }

    @Override
    public boolean supportsCustomEditor() {
        return true;
    }

    @Override
    public void setValue(Object object) {
        if (object instanceof String && this.getValue() instanceof FormI18nString) {
            FormI18nString i18nString = new FormI18nString((FormI18nString)((Object)this.getValue()));
            i18nString.setValue((String)object);
            object = i18nString;
        }
        super.setValue(object);
    }

    private FormI18nString createFormI18nString() {
        return new FormI18nString((DataObject)this.sourceDataObject);
    }

    public void setContext(FormModel model, FormProperty property) {
        if (model != null) {
            this.sourceDataObject = FormEditorSupport.getFormDataObject((FormModel)model);
        }
    }

    public void updateFormVersionLevel() {
    }

    public String getDisplayName() {
        return NbBundle.getMessage(FormI18nStringEditor.class, (String)"CTL_PropertyEditorName");
    }

    public void attachEnv(PropertyEnv env) {
        this.env = env;
    }

    public void readFromXML(Node domNode) throws IOException {
        FormI18nString formI18nString = this.createFormI18nString();
        NamedNodeMap namedNodes = domNode.getAttributes();
        if (XML_PLAINSTRING.equals(domNode.getNodeName())) {
            Node node = namedNodes.getNamedItem(ATTR_VALUE);
            if (node != null) {
                this.setValue(node.getNodeValue());
            }
            return;
        }
        if (!XML_RESOURCESTRING.equals(domNode.getNodeName())) {
            throw new IOException();
        }
        try {
            String key;
            Node node = namedNodes.getNamedItem(ATTR_BUNDLE);
            String bundleName = node == null ? null : node.getNodeValue();
            node = namedNodes.getNamedItem(ATTR_KEY);
            String string = key = node == null ? null : node.getNodeValue();
            if (bundleName != null) {
                FileObject fileObject;
                DataObject resourceDO = null;
                FileObject sourceFo = this.sourceDataObject.getPrimaryFile();
                if (sourceFo != null && (fileObject = Util.getResource((FileObject)sourceFo, (String)bundleName)) != null) {
                    try {
                        resourceDO = DataObject.find((FileObject)fileObject);
                        if (resourceDO.getClass().equals(formI18nString.getSupport().getResourceHolder().getResourceClasses()[0])) {
                            formI18nString.getSupport().getResourceHolder().setResource(resourceDO);
                        }
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
                if (resourceDO == null) {
                    formI18nString.bundleName = bundleName;
                }
            }
            if (key != null && key.length() > 0) {
                formI18nString.setKey(key);
                formI18nString.setValue(formI18nString.getSupport().getResourceHolder().getValueForKey(key));
                formI18nString.setComment(formI18nString.getSupport().getResourceHolder().getCommentForKey(key));
            }
            ((JavaI18nSupport)formI18nString.getSupport()).createIdentifier();
            node = namedNodes.getNamedItem(ATTR_IDENTIFIER);
            if (node != null) {
                String identifier;
                String string2 = identifier = node == null ? null : node.getNodeValue();
                if (identifier != null) {
                    ((JavaI18nSupport)formI18nString.getSupport()).setIdentifier(identifier);
                }
            }
            if ((node = namedNodes.getNamedItem(ATTR_REPLACE_FORMAT)) != null) {
                String replaceFormat = node.getNodeValue();
                if (replaceFormat != null && replaceFormat.length() > 0) {
                    HashMap<String, String> map = new HashMap<String, String>(6);
                    map.put("0", "{identifier}");
                    map.put("1", "{key}");
                    map.put("2", "{bundleNameSlashes}");
                    map.put("3", "{bundleNameDots}");
                    map.put("4", "{sourceFileName}");
                    map.put("fileName", "{sourceFileName}");
                    String newReplaceFormat = MapFormat.format((String)replaceFormat, map);
                    formI18nString.setReplaceFormat(newReplaceFormat);
                }
            } else {
                formI18nString.setReplaceFormat(I18nUtil.getDefaultReplaceFormat((boolean)false));
            }
        }
        catch (NullPointerException npe) {
            throw new IOException();
        }
        if (domNode instanceof Element) {
            int i;
            Element domElement = (Element)domNode;
            NodeList argNodeList = domElement.getElementsByTagName(XML_ARGUMENT);
            int highest = -1;
            for (int i2 = 0; i2 < argNodeList.getLength(); ++i2) {
                String indexString;
                NamedNodeMap attributes = argNodeList.item(i2).getAttributes();
                Node indexNode = attributes.getNamedItem(ATTR_INDEX);
                String string = indexString = indexNode == null ? null : indexNode.getNodeValue();
                if (indexString == null) continue;
                try {
                    int index = Integer.parseInt(indexString);
                    if (index <= highest || index >= 1000) continue;
                    highest = index;
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            String[] parameters = new String[highest + 1];
            for (i = 0; i < argNodeList.getLength(); ++i) {
                String indexString;
                NamedNodeMap attr = argNodeList.item(i).getAttributes();
                Node indexNode = attr.getNamedItem(ATTR_INDEX);
                String string = indexString = indexNode == null ? null : indexNode.getNodeValue();
                if (indexString == null) continue;
                try {
                    String javaCode;
                    int index = Integer.parseInt(indexString);
                    if (index >= 1000) continue;
                    Node javaCodeNode = attr.getNamedItem(ATTR_JAVACODE);
                    parameters[index] = javaCode = javaCodeNode == null ? null : javaCodeNode.getNodeValue();
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            for (i = 0; i < parameters.length; ++i) {
                if (parameters[i] != null) continue;
                parameters[i] = "";
            }
            formI18nString.setArguments(parameters);
        }
        this.setValue((Object)formI18nString);
    }

    public Node storeToXML(Document doc) {
        Object value = this.getValue();
        if (value == null) {
            return null;
        }
        Element element = doc.createElement(XML_RESOURCESTRING);
        if (value instanceof FormI18nString) {
            String bundleName;
            FormI18nString formI18nString = (FormI18nString)((Object)value);
            if (formI18nString.getSupport().getResourceHolder().getResource() == null) {
                bundleName = formI18nString.bundleName;
            } else {
                bundleName = Util.getResourceName((FileObject)formI18nString.getSupport().getSourceDataObject().getPrimaryFile(), (FileObject)formI18nString.getSupport().getResourceHolder().getResource().getPrimaryFile(), (char)'/', (boolean)true);
                if (bundleName == null) {
                    bundleName = "";
                }
            }
            element.setAttribute(ATTR_BUNDLE, bundleName);
            element.setAttribute(ATTR_KEY, formI18nString.getKey() == null ? "" : formI18nString.getKey());
            JavaI18nSupport support = (JavaI18nSupport)formI18nString.getSupport();
            if (support.getIdentifier() == null) {
                support.createIdentifier();
            }
            HashMap<String, String> map = new HashMap<String, String>(1);
            map.put(ATTR_IDENTIFIER, support.getIdentifier());
            element.setAttribute(ATTR_REPLACE_FORMAT, formI18nString.getReplaceFormat() == null ? "" : MapFormat.format((String)formI18nString.getReplaceFormat(), map));
            String[] arguments = formI18nString.getArguments();
            for (int i = 0; i < arguments.length; ++i) {
                Element childElement = doc.createElement(XML_ARGUMENT);
                childElement.setAttribute(ATTR_INDEX, "" + i);
                childElement.setAttribute(ATTR_JAVACODE, arguments[i]);
                try {
                    element.appendChild(childElement);
                    continue;
                }
                catch (DOMException de) {
                    // empty catch block
                }
            }
        } else {
            element = doc.createElement(XML_PLAINSTRING);
            element.setAttribute(ATTR_VALUE, (String)value);
        }
        return element;
    }

    private class CustomEditor
    extends JPanel
    implements VetoableChangeListener {
        private I18nPanel i18nPanel;

        public CustomEditor(I18nString i18nString, Project project, FileObject file) {
            this.i18nPanel = new I18nPanel(i18nString.getSupport().getPropertyPanel(), false, project, file);
            this.setLayout(new BorderLayout());
            this.add((Component)this.i18nPanel);
            this.i18nPanel.setI18nString(i18nString);
            FormI18nStringEditor.this.env.setState(PropertyEnv.STATE_NEEDS_VALIDATION);
            FormI18nStringEditor.this.env.addVetoableChangeListener((VetoableChangeListener)this);
            HelpCtx.setHelpIDString((JComponent)this, (String)"internation.formed");
        }

        @Override
        public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
            if ("state".equals(evt.getPropertyName()) && this.isVisible()) {
                I18nString i18nString = this.i18nPanel.getI18nString();
                if (i18nString == null || !(i18nString instanceof FormI18nString) || i18nString.getSupport().getResourceHolder().getResource() == null || i18nString.getKey() == null) {
                    throw new PropertyVetoException(NbBundle.getMessage(FormI18nStringEditor.class, (String)"MSG_InvalidValue"), evt);
                }
                FormI18nStringEditor.this.setValue(i18nString);
            }
        }
    }
}

