/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.sql.editor.ui.actions;

import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.modules.db.api.sql.execute.SQLExecuteCookie;
import org.netbeans.modules.db.api.sql.execute.SQLExecution;
import org.netbeans.modules.db.sql.editor.ui.actions.SQLExecutionBaseAction;
import org.netbeans.spi.project.ActionProvider;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class RunSQLAction
extends SQLExecutionBaseAction
implements ActionProvider {
    private static final Logger LOGGER = Logger.getLogger(RunSQLAction.class.getName());
    private static final boolean LOG = LOGGER.isLoggable(Level.FINE);
    private static final String ICON_PATH = "org/netbeans/modules/db/sql/editor/resources/runsql.png";

    @Override
    protected String getIconBase() {
        return ICON_PATH;
    }

    @Override
    protected String getDisplayName(SQLExecution sqlExecution) {
        return NbBundle.getMessage(RunSQLAction.class, (String)"LBL_RunSqlAction");
    }

    @Override
    public HelpCtx getHelpCtx() {
        return new HelpCtx(RunSQLAction.class);
    }

    @Override
    protected void actionPerformed(SQLExecution sqlExecution) {
        DatabaseConnection conn;
        if (LOG) {
            LOGGER.log(Level.FINE, "actionPerformed for " + sqlExecution);
        }
        if ((conn = sqlExecution.getDatabaseConnection()) != null) {
            sqlExecution.execute();
        } else {
            conn = RunSQLAction.selectDatabaseConnection();
            if (conn != null) {
                LOGGER.finer("Set DatabaseConnection: " + conn);
                sqlExecution.setDatabaseConnection(conn);
                sqlExecution.execute();
            }
        }
    }

    public String[] getSupportedActions() {
        return new String[]{"run.single"};
    }

    public boolean isActionEnabled(String command, Lookup context) throws IllegalArgumentException {
        Collection files = context.lookupAll(DataObject.class);
        if (files.isEmpty()) {
            return false;
        }
        for (DataObject d : files) {
            if (FileUtil.getMIMEType((FileObject)d.getPrimaryFile()) == null || !FileUtil.getMIMEType((FileObject)d.getPrimaryFile()).equals("text/x-sql")) continue;
            return true;
        }
        return false;
    }

    public void invokeAction(String command, Lookup context) throws IllegalArgumentException {
        Lookup.Result result = context.lookup(new Lookup.Template(SQLExecution.class));
        if (!result.allInstances().isEmpty()) {
            SQLExecution sqlExecution = (SQLExecution)result.allInstances().iterator().next();
            LOGGER.finer("Using " + sqlExecution + " for executing " + command);
            this.actionPerformed(sqlExecution);
            return;
        }
        Collection files = context.lookupAll(DataObject.class);
        if (files.isEmpty()) {
            assert (false) : "Any DataObject must found in lookup for command " + command;
            return;
        }
        for (DataObject d : files) {
            EditorCookie editorCookie;
            if (FileUtil.getMIMEType((FileObject)d.getPrimaryFile()) == null || !FileUtil.getMIMEType((FileObject)d.getPrimaryFile()).equals("text/x-sql")) continue;
            SQLExecuteCookie execCookie = (SQLExecuteCookie)d.getCookie(SQLExecuteCookie.class);
            LOGGER.finer("Using SQLExecuteCookie: " + execCookie + " for executing " + command);
            if (execCookie != null && execCookie.getDatabaseConnection() == null) {
                DatabaseConnection conn = RunSQLAction.selectDatabaseConnection();
                LOGGER.finer("Attach DatabaseConnection: " + conn + " for executing " + command);
                execCookie.setDatabaseConnection(conn);
            }
            if ((editorCookie = (EditorCookie)d.getCookie(EditorCookie.class)) != null && editorCookie.getOpenedPanes() == null) {
                LOGGER.finer("Opening " + d + " in the editor.");
                editorCookie.open();
            }
            if (execCookie == null) continue;
            execCookie.execute();
            return;
        }
    }
}

