/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hudson.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.netbeans.modules.hudson.api.HudsonJob;
import org.netbeans.modules.hudson.api.HudsonJobBuild;
import org.netbeans.modules.hudson.api.HudsonView;
import org.netbeans.modules.hudson.impl.Bundle;
import org.netbeans.modules.hudson.impl.HudsonInstanceImpl;
import org.netbeans.modules.hudson.ui.interfaces.OpenableInBrowser;
import org.netbeans.modules.hudson.util.HudsonPropertiesSupport;
import org.openide.filesystems.FileSystem;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.Utilities;

public class HudsonJobImpl
implements HudsonJob,
OpenableInBrowser {
    private HudsonPropertiesSupport properties = new HudsonPropertiesSupport();
    private Collection<HudsonView> views = new ArrayList<HudsonView>();
    private HudsonInstanceImpl instance;
    private Sheet.Set set;
    private Collection<? extends HudsonJobBuild> builds;
    final List<HudsonMavenModule> mavenModules = new LinkedList<HudsonMavenModule>();

    HudsonJobImpl(HudsonInstanceImpl instance) {
        this.instance = instance;
    }

    public void putProperty(String name, Object o) {
        if (o == null) {
            throw new NullPointerException("putProperty: " + name);
        }
        this.properties.putProperty(name, o);
    }

    @Override
    public String getDisplayName() {
        String name = this.properties.getProperty("job_display_name", String.class);
        return name != null ? name : this.getName();
    }

    @Override
    public String getName() {
        return this.properties.getProperty("job_name", String.class);
    }

    @Override
    public String getUrl() {
        String url = this.properties.getProperty("job_url", String.class);
        assert (url.endsWith("/")) : url;
        return url;
    }

    @Override
    public HudsonJob.Color getColor() {
        return this.properties.getProperty("job_color", HudsonJob.Color.class);
    }

    @Override
    public boolean isInQueue() {
        try {
            return this.properties.getProperty("job_in_queue", Boolean.class);
        }
        catch (NullPointerException x) {
            return false;
        }
    }

    @Override
    public boolean isBuildable() {
        return this.properties.getProperty("job_buildable", Boolean.class);
    }

    @Override
    public int getLastBuild() {
        try {
            return this.properties.getProperty("job_last_build", Integer.class);
        }
        catch (NullPointerException e) {
            return -1;
        }
    }

    @Override
    public int getLastStableBuild() {
        try {
            return this.properties.getProperty("job_last_stable_build", Integer.class);
        }
        catch (NullPointerException e) {
            return -1;
        }
    }

    @Override
    public int getLastSuccessfulBuild() {
        try {
            return this.properties.getProperty("job_last_successful_build", Integer.class);
        }
        catch (NullPointerException e) {
            return -1;
        }
    }

    @Override
    public int getLastFailedBuild() {
        try {
            return this.properties.getProperty("job_last_failed_build", Integer.class);
        }
        catch (NullPointerException e) {
            return -1;
        }
    }

    @Override
    public int getLastCompletedBuild() {
        try {
            return this.properties.getProperty("job_last_completed_build", Integer.class);
        }
        catch (NullPointerException e) {
            return -1;
        }
    }

    @Override
    public Collection<HudsonView> getViews() {
        return this.views;
    }

    void addView(HudsonView view) {
        this.views.add(view);
    }

    @Override
    public void start() {
        this.instance.getConnector().startJob(this);
    }

    public Sheet.Set getSheetSet() {
        if (null == this.set) {
            this.set = Sheet.createPropertiesSet();
            this.set.setDisplayName(this.getDisplayName());
            this.set.put((Node.Property[])new PropertySupport[]{new HudsonJobProperty("job_name", Bundle.TXT_Job_Prop_Name(), Bundle.DESC_Job_Prop_Name()), new HudsonJobProperty("job_url", Bundle.TXT_Job_Prop_Url(), Bundle.DESC_Job_Prop_Url()), new PropertySupport.ReadWrite<Boolean>("salient", Boolean.TYPE, Bundle.HudsonJobImpl_watched(), Bundle.HudsonJobImpl_watched_desc()){

                public Boolean getValue() {
                    return HudsonJobImpl.this.isSalient();
                }

                public void setValue(Boolean val) {
                    if (!this.getValue().equals(val)) {
                        HudsonJobImpl.this.setSalient(val);
                    }
                }
            }});
        }
        return this.set;
    }

    @Override
    public FileSystem getRemoteWorkspace() {
        return this.instance.getRemoteWorkspace(this);
    }

    public boolean equals(Object o) {
        if (!(o instanceof HudsonJobImpl)) {
            return false;
        }
        HudsonJobImpl j = (HudsonJobImpl)o;
        if (!Utilities.compareObjects((Object)this.getDisplayName(), (Object)j.getDisplayName())) {
            return false;
        }
        if (!Utilities.compareObjects((Object)this.getName(), (Object)j.getName())) {
            return false;
        }
        if (!Utilities.compareObjects((Object)this.getUrl(), (Object)j.getUrl())) {
            return false;
        }
        if (!Utilities.compareObjects((Object)((Object)this.getColor()), (Object)((Object)j.getColor()))) {
            return false;
        }
        if (this.isInQueue() != j.isInQueue()) {
            return false;
        }
        if (this.isBuildable() != j.isBuildable()) {
            return false;
        }
        if (!Utilities.compareObjects(this.views, j.views)) {
            return false;
        }
        if (this.getLastCompletedBuild() != j.getLastCompletedBuild()) {
            return false;
        }
        return ((Object)this.mavenModules).equals(j.mavenModules);
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    @Override
    public int compareTo(HudsonJob o) {
        return this.getDisplayName().compareTo(o.getDisplayName());
    }

    public String toString() {
        return this.getUrl();
    }

    @Override
    public synchronized Collection<? extends HudsonJobBuild> getBuilds() {
        if (this.builds == null) {
            this.builds = this.instance.getConnector().getBuilds(this);
        }
        return this.builds;
    }

    @Override
    public HudsonInstanceImpl getInstance() {
        return this.instance;
    }

    @Override
    public boolean isSalient() {
        return this.instance.isSalient(this);
    }

    @Override
    public void setSalient(boolean b) {
        this.instance.setSalient(this, b);
    }

    void addModule(String name, String displayName, HudsonJob.Color color, String url) {
        this.mavenModules.add(new HudsonMavenModule(name, displayName, color, url));
    }

    private class HudsonJobProperty
    extends PropertySupport.ReadOnly<String> {
        public HudsonJobProperty(String key, String name, String desc) {
            super(key, String.class, name, desc);
        }

        public String getValue() {
            return HudsonJobImpl.this.properties.getProperty(super.getName(), String.class);
        }
    }

    static class HudsonMavenModule {
        final String name;
        final String displayName;
        final HudsonJob.Color color;
        final String url;

        HudsonMavenModule(String name, String displayName, HudsonJob.Color color, String url) {
            this.name = name;
            this.displayName = displayName;
            this.color = color;
            this.url = url;
        }

        public boolean equals(Object other) {
            if (!(other instanceof HudsonMavenModule)) {
                return false;
            }
            HudsonMavenModule o = (HudsonMavenModule)other;
            return this.name.equals(o.name) && this.displayName.equals(o.displayName) && this.color == o.color && this.url.equals(o.url);
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public String toString() {
            return this.url;
        }
    }
}

