/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.memory;

import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.tree.TreePath;
import org.netbeans.lib.profiler.results.memory.PresoObjAllocCCTNode;
import org.netbeans.lib.profiler.ui.ResultsPanel;
import org.netbeans.lib.profiler.ui.components.JTreeTable;
import org.netbeans.lib.profiler.ui.components.table.CustomBarCellRenderer;
import org.netbeans.lib.profiler.ui.components.table.LabelBracketTableCellRenderer;
import org.netbeans.lib.profiler.ui.components.table.LabelTableCellRenderer;
import org.netbeans.lib.profiler.ui.components.tree.EnhancedTreeCellRenderer;
import org.netbeans.lib.profiler.ui.components.tree.MethodNameTreeCellRenderer;
import org.netbeans.lib.profiler.ui.components.treetable.ExtendedTreeTableModel;
import org.netbeans.lib.profiler.ui.components.treetable.JTreeTablePanel;
import org.netbeans.lib.profiler.ui.memory.MemoryResUserActionsHandler;

public abstract class ReverseMemCallGraphPanel
extends ResultsPanel {
    private static final ResourceBundle messages = ResourceBundle.getBundle("org.netbeans.lib.profiler.ui.memory.Bundle");
    private static final String METHOD_COLUMN_NAME = messages.getString("ReverseMemCallGraphPanel_MethodColumnName");
    private static final String LIVE_BYTES_REL_COLUMN_NAME = messages.getString("ReverseMemCallGraphPanel_LiveBytesRelColumnName");
    private static final String LIVE_BYTES_COLUMN_NAME = messages.getString("ReverseMemCallGraphPanel_LiveBytesColumnName");
    private static final String LIVE_OBJECTS_COLUMN_NAME = messages.getString("ReverseMemCallGraphPanel_LiveObjectsColumnName");
    private static final String ALLOC_OBJECTS_COLUMN_NAME = messages.getString("ReverseMemCallGraphPanel_AllocObjectsColumnName");
    private static final String AVG_AGE_COLUMN_NAME = messages.getString("ReverseMemCallGraphPanel_AvgAgeColumnName");
    private static final String SURVGEN_COLUMN_NAME = messages.getString("ReverseMemCallGraphPanel_SurvGenColumnName");
    private static final String METHOD_COLUMN_TOOLTIP = messages.getString("ReverseMemCallGraphPanel_MethodColumnToolTip");
    private static final String LIVE_BYTES_REL_COLUMN_TOOLTIP = messages.getString("ReverseMemCallGraphPanel_LiveBytesRelColumnToolTip");
    private static final String LIVE_BYTES_COLUMN_TOOLTIP = messages.getString("ReverseMemCallGraphPanel_LiveBytesColumnToolTip");
    private static final String LIVE_OBJECTS_COLUMN_TOOLTIP = messages.getString("ReverseMemCallGraphPanel_LiveObjectsColumnToolTip");
    private static final String ALLOC_OBJECTS_COLUMN_TOOLTIP = messages.getString("ReverseMemCallGraphPanel_AllocObjectsColumnToolTip");
    private static final String AVG_AGE_COLUMN_TOOLTIP = messages.getString("ReverseMemCallGraphPanel_AvgAgeColumnToolTip");
    private static final String SURVGEN_COLUMN_TOOLTIP = messages.getString("ReverseMemCallGraphPanel_SurvGenColumnToolTip");
    private static final String BYTES_ALLOC_REL_COLUMN_NAME = messages.getString("ReverseMemCallGraphPanel_BytesAllocRelColumnName");
    private static final String BYTES_ALLOC_COLUMN_NAME = messages.getString("ReverseMemCallGraphPanel_BytesAllocColumnName");
    private static final String OBJECTS_ALLOC_COLUMN_NAME = messages.getString("ReverseMemCallGraphPanel_ObjectsAllocColumnName");
    private static final String BYTES_ALLOC_REL_COLUMN_TOOLTIP = messages.getString("ReverseMemCallGraphPanel_BytesAllocRelColumnToolTip");
    private static final String BYTES_ALLOC_COLUMN_TOOLTIP = messages.getString("ReverseMemCallGraphPanel_BytesAllocColumnToolTip");
    private static final String OBJECTS_ALLOC_COLUMN_TOOLTIP = messages.getString("ReverseMemCallGraphPanel_ObjectsAllocColumnToolTip");
    private static final String GO_SOURCE_POPUP_ITEM = messages.getString("ReverseMemCallGraphPanel_GoSourcePopupItem");
    protected ExtendedTreeTableModel treeTableModel;
    protected JButton cornerButton;
    protected JPopupMenu headerPopup;
    protected JPopupMenu popupMenu;
    protected JTreeTable treeTable;
    protected JTreeTablePanel treeTablePanel;
    protected MemoryResUserActionsHandler actionsHandler;
    protected TreePath treePath;
    protected String[] columnNames;
    protected TableCellRenderer[] columnRenderers;
    protected String[] columnToolTips;
    protected int[] columnWidths;
    protected boolean extendedResults;
    protected int columnCount = 0;
    protected int minNamesColumnWidth;
    CustomBarCellRenderer customBarCellRenderer;
    private EnhancedTreeCellRenderer enhancedTreeCellRenderer = new MethodNameTreeCellRenderer();
    private ImageIcon leafIcon = new ImageIcon(ReverseMemCallGraphPanel.class.getResource("/org/netbeans/lib/profiler/ui/resources/reverseNode.png"));
    private ImageIcon nodeIcon = new ImageIcon(ReverseMemCallGraphPanel.class.getResource("/org/netbeans/lib/profiler/ui/resources/reverseNode.png"));

    public ReverseMemCallGraphPanel(MemoryResUserActionsHandler actionsHandler, boolean extendedResults) {
        this.extendedResults = extendedResults;
        this.actionsHandler = actionsHandler;
        this.enhancedTreeCellRenderer.setLeafIcon(this.leafIcon);
        this.enhancedTreeCellRenderer.setClosedIcon(this.nodeIcon);
        this.enhancedTreeCellRenderer.setOpenIcon(this.nodeIcon);
        this.minNamesColumnWidth = this.getFontMetrics(this.getFont()).charWidth('W') * 30;
        this.headerPopup = new JPopupMenu();
        this.cornerButton = this.createHeaderPopupCornerButton(this.headerPopup);
        this.popupMenu = this.initPopupMenu();
        this.initColumnsData();
    }

    public void setFindString(String findString) {
        if (this.treeTable != null) {
            this.treeTable.setFindParameters(findString, 0);
        }
    }

    public String getFindString() {
        if (this.treeTable == null) {
            return null;
        }
        return this.treeTable.getFindString();
    }

    public boolean isFindStringDefined() {
        if (this.treeTable == null) {
            return false;
        }
        return this.treeTable.isFindStringDefined();
    }

    public boolean findFirst() {
        if (this.treeTable == null) {
            return false;
        }
        return this.treeTable.findFirst();
    }

    public boolean findNext() {
        if (this.treeTable == null) {
            return false;
        }
        return this.treeTable.findNext();
    }

    public boolean findPrevious() {
        if (this.treeTable == null) {
            return false;
        }
        return this.treeTable.findPrevious();
    }

    @Override
    public void requestFocus() {
        if (this.treeTable != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ReverseMemCallGraphPanel.this.treeTable.requestFocus();
                }
            });
        }
    }

    protected void setColumnsData() {
        TableColumnModel colModel = this.treeTable.getColumnModel();
        this.treeTable.setTreeCellRenderer(this.enhancedTreeCellRenderer);
        colModel.getColumn(0).setPreferredWidth(this.minNamesColumnWidth);
        for (int i = 0; i < this.treeTableModel.getColumnCount(); ++i) {
            int index = this.treeTableModel.getRealColumn(i);
            if (index == 0) continue;
            colModel.getColumn(i).setPreferredWidth(this.columnWidths[index - 1]);
            colModel.getColumn(i).setCellRenderer(this.columnRenderers[index]);
        }
    }

    @Override
    protected void initColumnSelectorItems() {
        this.headerPopup.removeAll();
        for (int i = 0; i < this.columnCount; ++i) {
            JCheckBoxMenuItem menuItem = new JCheckBoxMenuItem(this.columnNames[i]);
            menuItem.setActionCommand(Integer.valueOf(i).toString());
            this.addMenuItemListener(menuItem);
            if (this.treeTable != null) {
                boolean columnVisible = this.treeTableModel.isRealColumnVisible(i);
                menuItem.setState(this.treeTableModel.isRealColumnVisible(i));
                if (i == 0) {
                    menuItem.setEnabled(false);
                }
            } else {
                menuItem.setState(true);
            }
            this.headerPopup.add(menuItem);
        }
        this.headerPopup.pack();
    }

    protected JPopupMenu initPopupMenu() {
        JPopupMenu popup = new JPopupMenu();
        Font boldfont = popup.getFont().deriveFont(1);
        JMenuItem popupShowSource = new JMenuItem();
        popupShowSource.setFont(boldfont);
        popupShowSource.setText(GO_SOURCE_POPUP_ITEM);
        popupShowSource.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (ReverseMemCallGraphPanel.this.treePath != null) {
                    ReverseMemCallGraphPanel.this.performDefaultAction(ReverseMemCallGraphPanel.this.treePath);
                }
            }
        });
        popup.add(popupShowSource);
        return popup;
    }

    void performDefaultAction(TreePath path) {
        PresoObjAllocCCTNode node = (PresoObjAllocCCTNode)path.getLastPathComponent();
        String[] classMethodAndSig = node.getMethodClassNameAndSig();
        if (node.getParent() == null) {
            this.showSourceForClass(classMethodAndSig[0]);
        } else {
            this.actionsHandler.showSourceForMethod(classMethodAndSig[0], classMethodAndSig[1], classMethodAndSig[2]);
        }
    }

    private void showSourceForClass(String className) {
        className = className.replace("[]", "");
        this.actionsHandler.showSourceForMethod(className, null, null);
    }

    private void addMenuItemListener(JCheckBoxMenuItem menuItem) {
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean sortResults = false;
                int column = Integer.parseInt(e.getActionCommand());
                boolean sortOrder = ReverseMemCallGraphPanel.this.treeTable.getSortingOrder();
                int sortingColumn = ReverseMemCallGraphPanel.this.treeTable.getSortingColumn();
                int realSortingColumn = ReverseMemCallGraphPanel.this.treeTableModel.getRealColumn(sortingColumn);
                boolean isColumnVisible = ReverseMemCallGraphPanel.this.treeTableModel.isRealColumnVisible(column);
                if (isColumnVisible && column == realSortingColumn) {
                    sortingColumn = sortingColumn + 1 == ReverseMemCallGraphPanel.this.treeTableModel.getColumnCount() ? sortingColumn - 1 : sortingColumn + 1;
                    realSortingColumn = ReverseMemCallGraphPanel.this.treeTableModel.getRealColumn(sortingColumn);
                    sortResults = true;
                }
                ReverseMemCallGraphPanel.this.treeTableModel.setRealColumnVisibility(column, !isColumnVisible);
                ReverseMemCallGraphPanel.this.treeTable.createDefaultColumnsFromModel();
                ReverseMemCallGraphPanel.this.treeTable.updateTreeTableHeader();
                sortingColumn = ReverseMemCallGraphPanel.this.treeTableModel.getVirtualColumn(realSortingColumn);
                if (sortResults) {
                    sortOrder = ReverseMemCallGraphPanel.this.treeTableModel.getInitialSorting(sortingColumn);
                    ReverseMemCallGraphPanel.this.treeTableModel.sortByColumn(sortingColumn, sortOrder);
                    ReverseMemCallGraphPanel.this.treeTable.updateTreeTable();
                }
                ReverseMemCallGraphPanel.this.treeTable.setSortingColumn(sortingColumn);
                ReverseMemCallGraphPanel.this.treeTable.setSortingOrder(sortOrder);
                ReverseMemCallGraphPanel.this.treeTable.getTableHeader().repaint();
                ReverseMemCallGraphPanel.this.setColumnsData();
            }
        });
    }

    private void initColumnsData() {
        int i;
        if (this.extendedResults) {
            this.columnNames = new String[]{METHOD_COLUMN_NAME, LIVE_BYTES_REL_COLUMN_NAME, LIVE_BYTES_COLUMN_NAME, LIVE_OBJECTS_COLUMN_NAME, ALLOC_OBJECTS_COLUMN_NAME, AVG_AGE_COLUMN_NAME, SURVGEN_COLUMN_NAME};
            this.columnToolTips = new String[]{METHOD_COLUMN_TOOLTIP, LIVE_BYTES_REL_COLUMN_TOOLTIP, LIVE_BYTES_COLUMN_TOOLTIP, LIVE_OBJECTS_COLUMN_TOOLTIP, ALLOC_OBJECTS_COLUMN_TOOLTIP, AVG_AGE_COLUMN_TOOLTIP, SURVGEN_COLUMN_TOOLTIP};
        } else {
            this.columnNames = new String[]{METHOD_COLUMN_NAME, BYTES_ALLOC_REL_COLUMN_NAME, BYTES_ALLOC_COLUMN_NAME, OBJECTS_ALLOC_COLUMN_NAME};
            this.columnToolTips = new String[]{METHOD_COLUMN_TOOLTIP, BYTES_ALLOC_REL_COLUMN_TOOLTIP, BYTES_ALLOC_COLUMN_TOOLTIP, OBJECTS_ALLOC_COLUMN_TOOLTIP};
        }
        this.columnCount = this.columnNames.length;
        this.columnWidths = new int[this.columnCount - 1];
        this.columnRenderers = new TableCellRenderer[this.columnCount];
        LabelBracketTableCellRenderer labelBracketTableCellRenderer = new LabelBracketTableCellRenderer(11);
        LabelTableCellRenderer labelTableCellRenderer = new LabelTableCellRenderer(11);
        int maxWidth = this.extendedResults ? this.getFontMetrics(this.getFont()).charWidth('W') * 10 : this.getFontMetrics(this.getFont()).charWidth('W') * 13;
        this.columnRenderers[0] = null;
        this.columnWidths[0] = maxWidth;
        this.columnRenderers[1] = null;
        for (i = 2; i < 4; ++i) {
            this.columnWidths[i - 1] = maxWidth;
            this.columnRenderers[i] = labelBracketTableCellRenderer;
        }
        for (i = 4; i < this.columnNames.length; ++i) {
            this.columnWidths[i - 1] = maxWidth;
            this.columnRenderers[i] = labelTableCellRenderer;
        }
    }

    private void saveColumnsData() {
        TableColumnModel colModel = this.treeTable.getColumnModel();
        for (int i = 0; i < this.treeTableModel.getColumnCount(); ++i) {
            int index = this.treeTableModel.getRealColumn(i);
            if (index == 0) continue;
            this.columnWidths[index - 1] = colModel.getColumn(i).getPreferredWidth();
        }
    }
}

