/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.componentssupport.ui.helpers;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.vmd.componentssupport.ui.helpers.BaseHelper;
import org.netbeans.modules.vmd.componentssupport.ui.helpers.LayerXmlHelper;
import org.netbeans.modules.vmd.componentssupport.ui.helpers.ProjectXmlHelper;
import org.netbeans.modules.vmd.componentssupport.ui.wizard.PaletteCategory;
import org.netbeans.modules.vmd.componentssupport.ui.wizard.Version;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.openide.ErrorManager;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Mutex;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class CustomComponentHelper
extends BaseHelper {
    public static final String OPENIDE_MODULE = "OpenIDE-Module";
    public static final String OPENIDE_MODULE_LAYER = "OpenIDE-Module-Layer";
    public static final String OPENIDE_MODULE_LOCALIZING_BUNDLE = "OpenIDE-Module-Localizing-Bundle";
    public static final String TEMPLATE_COMP_DESCR = "CustomComponentCD.java";
    public static final String TEMPLATE_PRODUCER = "CustomComponentProducer.java";
    private static final String MANIFEST = "manifest.mf";

    public abstract Set<FileObject> instantiate() throws IOException;

    public abstract String getCodeNameBase();

    public abstract String getProjectName();

    public abstract String getCDPath();

    public abstract String getProducerPath();

    public abstract boolean isCDClassNameExist(String var1);

    public abstract boolean isProducerClassNameExist(String var1);

    protected String createCDPath(String cdName) {
        String slashCodeNameBase = this.getCodeNameBase().replace('.', '/');
        return "src/" + slashCodeNameBase + "/" + "descriptors" + "/" + cdName + ".java";
    }

    protected String createProducerPath(String producerName) {
        String slashCodeNameBase = this.getCodeNameBase().replace('.', '/');
        return "src/" + slashCodeNameBase + "/" + "producers" + "/" + producerName + ".java";
    }

    public static class RealInstantiationHelper
    extends CustomComponentHelper {
        private static final String INSTANCE_NAME_EXTENSION = ".instance";
        private static final String LAYER_TAG_VMD_MIDP = "vmd-midp";
        private static final String LAYER_TAG_COMPONENTS = "components";
        private static final String LAYER_TAG_PRODUCERS = "producers";
        private static final String LAYER_XPATH_VMD_MIDP = "./folder[@name=\"vmd-midp\"]";
        private static final String LAYER_XPATH_COMPONENTS = "./folder[@name=\"components\"]";
        private static final String LAYER_XPATH_PRODUCERS = "./folder[@name=\"producers\"]";
        private static final String VALIDITY_TOKEN_VALUE_ALWAYS = "always";
        private static final String VALIDITY_TOKEN_VALUE_PLATFORM = "platform";
        private static final String VALIDITY_TOKEN_VALUE_CUSTOM = "custom";
        private static final String VMD_MIDP_NAME = "org.netbeans.modules.vmd.midp";
        private static final String VMD_MIDP_VERSION = "1.1";
        private static final String VMD_MODEL_NAME = "org.netbeans.modules.vmd.model";
        private static final String VMD_MODEL_VERSION = "1.1";
        private static final String VMD_PROPERTIES_NAME = "org.netbeans.modules.vmd.properties";
        private static final String VMD_PROPERTIES_VERSION = "1.1";
        private static final String OPENIDE_UTIL_NAME = "org.openide.util";
        private static final String OPENIDE_UTIL_VERSION = "7.12";
        private Project myProject;
        private Map<String, Object> myComponent;
        private WizardDescriptor myComponentWizard;
        private String myBundlePath;
        private String myLayerPath;
        private String myCodeNameBase;
        private Manifest myManifest;

        public RealInstantiationHelper(Project project, Map<String, Object> component) {
            this.myProject = project;
            this.myComponent = component;
            this.myComponentWizard = null;
            assert (this.myComponent != null);
        }

        public RealInstantiationHelper(Project project, WizardDescriptor wizard) {
            this.myProject = project;
            this.myComponent = null;
            this.myComponentWizard = wizard;
            assert (this.myComponentWizard != null);
        }

        @Override
        public boolean isCDClassNameExist(String name) {
            FileObject prjDir = this.getProject().getProjectDirectory();
            String cd = this.createCDPath(name);
            return this.isFileExist(prjDir, cd);
        }

        @Override
        public boolean isProducerClassNameExist(String name) {
            FileObject prjDir = this.getProject().getProjectDirectory();
            String producer = this.createProducerPath(name);
            return this.isFileExist(prjDir, producer);
        }

        @Override
        public String getProjectName() {
            return ProjectUtils.getInformation((Project)this.myProject).getDisplayName();
        }

        @Override
        public Set<FileObject> instantiate() throws IOException {
            LinkedHashSet<FileObject> result = new LinkedHashSet<FileObject>();
            assert (this.myComponent != null || this.myComponentWizard != null);
            this.configureDependencies();
            FileObject cdFO = this.configureComponentDescriptor();
            result.add(cdFO);
            FileObject producerFO = this.configureProducer();
            result.add(producerFO);
            result.addAll(this.configureLayerXml());
            result.addAll(this.configureProducerBundle());
            result.addAll(this.configureIcons());
            return result;
        }

        @Override
        public String getCDPath() {
            String name = this.getCDClassName();
            return this.createCDPath(name);
        }

        @Override
        public String getProducerPath() {
            String name = this.getProducerClassName();
            return this.createProducerPath(name);
        }

        @Override
        public String getCodeNameBase() {
            if (this.myCodeNameBase != null) {
                return this.myCodeNameBase;
            }
            Manifest manifest = this.getManifest();
            Attributes attrs = manifest.getMainAttributes();
            String codename = attrs.getValue(CustomComponentHelper.OPENIDE_MODULE);
            if (codename != null) {
                int slash = codename.lastIndexOf(47);
                this.myCodeNameBase = slash == -1 ? codename : codename.substring(0, slash);
            }
            return this.myCodeNameBase;
        }

        public String getCDPkg() {
            return this.getCodeNameBase() + "." + "descriptors";
        }

        public String getProducerPkg() {
            return this.getCodeNameBase() + "." + LAYER_TAG_PRODUCERS;
        }

        public String getCDLayerInstanceName() {
            String dotCodeNameBase = this.getCodeNameBase();
            String name = this.getCDClassName();
            String codeNameBase = dotCodeNameBase.replace('.', '-');
            return codeNameBase + "-" + "descriptors" + "-" + name + INSTANCE_NAME_EXTENSION;
        }

        public String getProducerLayerInstanceName() {
            String dotCodeNameBase = this.getCodeNameBase();
            String name = this.getProducerClassName();
            String codeNameBase = dotCodeNameBase.replace('.', '-');
            return codeNameBase + "-" + LAYER_TAG_PRODUCERS + "-" + name + INSTANCE_NAME_EXTENSION;
        }

        protected String getLocalizingBundle() {
            if (this.myBundlePath == null) {
                Manifest manifest = this.getManifest();
                Attributes attrs = manifest.getMainAttributes();
                this.myBundlePath = attrs.getValue(CustomComponentHelper.OPENIDE_MODULE_LOCALIZING_BUNDLE);
            }
            return this.myBundlePath;
        }

        protected String getLayer() {
            Manifest manifest;
            Attributes attrs;
            if (this.myLayerPath == null && (attrs = (manifest = this.getManifest()).getMainAttributes()).containsKey(CustomComponentHelper.OPENIDE_MODULE_LAYER)) {
                this.myLayerPath = "src/" + attrs.getValue(CustomComponentHelper.OPENIDE_MODULE_LAYER);
            }
            return this.myLayerPath;
        }

        protected Project getProject() {
            return this.myProject;
        }

        private FileObject configureComponentDescriptor() throws IOException {
            FileObject template = RealInstantiationHelper.getTemplate(CustomComponentHelper.TEMPLATE_COMP_DESCR);
            Map<String, String> tokens = this.getCDTokens();
            return RealInstantiationHelper.doCopyFile(this.getProject().getProjectDirectory(), this.getCDPath(), template, tokens);
        }

        private FileObject configureProducer() throws IOException {
            FileObject template = RealInstantiationHelper.getTemplate(CustomComponentHelper.TEMPLATE_PRODUCER);
            Map<String, String> tokens = this.getProducerTokens();
            return RealInstantiationHelper.doCopyFile(this.getProject().getProjectDirectory(), this.getProducerPath(), template, tokens);
        }

        private Map<String, String> getCDTokens() {
            HashMap<String, String> tokens = new HashMap<String, String>();
            tokens.put("package", this.getCDPkg());
            tokens.put("cdName", this.getCDClassName());
            tokens.put("typeId", (String)this.getProperty("compDescrTypeId"));
            tokens.put("superDescriptorClass", this.getSuperDescrClassNameToken());
            tokens.put("superDescriptorClassFQN", this.getSuperDescrClassFQNToken());
            tokens.put("prefix", (String)this.getProperty("prefix"));
            tokens.put("canInstantiate", this.getProperty("compDescrCanInstantiate").toString());
            tokens.put("canBeSuper", this.getProperty("compDescrCanBeSuper").toString());
            tokens.put("midpVersion", this.getMidpVersionToken());
            return tokens;
        }

        private String getMidpVersionToken() {
            Version version = (Version)((Object)this.getProperty("compDescrVersion"));
            assert (version != null);
            return version.javaCodeValue();
        }

        private String getSuperDescrClassFQNToken() {
            String superString = (String)this.getProperty("compDescrSuperClass");
            assert (superString != null);
            if (superString.indexOf(".") == -1) {
                return "";
            }
            return superString;
        }

        private String getSuperDescrClassNameToken() {
            String superString = (String)this.getProperty("compDescrSuperClass");
            assert (superString != null);
            if (superString.indexOf(".") == -1) {
                return superString;
            }
            return superString.substring(superString.lastIndexOf(".") + 1, superString.length());
        }

        private Map<String, String> getProducerTokens() {
            HashMap<String, String> tokens = new HashMap<String, String>();
            tokens.put("package", this.getProducerPkg());
            tokens.put("producerName", this.getProducerClassName());
            tokens.put("iconPathSmall", this.getSmallIconToken());
            tokens.put("iconPathLarge", this.getLargeIconToken());
            tokens.put("cdName", this.getCDClassName());
            tokens.put("cdPackage", this.getCDPkg());
            tokens.put("paletteCategory", this.getPaletteCategoryToken());
            tokens.put("prefix", (String)this.getProperty("prefix"));
            if (((Boolean)this.getProperty("compProdAddLib")).booleanValue()) {
                tokens.put("libraryName", (String)this.getProperty("compProdLibName"));
            }
            tokens.put("validity", this.getProducerValidityToken());
            return tokens;
        }

        private String getPaletteCategoryToken() {
            PaletteCategory category = (PaletteCategory)((Object)this.getProperty("compProdPaletteCategory"));
            assert (category != null);
            return category.javaCodeValue();
        }

        private String getProducerValidityToken() {
            Boolean always = (Boolean)this.getProperty("compProdValidAlways");
            Boolean platform = (Boolean)this.getProperty("compProdValidPlatform");
            Boolean custom = (Boolean)this.getProperty("compProdValidCustom");
            assert (always != null || platform != null || custom != null);
            if (always != null) {
                return VALIDITY_TOKEN_VALUE_ALWAYS;
            }
            if (platform != null) {
                return VALIDITY_TOKEN_VALUE_PLATFORM;
            }
            if (custom != null) {
                return VALIDITY_TOKEN_VALUE_CUSTOM;
            }
            return VALIDITY_TOKEN_VALUE_ALWAYS;
        }

        private String getSmallIconToken() {
            return this.getIconToken(this.getSmallIconPath());
        }

        private String getLargeIconToken() {
            return this.getIconToken(this.getLargeIconPath());
        }

        private String getIconToken(String srcPath) {
            if (srcPath == null) {
                return "null";
            }
            String codeNameBase = this.getCodeNameBase().replace('.', '/');
            File iconFile = new File(srcPath);
            String name = iconFile.getName();
            return codeNameBase + "/" + "resources" + "/" + name;
        }

        private Set<FileObject> configureProducerBundle() throws IOException {
            FileObject prjDir = this.getProject().getProjectDirectory();
            String pkgPath = this.getProducerPkg().replace('.', '/');
            String bundlePath = "src/" + pkgPath + "/" + "Bundle.properties";
            boolean exists = this.isFileExist(prjDir, bundlePath);
            FileObject bundleFO = FileUtil.createData((FileObject)prjDir, (String)bundlePath);
            this.doUpdateProducerBundle(bundleFO);
            if (exists) {
                return Collections.EMPTY_SET;
            }
            LinkedHashSet<FileObject> result = new LinkedHashSet<FileObject>();
            result.add(bundleFO);
            return result;
        }

        private void doUpdateProducerBundle(FileObject bundleFO) throws IOException {
            String prefix = (String)this.getProperty("prefix") + "_";
            EditableProperties ep = RealInstantiationHelper.loadProperties(bundleFO);
            String nameKey = prefix + "paletteName";
            String nameValue = (String)this.getProperty("compProdPaletteDispName");
            String tooltipKey = prefix + "paletteTooltip";
            String tooltipValue = (String)this.getProperty("compProdPaletteTip");
            ep.setProperty(nameKey, nameValue);
            ep.setProperty(tooltipKey, tooltipValue);
            RealInstantiationHelper.storeProperties(bundleFO, ep);
        }

        private boolean isFileExist(FileObject prjDir, String path) {
            File file = new File(FileUtil.toFile((FileObject)prjDir), path);
            return file.exists();
        }

        private FileObject createAndRegisterLayerXml() throws IOException {
            FileObject prjDir = this.getProject().getProjectDirectory();
            String cnb = this.getCodeNameBase().replace(".", "/");
            String layerXmlPath = cnb + "/" + "layer.xml";
            FileObject layerFO = LayerXmlHelper.createLayerXml(prjDir, "src/" + layerXmlPath);
            Manifest manifest = this.getManifest();
            Attributes attrs = manifest.getMainAttributes();
            attrs.putValue(CustomComponentHelper.OPENIDE_MODULE_LAYER, layerXmlPath);
            this.saveManifest(manifest);
            return layerFO;
        }

        private Set<FileObject> configureLayerXml() throws IOException {
            String layerXmlPath = this.getLayer();
            FileObject prjDir = this.getProject().getProjectDirectory();
            FileObject layerXmlFO = null;
            layerXmlFO = layerXmlPath == null || !this.isFileExist(prjDir, layerXmlPath) ? this.createAndRegisterLayerXml() : FileUtil.createData((FileObject)prjDir, (String)layerXmlPath);
            try {
                Document doc = LayerXmlHelper.parseXmlDocument(layerXmlFO);
                assert (doc != null);
                Element docRoot = doc.getDocumentElement();
                XPath xpath = XPathFactory.newInstance().newXPath();
                Node fsNode = LayerXmlHelper.goToFilesystemNode(doc, xpath, docRoot);
                Node vmdMidpNode = RealInstantiationHelper.goToVmdMidpNode(doc, xpath, fsNode);
                Node compsNode = RealInstantiationHelper.goToComponentsNode(doc, xpath, vmdMidpNode);
                Element cd = doc.createElement("file");
                cd.setAttribute("name", this.getCDLayerInstanceName());
                compsNode.appendChild(cd);
                Node produsersNode = RealInstantiationHelper.goToProducersNode(doc, xpath, vmdMidpNode);
                Element prod = doc.createElement("file");
                prod.setAttribute("name", this.getProducerLayerInstanceName());
                produsersNode.appendChild(prod);
                LayerXmlHelper.saveXmlDocument(doc, layerXmlFO);
            }
            catch (XPathExpressionException ex) {
                ErrorManager.getDefault().notify((Throwable)ex);
            }
            return Collections.EMPTY_SET;
        }

        private static Node goToProducersNode(Document doc, XPath xpath, Node parent) throws XPathExpressionException {
            String expression = LAYER_XPATH_PRODUCERS;
            Node libsNode = (Node)xpath.evaluate(expression, parent, XPathConstants.NODE);
            if (libsNode == null) {
                Element libsElement = doc.createElement("folder");
                libsElement.setAttribute("name", LAYER_TAG_PRODUCERS);
                parent.appendChild(libsElement);
                libsNode = libsElement;
            }
            return libsNode;
        }

        private static Node goToComponentsNode(Document doc, XPath xpath, Node parent) throws XPathExpressionException {
            String expression = LAYER_XPATH_COMPONENTS;
            Node libsNode = (Node)xpath.evaluate(expression, parent, XPathConstants.NODE);
            if (libsNode == null) {
                Element libsElement = doc.createElement("folder");
                libsElement.setAttribute("name", LAYER_TAG_COMPONENTS);
                parent.appendChild(libsElement);
                libsNode = libsElement;
            }
            return libsNode;
        }

        private static Node goToVmdMidpNode(Document doc, XPath xpath, Node parent) throws XPathExpressionException {
            String expression = LAYER_XPATH_VMD_MIDP;
            Node libsAreaNode = (Node)xpath.evaluate(expression, parent, XPathConstants.NODE);
            if (libsAreaNode == null) {
                Element libsAreaElement = doc.createElement("folder");
                libsAreaElement.setAttribute("name", LAYER_TAG_VMD_MIDP);
                parent.appendChild(libsAreaElement);
                libsAreaNode = libsAreaElement;
            }
            return libsAreaNode;
        }

        private Set<FileObject> configureIcons() throws IOException {
            String large;
            LinkedHashSet<FileObject> result = new LinkedHashSet<FileObject>();
            String small = this.getSmallIconPath();
            if (small != null) {
                result.add(this.copyIcon(small));
            }
            if ((large = this.getLargeIconPath()) != null) {
                result.add(this.copyIcon(large));
            }
            return result;
        }

        private FileObject copyIcon(String srcPath) throws IOException {
            String dotCodeNameBase = this.getCodeNameBase();
            String codeNameBase = dotCodeNameBase.replace('.', '/');
            File iconFile = new File(srcPath);
            String name = iconFile.getName();
            String targetPath = "src/" + codeNameBase + "/" + "resources" + "/" + name;
            FileObject targetFO = FileUtil.createData((FileObject)this.getProject().getProjectDirectory(), (String)targetPath);
            RealInstantiationHelper.copyByteAfterByte(iconFile, targetFO);
            return targetFO;
        }

        private String getSmallIconPath() {
            String path = (String)this.getProperty("compProdSmallIcon");
            if (path == null || path.length() == 0) {
                return null;
            }
            return path;
        }

        private String getLargeIconPath() {
            String path = (String)this.getProperty("compProdLargeIcon");
            if (path == null || path.length() == 0) {
                return null;
            }
            return path;
        }

        private void configureDependencies() {
            try {
                FileObject prjDir = this.getProject().getProjectDirectory();
                FileObject projectXmlFO = FileUtil.createData((FileObject)prjDir, (String)"nbproject/project.xml");
                Document doc = LayerXmlHelper.parseXmlDocument(projectXmlFO);
                XPath xpath = XPathFactory.newInstance().newXPath();
                Node confData = ProjectXmlHelper.getPrimaryConfigurationData(xpath, doc.getDocumentElement());
                Node modDeps = ProjectXmlHelper.goToModuleDependencies(doc, xpath, confData);
                ProjectXmlHelper.testAndAddDependency(doc, xpath, modDeps, VMD_MIDP_NAME, "1.1");
                ProjectXmlHelper.testAndAddDependency(doc, xpath, modDeps, VMD_MODEL_NAME, "1.1");
                ProjectXmlHelper.testAndAddDependency(doc, xpath, modDeps, VMD_PROPERTIES_NAME, "1.1");
                ProjectXmlHelper.testAndAddDependency(doc, xpath, modDeps, OPENIDE_UTIL_NAME, OPENIDE_UTIL_VERSION);
                ProjectXmlHelper.saveXmlDocument(doc, projectXmlFO);
            }
            catch (IOException ex) {
                ErrorManager.getDefault().notify((Throwable)ex);
            }
            catch (XPathExpressionException ex) {
                ErrorManager.getDefault().notify((Throwable)ex);
            }
        }

        private Object getProperty(String name) {
            if (this.myComponent == null) {
                return this.myComponentWizard.getProperty(name);
            }
            return this.myComponent.get(name);
        }

        private String getCDClassName() {
            return (String)this.getProperty("compDescrClassName");
        }

        private String getProducerClassName() {
            return (String)this.getProperty("compProdClassName");
        }

        private Manifest getManifest() {
            if (this.myManifest == null) {
                this.myManifest = this.readManifest();
            }
            return this.myManifest;
        }

        private Manifest readManifest() {
            return (Manifest)ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<Manifest>(){

                public Manifest run() {
                    try {
                        return RealInstantiationHelper.this.doReadManifest();
                    }
                    catch (IOException ex) {
                        ErrorManager.getDefault().notify((Throwable)ex);
                        return null;
                    }
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Manifest doReadManifest() throws IOException {
            Manifest manifest = null;
            FileObject manifestFO = this.getProject().getProjectDirectory().getFileObject(CustomComponentHelper.MANIFEST);
            if (manifestFO != null) {
                InputStream is = manifestFO.getInputStream();
                try {
                    manifest = new Manifest(is);
                }
                finally {
                    is.close();
                }
            }
            return manifest;
        }

        private void saveManifest(final Manifest manifest) {
            if (manifest == null) {
                return;
            }
            ProjectManager.mutex().writeAccess((Mutex.Action)new Mutex.Action<Void>(){

                public Void run() {
                    try {
                        RealInstantiationHelper.this.doSaveManifest(manifest);
                    }
                    catch (IOException ex) {
                        ErrorManager.getDefault().notify((Throwable)ex);
                    }
                    return null;
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doSaveManifest(Manifest manifest) throws IOException {
            FileObject manifestFO = this.getProject().getProjectDirectory().getFileObject(CustomComponentHelper.MANIFEST);
            if (manifestFO != null) {
                FileLock lock = manifestFO.lock();
                try {
                    OutputStream os = manifestFO.getOutputStream(lock);
                    try {
                        manifest.write(os);
                    }
                    finally {
                        os.close();
                    }
                }
                finally {
                    lock.releaseLock();
                }
            }
        }
    }

    public static class InstantiationToWizardHelper
    extends CustomComponentHelper {
        private WizardDescriptor myComponentWizard;
        private WizardDescriptor myMainWizard;

        public InstantiationToWizardHelper(WizardDescriptor mainWizard, WizardDescriptor componentWizard) {
            this.myMainWizard = mainWizard;
            this.myComponentWizard = componentWizard;
        }

        @Override
        public boolean isCDClassNameExist(String name) {
            return this.checkIfComponentValueExists("compDescrClassName", name);
        }

        @Override
        public boolean isProducerClassNameExist(String name) {
            return this.checkIfComponentValueExists("compProdClassName", name);
        }

        @Override
        public String getProjectName() {
            return (String)this.myMainWizard.getProperty("projName");
        }

        @Override
        public String getCDPath() {
            String name = this.getCDClassName();
            return this.createCDPath(name);
        }

        @Override
        public String getProducerPath() {
            String name = this.getProducerClassName();
            return this.createProducerPath(name);
        }

        @Override
        public Set<FileObject> instantiate() throws IOException {
            assert (this.myComponentWizard != null && this.myMainWizard != null);
            LinkedList<Map> components = (LinkedList<Map>)this.myMainWizard.getProperty("customComponents");
            if (components == null) {
                components = new LinkedList<Map>();
                this.myMainWizard.putProperty("customComponents", components);
            }
            components.add(this.myComponentWizard.getProperties());
            return Collections.EMPTY_SET;
        }

        @Override
        public String getCodeNameBase() {
            String codeNameBase = (String)this.myMainWizard.getProperty("codeBaseName");
            String projectName = (String)this.myMainWizard.getProperty("projName");
            if (codeNameBase == null) {
                codeNameBase = InstantiationToWizardHelper.getDefaultCodeNameBase(projectName);
            }
            return codeNameBase;
        }

        private boolean checkIfComponentValueExists(String key, Object value) {
            List<Map<String, Object>> list = this.getExistingComponents();
            if (list == null) {
                return false;
            }
            for (Map<String, Object> comp : list) {
                Object testValue = comp.get(key);
                if (!testValue.equals(value)) continue;
                return true;
            }
            return false;
        }

        private List<Map<String, Object>> getExistingComponents() {
            Object value = this.myMainWizard.getProperty("customComponents");
            if (value == null || !(value instanceof List)) {
                return null;
            }
            return (List)value;
        }

        private String getCDClassName() {
            return (String)this.myComponentWizard.getProperty("compDescrClassName");
        }

        private String getProducerClassName() {
            return (String)this.myComponentWizard.getProperty("compProdClassName");
        }
    }
}

