/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.j2ee;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.db.explorer.ConnectionManager;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.api.db.explorer.JDBCDriver;
import org.netbeans.api.db.explorer.JDBCDriverManager;
import org.netbeans.api.db.explorer.support.DatabaseExplorerUIs;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.form.DataImporter;
import org.netbeans.modules.form.FormEditor;
import org.netbeans.modules.form.FormJavaSource;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.form.RADComponent;
import org.netbeans.modules.form.j2ee.DBTableDrop;
import org.netbeans.modules.form.j2ee.J2EEUtils;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModel;
import org.netbeans.modules.j2ee.persistence.api.PersistenceScope;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.EntityMappingsMetadata;
import org.netbeans.modules.j2ee.persistence.dd.common.PersistenceUnit;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class JPADataImporter
extends JPanel
implements DataImporter {
    private JComboBox connectionCombo;
    private JLabel connectionLabel;
    private JLabel importerLabel;
    private JComboBox tableCombo;
    private JLabel tableLabel;

    private void initComponents() {
        this.importerLabel = new JLabel();
        this.connectionLabel = new JLabel();
        this.tableLabel = new JLabel();
        this.tableCombo = new JComboBox();
        this.connectionCombo = new JComboBox();
        this.importerLabel.setText(NbBundle.getMessage(JPADataImporter.class, (String)"MSG_ImportData"));
        this.connectionLabel.setText(NbBundle.getMessage(JPADataImporter.class, (String)"LBL_ImportDBConnection"));
        this.tableLabel.setText(NbBundle.getMessage(JPADataImporter.class, (String)"LBL_ImportDBTable"));
        this.tableCombo.setEnabled(false);
        this.tableCombo.setRenderer(J2EEUtils.DBColumnInfo.getRenderer());
        this.connectionCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPADataImporter.this.connectionComboActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.importerLabel).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.connectionLabel).add((Component)this.tableLabel)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.tableCombo, 0, 238, Short.MAX_VALUE).add((Component)this.connectionCombo, 0, 238, Short.MAX_VALUE)))).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.importerLabel).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.connectionLabel).add((Component)this.connectionCombo, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.tableLabel).add((Component)this.tableCombo, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void connectionComboActionPerformed(ActionEvent evt) {
        Object selItem = this.connectionCombo.getSelectedItem();
        if (selItem instanceof DatabaseConnection) {
            DatabaseConnection connection = (DatabaseConnection)selItem;
            Connection con = J2EEUtils.establishConnection(connection);
            if (con == null) {
                return;
            }
            this.fillTableCombo(connection);
        } else assert (selItem == null);
    }

    private void fillTableCombo(DatabaseConnection connection) {
        DefaultComboBoxModel<J2EEUtils.DBColumnInfo> model = new DefaultComboBoxModel<J2EEUtils.DBColumnInfo>();
        for (J2EEUtils.DBColumnInfo table : J2EEUtils.tableNamesForConnection(connection)) {
            model.addElement(table);
        }
        this.tableCombo.setModel(model);
        this.tableCombo.setEnabled(this.tableCombo.getModel().getSize() != 0);
        this.tableCombo.setSelectedItem(this.tableCombo.getSelectedItem());
    }

    public Future<RADComponent> importData(final FormModel formModel) {
        this.removeAll();
        if (FormJavaSource.isInDefaultPackage((FormModel)formModel)) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(this.getClass(), (String)"MSG_ImportToDefaultPackage")));
            return null;
        }
        this.initComponents();
        DatabaseExplorerUIs.connect((JComboBox)this.connectionCombo, (ConnectionManager)ConnectionManager.getDefault());
        DialogDescriptor dd = new DialogDescriptor((Object)this, NbBundle.getMessage(this.getClass(), (String)"TITLE_ImportData"), true, null);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dd);
        dialog.setVisible(true);
        if (dd.getValue() != DialogDescriptor.OK_OPTION) {
            return null;
        }
        FutureTask<RADComponent> task = new FutureTask<RADComponent>(new Callable<RADComponent>(){

            @Override
            public RADComponent call() throws Exception {
                final RADComponent[] resultList = new RADComponent[1];
                try {
                    J2EEUtils.DBColumnInfo table = (J2EEUtils.DBColumnInfo)JPADataImporter.this.tableCombo.getSelectedItem();
                    if (table == null || !table.isValid()) {
                        return null;
                    }
                    String tableName = table.getName();
                    DatabaseConnection connection = (DatabaseConnection)JPADataImporter.this.connectionCombo.getSelectedItem();
                    FileObject formFile = FormEditor.getFormDataObject((FormModel)formModel).getFormFile();
                    Project project = FileOwnerQuery.getOwner((FileObject)formFile);
                    FileObject persistenceXML = J2EEUtils.getPersistenceXML(project, true);
                    PersistenceUnit unit = J2EEUtils.initPersistenceUnit(persistenceXML, connection);
                    JDBCDriver[] driver = JDBCDriverManager.getDefault().getDrivers(connection.getDriverClass());
                    J2EEUtils.updateProjectForUnit(formFile, unit, driver[0]);
                    PersistenceScope scope = PersistenceScope.getPersistenceScope((FileObject)formFile);
                    MetadataModel mappings = scope.getEntityMappingsModel(unit.getName());
                    String[] entityInfo = J2EEUtils.findEntity((MetadataModel<EntityMappingsMetadata>)mappings, tableName);
                    if (entityInfo == null) {
                        J2EEUtils.createEntity(formFile.getParent(), scope, unit, connection, tableName, null);
                        mappings = scope.getEntityMappingsModel(unit.getName());
                        entityInfo = J2EEUtils.findEntity((MetadataModel<EntityMappingsMetadata>)mappings, tableName);
                    } else {
                        J2EEUtils.addEntityToUnit(entityInfo[1], unit, project);
                    }
                    J2EEUtils.makeEntityObservable(formFile, entityInfo, (MetadataModel<EntityMappingsMetadata>)mappings);
                    final String puName = unit.getName();
                    final String[] info = entityInfo;
                    EventQueue.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                RADComponent entityManager = J2EEUtils.findEntityManager(formModel, puName);
                                if (entityManager == null) {
                                    entityManager = J2EEUtils.createEntityManager(formModel, puName);
                                }
                                RADComponent queryBean = DBTableDrop.createQueryBean(formModel, entityManager, info[0]);
                                resultList[0] = DBTableDrop.createResultListBean(formModel, queryBean, info);
                            }
                            catch (Exception ex) {
                                Logger.getLogger(this.getClass().getName()).log(Level.INFO, ex.getMessage(), ex);
                            }
                        }
                    });
                }
                catch (Exception ex) {
                    Logger.getLogger(this.getClass().getName()).log(Level.INFO, ex.getMessage(), ex);
                }
                return resultList[0];
            }
        });
        RequestProcessor.getDefault().post(task);
        return task;
    }
}

