/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hibernate.refactoring;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.swing.text.BadLocationException;
import javax.swing.text.Position;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.TokenID;
import org.netbeans.editor.TokenItem;
import org.netbeans.modules.hibernate.editor.HibernateEditorUtil;
import org.netbeans.modules.hibernate.service.api.HibernateEnvironment;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.xml.text.api.XMLDefaultTokenContext;
import org.netbeans.modules.xml.text.syntax.SyntaxElement;
import org.netbeans.modules.xml.text.syntax.XMLSyntaxSupport;
import org.netbeans.modules.xml.text.syntax.dom.EmptyTag;
import org.netbeans.modules.xml.text.syntax.dom.StartTag;
import org.openide.ErrorManager;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.PositionBounds;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class HibernateRefactoringUtil {
    private static final Logger LOGGER = Logger.getLogger(HibernateRefactoringUtil.class.getName());
    private static final String JAVA_MIME_TYPE = "text/x-java";

    public static boolean isJavaFile(FileObject fo) {
        return JAVA_MIME_TYPE.equals(fo.getMIMEType());
    }

    public static RenamedClassName getRenamedClassName(final TreePathHandle oldHandle, JavaSource javaSource, final String newName) throws IOException {
        final RenamedClassName[] result = new RenamedClassName[]{null};
        javaSource.runUserActionTask((Task)new Task<CompilationController>(){

            public void run(CompilationController cc) throws IOException {
                cc.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                Element element = oldHandle.resolveElement((CompilationInfo)cc);
                if (element == null || element.getKind() != ElementKind.CLASS) {
                    return;
                }
                String oldBinaryName = ElementUtilities.getBinaryName((TypeElement)((TypeElement)element));
                String oldSimpleName = element.getSimpleName().toString();
                String newBinaryName = null;
                if ((element = element.getEnclosingElement()).getKind() == ElementKind.CLASS) {
                    newBinaryName = ElementUtilities.getBinaryName((TypeElement)((TypeElement)element)) + '$' + newName;
                } else if (element.getKind() == ElementKind.PACKAGE) {
                    String packageName = ((PackageElement)element).getQualifiedName().toString();
                    newBinaryName = HibernateRefactoringUtil.createQualifiedName(packageName, newName);
                } else {
                    LOGGER.log(Level.WARNING, "Enclosing element of {0} was neither class nor package", oldHandle);
                }
                result[0] = new RenamedClassName(oldSimpleName, oldBinaryName, newBinaryName);
            }
        }, true);
        return result[0];
    }

    public static List<String> getTopLevelClassNames(FileObject fo) throws IOException {
        JavaSource javaSource = JavaSource.forFileObject((FileObject)fo);
        if (javaSource == null) {
            return Collections.emptyList();
        }
        final ArrayList<String> result = new ArrayList<String>(1);
        javaSource.runUserActionTask((Task)new Task<CompilationController>(){

            public void run(CompilationController cc) throws IOException {
                cc.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                for (TypeElement typeElement : cc.getTopLevelElements()) {
                    result.add(ElementUtilities.getBinaryName((TypeElement)typeElement));
                }
            }
        }, true);
        return result;
    }

    public static String getPackageName(FileObject folder) {
        ClassPath cp = ClassPath.getClassPath((FileObject)folder, (String)"classpath/source");
        if (cp != null) {
            return cp.getResourceName(folder, '.', false);
        }
        return null;
    }

    public static String getRenamedPackageName(FileObject folder, String newName) {
        FileObject parent = folder.getParent();
        if (parent == null) {
            return null;
        }
        ClassPath cp = ClassPath.getClassPath((FileObject)parent, (String)"classpath/source");
        if (cp == null) {
            return null;
        }
        String parentName = cp.getResourceName(parent, '.', false);
        if (parentName == null) {
            return null;
        }
        if (parentName.length() > 0) {
            return parentName + '.' + newName;
        }
        return newName;
    }

    public static String getPackageName(URL url) {
        File f = null;
        try {
            String path = URLDecoder.decode(url.getPath(), "UTF-8");
            f = FileUtil.normalizeFile((File)new File(path));
        }
        catch (UnsupportedEncodingException u) {
            throw new IllegalArgumentException("Cannot create package name for URL " + url);
        }
        String suffix = "";
        do {
            FileObject fo;
            if ((fo = FileUtil.toFileObject((File)f)) != null) {
                if ("".equals(suffix)) {
                    return HibernateRefactoringUtil.getPackageName(fo);
                }
                String prefix = HibernateRefactoringUtil.getPackageName(fo);
                return prefix + ("".equals(prefix) ? "" : ".") + suffix;
            }
            if (!"".equals(suffix)) {
                suffix = "." + suffix;
            }
            try {
                suffix = URLDecoder.decode(f.getPath().substring(f.getPath().lastIndexOf(File.separatorChar) + 1), "UTF-8") + suffix;
            }
            catch (UnsupportedEncodingException u) {
                throw new IllegalArgumentException("Cannot create package name for URL " + url);
            }
        } while ((f = f.getParentFile()) != null);
        throw new IllegalArgumentException("Cannot create package name for URL " + url);
    }

    public static String getSimpleElementName(String elementName) {
        int lastDot;
        while (true) {
            if (elementName.length() == 0) {
                return elementName;
            }
            lastDot = elementName.lastIndexOf(46);
            if (lastDot == -1) {
                return elementName;
            }
            if (lastDot != elementName.length() - 1) break;
            elementName = elementName.substring(0, lastDot);
        }
        return elementName.substring(lastDot + 1);
    }

    public static String createQualifiedName(String packageName, String simpleName) {
        if (packageName.length() == 0) {
            return simpleName;
        }
        if (simpleName.length() == 0) {
            return packageName;
        }
        return packageName + '.' + simpleName;
    }

    public static Map<FileObject, List<OccurrenceItem>> getJavaClassOccurrences(List<FileObject> allMappingFiles, String origBinaryName) {
        HashMap<FileObject, List<OccurrenceItem>> occurrences = new HashMap<FileObject, List<OccurrenceItem>>();
        for (FileObject mFileObj : allMappingFiles) {
            occurrences.put(mFileObj, HibernateRefactoringUtil.getOccurPlaces(mFileObj, origBinaryName, false));
        }
        return occurrences;
    }

    public static Map<FileObject, List<OccurrenceItem>> getJavaPackageOccurrences(List<FileObject> allMappingFiles, String origPkgName) {
        HashMap<FileObject, List<OccurrenceItem>> occurrences = new HashMap<FileObject, List<OccurrenceItem>>();
        for (FileObject mFileObj : allMappingFiles) {
            occurrences.put(mFileObj, HibernateRefactoringUtil.getOccurPlaces(mFileObj, origPkgName, true));
        }
        return occurrences;
    }

    public static Map<FileObject, List<OccurrenceItem>> getJavaFieldOccurrences(List<FileObject> allMappingFiles, String className, String fieldName) {
        HashMap<FileObject, List<OccurrenceItem>> occurrences = new HashMap<FileObject, List<OccurrenceItem>>();
        for (FileObject mFileObj : allMappingFiles) {
            occurrences.put(mFileObj, HibernateRefactoringUtil.getJavaFieldOccurPlaces(mFileObj, className, fieldName));
        }
        return occurrences;
    }

    private static List<OccurrenceItem> getOccurPlaces(FileObject mappingFile, String searchingForName, boolean searchingPackageName) {
        ArrayList<OccurrenceItem> foundPlaces = new ArrayList<OccurrenceItem>();
        try {
            int start;
            DataObject dataObject = DataObject.find((FileObject)mappingFile);
            EditorCookie result = (EditorCookie)dataObject.getCookie(EditorCookie.class);
            if (result == null) {
                throw new IllegalStateException("File " + mappingFile + " does not have an EditorCookie.");
            }
            CloneableEditorSupport editor = (CloneableEditorSupport)result;
            BaseDocument document = (BaseDocument)editor.openDocument();
            XMLSyntaxSupport syntaxSupport = (XMLSyntaxSupport)document.getSyntaxSupport();
            TokenItem item = syntaxSupport.getTokenChain(start = document.getStartPosition().getOffset(), Math.min(start + 1, document.getLength()));
            if (item == null) {
                return null;
            }
            while (item != null) {
                TokenID tokenId = item.getTokenID();
                if (tokenId == XMLDefaultTokenContext.TAG) {
                    SyntaxElement element = syntaxSupport.getElementChain(item.getOffset() + 1);
                    String[] attributeValues = null;
                    boolean pkgValue = false;
                    if (element instanceof StartTag || element instanceof EmptyTag) {
                        Node theNode = (Node)element;
                        String nodeName = theNode.getNodeName();
                        String itemImage = item.getImage();
                        if (searchingPackageName && nodeName.equalsIgnoreCase("hibernate-mapping") && itemImage.contains("hibernate-mapping")) {
                            attributeValues = new String[]{HibernateRefactoringUtil.getAttributeValue(theNode, "package")};
                            pkgValue = true;
                        } else if (nodeName.equalsIgnoreCase("class") && itemImage.contains("class")) {
                            attributeValues = new String[]{HibernateRefactoringUtil.getAttributeValue(theNode, "name")};
                        } else if (nodeName.equalsIgnoreCase("one-to-many") && itemImage.contains("one-to-many")) {
                            attributeValues = new String[]{HibernateRefactoringUtil.getAttributeValue(theNode, "class")};
                        } else if (nodeName.equalsIgnoreCase("composite-id") && itemImage.contains("composite-id")) {
                            attributeValues = new String[]{HibernateRefactoringUtil.getAttributeValue(theNode, "class")};
                        } else if (nodeName.equalsIgnoreCase("key-many-to-one") && itemImage.contains("key-many-to-one")) {
                            attributeValues = new String[]{HibernateRefactoringUtil.getAttributeValue(theNode, "class")};
                        } else if (nodeName.equalsIgnoreCase("many-to-one") && itemImage.contains("many-to-one")) {
                            attributeValues = new String[]{HibernateRefactoringUtil.getAttributeValue(theNode, "class")};
                        } else if (nodeName.equalsIgnoreCase("one-to-one") && itemImage.contains("one-to-one")) {
                            attributeValues = new String[]{HibernateRefactoringUtil.getAttributeValue(theNode, "class")};
                        } else if (nodeName.equalsIgnoreCase("component") && itemImage.contains("component")) {
                            attributeValues = new String[]{HibernateRefactoringUtil.getAttributeValue(theNode, "class")};
                        } else if (nodeName.equalsIgnoreCase("subclass") && itemImage.contains("subclass")) {
                            attributeValues = new String[]{HibernateRefactoringUtil.getAttributeValue(theNode, "name"), HibernateRefactoringUtil.getAttributeValue(theNode, "extends")};
                        } else if (nodeName.equalsIgnoreCase("joined-subclass") && itemImage.contains("joined-subclass")) {
                            attributeValues = new String[]{HibernateRefactoringUtil.getAttributeValue(theNode, "name"), HibernateRefactoringUtil.getAttributeValue(theNode, "extends"), HibernateRefactoringUtil.getAttributeValue(theNode, "persister")};
                        } else if (nodeName.equalsIgnoreCase("union-subclass") && itemImage.contains("union-subclass")) {
                            attributeValues = new String[]{HibernateRefactoringUtil.getAttributeValue(theNode, "name"), HibernateRefactoringUtil.getAttributeValue(theNode, "extends"), HibernateRefactoringUtil.getAttributeValue(theNode, "persister")};
                        } else if (nodeName.equalsIgnoreCase("import") && itemImage.contains("import")) {
                            attributeValues = new String[]{HibernateRefactoringUtil.getAttributeValue(theNode, "class")};
                        } else if (nodeName.equalsIgnoreCase("many-to-many") && itemImage.contains("many-to-many")) {
                            attributeValues = new String[]{HibernateRefactoringUtil.getAttributeValue(theNode, "class")};
                        }
                        if (attributeValues != null) {
                            for (int i = 0; i < attributeValues.length; ++i) {
                                String text = document.getText(item.getOffset(), element.getElementLength());
                                String value = attributeValues[i];
                                if (searchingPackageName && !pkgValue) {
                                    value = HibernateRefactoringUtil.getPackageName(value);
                                }
                                if (value == null || !value.equals(searchingForName) || text.indexOf(searchingForName) == -1) continue;
                                int startOffset = item.getOffset() + text.indexOf(searchingForName);
                                int endOffset = startOffset + searchingForName.length();
                                PositionBounds loc = new PositionBounds(editor.createPositionRef(startOffset, Position.Bias.Forward), editor.createPositionRef(endOffset, Position.Bias.Forward));
                                foundPlaces.add(new OccurrenceItem(loc, text));
                            }
                        }
                    }
                }
                item = item.getNext();
            }
        }
        catch (IOException ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
        }
        catch (BadLocationException ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
        }
        return foundPlaces;
    }

    private static List<OccurrenceItem> getJavaFieldOccurPlaces(FileObject mappingFile, String className, String fieldName) {
        ArrayList<OccurrenceItem> foundPlaces = new ArrayList<OccurrenceItem>();
        try {
            int start;
            DataObject dataObject = DataObject.find((FileObject)mappingFile);
            EditorCookie result = (EditorCookie)dataObject.getCookie(EditorCookie.class);
            if (result == null) {
                throw new IllegalStateException("File " + mappingFile + " does not have an EditorCookie.");
            }
            CloneableEditorSupport editor = (CloneableEditorSupport)result;
            BaseDocument document = (BaseDocument)editor.openDocument();
            XMLSyntaxSupport syntaxSupport = (XMLSyntaxSupport)document.getSyntaxSupport();
            TokenItem item = syntaxSupport.getTokenChain(start = document.getStartPosition().getOffset(), Math.min(start + 1, document.getLength()));
            if (item == null) {
                return null;
            }
            String text = null;
            while (item != null) {
                TokenID tokenId = item.getTokenID();
                if (tokenId == XMLDefaultTokenContext.TAG) {
                    SyntaxElement element = syntaxSupport.getElementChain(item.getOffset() + 1);
                    String nameAttribValue = null;
                    if (element instanceof StartTag || element instanceof EmptyTag) {
                        Node theNode = (Node)element;
                        String nodeName = theNode.getNodeName();
                        String itemImage = item.getImage();
                        if ((nodeName.equalsIgnoreCase("property") && itemImage.contains("property") || nodeName.equalsIgnoreCase("id") && itemImage.contains("id") || nodeName.equalsIgnoreCase("set") && itemImage.contains("set") || nodeName.equalsIgnoreCase("composite-id") && itemImage.contains("composite-id") || nodeName.equalsIgnoreCase("key-property") && itemImage.contains("key-property") || nodeName.equalsIgnoreCase("key-many-to-one") && itemImage.contains("key-many-to-one") || nodeName.equalsIgnoreCase("version") && itemImage.contains("version") || nodeName.equalsIgnoreCase("timestamp") && itemImage.contains("timestamp") || nodeName.equalsIgnoreCase("many-to-one") && itemImage.contains("many-to-one") || nodeName.equalsIgnoreCase("one-to-one") && itemImage.contains("one-to-one") || nodeName.equalsIgnoreCase("component") && itemImage.contains("component") || nodeName.equalsIgnoreCase("any") && itemImage.contains("any") || nodeName.equalsIgnoreCase("map") && itemImage.contains("map") || nodeName.equalsIgnoreCase("list") && itemImage.contains("list")) && (nameAttribValue = HibernateRefactoringUtil.getAttributeValue(theNode, "name")) != null && nameAttribValue.equals(fieldName) && HibernateEditorUtil.getClassName(theNode).equals(className)) {
                            text = document.getText(item.getOffset(), element.getElementLength());
                            int index = text.indexOf(fieldName);
                            int startOffset = item.getOffset() + index;
                            int endOffset = startOffset + fieldName.length();
                            PositionBounds loc = new PositionBounds(editor.createPositionRef(startOffset, Position.Bias.Forward), editor.createPositionRef(endOffset, Position.Bias.Forward));
                            foundPlaces.add(new OccurrenceItem(loc, text));
                        }
                    }
                }
                item = item.getNext();
            }
        }
        catch (IOException ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
        }
        catch (BadLocationException ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
        }
        return foundPlaces;
    }

    public static Map<FileObject, List<OccurrenceItem>> getMappingResourceOccurrences(List<FileObject> configFiles, String origName, boolean searchingPathOnly) {
        HashMap<FileObject, List<OccurrenceItem>> occurrences = new HashMap<FileObject, List<OccurrenceItem>>();
        for (FileObject file : configFiles) {
            occurrences.put(file, HibernateRefactoringUtil.getMappingResourceOccurPlaces(file, origName, searchingPathOnly));
        }
        return occurrences;
    }

    private static List<OccurrenceItem> getMappingResourceOccurPlaces(FileObject configFile, String resourceName, boolean searchingPathOnly) {
        ArrayList<OccurrenceItem> foundPlaces = new ArrayList<OccurrenceItem>();
        try {
            int start;
            DataObject dataObject = DataObject.find((FileObject)configFile);
            EditorCookie result = (EditorCookie)dataObject.getCookie(EditorCookie.class);
            if (result == null) {
                throw new IllegalStateException("File " + configFile + " does not have an EditorCookie.");
            }
            CloneableEditorSupport editor = (CloneableEditorSupport)result;
            BaseDocument document = (BaseDocument)editor.openDocument();
            XMLSyntaxSupport syntaxSupport = (XMLSyntaxSupport)document.getSyntaxSupport();
            TokenItem item = syntaxSupport.getTokenChain(start = document.getStartPosition().getOffset(), Math.min(start + 1, document.getLength()));
            if (item == null) {
                return null;
            }
            String text = null;
            while (item != null) {
                TokenID tokenId = item.getTokenID();
                if (tokenId == XMLDefaultTokenContext.TAG) {
                    SyntaxElement element = syntaxSupport.getElementChain(item.getOffset() + 1);
                    String mappingResourceAttribValue = null;
                    if (element instanceof StartTag || element instanceof EmptyTag) {
                        Node theNode = (Node)element;
                        String nodeName = theNode.getNodeName();
                        String itemImage = item.getImage();
                        if (nodeName.equalsIgnoreCase("mapping") && itemImage.contains("mapping") && (mappingResourceAttribValue = HibernateRefactoringUtil.getAttributeValue(theNode, "resource")) != null) {
                            if (searchingPathOnly) {
                                int lastIndex = mappingResourceAttribValue.lastIndexOf(47);
                                mappingResourceAttribValue = lastIndex > -1 ? mappingResourceAttribValue.substring(0, lastIndex) : "";
                            }
                            if (mappingResourceAttribValue.equals(resourceName)) {
                                text = document.getText(item.getOffset(), element.getElementLength());
                                int index = text.indexOf(resourceName);
                                int startOffset = item.getOffset() + index;
                                int endOffset = startOffset + resourceName.length();
                                PositionBounds loc = new PositionBounds(editor.createPositionRef(startOffset, Position.Bias.Forward), editor.createPositionRef(endOffset, Position.Bias.Forward));
                                foundPlaces.add(new OccurrenceItem(loc, text));
                            }
                        }
                    }
                }
                item = item.getNext();
            }
        }
        catch (IOException ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
        }
        catch (BadLocationException ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
        }
        return foundPlaces;
    }

    public static boolean anyHibernateMappingFiles(FileObject fo) {
        Project proj = FileOwnerQuery.getOwner((FileObject)fo);
        HibernateEnvironment env = (HibernateEnvironment)proj.getLookup().lookup(HibernateEnvironment.class);
        if (env == null) {
            return false;
        }
        List<FileObject> mFileObjs = env.getAllHibernateMappingFileObjects();
        return mFileObjs != null && mFileObjs.size() != 0;
    }

    private static String getAttributeValue(Node node, String attributeName) {
        if (node == null) {
            return null;
        }
        NamedNodeMap attribs = node.getAttributes();
        if (attribs != null && attribs.getNamedItem(attributeName) != null) {
            return attribs.getNamedItem(attributeName).getNodeValue();
        }
        return null;
    }

    public static String getPackageName(String binaryClassName) {
        if (binaryClassName == null) {
            return null;
        }
        int lastDot = binaryClassName.lastIndexOf(".");
        if (lastDot == -1) {
            return null;
        }
        return binaryClassName.substring(0, lastDot);
    }

    public static final Problem createProblem(Problem result, boolean isFatal, String message) {
        Problem problem = new Problem(isFatal, message);
        if (result == null) {
            return problem;
        }
        if (isFatal) {
            problem.setNext(result);
            return problem;
        }
        Problem p = result;
        while (p.getNext() != null) {
            p = p.getNext();
        }
        p.setNext(problem);
        return result;
    }

    public static final boolean isValidMappingFileName(String name) {
        if (name == null) {
            return false;
        }
        if (name.equals("")) {
            return false;
        }
        return name.endsWith(".hbm");
    }

    public static boolean nameNotUnique(String name, Project project) {
        HibernateEnvironment hibernateEnv = (HibernateEnvironment)project.getLookup().lookup(HibernateEnvironment.class);
        if (hibernateEnv == null) {
            return false;
        }
        List<String> mappingFiles = hibernateEnv.getAllHibernateMappings();
        return mappingFiles.contains(name);
    }

    public static final class OccurrenceItem {
        private String text;
        private PositionBounds location;

        public OccurrenceItem(PositionBounds location, String text) {
            this.location = location;
            this.text = text;
        }

        public String getText() {
            return this.text;
        }

        public PositionBounds getLocation() {
            return this.location;
        }
    }

    public static final class RenamedClassName {
        private final String oldSimpleName;
        private final String oldBinaryName;
        private final String newBinaryName;

        public RenamedClassName(String oldSimpleName, String oldBinaryName, String newBinaryName) {
            this.oldSimpleName = oldSimpleName;
            this.oldBinaryName = oldBinaryName;
            this.newBinaryName = newBinaryName;
        }

        public String getOldSimpleName() {
            return this.oldSimpleName;
        }

        public String getOldBinaryName() {
            return this.oldBinaryName;
        }

        public String getNewBinaryName() {
            return this.newBinaryName;
        }
    }
}

