/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.completion.preprocessor;

import java.util.ArrayList;
import java.util.Collection;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.completion.Completion;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.cnd.api.lexer.CndLexerUtilities;
import org.netbeans.cnd.api.lexer.CppTokenId;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.cnd.completion.cplusplus.ext.CompletionSupport;
import org.netbeans.modules.cnd.completion.preprocessor.CsmPreprocessorDirectiveCompletionItem;
import org.netbeans.spi.editor.completion.CompletionProvider;
import org.netbeans.spi.editor.completion.CompletionResultSet;
import org.netbeans.spi.editor.completion.CompletionTask;
import org.netbeans.spi.editor.completion.support.AsyncCompletionQuery;
import org.netbeans.spi.editor.completion.support.AsyncCompletionTask;

public class CsmPreprocessorDirectiveCompletionProvider
implements CompletionProvider {
    private static final boolean TRACE = Boolean.getBoolean("cnd.completion.preproc.trace");
    private static final String[] keywords = new String[]{"define", "elif", "else", "endif", "error", "ident", "if", "ifdef", "ifndef", "include", "include_next", "line", "pragma", "undef", "warning", "#if\n#endif", "#if\n#else\n#endif", "#ifdef\n#endif", "#ifdef\n#else\n#endif", "#ifndef\n#endif", "#ifndef\n#else\n#endif"};

    public int getAutoQueryTypes(JTextComponent component, String typedText) {
        CompletionSupport sup;
        if (TRACE) {
            System.err.println("typed text " + typedText);
        }
        if ((sup = CompletionSupport.get(component)) == null) {
            return 0;
        }
        int dot = component.getCaretPosition();
        if (CompletionSupport.isPreprocessorDirectiveCompletionEnabled(component.getDocument(), dot)) {
            if (TRACE) {
                System.err.println("preprocessor completion will be shown on " + dot);
            }
            return 1;
        }
        if (TRACE) {
            System.err.println("preprocessor completion will NOT be shown on " + dot);
        }
        return 0;
    }

    public CompletionTask createTask(int queryType, JTextComponent component) {
        if (TRACE) {
            System.err.println("queryType = " + queryType);
        }
        if ((queryType & 1) != 0) {
            int dot = component.getCaret().getDot();
            if (CompletionSupport.isPreprocessorDirectiveCompletionEnabled(component.getDocument(), dot)) {
                if (TRACE) {
                    System.err.println("preprocessor completion task is created with offset " + dot);
                }
                return new AsyncCompletionTask((AsyncCompletionQuery)new Query(dot), component);
            }
            if (TRACE) {
                System.err.println("preprocessor completion task is NOT created on " + dot);
            }
        }
        return null;
    }

    static Collection<CsmPreprocessorDirectiveCompletionItem> getFilteredData(BaseDocument doc, int caretOffset, int queryType) {
        Query query = new Query(caretOffset);
        Collection items = query.getItems(doc, caretOffset);
        if (TRACE) {
            System.err.println("Completion Items " + items.size());
            for (CsmPreprocessorDirectiveCompletionItem completionItem : items) {
                System.err.println(completionItem.toString());
            }
        }
        return items;
    }

    private static final class Query
    extends AsyncCompletionQuery {
        private Collection<CsmPreprocessorDirectiveCompletionItem> results;
        private int creationCaretOffset;
        private int resultSetAnchorOffset;
        private int queryAnchorOffset;
        private String filterPrefix;

        Query(int caretOffset) {
            this.creationCaretOffset = caretOffset;
            this.queryAnchorOffset = -1;
            this.resultSetAnchorOffset = this.creationCaretOffset;
        }

        protected void query(CompletionResultSet resultSet, Document doc, int caretOffset) {
            if (TRACE) {
                System.err.println("query on " + caretOffset + " anchor " + this.queryAnchorOffset);
            }
            Collection<CsmPreprocessorDirectiveCompletionItem> items = this.getItems((BaseDocument)doc, caretOffset);
            if (this.queryAnchorOffset > 0) {
                if (items != null && items.size() > 0) {
                    this.results = items;
                    items = this.getFilteredData(items, this.filterPrefix);
                    resultSet.estimateItems(items.size(), -1);
                    resultSet.addAllItems(items);
                    resultSet.setAnchorOffset(this.resultSetAnchorOffset);
                }
                resultSet.setHasAdditionalItems(false);
            }
            resultSet.finish();
        }

        protected boolean canFilter(JTextComponent component) {
            int caretOffset = component.getCaretPosition();
            if (TRACE) {
                System.err.println("canFilter on " + caretOffset + " anchor " + this.queryAnchorOffset);
            }
            this.filterPrefix = null;
            if (this.queryAnchorOffset > -1 && caretOffset >= this.queryAnchorOffset) {
                Document doc = component.getDocument();
                try {
                    this.filterPrefix = doc.getText(this.queryAnchorOffset, caretOffset - this.queryAnchorOffset);
                }
                catch (BadLocationException ex) {
                    Completion.get().hideCompletion();
                }
            } else {
                Completion.get().hideCompletion();
            }
            return this.filterPrefix != null;
        }

        protected void filter(CompletionResultSet resultSet) {
            if (this.filterPrefix != null && this.results != null) {
                resultSet.setAnchorOffset(this.resultSetAnchorOffset);
                Collection<CsmPreprocessorDirectiveCompletionItem> items = this.getFilteredData(this.results, this.filterPrefix);
                resultSet.estimateItems(items.size(), -1);
                resultSet.addAllItems(items);
            }
            resultSet.setHasAdditionalItems(false);
            resultSet.finish();
        }

        private Collection<CsmPreprocessorDirectiveCompletionItem> getItems(BaseDocument doc, int caretOffset) {
            ArrayList<CsmPreprocessorDirectiveCompletionItem> items = new ArrayList<CsmPreprocessorDirectiveCompletionItem>();
            try {
                if (this.init(doc, caretOffset)) {
                    for (String string : keywords) {
                        items.add(CsmPreprocessorDirectiveCompletionItem.createItem(this.queryAnchorOffset, caretOffset, string));
                    }
                }
            }
            catch (BadLocationException ex) {
                // empty catch block
            }
            return items;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean init(BaseDocument doc, int caretOffset) throws BadLocationException {
            this.resultSetAnchorOffset = caretOffset;
            this.filterPrefix = "";
            this.queryAnchorOffset = -1;
            if (CompletionSupport.isPreprocessorDirectiveCompletionEnabled((Document)doc, caretOffset)) {
                doc.readLock();
                try {
                    TokenSequence ppTs = CndLexerUtilities.getCppTokenSequence((Document)doc, (int)caretOffset, (boolean)true, (boolean)true);
                    if (ppTs == null || ppTs.token() == null) {
                        boolean bl = false;
                        return bl;
                    }
                    TokenId id = ppTs.token().id();
                    if (id instanceof CppTokenId) {
                        switch ((CppTokenId)id) {
                            case WHITESPACE: 
                            case PREPROCESSOR_START: {
                                this.queryAnchorOffset = caretOffset;
                                break;
                            }
                            default: {
                                this.queryAnchorOffset = ppTs.offset();
                            }
                        }
                    }
                    this.filterPrefix = doc.getText(this.queryAnchorOffset, caretOffset - this.queryAnchorOffset);
                }
                catch (BadLocationException badLocationException) {
                }
                finally {
                    doc.readUnlock();
                }
            }
            if (TRACE) {
                System.err.println(" anchorOffset=" + this.queryAnchorOffset + " filterPrefix=" + this.filterPrefix);
            }
            return this.queryAnchorOffset >= 0;
        }

        private Collection<CsmPreprocessorDirectiveCompletionItem> getFilteredData(Collection<CsmPreprocessorDirectiveCompletionItem> data, String prefix) {
            Collection<CsmPreprocessorDirectiveCompletionItem> out;
            if (prefix == null) {
                out = data;
            } else {
                ArrayList<CsmPreprocessorDirectiveCompletionItem> ret = new ArrayList<CsmPreprocessorDirectiveCompletionItem>(data.size());
                for (CsmPreprocessorDirectiveCompletionItem itm : data) {
                    if (!this.matchPrefix(itm, prefix)) continue;
                    ret.add(itm);
                }
                out = ret;
            }
            return out;
        }

        private boolean matchPrefix(CsmPreprocessorDirectiveCompletionItem itm, String prefix) {
            return itm.getItemText().startsWith(prefix);
        }
    }
}

