/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorSupport;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.Icon;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.modules.form.ComponentContainer;
import org.netbeans.modules.form.ExternalValue;
import org.netbeans.modules.form.FormDataObject;
import org.netbeans.modules.form.FormDesignValue;
import org.netbeans.modules.form.FormEditor;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.form.FormModelEvent;
import org.netbeans.modules.form.FormModelListener;
import org.netbeans.modules.form.FormProperty;
import org.netbeans.modules.form.FormPropertyContext;
import org.netbeans.modules.form.FormPropertyEditor;
import org.netbeans.modules.form.FormSettings;
import org.netbeans.modules.form.FormUtils;
import org.netbeans.modules.form.I18nService;
import org.netbeans.modules.form.I18nValue;
import org.netbeans.modules.form.RADComponent;
import org.netbeans.modules.form.RADProperty;
import org.netbeans.modules.form.RADVisualComponent;
import org.netbeans.modules.form.ResourcePanel;
import org.netbeans.modules.form.ResourceService;
import org.netbeans.modules.form.ResourceValue;
import org.netbeans.modules.form.ResourceWrapperEditor;
import org.netbeans.modules.form.editors.EnumEditor;
import org.netbeans.modules.form.editors.IconEditor;
import org.netbeans.modules.form.editors2.BorderDesignSupport;
import org.netbeans.modules.form.editors2.TableColumnModelEditor;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.util.Lookup;

public class ResourceSupport {
    private FormModel formModel;
    private ResourceService resourceService;
    private I18nService i18nService;
    private String designLocale = "";
    private static Map<DataObject, String> rememberedLocales = new WeakHashMap<DataObject, String>();
    private Map<String, Object> droppedValues;
    private static final String EXCLUDE_FROM_RESOURCING = "does not want to be a resource";
    private static final String EXCLUSION_DETERMINED = "already consulted with exclusion filters";
    private static final String[] PROPERTY_ATTRS = new String[]{"already consulted with exclusion filters", "does not want to be a resource"};
    static final String PROP_AUTO_SET_COMPONENT_NAME = "autoSetComponentName";
    static final String PROP_AUTO_RESOURCING = "autoResourcing";
    static final int AUTO_OFF = 0;
    static final int AUTO_I18N = 1;
    static final int AUTO_RESOURCING = 2;
    static final int AUTO_INJECTION = 3;
    static final String PROP_FORM_BUNDLE = "formBundle";
    private static final String PROP_DESIGN_LOCALE = "designLocale";
    private static final String DEFAULT_BUNDLE_NAME = "Bundle";
    private String defaultI18nBundle;
    private static final int PLAIN_VALUE = 1;
    private static final int UNDEFINED_RESOURCE = 2;
    private static final int VALID_RESOURCE_VALUE = 4;
    static final FormProperty.Filter COPIED_PROPERTY_FILTER = new FormProperty.Filter(){

        @Override
        public boolean accept(FormProperty property) {
            return property.isChanged() && !ResourceSupport.isAutoNamedProperty(property);
        }
    };

    ResourceSupport(FormModel formModel) {
        this.formModel = formModel;
        formModel.addFormModelListener(new ModelListener());
    }

    void init() {
        String locale = rememberedLocales.get(this.getSrcDataObject());
        if (locale != null) {
            this.designLocale = locale;
            if (!locale.equals("") && this.formModel.isFormLoaded()) {
                this.updateDesignLocale();
            }
        }
    }

    private ResourceService getResourceService() {
        if (this.resourceService == null) {
            this.resourceService = (ResourceService)Lookup.getDefault().lookup(ResourceService.class);
        }
        return this.resourceService;
    }

    private I18nService getI18nService() {
        if (this.i18nService == null) {
            this.i18nService = (I18nService)Lookup.getDefault().lookup(I18nService.class);
        }
        return this.i18nService;
    }

    private static ResourceSupport getResourceSupport(FormProperty property) {
        return FormEditor.getResourceSupport(property.getPropertyContext().getFormModel());
    }

    private static ResourceSupport getResourceSupport(RADComponent metacomp) {
        return FormEditor.getResourceSupport(metacomp.getFormModel());
    }

    void prepareNewForm() {
        if (this.isResourceAutoMode()) {
            this.resourceService.prepareNew(this.getSourceFile());
        } else if (!this.isI18nAutoMode()) {
            return;
        }
        this.switchFormToResources();
        if (this.isAutoName()) {
            this.setupNameProperty(true);
        }
    }

    public static Object makeResource(Object value, FormProperty property) {
        if (!ResourceSupport.isResourceableProperty(property)) {
            return value;
        }
        ResourceSupport support = ResourceSupport.getResourceSupport(property);
        if (ResourceSupport.isResourceType(property.getValueType())) {
            value = support.makeResource0(value, property);
        } else {
            for (FormProperty prop : support.getNestedResourceProperties(FormProperty.getEnclosedValue(value), property, 1)) {
                boolean fire = prop.isChangeFiring();
                prop.setChangeFiring(false);
                try {
                    Object val = prop.getValue();
                    Object resValue = support.makeResource0(val, prop);
                    if (resValue != val) {
                        prop.setValue(resValue);
                        if (resValue instanceof ResourceValue) {
                            support.formModel.raiseVersionLevel(FormModel.FormVersion.NB60, FormModel.FormVersion.NB60);
                        }
                    }
                }
                catch (Exception ex) {
                    ErrorManager.getDefault().notify(1, (Throwable)ex);
                }
                prop.setChangeFiring(fire);
            }
        }
        return value;
    }

    private Object makeResource0(Object newValue, FormProperty property) {
        Object prevValue;
        Object value = FormProperty.getEnclosedValue(newValue);
        if (value instanceof ExternalValue) {
            ExternalValue eValue = (ExternalValue)value;
            if (eValue.getKey() == "#auto") {
                if (value instanceof I18nValue && this.getI18nService() != null) {
                    String key = this.getDefaultKey0(property, 1);
                    eValue = this.i18nService.changeKey((I18nValue)value, key);
                } else if (value instanceof ResourceValue && this.getResourceService() != null) {
                    String key = this.getDefaultKey0(property, 2);
                    eValue = this.resourceService.changeKey((ResourceValue)value, key);
                }
                return eValue;
            }
            return newValue;
        }
        if (value == null || !ResourceSupport.isConvertibleToResource(value) || this.isExcludedProperty0(property)) {
            return newValue;
        }
        try {
            prevValue = property.getValue();
        }
        catch (Exception ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
            return newValue;
        }
        if (prevValue instanceof I18nValue) {
            if (!this.isEditorSwitchingValue(newValue) && this.getI18nService() != null) {
                newValue = this.i18nService.changeValue((I18nValue)prevValue, value.toString());
            }
        } else if (prevValue instanceof ResourceValue) {
            if (this.getResourceService() != null) {
                newValue = this.resourceService.changeValue((ResourceValue)prevValue, value, ResourceSupport.getStringValue(property, value));
            }
        } else if (this.isI18nAutoMode()) {
            if (value instanceof String) {
                I18nValue i18nValue = this.searchDroppedI18nValue(property, value.toString());
                if (i18nValue == null) {
                    i18nValue = this.i18nService.create(this.getDefaultKey0(property, 1), value.toString(), this.getSrcDataObject());
                }
                newValue = new FormProperty.ValueWithEditor(i18nValue, this.i18nService.getPropertyEditor(property.getValueType(), property.getCurrentEditor()));
            }
        } else if (this.isResourceAutoMode()) {
            PropertyEditor propEd;
            PropertyEditor newPrEd = newValue instanceof FormProperty.ValueWithEditor ? ((FormProperty.ValueWithEditor)newValue).getPropertyEditor() : null;
            ResourceValue resValue = this.searchDroppedResourceValue(property, value);
            if (resValue == null) {
                resValue = this.resourceService.create(this.getDefaultKey0(property, 2), property.getValueType(), value, ResourceSupport.getStringValue(property, value), this.getSourceFile());
            }
            if (newPrEd == null && !(property.getCurrentEditor() instanceof ResourceWrapperEditor) && (propEd = property.getPropertyEditor()) instanceof FormPropertyEditor) {
                FormPropertyEditor formPropEd = (FormPropertyEditor)propEd;
                for (PropertyEditor newPropEd : formPropEd.getAllEditors()) {
                    if (!(newPropEd instanceof ResourceWrapperEditor)) continue;
                    return new FormProperty.ValueWithEditor(resValue, newPropEd);
                }
            }
            newValue = newPrEd != null ? new FormProperty.ValueWithEditor(resValue, newPrEd) : resValue;
        }
        return newValue;
    }

    private I18nValue searchDroppedI18nValue(FormProperty property, String expectedValue) {
        I18nValue i18nValue;
        String dropKey;
        Object value;
        if (this.droppedValues != null && (value = this.droppedValues.get(dropKey = this.getPropertyPath(property, null))) instanceof I18nValue && (i18nValue = (I18nValue)value).getValue().equals(expectedValue)) {
            return i18nValue;
        }
        return null;
    }

    private ResourceValue searchDroppedResourceValue(FormProperty property, Object expectedValue) {
        ResourceValue resValue;
        String dropKey;
        Object value;
        if (this.droppedValues != null && (value = this.droppedValues.get(dropKey = this.getPropertyPath(property, null))) instanceof ResourceValue && (resValue = (ResourceValue)value).getValue().equals(expectedValue)) {
            return resValue;
        }
        return null;
    }

    public static void switchComponentToResources(RADComponent metacomp) {
        ResourceSupport support = ResourceSupport.getResourceSupport(metacomp);
        if (support.isAutoMode()) {
            support.switchComponentToResources(metacomp, false, true);
        }
    }

    private void switchComponentToResources(RADComponent metacomp, boolean update, boolean recursive) {
        int valueType = 3;
        for (FormProperty prop : this.getComponentResourceProperties(metacomp, valueType, recursive)) {
            boolean fire = prop.isChangeFiring();
            prop.setChangeFiring(false);
            try {
                Object resValue = this.makeResource0(prop.getValue(), prop);
                prop.setValue(resValue);
                this.formModel.raiseVersionLevel(FormModel.FormVersion.NB60_PRE, FormModel.FormVersion.NB60);
                if (update) {
                    resValue = prop.getValue();
                    if (resValue instanceof I18nValue) {
                        this.getI18nService().update(null, (I18nValue)resValue, this.getSrcDataObject(), this.getI18nBundleName(), this.designLocale, true);
                    } else if (resValue instanceof ResourceValue) {
                        this.getResourceService().update(null, (ResourceValue)resValue, this.getSourceFile(), this.designLocale);
                        this.formModel.raiseVersionLevel(FormModel.FormVersion.NB60, FormModel.FormVersion.NB60);
                    }
                }
            }
            catch (Exception ex) {
                ErrorManager.getDefault().notify(1, (Throwable)ex);
            }
            prop.setChangeFiring(fire);
        }
    }

    private static void setupNameProperty(RADComponent metacomp, boolean set, boolean recursive) {
        FormProperty nameProp = ResourceSupport.getNameProperty(metacomp);
        if (nameProp != null) {
            try {
                if (set && !nameProp.isChanged()) {
                    nameProp.setValue(metacomp.getName());
                } else if (!set && nameProp.isChanged() && metacomp.getName().equals(nameProp.getValue())) {
                    nameProp.restoreDefaultValue();
                }
            }
            catch (Exception ex) {
                ErrorManager.getDefault().notify(1, (Throwable)ex);
            }
        }
        if (recursive && metacomp instanceof ComponentContainer) {
            for (RADComponent subcomp : ((ComponentContainer)((Object)metacomp)).getSubBeans()) {
                ResourceSupport.setupNameProperty(subcomp, set, recursive);
            }
        }
    }

    private void setupNameProperty(boolean set) {
        for (RADComponent metacomp : this.formModel.getAllComponents()) {
            ResourceSupport.setupNameProperty(metacomp, set, false);
        }
    }

    private static FormProperty getNameProperty(RADComponent metacomp) {
        if (metacomp.getBeanInstance() instanceof Component) {
            return (FormProperty)metacomp.getPropertyByName("name");
        }
        return null;
    }

    private void switchFormToResources() {
        for (RADComponent metacomp : this.formModel.getAllComponents()) {
            this.switchComponentToResources(metacomp, true, false);
        }
        if (this.droppedValues != null) {
            this.droppedValues.clear();
        }
    }

    private void switchFormToPlainValues(String originalBundleName) {
        for (RADComponent metacomp : this.formModel.getAllComponents()) {
            for (FormProperty prop : this.getComponentResourceProperties(metacomp, 4, false)) {
                ExternalValue value = this.getAutoValue(prop);
                if (value == null) continue;
                boolean fire = prop.isChangeFiring();
                prop.setChangeFiring(false);
                try {
                    if (value instanceof I18nValue) {
                        I18nValue i18nValue = (I18nValue)value;
                        prop.setValue(new FormProperty.ValueWithEditor(i18nValue.getValue(), prop.findDefaultEditor()));
                        this.i18nService.update(i18nValue, null, this.getSrcDataObject(), originalBundleName != null ? originalBundleName : this.getI18nBundleName(), null, true);
                    } else if (value instanceof ResourceValue) {
                        Object plainValue;
                        ResourceValue resValue = (ResourceValue)value;
                        PropertyEditor prEd = prop.getCurrentEditor();
                        if (prEd instanceof ResourceWrapperEditor) {
                            prEd.setValue(value);
                            plainValue = ((ResourceWrapperEditor)((Object)prEd)).getUnwrappedValue();
                        } else {
                            plainValue = resValue.getValue();
                        }
                        prop.setValue(plainValue);
                        this.resourceService.update(resValue, null, this.getSourceFile(), this.designLocale);
                    }
                    this.addDroppedValue(prop, value);
                }
                catch (Exception ex) {
                    ErrorManager.getDefault().notify(1, (Throwable)ex);
                }
                prop.setChangeFiring(fire);
            }
        }
    }

    private void addDroppedValue(FormProperty property, Object value) {
        if (this.droppedValues == null) {
            this.droppedValues = new HashMap<String, Object>();
        }
        this.droppedValues.put(this.getPropertyPath(property, null), value);
    }

    public static void componentRenamed(RADComponent metacomp, String oldName, String newName) {
        FormProperty nameProp;
        ResourceSupport support = ResourceSupport.getResourceSupport(metacomp);
        if (support.isAutoMode()) {
            support.renameDefaultKeysForComponent(metacomp, null, null, oldName, newName, false);
        }
        if ((nameProp = ResourceSupport.getNameProperty(metacomp)) != null && nameProp.isChanged()) {
            try {
                Object name = nameProp.getValue();
                if (oldName.equals(name) && !name.equals(newName)) {
                    nameProp.setValue(newName);
                }
            }
            catch (Exception ex) {
                ErrorManager.getDefault().notify(1, (Throwable)ex);
            }
        }
    }

    private void renameDefaultKeys(String oldFormName, boolean copy) {
        for (RADComponent metacomp : this.formModel.getAllComponents()) {
            this.renameDefaultKeysForComponent(metacomp, oldFormName, this.getSrcDataObject().getName(), null, null, copy);
        }
    }

    private void renameDefaultKeysForComponent(RADComponent metacomp, String oldFormName, String newFormName, String oldCompName, String newCompName, boolean copy) {
        if (oldFormName == null) {
            newFormName = oldFormName = this.getSrcDataObject().getName();
        } else assert (newFormName != null);
        if (oldCompName == null) {
            newCompName = oldCompName = this.getComponentName(metacomp);
        } else assert (newCompName != null);
        for (FormProperty prop : this.getComponentResourceProperties(metacomp, 4, false)) {
            String oldDefaultKey;
            int type = -1;
            I18nValue i18nValue = null;
            ResourceValue resValue = null;
            String oldKey = null;
            try {
                ExternalValue eValue = (ExternalValue)prop.getValue();
                oldKey = eValue.getKey();
                if (eValue instanceof I18nValue) {
                    i18nValue = (I18nValue)eValue;
                    type = 1;
                } else if (eValue instanceof ResourceValue) {
                    resValue = (ResourceValue)eValue;
                    type = 2;
                }
            }
            catch (Exception ex) {
                ErrorManager.getDefault().notify(1, (Throwable)ex);
            }
            if (!ResourceSupport.isAutoKey(oldKey, oldDefaultKey = this.getDefaultKey(oldFormName, this.getPropertyPath(prop, oldCompName), type))) continue;
            String suffix = oldKey.length() > oldDefaultKey.length() ? oldKey.substring(oldDefaultKey.length()) : "";
            String newKey = this.getDefaultKey(newFormName, this.getPropertyPath(prop, newCompName), type) + suffix;
            if (newKey.equals(oldKey)) continue;
            boolean fire = prop.isChangeFiring();
            prop.setChangeFiring(false);
            try {
                if (i18nValue != null) {
                    if (copy) {
                        i18nValue = this.i18nService.copy(i18nValue);
                    }
                    I18nValue newI18nValue = this.i18nService.changeKey(i18nValue, newKey);
                    if (copy) {
                        i18nValue = null;
                    }
                    prop.setValue(newI18nValue);
                    this.i18nService.update(i18nValue, newI18nValue, this.getSrcDataObject(), this.getI18nBundleName(), this.designLocale, true);
                } else if (resValue != null) {
                    ResourceValue newResValue = this.resourceService.changeKey(resValue, newKey);
                    prop.setValue(newResValue);
                    this.resourceService.update(copy ? null : resValue, newResValue, this.getSourceFile(), this.designLocale);
                }
            }
            catch (Exception ex) {
                ErrorManager.getDefault().notify(1, (Throwable)ex);
            }
            prop.setChangeFiring(fire);
        }
    }

    public static void formMoved(FormModel formModel, FileObject oldFolder, String oldFormName, boolean copy) {
        ResourceSupport support = FormEditor.getResourceSupport(formModel);
        if (support.getAutoMode() == 1) {
            if (oldFolder == null) {
                support.renameDefaultKeys(oldFormName, copy);
            } else {
                support.moveFormI18n(oldFormName, oldFolder, copy);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void moveFormI18n(String oldFormName, FileObject oldFolder, boolean copy) {
        assert (this.getAutoMode() == 1);
        String oldPkg = ResourceSupport.getPkgResourceName(oldFolder);
        String newPkg = ResourceSupport.getPkgResourceName(this.getSourceFile());
        String newBundle = this.getI18nBundleName();
        String oldBundle = oldPkg + newBundle.substring(newPkg.length());
        if (oldFormName == null) {
            oldFormName = this.getSrcDataObject().getName();
        }
        for (RADComponent metacomp : this.formModel.getAllComponents()) {
            for (FormProperty prop : this.getComponentResourceProperties(metacomp, 4, false)) {
                try {
                    Object value = prop.getValue();
                    if (!(value instanceof I18nValue)) continue;
                    I18nValue i18nValue = (I18nValue)value;
                    String oldKey = this.getDefaultKey(oldFormName, this.getPropertyPath(prop, metacomp.getName()), 1);
                    if (!ResourceSupport.isAutoKey(i18nValue.getKey(), oldKey)) continue;
                    boolean fire = prop.isChangeFiring();
                    prop.setChangeFiring(false);
                    try {
                        if (copy) {
                            i18nValue = this.i18nService.copy(i18nValue);
                        } else {
                            this.i18nService.update(i18nValue, null, this.getSrcDataObject(), oldBundle, null, true);
                        }
                        String newKey = ResourceSupport.getDefaultKey(prop, 1);
                        if (!newKey.equals(oldKey)) {
                            i18nValue = this.i18nService.changeKey(i18nValue, newKey);
                        }
                        this.i18nService.update(null, i18nValue, this.getSrcDataObject(), this.getI18nBundleName(), null, true);
                        prop.setValue(i18nValue);
                    }
                    finally {
                        prop.setChangeFiring(fire);
                    }
                }
                catch (Exception ex) {
                    ErrorManager.getDefault().notify(1, (Throwable)ex);
                }
            }
        }
    }

    public static void loadInjectedResources(RADComponent metacomp) {
        ResourceSupport support = ResourceSupport.getResourceSupport(metacomp);
        if (support != null && support.getAutoMode() == 3) {
            support.loadInjectedResources0(metacomp);
        }
    }

    private void loadInjectedResources0(RADComponent metacomp) {
        if (this.getResourceService() == null) {
            return;
        }
        String compName = this.getComponentName(metacomp);
        String keyEx = compName + "\\.\\w+";
        Collection<String> compResources = this.resourceService.findKeys(keyEx, this.getSourceFile());
        if (compResources.size() > 0) {
            String[] propNames = new String[compResources.size()];
            int compPrefixLength = compName.length() + 1;
            int i = 0;
            for (String key : compResources) {
                propNames[i++] = key.substring(compPrefixLength);
            }
            RADProperty[] properties = metacomp.getBeanProperties(propNames);
            i = 0;
            for (String key : compResources) {
                RADProperty prop;
                if ((prop = properties[i++]) == null || !ResourceSupport.isResourceType(prop.getValueType())) continue;
                try {
                    prop.setValue(this.resourceService.get(key, prop.getValueType(), this.designLocale, this.getSourceFile()));
                }
                catch (Exception ex) {
                    ErrorManager.getDefault().notify(1, (Throwable)ex);
                }
            }
        }
    }

    public static void updateStoredValue(Object oldValue, Object newValue, FormProperty property) {
        ResourceSupport support;
        if (ResourceSupport.isResourceableProperty(property) && (support = ResourceSupport.getResourceSupport(property)) != null) {
            support.updateStoredValue0(oldValue, newValue, property);
        }
    }

    private void updateStoredValue0(Object oldValue, Object newValue, FormProperty property) {
        if (property.getName().equals("name") && property instanceof RADProperty && property.getValueType() == String.class) {
            String newName;
            RADComponent metacomp = ((RADProperty)property).getRADComponent();
            String oldName = oldValue instanceof String ? (String)oldValue : metacomp.getName();
            String string = newName = property.isChanged() && newValue instanceof String ? (String)newValue : metacomp.getName();
            if (!newName.equals(oldName)) {
                ResourceSupport.componentRenamed(metacomp, oldName, newName);
            }
            if (!(oldValue instanceof ExternalValue) && !(newValue instanceof ExternalValue)) {
                return;
            }
        }
        if (ResourceSupport.isResourceType(property.getValueType())) {
            this.updateStoredValue1(oldValue, newValue, property);
        } else {
            Collection<FormProperty> colOld = this.getNestedResourceProperties(oldValue, property, 4);
            Collection<FormProperty> colNew = this.getNestedResourceProperties(newValue, property, 4);
            for (FormProperty oProp : colOld) {
                boolean foundInNew = false;
                Iterator<FormProperty> it = colNew.iterator();
                while (it.hasNext()) {
                    FormProperty nProp = it.next();
                    if (!this.getPropertyPath(oProp, null).equals(this.getPropertyPath(nProp, null))) continue;
                    try {
                        this.updateStoredValue1(oProp.getValue(), nProp.getValue(), nProp);
                    }
                    catch (Exception ex) {
                        ErrorManager.getDefault().notify(1, (Throwable)ex);
                    }
                    it.remove();
                    foundInNew = true;
                    break;
                }
                if (foundInNew) continue;
                try {
                    this.updateStoredValue1(oProp.getValue(), null, oProp);
                }
                catch (Exception ex) {
                    ErrorManager.getDefault().notify(1, (Throwable)ex);
                }
            }
            for (FormProperty nProp : colNew) {
                try {
                    this.updateStoredValue1(null, nProp.getValue(), nProp);
                }
                catch (Exception ex) {
                    ErrorManager.getDefault().notify(1, (Throwable)ex);
                }
            }
        }
    }

    private void updateStoredValue1(Object oldValue, Object newValue, FormProperty property) {
        if (oldValue instanceof I18nValue) {
            this.updateI18nValue(oldValue, newValue, property);
            if (newValue instanceof ResourceValue) {
                this.updateResourceValue(oldValue, newValue, property);
            }
        } else if (oldValue instanceof ResourceValue) {
            this.updateResourceValue(oldValue, newValue, property);
            if (newValue instanceof I18nValue) {
                this.updateI18nValue(oldValue, newValue, property);
            }
        } else if (newValue instanceof I18nValue) {
            this.updateI18nValue(oldValue, newValue, property);
        } else if (newValue instanceof ResourceValue) {
            this.updateResourceValue(oldValue, newValue, property);
        }
    }

    private void updateI18nValue(Object oldValue, Object newValue, FormProperty property) {
        if (this.getI18nService() != null) {
            I18nValue oldVal = oldValue instanceof I18nValue ? (I18nValue)oldValue : null;
            I18nValue newVal = newValue instanceof I18nValue ? (I18nValue)newValue : null;
            try {
                this.i18nService.update(oldVal, newVal, this.getSrcDataObject(), this.getI18nBundleName(), this.designLocale, ResourceSupport.isAutoValue(oldVal, this.getDefaultKey0(property, 1)));
            }
            catch (IOException ex) {
                ErrorManager.getDefault().notify(1, (Throwable)ex);
            }
        }
    }

    private void updateResourceValue(Object oldValue, Object newValue, FormProperty property) {
        if (this.getResourceService() != null) {
            ResourceValue oldVal = oldValue instanceof ResourceValue ? (ResourceValue)oldValue : null;
            ResourceValue newVal = newValue instanceof ResourceValue ? (ResourceValue)newValue : null;
            try {
                this.resourceService.update(oldVal, newVal, this.getSourceFile(), this.designLocale);
            }
            catch (IOException ex) {
                ErrorManager.getDefault().notify(1, (Throwable)ex);
            }
        }
    }

    public static ResourceValue findResource(String key, FormProperty property) {
        return ResourceSupport.findResource(property.getPropertyContext().getFormModel(), key, property.getValueType());
    }

    public static ResourceValue findResource(FormModel formModel, String key, Class valueType) {
        return FormEditor.getResourceSupport(formModel).findResource0(key, valueType);
    }

    private ResourceValue findResource0(String key, Class valueType) {
        return this.getResourceService() != null ? this.resourceService.get(key, valueType, this.designLocale, this.getSourceFile()) : null;
    }

    public static boolean isResourceableProperty(FormProperty prop) {
        return prop.getPropertyContext().useMultipleEditors();
    }

    public static boolean isPropertyForResourcing(FormProperty prop) {
        if (!ResourceSupport.isResourceableProperty(prop)) {
            return false;
        }
        ResourceSupport support = ResourceSupport.getResourceSupport(prop);
        return !support.isExcludedProperty0(prop) && support.isResourceAutoMode();
    }

    public static boolean isExcludedProperty(FormProperty prop) {
        assert (ResourceSupport.isResourceableProperty(prop));
        return Boolean.TRUE.equals(prop.getValue(EXCLUDE_FROM_RESOURCING)) ? true : ResourceSupport.getResourceSupport(prop).isExcludedProperty1(prop);
    }

    private boolean isExcludedProperty0(FormProperty prop) {
        return Boolean.TRUE.equals(prop.getValue(EXCLUDE_FROM_RESOURCING)) ? true : this.isExcludedProperty1(prop);
    }

    private boolean isExcludedProperty1(FormProperty prop) {
        if (!Boolean.TRUE.equals(prop.getValue(EXCLUSION_DETERMINED))) {
            if (this.getResourceService() == null) {
                return false;
            }
            prop.setValue(EXCLUSION_DETERMINED, true);
            Object propOwner = prop.getPropertyContext().getOwner();
            Class type = null;
            if (propOwner instanceof RADComponent) {
                type = ((RADComponent)propOwner).getBeanClass();
            } else if (propOwner instanceof FormProperty) {
                type = ((FormProperty)((Object)propOwner)).getValueType();
            }
            boolean excl = type != null ? this.resourceService.isExcludedProperty(type, prop.getName()) : false;
            prop.setValue(EXCLUDE_FROM_RESOURCING, excl);
            return excl;
        }
        return false;
    }

    public static void setExcludedProperty(FormProperty prop, boolean excl) {
        if (ResourceSupport.isResourceableProperty(prop) && excl != ResourceSupport.isExcludedProperty(prop)) {
            prop.setValue(EXCLUDE_FROM_RESOURCING, excl);
        }
    }

    static String[] getPropertyAttrNames() {
        return PROPERTY_ATTRS;
    }

    public static String getInjectionCode(RADComponent metacomp, String compGenName) {
        return ResourceSupport.getResourceSupport(metacomp).getInjectionCode0(metacomp, compGenName);
    }

    private String getInjectionCode0(RADComponent metacomp, String compGenName) {
        return this.getAutoMode() == 3 && this.getResourceService() != null ? this.resourceService.getInjectionCode(metacomp.getBeanInstance(), compGenName, this.getSourceFile()) : null;
    }

    public static boolean isInjectedProperty(FormProperty prop) {
        ResourceSupport support;
        if (ResourceSupport.isResourceableProperty(prop) && (support = ResourceSupport.getResourceSupport(prop)).getAutoMode() == 3) {
            try {
                String key;
                Object value = prop.getValue();
                if (value instanceof ResourceValue && (key = ((ResourceValue)value).getKey()) != null && support.getDefaultKey0(prop, 3).equals(key)) {
                    return true;
                }
            }
            catch (Exception ex) {
                ErrorManager.getDefault().notify(1, (Throwable)ex);
            }
        }
        return false;
    }

    public boolean isDefaultInternationalizableProject() {
        if (this.getI18nService() != null) {
            return this.i18nService.isDefaultInternationalizableProject(this.getSourceFile());
        }
        return false;
    }

    public boolean projectUsesResources() {
        if (this.getResourceService() != null) {
            return this.resourceService.projectUsesResources(this.getSourceFile());
        }
        return false;
    }

    public boolean projectWantsUseResources() {
        if (this.getResourceService() != null) {
            return this.resourceService.projectWantsUseResources(this.getSourceFile());
        }
        return false;
    }

    private void bundleChanged(String oldBundle) {
        this.switchFormToPlainValues(oldBundle);
        String oldLocale = this.designLocale;
        this.setDesignLocale("");
        FormEditor.getFormEditor(this.formModel).getFormRootNode().firePropertyChangeHelper(PROP_DESIGN_LOCALE, oldLocale, this.designLocale);
        this.switchFormToResources();
    }

    String getDesignLocale() {
        return this.designLocale;
    }

    private void changeDesignLocale(String designLocale) {
        this.setDesignLocale(designLocale);
        this.updateDesignLocale();
        this.formModel.fireEvents(null);
    }

    private void setDesignLocale(String locale) {
        this.designLocale = locale;
        rememberedLocales.put(this.getSrcDataObject(), locale);
    }

    void updateDesignLocale() {
        Collection<FormProperty> props = this.getAllResourceProperties(4);
        ArrayList<Object> values = new ArrayList<Object>(props.size());
        for (FormProperty prop : props) {
            try {
                values.add(prop.getValue());
            }
            catch (Exception ex) {
                ErrorManager.getDefault().notify(1, (Throwable)ex);
            }
        }
        Iterator it = values.iterator();
        for (FormProperty prop : props) {
            Object value = it.next();
            boolean fire = prop.isChangeFiring();
            prop.setChangeFiring(false);
            try {
                if (value instanceof I18nValue) {
                    prop.setValue(this.getI18nService().switchLocale((I18nValue)value, this.designLocale));
                } else if (value instanceof ResourceValue) {
                    prop.setValue(this.getResourceService().switchLocale((ResourceValue)value, this.designLocale));
                }
            }
            catch (Exception ex) {
                ErrorManager.getDefault().notify(1, (Throwable)ex);
            }
            prop.setChangeFiring(fire);
        }
    }

    public static ResourcePanel createResourcePanel(FormProperty property, boolean force) {
        if (!ResourceSupport.isResourceableProperty(property)) {
            return null;
        }
        ResourceSupport support = ResourceSupport.getResourceSupport(property);
        if (support == null) {
            return null;
        }
        return support.createResourcePanel0(property, force);
    }

    private ResourcePanel createResourcePanel0(FormProperty prop, boolean force) {
        if (this.getResourceService() != null && (force || !this.isI18nAutoMode() && (this.isResourceAutoMode() || this.projectUsesResources()) && !this.isAutoNamedProperty0(prop))) {
            return this.resourceService.createResourcePanel(prop.getValueType(), this.getSourceFile());
        }
        return null;
    }

    private static boolean isAutoNamedProperty(FormProperty prop) {
        return "name".equals(prop.getName()) && prop instanceof RADProperty && ResourceSupport.getNameProperty(((RADProperty)prop).getRADComponent()) == prop && ResourceSupport.getResourceSupport(prop).isAutoName();
    }

    private boolean isAutoNamedProperty0(FormProperty prop) {
        return this.isAutoName() && "name".equals(prop.getName()) && prop instanceof RADProperty && ResourceSupport.getNameProperty(((RADProperty)prop).getRADComponent()) == prop;
    }

    public static List<URL> getFilesForContentChangeBackup(FormModel formModel) {
        return FormEditor.getResourceSupport(formModel).getFilesForContentChangeBackup();
    }

    private List<URL> getFilesForContentChangeBackup() {
        if (this.isI18nAutoMode()) {
            return this.getI18nService().getResourceFiles(this.getSourceFile(), this.getI18nBundleName());
        }
        if (this.isResourceAutoMode()) {
            return this.getResourceService().getResourceFiles(this.getSourceFile());
        }
        return Collections.emptyList();
    }

    public static List<URL> getFilesForFormRenameBackup(FormModel formModel) {
        return FormEditor.getResourceSupport(formModel).getI18nFilesForFormRenameBackup();
    }

    private List<URL> getI18nFilesForFormRenameBackup() {
        if (this.isI18nAutoMode()) {
            return this.getI18nService().getResourceFiles(this.getSourceFile(), this.getI18nBundleName());
        }
        return Collections.emptyList();
    }

    public static List<URL> getFilesForFormMoveBackup(FormModel formModel, FileObject oldFolder) {
        return FormEditor.getResourceSupport(formModel).getFilesForFormMoveBackup(oldFolder);
    }

    private List<URL> getFilesForFormMoveBackup(FileObject oldFolder) {
        if (this.isI18nAutoMode()) {
            String oldPkg = ResourceSupport.getPkgResourceName(oldFolder);
            String newPkg = ResourceSupport.getPkgResourceName(this.getSourceFile());
            String newBundle = this.getI18nBundleName();
            String oldBundle = oldPkg + newBundle.substring(newPkg.length());
            List<URL> oldFiles = this.getI18nService().getResourceFiles(this.getSourceFile(), oldBundle);
            List<URL> newFiles = this.getI18nService().getResourceFiles(this.getSourceFile(), newBundle);
            ArrayList<URL> all = new ArrayList<URL>(oldFiles.size() + newFiles.size());
            all.addAll(oldFiles);
            all.addAll(newFiles);
            return all;
        }
        return Collections.emptyList();
    }

    private Collection<FormProperty> getAllResourceProperties(int valueType) {
        Collection<RADComponent> components = this.formModel.getAllComponents();
        ArrayList<FormProperty> propList = new ArrayList<FormProperty>(components.size());
        for (RADComponent metacomp : components) {
            this.collectResourceProperties(metacomp, valueType, false, propList);
        }
        return propList;
    }

    private Collection<FormProperty> getComponentResourceProperties(RADComponent metacomp, int valueType, boolean recursive) {
        Collection<FormProperty> col = this.collectResourceProperties(metacomp, valueType, recursive, null);
        if (col == null) {
            col = Collections.emptyList();
        }
        return col;
    }

    private Collection<FormProperty> getNestedResourceProperties(Object value, FormProperty prop, int valueType) {
        Collection<FormProperty> col = this.collectNestedResourceProperties(value, prop, valueType, null);
        if (col == null) {
            col = Collections.emptyList();
        }
        return col;
    }

    /*
     * WARNING - void declaration
     */
    private Collection<FormProperty> collectResourceProperties(RADComponent metacomp, int valueType, boolean recursive, Collection<FormProperty> col) {
        Node.Property[] propertyArray;
        for (RADProperty rADProperty : metacomp.getKnownBeanProperties()) {
            if (!rADProperty.isChanged() || !ResourceSupport.isResourceableProperty(rADProperty) || this.isExcludedProperty0(rADProperty)) continue;
            col = this.collectNestedResourceProperties(rADProperty, valueType, col);
        }
        if (metacomp instanceof RADVisualComponent && (propertyArray = ((RADVisualComponent)metacomp).getConstraintsProperties()) != null) {
            void var8_14;
            Node.Property[] arr$ = propertyArray;
            int len$ = arr$.length;
            boolean bl = false;
            while (var8_14 < len$) {
                FormProperty prop;
                Node.Property p = arr$[var8_14];
                if (p instanceof FormProperty && (prop = (FormProperty)p).isChanged() && ResourceSupport.isResourceableProperty(prop) && !this.isExcludedProperty0(prop)) {
                    col = this.collectNestedResourceProperties(prop, valueType, col);
                }
                ++var8_14;
            }
        }
        if (recursive && metacomp instanceof ComponentContainer) {
            for (RADComponent rADComponent : ((ComponentContainer)((Object)metacomp)).getSubBeans()) {
                col = this.collectResourceProperties(rADComponent, valueType, recursive, col);
            }
        }
        return col;
    }

    private Collection<FormProperty> collectNestedResourceProperties(Object value, FormProperty property, int valueType, Collection<FormProperty> col) {
        Node.Property[] nestedProps = ResourceSupport.getNestedProperties(value);
        if (nestedProps == null) {
            if ((valueType != 1 || ResourceSupport.isResourceType(property.getValueType())) && ResourceSupport.isWanted(valueType, value)) {
                if (col == null) {
                    col = new LinkedList<FormProperty>();
                }
                col.add(property);
            }
            return col;
        }
        for (Node.Property p : nestedProps) {
            FormProperty prop;
            if (!(p instanceof FormProperty) || !(prop = (FormProperty)p).isChanged() || !ResourceSupport.isResourceableProperty(prop) || this.isExcludedProperty0(prop)) continue;
            col = this.collectNestedResourceProperties(prop, valueType, col);
        }
        return col;
    }

    private Collection<FormProperty> collectNestedResourceProperties(FormProperty property, int valueType, Collection<FormProperty> col) {
        try {
            return this.collectNestedResourceProperties(property.getValue(), property, valueType, col);
        }
        catch (Exception ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
            return col;
        }
    }

    private static Node.Property[] getNestedProperties(Object value) {
        if (value instanceof BorderDesignSupport) {
            return ((BorderDesignSupport)value).getProperties();
        }
        if (value instanceof TableColumnModelEditor.FormTableColumnModel) {
            TableColumnModelEditor.FormTableColumnModel columnModel = (TableColumnModelEditor.FormTableColumnModel)value;
            ArrayList<FormProperty> props = new ArrayList<FormProperty>(columnModel.getColumns().size());
            for (TableColumnModelEditor.FormTableColumn column : columnModel.getColumns()) {
                props.add(column.getTitle());
            }
            return props.toArray(new Node.Property[props.size()]);
        }
        return null;
    }

    private static boolean isWanted(int valueType, Object value) {
        String key;
        if (value instanceof ExternalValue) {
            key = ((ExternalValue)value).getKey();
            if (key == null) {
                key = "";
            }
        } else {
            key = null;
        }
        if (key == null) {
            return (valueType & 1) != 0 && !(value instanceof FormDesignValue);
        }
        if ((valueType & 2) != 0 && key.equals("#auto")) {
            return true;
        }
        return (valueType & 4) != 0 && !key.startsWith("#");
    }

    private String getComponentName(RADComponent metacomp) {
        String name = null;
        boolean rootName = false;
        if (this.isResourceAutoMode()) {
            FormProperty nameProp = ResourceSupport.getNameProperty(metacomp);
            if (nameProp != null && nameProp.isChanged()) {
                try {
                    name = (String)nameProp.getValue();
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            rootName = true;
        }
        if (!(metacomp == this.formModel.getTopRADComponent() && !rootName || name != null && name.trim().length() != 0)) {
            name = metacomp.getName();
        }
        return name;
    }

    private String getPropertyPath(FormProperty property, String compName) {
        String propertyName = property.getName();
        ArrayList<Object> parents = new ArrayList<Object>();
        do {
            FormPropertyContext propContext;
            Object parent;
            if ((parent = (propContext = property.getPropertyContext()).getOwner()) instanceof FormProperty) {
                parents.add(parent);
                property = (FormProperty)((Object)parent);
                continue;
            }
            if (parent instanceof RADComponent) {
                parents.add(parent);
            }
            property = null;
        } while (property != null);
        StringBuilder buf = new StringBuilder();
        ListIterator it = parents.listIterator(parents.size());
        while (it.hasPrevious()) {
            Object parent = it.previous();
            String append = parent instanceof RADComponent ? (compName != null ? compName : this.getComponentName((RADComponent)parent)) : ((FormProperty)((Object)parent)).getName();
            if (append == null) continue;
            if (buf.length() > 0) {
                buf.append(".");
            }
            buf.append(append);
        }
        if (buf.length() > 0) {
            buf.append(".");
        }
        buf.append(propertyName);
        return buf.toString();
    }

    private String getDefaultKey0(FormProperty prop, int type) {
        return this.getDefaultKey(this.getSrcDataObject().getName(), this.getPropertyPath(prop, null), type);
    }

    static String getDefaultKey(FormProperty prop, int type) {
        return ResourceSupport.getResourceSupport(prop).getDefaultKey0(prop, type);
    }

    private String getDefaultKey(String formName, String propPath, int type) {
        if (type != 1) {
            formName = null;
        }
        StringBuilder buf = new StringBuilder();
        if (formName != null) {
            buf.append(formName).append(".");
        }
        buf.append(propPath);
        return buf.toString();
    }

    private String getDefaultKey(FormProperty prop, ExternalValue eValue) {
        if (eValue instanceof I18nValue) {
            return this.getDefaultKey0(prop, 1);
        }
        if (eValue instanceof ResourceValue) {
            return this.getDefaultKey0(prop, 2);
        }
        return null;
    }

    private FileObject getSourceFile() {
        FormDataObject dobj = FormEditor.getFormDataObject(this.formModel);
        return dobj != null ? dobj.getPrimaryFile() : null;
    }

    private DataObject getSrcDataObject() {
        return FormEditor.getFormDataObject(this.formModel);
    }

    private int getAutoMode() {
        return this.formModel.getSettings().getResourceAutoMode();
    }

    private boolean isAutoMode() {
        return this.getAutoMode() != 0;
    }

    private boolean isResourceAutoMode() {
        int mode = this.formModel.getSettings().getResourceAutoMode();
        return this.getResourceService() != null && (mode == 2 || mode == 3);
    }

    private boolean isI18nAutoMode() {
        return this.getI18nService() != null && this.formModel.getSettings().getResourceAutoMode() == 1;
    }

    private boolean isAutoName() {
        return this.formModel.getSettings().getAutoSetComponentName();
    }

    private String getI18nBundleName() {
        String bundleName = this.formModel.getSettings().getFormBundle();
        if (bundleName == null) {
            if (this.defaultI18nBundle == null) {
                this.defaultI18nBundle = ResourceSupport.composeBundleName(ResourceSupport.getPkgResourceName(this.getSourceFile()), DEFAULT_BUNDLE_NAME);
            }
            bundleName = this.defaultI18nBundle;
        }
        return bundleName;
    }

    private static String getPkgResourceName(FileObject fo) {
        ClassPath cp = ClassPath.getClassPath((FileObject)fo, (String)"classpath/source");
        if (cp != null) {
            return cp.getResourceName(fo.isFolder() ? fo : fo.getParent());
        }
        return null;
    }

    private static String composeBundleName(String pkgResName, String bundleSimpleName) {
        return pkgResName != null && pkgResName.length() > 0 ? pkgResName + "/" + bundleSimpleName : bundleSimpleName;
    }

    private static boolean isResourceType(Class type) {
        return type == String.class || Font.class.isAssignableFrom(type) || Icon.class.isAssignableFrom(type) || Color.class.isAssignableFrom(type);
    }

    private static boolean isConvertibleToResource(Object value) {
        return value instanceof String || value instanceof Font || value instanceof IconEditor.NbImageIcon || value instanceof Color;
    }

    private boolean isEditorSwitchingValue(Object value) {
        FormProperty.ValueWithEditor vwe;
        return value instanceof FormProperty.ValueWithEditor && (vwe = (FormProperty.ValueWithEditor)value).getEditorSetByUser();
    }

    private ExternalValue getAutoValue(FormProperty prop) {
        ExternalValue eVal;
        Object value;
        try {
            value = prop.getValue();
        }
        catch (Exception ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
            return null;
        }
        if (value instanceof ExternalValue && ResourceSupport.isAutoValue(eVal = (ExternalValue)value, this.getDefaultKey(prop, eVal))) {
            return eVal;
        }
        return null;
    }

    private static boolean isAutoValue(ExternalValue value, String defaultKey) {
        String key = value != null ? value.getKey() : null;
        return key != null ? ResourceSupport.isAutoKey(key, defaultKey) : false;
    }

    private static boolean isAutoKey(String key, String defaultKey) {
        return key != null && key.startsWith(defaultKey);
    }

    private static String getStringValue(FormProperty prop, Object value) {
        if (value instanceof String) {
            return (String)value;
        }
        PropertyEditor prEd = prop.getCurrentEditor();
        prEd.setValue(value);
        return prEd.getAsText();
    }

    Node.Property[] createFormProperties() {
        Node.Property[] propertyArray;
        PropertySupport.ReadWrite<Boolean> autoNamingProp = new PropertySupport.ReadWrite<Boolean>(PROP_AUTO_SET_COMPONENT_NAME, Boolean.TYPE, FormUtils.getBundleString("PROP_AUTO_SET_COMPONENT_NAME"), FormUtils.getBundleString("HINT_AUTO_SET_COMPONENT_NAME")){

            public void setValue(Boolean value) {
                Boolean oldValue = this.getValue();
                if (!oldValue.equals(value)) {
                    boolean autoName = value;
                    ResourceSupport.this.formModel.getSettings().setAutoSetComponentName(autoName);
                    ResourceSupport.this.setupNameProperty(autoName);
                    ResourceSupport.this.formModel.fireSyntheticPropertyChanged(null, ResourceSupport.PROP_AUTO_SET_COMPONENT_NAME, oldValue, value);
                    FormEditor.getFormEditor(ResourceSupport.this.formModel).getFormRootNode().firePropertyChangeHelper(ResourceSupport.PROP_AUTO_SET_COMPONENT_NAME, oldValue, value);
                }
            }

            public Boolean getValue() {
                return ResourceSupport.this.formModel.getSettings().getAutoSetComponentName();
            }
        };
        int mode = this.getAutoMode();
        Object autoModeProp = this.projectUsesResources() || mode == 2 || mode == 3 ? new PropertySupport.ReadWrite<Integer>(PROP_AUTO_RESOURCING, Integer.TYPE, FormUtils.getBundleString("PROP_AUTO_RESOURCE"), FormUtils.getBundleString("HINT_AUTO_RESOURCE_LOCAL")){

            public void setValue(Integer value) {
                boolean i18nResChange;
                int oldMode = ResourceSupport.this.getAutoMode();
                if (value == null || value.equals(oldMode)) {
                    return;
                }
                int newMode = value;
                FormSettings settings = ResourceSupport.this.formModel.getSettings();
                boolean bl = i18nResChange = oldMode == 1 && (newMode == 2 || newMode == 3) || newMode == 1 && (oldMode == 2 || oldMode == 3);
                if (newMode == 0 || i18nResChange) {
                    ResourceSupport.this.switchFormToPlainValues(null);
                }
                settings.setResourceAutoMode(newMode);
                if (oldMode == 0 || i18nResChange) {
                    ResourceSupport.this.switchFormToResources();
                }
                if (newMode == 3 && !ResourceSupport.this.isAutoName()) {
                    ResourceSupport.this.formModel.getSettings().setAutoSetComponentName(true);
                    ResourceSupport.this.setupNameProperty(true);
                    FormEditor.getFormEditor(ResourceSupport.this.formModel).getFormRootNode().firePropertyChangeHelper(ResourceSupport.PROP_AUTO_SET_COMPONENT_NAME, oldMode, newMode);
                }
                ResourceSupport.this.formModel.fireSyntheticPropertyChanged(null, ResourceSupport.PROP_AUTO_RESOURCING, oldMode, newMode);
                FormEditor.getFormEditor(ResourceSupport.this.formModel).getFormRootNode().firePropertyChangeHelper(ResourceSupport.PROP_AUTO_RESOURCING, oldMode, newMode);
            }

            public Integer getValue() {
                return ResourceSupport.this.getAutoMode();
            }

            public PropertyEditor getPropertyEditor() {
                return new EnumEditor(new Object[]{FormUtils.getBundleString("CTL_AUTO_OFF"), 0, "", FormUtils.getBundleString("CTL_AUTO_I18N"), 1, "", FormUtils.getBundleString("CTL_AUTO_RESOURCING"), 2, "", FormUtils.getBundleString("CTL_AUTO_INJECTION"), 3, ""});
            }
        } : new PropertySupport.ReadWrite<Boolean>(PROP_AUTO_RESOURCING, Boolean.TYPE, FormUtils.getBundleString("PROP_AUTO_I18N"), FormUtils.getBundleString("HINT_AUTO_I18N")){

            public void setValue(Boolean value) {
                boolean oldAutoI18n = ResourceSupport.this.getAutoMode() == 1;
                Boolean oldValue = oldAutoI18n;
                if (!oldValue.equals(value)) {
                    boolean newAutoI18n = value;
                    FormSettings settings = ResourceSupport.this.formModel.getSettings();
                    if (newAutoI18n) {
                        settings.setResourceAutoMode(1);
                        ResourceSupport.this.switchFormToResources();
                    } else {
                        ResourceSupport.this.switchFormToPlainValues(null);
                        settings.setResourceAutoMode(0);
                    }
                    ResourceSupport.this.formModel.fireSyntheticPropertyChanged(null, ResourceSupport.PROP_AUTO_RESOURCING, oldValue, value);
                    FormEditor.getFormEditor(ResourceSupport.this.formModel).getFormRootNode().firePropertyChangeHelper(ResourceSupport.PROP_AUTO_RESOURCING, oldValue, value);
                }
            }

            public Boolean getValue() {
                return ResourceSupport.this.getAutoMode() == 1;
            }
        };
        PropertySupport.ReadWrite<String> formBundleProp = new PropertySupport.ReadWrite<String>(PROP_FORM_BUNDLE, String.class, FormUtils.getBundleString("PROP_FORM_BUNDLE"), FormUtils.getBundleString("HINT_FORM_BUNDLE")){

            public void setValue(String value) {
                String oldValue = ResourceSupport.this.getI18nBundleName();
                if (oldValue == null && value != null || !oldValue.equals(value)) {
                    String resourceName = value;
                    if (resourceName != null && resourceName.toLowerCase().endsWith(".properties")) {
                        resourceName = resourceName.substring(0, resourceName.length() - ".properties".length());
                    }
                    ResourceSupport.this.formModel.getSettings().setFormBundle(resourceName);
                    ResourceSupport.this.bundleChanged(oldValue);
                    ResourceSupport.this.formModel.fireSyntheticPropertyChanged(null, ResourceSupport.PROP_FORM_BUNDLE, oldValue, value);
                    FormEditor.getFormEditor(ResourceSupport.this.formModel).getFormRootNode().firePropertyChangeHelper(ResourceSupport.PROP_FORM_BUNDLE, oldValue, value);
                }
            }

            public String getValue() {
                return ResourceSupport.this.getI18nBundleName();
            }

            public PropertyEditor getPropertyEditor() {
                return new BundleFilePropertyEditor();
            }
        };
        PropertySupport.ReadWrite<String> localeProp = new PropertySupport.ReadWrite<String>(PROP_DESIGN_LOCALE, String.class, FormUtils.getBundleString("PROP_DESIGN_LOCALE"), FormUtils.getBundleString("HINT_DESIGN_LOCALE")){

            public void setValue(String value) {
                String oldValue = ResourceSupport.this.designLocale;
                ResourceSupport.this.changeDesignLocale(value);
                ResourceSupport.this.formModel.fireSyntheticPropertyChanged(null, ResourceSupport.PROP_DESIGN_LOCALE, oldValue, value);
                FormEditor.getFormEditor(ResourceSupport.this.formModel).getFormRootNode().firePropertyChangeHelper(ResourceSupport.PROP_DESIGN_LOCALE, oldValue, value);
            }

            public String getValue() {
                return ResourceSupport.this.designLocale;
            }

            public PropertyEditor getPropertyEditor() {
                return new LocalePropertyEditor();
            }
        };
        int autoMode = this.getAutoMode();
        if (autoMode == 0 || autoMode == 1) {
            Node.Property[] propertyArray2 = new Node.Property[4];
            propertyArray2[0] = autoNamingProp;
            propertyArray2[1] = autoModeProp;
            propertyArray2[2] = formBundleProp;
            propertyArray = propertyArray2;
            propertyArray2[3] = localeProp;
        } else {
            Node.Property[] propertyArray3 = new Node.Property[3];
            propertyArray3[0] = autoNamingProp;
            propertyArray3[1] = autoModeProp;
            propertyArray = propertyArray3;
            propertyArray3[2] = localeProp;
        }
        return propertyArray;
    }

    private class LocalePropertyEditor
    extends PropertyEditorSupport {
        private String[][] tags;

        private LocalePropertyEditor() {
        }

        @Override
        public String[] getTags() {
            FileObject srcFile;
            if (this.tags == null && (srcFile = ResourceSupport.this.getSourceFile()) != null) {
                if (ResourceSupport.this.isI18nAutoMode()) {
                    this.tags = ResourceSupport.this.i18nService.getAvailableLocales(srcFile, ResourceSupport.this.getI18nBundleName());
                } else if (ResourceSupport.this.isResourceAutoMode()) {
                    this.tags = ResourceSupport.this.resourceService.getAvailableLocales(srcFile);
                }
            }
            return this.tags != null ? this.tags[1] : null;
        }

        @Override
        public void setAsText(String text) {
            this.getTags();
            if (this.tags != null) {
                int n = this.tags[0].length;
                for (int i = 0; i < n; ++i) {
                    if (!this.tags[1][i].equals(text)) continue;
                    this.setValue(this.tags[0][i]);
                    return;
                }
            }
            this.setValue(text);
        }

        @Override
        public String getAsText() {
            Object value = this.getValue();
            this.getTags();
            if (this.tags != null) {
                int n = this.tags[0].length;
                for (int i = 0; i < n; ++i) {
                    if (!this.tags[0][i].equals(value)) continue;
                    return this.tags[1][i];
                }
            }
            return value != null ? value.toString() : null;
        }

        @Override
        public boolean supportsCustomEditor() {
            return this.getTags() != null;
        }

        @Override
        public Component getCustomEditor() {
            if (ResourceSupport.this.isI18nAutoMode()) {
                return ResourceSupport.this.i18nService.getCreateLocaleComponent(this, ResourceSupport.this.getSourceFile(), ResourceSupport.this.getI18nBundleName());
            }
            if (ResourceSupport.this.isResourceAutoMode()) {
                return ResourceSupport.this.resourceService.getCreateLocaleComponent(this, ResourceSupport.this.getSourceFile());
            }
            return null;
        }
    }

    private class BundleFilePropertyEditor
    extends PropertyEditorSupport {
        private BundleFilePropertyEditor() {
        }

        @Override
        public boolean supportsCustomEditor() {
            return ResourceSupport.this.getI18nService() != null;
        }

        @Override
        public Component getCustomEditor() {
            return ResourceSupport.this.getI18nService() != null ? ResourceSupport.this.i18nService.getBundleSelectionComponent(this, ResourceSupport.this.getSourceFile()) : null;
        }
    }

    private class ModelListener
    implements FormModelListener {
        private ModelListener() {
        }

        @Override
        public void formChanged(FormModelEvent[] events) {
            if (events == null) {
                return;
            }
            ResourceSupport.this.getI18nService();
            ResourceSupport.this.getResourceService();
            if (ResourceSupport.this.i18nService == null && ResourceSupport.this.resourceService == null) {
                return;
            }
            block10: for (int i = 0; i < events.length; ++i) {
                FormModelEvent ev = events[i];
                switch (ev.getChangeType()) {
                    case 8: {
                        if (!ev.getCreatedDeleted()) continue block10;
                        for (FormProperty prop : ResourceSupport.this.getComponentResourceProperties(ev.getComponent(), 4, true)) {
                            ExternalValue value = ResourceSupport.this.getAutoValue(prop);
                            if (value == null) continue;
                            try {
                                if (value instanceof I18nValue && ResourceSupport.this.i18nService != null) {
                                    ResourceSupport.this.i18nService.update((I18nValue)value, null, ResourceSupport.this.getSrcDataObject(), ResourceSupport.this.getI18nBundleName(), null, true);
                                    continue;
                                }
                                if (!(value instanceof ResourceValue) || ResourceSupport.this.resourceService == null) continue;
                                ResourceSupport.this.resourceService.update((ResourceValue)value, null, ResourceSupport.this.getSourceFile(), null);
                            }
                            catch (IOException ex) {
                                ErrorManager.getDefault().notify(1, (Throwable)ex);
                            }
                        }
                        continue block10;
                    }
                    case 7: {
                        if (!ev.getCreatedDeleted()) continue block10;
                        RADComponent addedComp = ev.getComponent();
                        for (FormProperty prop : ResourceSupport.this.getComponentResourceProperties(addedComp, 4, true)) {
                            try {
                                Object value = prop.getValue();
                                if (value instanceof I18nValue && ResourceSupport.this.i18nService != null) {
                                    ResourceSupport.this.i18nService.update(null, (I18nValue)value, ResourceSupport.this.getSrcDataObject(), ResourceSupport.this.getI18nBundleName(), ResourceSupport.this.designLocale, false);
                                    continue;
                                }
                                if (!(value instanceof ResourceValue) || ResourceSupport.this.resourceService == null) continue;
                                ResourceSupport.this.resourceService.update(null, (ResourceValue)value, ResourceSupport.this.getSourceFile(), ResourceSupport.this.designLocale);
                            }
                            catch (Exception ex) {
                                ErrorManager.getDefault().notify(1, (Throwable)ex);
                            }
                        }
                        if (!ResourceSupport.this.isAutoName() || addedComp == ResourceSupport.this.formModel.getTopRADComponent() || !ResourceSupport.this.formModel.isUndoRedoRecording()) continue block10;
                        ResourceSupport.setupNameProperty(addedComp, true, true);
                        continue block10;
                    }
                    case 2: {
                        if (ResourceSupport.this.i18nService != null) {
                            ResourceSupport.this.i18nService.autoSave(ResourceSupport.this.getSrcDataObject());
                        }
                        if (ResourceSupport.this.resourceService == null) continue block10;
                        ResourceSupport.this.resourceService.autoSave(ResourceSupport.this.getSourceFile());
                        continue block10;
                    }
                    case 3: {
                        if (ResourceSupport.this.i18nService != null) {
                            ResourceSupport.this.i18nService.close(ResourceSupport.this.getSrcDataObject());
                        }
                        if (ResourceSupport.this.resourceService == null) continue block10;
                        ResourceSupport.this.resourceService.close(ResourceSupport.this.getSourceFile());
                    }
                }
            }
        }
    }
}

