/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.qnavigator.navigator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmInclude;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.services.CsmStandaloneFileProvider;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.netbeans.modules.cnd.qnavigator.navigator.CppDeclarationNode;
import org.netbeans.modules.cnd.qnavigator.navigator.CsmFileFilter;
import org.netbeans.modules.cnd.qnavigator.navigator.IndexOffsetNode;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;

public class CsmFileModel {
    static final Logger logger = Logger.getLogger("org.netbeans.modules.cnd.qnavigator");
    private List<IndexOffsetNode> lineNumberIndex = Collections.synchronizedList(new ArrayList());
    private List<CppDeclarationNode> list = Collections.synchronizedList(new ArrayList());
    private CsmFileFilter filter;
    private Action[] actions;
    private FileObject fileObject;
    private boolean isStandalone;

    public CsmFileModel(CsmFileFilter filter, Action[] actions) {
        this.filter = filter;
        this.actions = actions;
    }

    public Node[] getNodes() {
        return this.list.toArray(new Node[0]);
    }

    private void clear() {
        this.lineNumberIndex.clear();
        this.list.clear();
    }

    public CsmFileFilter getFilter() {
        return this.filter;
    }

    public FileObject getFileObject() {
        return this.fileObject;
    }

    public boolean isStandalone() {
        return this.isStandalone;
    }

    public void addOffset(Node node, CsmOffsetable element, List<IndexOffsetNode> lineNumberIndex) {
        lineNumberIndex.add(new IndexOffsetNode(node, element.getStartOffset(), element.getEndOffset()));
    }

    public void addFileOffset(Node node, CsmFile element, List<IndexOffsetNode> lineNumberIndex) {
        lineNumberIndex.add(new IndexOffsetNode(node, 0L, 0L));
    }

    public PreBuildModel buildPreModel(CsmFile csmFile) {
        this.isStandalone = CsmStandaloneFileProvider.getDefault().isStandalone(csmFile);
        this.fileObject = CsmUtilities.getFileObject((CsmFile)csmFile);
        PreBuildModel preBuildModel = new PreBuildModel();
        if (csmFile != null && csmFile.isValid()) {
            CppDeclarationNode node;
            CppDeclarationNode node2;
            if (this.isStandalone && (node2 = CppDeclarationNode.nodeFactory((CsmObject)csmFile, this, false, this.lineNumberIndex)) != null) {
                preBuildModel.newList.add(node2);
            }
            if (this.filter.isApplicableInclude()) {
                for (CsmInclude element : csmFile.getIncludes()) {
                    node = CppDeclarationNode.nodeFactory((CsmObject)element, this, false, preBuildModel.newLineNumberIndex);
                    if (node == null) continue;
                    preBuildModel.newList.add(node);
                }
            }
            if (this.filter.isApplicableMacro()) {
                for (CsmInclude element : csmFile.getMacros()) {
                    node = CppDeclarationNode.nodeFactory((CsmObject)element, this, false, preBuildModel.newLineNumberIndex);
                    if (node == null) continue;
                    preBuildModel.newList.add(node);
                }
            }
            for (CsmInclude element : csmFile.getDeclarations()) {
                if (!this.filter.isApplicable((CsmOffsetable)element) || (node = CppDeclarationNode.nodeFactory((CsmObject)element, this, false, preBuildModel.newLineNumberIndex)) == null) continue;
                preBuildModel.newList.add(node);
            }
        }
        if (csmFile != null && csmFile.isValid()) {
            Collections.sort(preBuildModel.newList);
            Collections.sort(preBuildModel.newLineNumberIndex);
        }
        return preBuildModel;
    }

    public boolean buildModel(PreBuildModel preBuildModel, CsmFile csmFile, boolean force) {
        boolean res = true;
        if (csmFile != null && csmFile.isValid()) {
            this.resetScope(preBuildModel.newLineNumberIndex);
            if (force || this.isNeedChange(preBuildModel.newLineNumberIndex)) {
                this.clear();
                this.list.addAll(preBuildModel.newList);
                this.lineNumberIndex.addAll(preBuildModel.newLineNumberIndex);
                logger.log(Level.FINE, "Set new navigator model for file {0}", csmFile);
            } else {
                this.resetScope(this.lineNumberIndex);
                res = false;
                logger.log(Level.FINE, "Reset navigator model for file {0}", csmFile);
            }
        } else {
            this.clear();
            logger.log(Level.FINE, "Clear navigator model for file {0}", csmFile);
        }
        preBuildModel.newList.clear();
        preBuildModel.newLineNumberIndex.clear();
        return res;
    }

    private boolean isNeedChange(List<IndexOffsetNode> newLineNumberIndex) {
        IndexOffsetNode n2;
        if (newLineNumberIndex.size() != this.lineNumberIndex.size()) {
            return true;
        }
        int i = 0;
        for (IndexOffsetNode n1 : this.lineNumberIndex) {
            if (newLineNumberIndex.size() <= i) {
                return true;
            }
            n2 = newLineNumberIndex.get(i);
            if (!this.compareNodeContent(n1, n2)) {
                return true;
            }
            ++i;
        }
        i = 0;
        for (IndexOffsetNode n1 : this.lineNumberIndex) {
            if (newLineNumberIndex.size() <= i) {
                return true;
            }
            n2 = newLineNumberIndex.get(i);
            this.updateNodeContent(n1, n2);
            ++i;
        }
        return false;
    }

    private boolean compareNodeContent(IndexOffsetNode n1, IndexOffsetNode n2) {
        CppDeclarationNode d2;
        CppDeclarationNode d1 = (CppDeclarationNode)n1.getNode();
        return d1.compareToWithoutOffset(d2 = (CppDeclarationNode)n2.getNode()) == 0;
    }

    private void updateNodeContent(IndexOffsetNode n1, IndexOffsetNode n2) {
        CppDeclarationNode d1 = (CppDeclarationNode)n1.getNode();
        CppDeclarationNode d2 = (CppDeclarationNode)n2.getNode();
        d1.resetNode(d2);
        n1.resetContent(n2);
    }

    private void resetScope(List<IndexOffsetNode> newLineNumberIndex) {
        Stack<IndexOffsetNode> stack = new Stack<IndexOffsetNode>();
        for (IndexOffsetNode node : newLineNumberIndex) {
            while (!stack.empty()) {
                IndexOffsetNode scope = (IndexOffsetNode)stack.peek();
                if (node.getStartOffset() >= scope.getStartOffset() && node.getEndOffset() <= scope.getEndOffset()) {
                    node.setScope(scope);
                    break;
                }
                stack.pop();
            }
            stack.push(node);
        }
    }

    public Node setSelection(long caretLineNo) {
        int index = Collections.binarySearch(this.lineNumberIndex, new IndexOffsetNode(null, caretLineNo, caretLineNo));
        if (index < 0) {
            index = -index - 2;
        }
        if (index > -1 && index < this.lineNumberIndex.size()) {
            IndexOffsetNode node = this.lineNumberIndex.get(index);
            if (node.getStartOffset() <= caretLineNo && node.getEndOffset() >= caretLineNo) {
                return node.getNode();
            }
            for (IndexOffsetNode scopedNode = node.getScope(); scopedNode != null; scopedNode = scopedNode.getScope()) {
                node = scopedNode;
                if (scopedNode.getStartOffset() > caretLineNo || scopedNode.getEndOffset() < caretLineNo) continue;
                return scopedNode.getNode();
            }
            return node.getNode();
        }
        return null;
    }

    public Action[] getActions() {
        return this.actions;
    }

    public static final class PreBuildModel {
        List<CppDeclarationNode> newList = new ArrayList<CppDeclarationNode>();
        List<IndexOffsetNode> newLineNumberIndex = new ArrayList<IndexOffsetNode>();
    }
}

