/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.masterfs.providers.ProvidedExtensions;
import org.netbeans.modules.versioning.Utils;
import org.netbeans.modules.versioning.VersioningManager;
import org.netbeans.modules.versioning.spi.VCSInterceptor;
import org.netbeans.modules.versioning.spi.VersioningSystem;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;

class FilesystemInterceptor
extends ProvidedExtensions
implements FileChangeListener {
    private static final String ATTRIBUTE_REMOTE_LOCATION = "ProvidedExtensions.RemoteLocation";
    private static final String ATTRIBUTE_REFRESH = "ProvidedExtensions.Refresh";
    private static final String ATTRIBUTE_SEARCH_HISTORY = "ProvidedExtensions.SearchHistorySupport";
    private static final String ATTRIBUTE_VCS_MANAGED = "ProvidedExtensions.VCSManaged";
    private static final Logger LOG = Logger.getLogger("org.netbeans.modules.versioning.FilesystemInterceptor");
    private VersioningManager master;
    private final Map<FileEx, DelegatingInterceptor> filesBeingCreated = new HashMap<FileEx, DelegatingInterceptor>(10);
    private final DelegatingInterceptor nullDelegatingInterceptor = new DelegatingInterceptor(){

        @Override
        public boolean beforeDelete() {
            return false;
        }

        @Override
        public void doDelete() throws IOException {
        }

        @Override
        public void afterDelete() {
        }

        @Override
        public boolean beforeMove() {
            return false;
        }

        @Override
        public void doMove() throws IOException {
        }

        @Override
        public boolean beforeCreate() {
            return false;
        }

        @Override
        public void doCreate() throws IOException {
        }

        @Override
        public void afterCreate() {
        }

        @Override
        public void beforeChange() {
        }

        @Override
        public void beforeEdit() {
        }

        @Override
        public void afterChange() {
        }

        @Override
        public void afterMove() {
        }

        @Override
        public boolean delete(File file) {
            throw new UnsupportedOperationException();
        }
    };
    private final VCSInterceptor nullVCSInterceptor = new VCSInterceptor(){};
    private final Set<File> deletedFiles = new HashSet<File>(5);

    public FilesystemInterceptor(boolean providesCanWrite) {
        super(providesCanWrite);
    }

    void init(VersioningManager versioningManager) {
        assert (this.master == null);
        this.master = versioningManager;
        FileSystem fileSystem = Utils.getRootFilesystem();
        fileSystem.addFileChangeListener((FileChangeListener)this);
    }

    void shutdown() {
        FileSystem fileSystem = Utils.getRootFilesystem();
        fileSystem.removeFileChangeListener((FileChangeListener)this);
    }

    public boolean canWrite(File file) {
        LOG.log(Level.FINE, "canWrite {0}", file);
        if (Utils.canWrite(file)) {
            return true;
        }
        if (!Utils.exists(file)) {
            return false;
        }
        return this.getInterceptor(file, false, "isMutable").isMutable(file);
    }

    public Object getAttribute(File file, String attrName) {
        if (ATTRIBUTE_REMOTE_LOCATION.equals(attrName) || ATTRIBUTE_REFRESH.equals(attrName) || ATTRIBUTE_SEARCH_HISTORY.equals(attrName)) {
            return this.getInterceptor(file, file.isDirectory(), "getAttribute").getAttribute(attrName);
        }
        if (ATTRIBUTE_VCS_MANAGED.equals(attrName)) {
            return this.master.getOwner(file) != null;
        }
        return null;
    }

    public void fileChanged(FileEvent fe) {
        LOG.log(Level.FINE, "fileChanged {0}", fe.getFile());
        this.removeFromDeletedFiles(fe.getFile());
        this.getInterceptor(fe, "afterChange").afterChange();
    }

    public void beforeChange(FileObject fo) {
        File file = FileUtil.toFile((FileObject)fo);
        LOG.log(Level.FINE, "beforeChange {0}", file);
        this.getInterceptor(file, fo.isFolder(), "beforeChange").beforeChange();
    }

    public long refreshRecursively(File dir, long lastTimeStamp, List<? super File> children) {
        LOG.log(Level.FINE, "refreshRecursively {0}, {1}", new Object[]{dir, lastTimeStamp});
        if (LOG.isLoggable(Level.FINER)) {
            for (File file : children) {
                LOG.log(Level.FINE, "  refreshRecursively child {1}", file);
            }
        }
        DelegatingInterceptor interceptor = this.getRefreshInterceptor(dir);
        return interceptor.refreshRecursively(dir, lastTimeStamp, children);
    }

    private boolean needsLH(String ... methodNames) {
        for (String methodName : methodNames) {
            if (!this.master.needsLocalHistory(methodName)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFromDeletedFiles(File file) {
        Set<File> set = this.deletedFiles;
        synchronized (set) {
            this.deletedFiles.remove(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFromDeletedFiles(FileObject fo) {
        Set<File> set = this.deletedFiles;
        synchronized (set) {
            if (this.deletedFiles.size() > 0) {
                this.deletedFiles.remove(FileUtil.toFile((FileObject)fo));
            }
        }
    }

    public ProvidedExtensions.DeleteHandler getDeleteHandler(File file) {
        LOG.log(Level.FINE, "getDeleteHandler {0}", file);
        this.removeFromDeletedFiles(file);
        DelegatingInterceptor dic = this.getInterceptor(file, (Boolean)null, "beforeDelete", "doDelete");
        return dic.beforeDelete() ? dic : null;
    }

    public void deleteSuccess(FileObject fo) {
        this.fileDeleted(fo);
    }

    public void deletedExternally(FileObject fo) {
        this.fileDeleted(fo);
    }

    public void fileDeleted(FileEvent fe) {
    }

    private void fileDeleted(FileObject fo) {
        FileEvent fe = new FileEvent(fo);
        LOG.log(Level.FINE, "fileDeleted {0}", fe.getFile());
        this.removeFromDeletedFiles(fe.getFile());
        this.getInterceptor(fe, "afterDelete").afterDelete();
    }

    public void beforeCreate(FileObject parent, String name, boolean isFolder) {
        LOG.log(Level.FINE, "beforeCreate {0}, {1}, {2} ", new Object[]{parent, name, isFolder});
        File file = FileUtil.toFile((FileObject)parent);
        if (file == null) {
            return;
        }
        file = new File(file, name);
        DelegatingInterceptor dic = this.getInterceptor(file, isFolder, "beforeCreate");
        if (dic.beforeCreate()) {
            this.filesBeingCreated.put(new FileEx(parent, name, isFolder), dic);
        }
    }

    public void createFailure(FileObject parent, String name, boolean isFolder) {
        LOG.log(Level.FINE, "createFailure {0}, {1}, {2} ", new Object[]{parent, name, isFolder});
        this.filesBeingCreated.remove(new FileEx(parent, name, isFolder));
    }

    public void createSuccess(FileObject fo) {
        LOG.log(Level.FINE, "createSuccess {0}", fo);
        this.fileCreated(new FileEvent(fo));
    }

    public void createdExternally(FileObject fo) {
        LOG.log(Level.FINE, "createdExternally {0}", fo);
        this.fileCreated(new FileEvent(fo));
    }

    public void fileDataCreated(FileEvent fe) {
    }

    public void fileFolderCreated(FileEvent fe) {
    }

    private void fileCreated(FileEvent fe) {
        FileObject fo = fe.getFile();
        FileEx fileEx = new FileEx(fo.getParent(), fo.getNameExt(), fo.isFolder());
        DelegatingInterceptor interceptor = this.filesBeingCreated.remove(fileEx);
        if (interceptor != null) {
            try {
                interceptor.doCreate();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        this.removeFromDeletedFiles(fe.getFile());
        if (interceptor == null) {
            interceptor = this.getInterceptor(fe, "afterCreate");
        }
        interceptor.afterCreate();
    }

    public ProvidedExtensions.IOHandler getMoveHandler(File from, File to) {
        LOG.log(Level.FINE, "getMoveHandler {0}, {1}", new Object[]{from, to});
        return this.getMoveHandlerIntern(from, to);
    }

    public ProvidedExtensions.IOHandler getRenameHandler(File from, String newName) {
        LOG.log(Level.FINE, "getRenameHandler {0}, {1}", new Object[]{from, newName});
        File to = new File(from.getParentFile(), newName);
        return this.getMoveHandlerIntern(from, to);
    }

    private ProvidedExtensions.IOHandler getMoveHandlerIntern(File from, File to) {
        DelegatingInterceptor dic = this.getInterceptor(from, to, "beforeMove", "doMove");
        return dic.beforeMove() ? dic.getMoveHandler() : null;
    }

    public void moveSuccess(FileObject from, File to) {
        this.getInterceptor(FileUtil.toFile((FileObject)from), to, "afterMove").afterMove();
    }

    public void fileRenamed(FileRenameEvent fe) {
        LOG.log(Level.FINE, "fileRenamed {0}", fe.getFile());
        this.removeFromDeletedFiles(fe.getFile());
        this.getInterceptor((FileEvent)fe, "afterMove").afterMove();
    }

    public void fileAttributeChanged(FileAttributeEvent fe) {
        LOG.log(Level.FINE, "fileAttributeChanged {0}", fe.getFile());
    }

    public ProvidedExtensions.IOHandler getCopyHandler(File from, File to) {
        LOG.log(Level.FINE, "getCopyHandler {0}, {1}", new Object[]{from, to});
        return this.getCopyHandlerIntern(from, to);
    }

    private ProvidedExtensions.IOHandler getCopyHandlerIntern(File from, File to) {
        DelegatingInterceptor dic = this.getInterceptor(from, to, "beforeCopy", "doCopy");
        return dic.beforeCopy() ? dic.getCopyHandler() : null;
    }

    public void beforeCopy(FileObject from, File to) {
    }

    public void copySuccess(FileObject from, File to) {
        this.getInterceptor(FileUtil.toFile((FileObject)from), to, "afterCopy").afterCopy();
    }

    public void copyFailure(FileObject from, File to) {
    }

    public void fileLocked(FileObject fo) {
        LOG.log(Level.FINE, "fileLocked {0}", fo);
        this.getInterceptor(new FileEvent(fo), "beforeEdit").beforeEdit();
    }

    private DelegatingInterceptor getInterceptor(FileEvent fe, String ... forMethods) {
        VCSInterceptor lhInterceptor;
        if (this.master == null) {
            return this.nullDelegatingInterceptor;
        }
        FileObject fo = fe.getFile();
        if (fo == null) {
            return this.nullDelegatingInterceptor;
        }
        File file = FileUtil.toFile((FileObject)fo);
        if (file == null) {
            return this.nullDelegatingInterceptor;
        }
        VersioningSystem lh = this.needsLH(forMethods) ? this.master.getLocalHistory(file, !fo.isFolder()) : null;
        VersioningSystem vs = this.master.getOwner(file, !fo.isFolder());
        VCSInterceptor vsInterceptor = vs != null ? vs.getVCSInterceptor() : null;
        VCSInterceptor vCSInterceptor = lhInterceptor = lh != null ? lh.getVCSInterceptor() : null;
        if (vsInterceptor == null && lhInterceptor == null) {
            return this.nullDelegatingInterceptor;
        }
        if (fe instanceof FileRenameEvent) {
            FileRenameEvent fre = (FileRenameEvent)fe;
            File parent = file.getParentFile();
            if (parent != null) {
                String name = fre.getName();
                String ext = fre.getExt();
                if (ext != null && ext.length() > 0) {
                    name = name + "." + ext;
                }
                File from = new File(parent, name);
                return new DelegatingInterceptor(vsInterceptor, lhInterceptor, from, file, false);
            }
            return this.nullDelegatingInterceptor;
        }
        return new DelegatingInterceptor(vsInterceptor, lhInterceptor, file, null, false);
    }

    private DelegatingInterceptor getInterceptor(File file, Boolean isDirectory, String ... forMethods) {
        if (file == null || this.master == null) {
            return this.nullDelegatingInterceptor;
        }
        Boolean isFile = isDirectory != null ? Boolean.valueOf(isDirectory == false) : null;
        isDirectory = isDirectory != null ? isDirectory : false;
        VersioningSystem vs = this.master.getOwner(file, isFile);
        VCSInterceptor vsInterceptor = vs != null ? vs.getVCSInterceptor() : this.nullVCSInterceptor;
        VersioningSystem lhvs = this.needsLH(forMethods) ? this.master.getLocalHistory(file, isFile) : null;
        VCSInterceptor localHistoryInterceptor = lhvs != null ? lhvs.getVCSInterceptor() : this.nullVCSInterceptor;
        return new DelegatingInterceptor(vsInterceptor, localHistoryInterceptor, file, null, (boolean)isDirectory);
    }

    private DelegatingInterceptor getInterceptor(File from, File to, String ... forMethods) {
        if (from == null || to == null) {
            return this.nullDelegatingInterceptor;
        }
        VersioningSystem vs = this.master.getOwner(from);
        VCSInterceptor vsInterceptor = vs != null ? vs.getVCSInterceptor() : this.nullVCSInterceptor;
        VersioningSystem lhvs = this.needsLH(forMethods) ? this.master.getLocalHistory(from) : null;
        VCSInterceptor localHistoryInterceptor = lhvs != null ? lhvs.getVCSInterceptor() : this.nullVCSInterceptor;
        return new DelegatingInterceptor(vsInterceptor, localHistoryInterceptor, from, to, false);
    }

    private DelegatingInterceptor getRefreshInterceptor(File dir) {
        if (dir == null) {
            return this.nullDelegatingInterceptor;
        }
        VersioningSystem vs = this.master.getOwner(dir);
        VCSInterceptor vcsInterceptor = vs != null ? vs.getVCSInterceptor() : this.nullVCSInterceptor;
        return new DelegatingInterceptor(vcsInterceptor, this.nullVCSInterceptor, dir, null, true);
    }

    private class FileEx {
        final FileObject parent;
        final String name;
        final boolean isFolder;

        public FileEx(FileObject parent, String name, boolean folder) {
            this.parent = parent;
            this.name = name;
            this.isFolder = folder;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof FileEx)) {
                return false;
            }
            FileEx fileEx = (FileEx)o;
            return this.isFolder == fileEx.isFolder && this.name.equals(fileEx.name) && this.parent.equals(fileEx.parent);
        }

        public int hashCode() {
            int result = this.parent.hashCode();
            result = 17 * result + this.name.hashCode();
            result = 17 * result + (this.isFolder ? 1 : 0);
            return result;
        }
    }

    private class DelegatingInterceptor
    implements ProvidedExtensions.DeleteHandler {
        final Collection<VCSInterceptor> interceptors;
        final VCSInterceptor interceptor;
        final VCSInterceptor lhInterceptor;
        final File file;
        final File to;
        private final boolean isDirectory;
        private ProvidedExtensions.IOHandler moveHandler;
        private ProvidedExtensions.IOHandler copyHandler;

        private DelegatingInterceptor() {
            this((VCSInterceptor)null, null, null, null, false);
        }

        public DelegatingInterceptor(VCSInterceptor interceptor, VCSInterceptor lhInterceptor, File file, File to, boolean isDirectory) {
            this.interceptor = interceptor != null ? interceptor : FilesystemInterceptor.this.nullVCSInterceptor;
            this.interceptors = Collections.singleton(this.interceptor);
            this.lhInterceptor = lhInterceptor != null ? lhInterceptor : FilesystemInterceptor.this.nullVCSInterceptor;
            this.file = file;
            this.to = to;
            this.isDirectory = isDirectory;
        }

        public DelegatingInterceptor(Collection<VCSInterceptor> interceptors, VCSInterceptor lhInterceptor, File file, File to, boolean isDirectory) {
            this.interceptors = interceptors != null && interceptors.size() > 0 ? interceptors : Collections.singleton(FilesystemInterceptor.this.nullVCSInterceptor);
            this.interceptor = this.interceptors.iterator().next();
            this.lhInterceptor = lhInterceptor != null ? lhInterceptor : FilesystemInterceptor.this.nullVCSInterceptor;
            this.file = file;
            this.to = to;
            this.isDirectory = isDirectory;
        }

        public boolean isMutable(File file) {
            return this.interceptor.isMutable(file);
        }

        private Object getAttribute(String attrName) {
            return this.interceptor.getAttribute(this.file, attrName);
        }

        public boolean beforeDelete() {
            this.lhInterceptor.beforeDelete(this.file);
            return this.interceptor.beforeDelete(this.file);
        }

        public void doDelete() throws IOException {
            this.lhInterceptor.doDelete(this.file);
            this.interceptor.doDelete(this.file);
        }

        public void afterDelete() {
            this.lhInterceptor.afterDelete(this.file);
            this.interceptor.afterDelete(this.file);
        }

        public boolean beforeMove() {
            this.lhInterceptor.beforeMove(this.file, this.to);
            return this.interceptor.beforeMove(this.file, this.to);
        }

        public void doMove() throws IOException {
            this.lhInterceptor.doMove(this.file, this.to);
            this.interceptor.doMove(this.file, this.to);
        }

        public void afterMove() {
            this.lhInterceptor.afterMove(this.file, this.to);
            this.interceptor.afterMove(this.file, this.to);
        }

        public boolean beforeCopy() {
            this.lhInterceptor.beforeCopy(this.file, this.to);
            return this.interceptor.beforeCopy(this.file, this.to);
        }

        public void doCopy() throws IOException {
            this.lhInterceptor.doCopy(this.file, this.to);
            this.interceptor.doCopy(this.file, this.to);
        }

        public void afterCopy() {
            this.lhInterceptor.afterCopy(this.file, this.to);
            this.interceptor.afterCopy(this.file, this.to);
        }

        public boolean beforeCreate() {
            this.lhInterceptor.beforeCreate(this.file, this.isDirectory);
            return this.interceptor.beforeCreate(this.file, this.isDirectory);
        }

        public void doCreate() throws IOException {
            this.lhInterceptor.doCreate(this.file, this.isDirectory);
            this.interceptor.doCreate(this.file, this.isDirectory);
        }

        public void afterCreate() {
            this.lhInterceptor.afterCreate(this.file);
            this.interceptor.afterCreate(this.file);
        }

        public void afterChange() {
            this.lhInterceptor.afterChange(this.file);
            this.interceptor.afterChange(this.file);
        }

        public void beforeChange() {
            this.lhInterceptor.beforeChange(this.file);
            this.interceptor.beforeChange(this.file);
        }

        public void beforeEdit() {
            this.lhInterceptor.beforeEdit(this.file);
            this.interceptor.beforeEdit(this.file);
        }

        private ProvidedExtensions.IOHandler getMoveHandler() {
            if (this.moveHandler == null) {
                this.moveHandler = new ProvidedExtensions.IOHandler(){

                    public void handle() throws IOException {
                        DelegatingInterceptor.this.doMove();
                    }
                };
            }
            return this.moveHandler;
        }

        private ProvidedExtensions.IOHandler getCopyHandler() {
            if (this.copyHandler == null) {
                this.copyHandler = new ProvidedExtensions.IOHandler(){

                    public void handle() throws IOException {
                        DelegatingInterceptor.this.doCopy();
                    }
                };
            }
            return this.copyHandler;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean delete(File file) {
            Set set;
            File[] children = file.listFiles();
            if (children != null) {
                set = FilesystemInterceptor.this.deletedFiles;
                synchronized (set) {
                    for (File child : children) {
                        if (FilesystemInterceptor.this.deletedFiles.contains(child)) continue;
                        return false;
                    }
                }
            }
            try {
                this.lhInterceptor.doDelete(file);
                this.interceptor.doDelete(file);
                set = FilesystemInterceptor.this.deletedFiles;
                synchronized (set) {
                    if (file.isDirectory()) {
                        Iterator i = FilesystemInterceptor.this.deletedFiles.iterator();
                        while (i.hasNext()) {
                            File fakedFile = (File)i.next();
                            if (!file.equals(fakedFile.getParentFile())) continue;
                            i.remove();
                        }
                    }
                    if (Utils.exists(file)) {
                        FilesystemInterceptor.this.deletedFiles.add(file);
                    } else {
                        FilesystemInterceptor.this.deletedFiles.remove(file);
                    }
                }
                return true;
            }
            catch (IOException e) {
                return false;
            }
        }

        public long refreshRecursively(File dir, long lastTimeStamp, List<? super File> children) {
            return this.interceptor.refreshRecursively(dir, lastTimeStamp, children);
        }
    }
}

