/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.ui.pull;

import java.io.File;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.JOptionPane;
import org.netbeans.modules.mercurial.FileStatusCache;
import org.netbeans.modules.mercurial.HgException;
import org.netbeans.modules.mercurial.HgProgressSupport;
import org.netbeans.modules.mercurial.Mercurial;
import org.netbeans.modules.mercurial.OutputLogger;
import org.netbeans.modules.mercurial.ui.actions.ContextAction;
import org.netbeans.modules.mercurial.ui.merge.MergeAction;
import org.netbeans.modules.mercurial.ui.repository.HgURL;
import org.netbeans.modules.mercurial.util.HgCommand;
import org.netbeans.modules.mercurial.util.HgProjectUtils;
import org.netbeans.modules.mercurial.util.HgRepositoryContextCache;
import org.netbeans.modules.mercurial.util.HgUtils;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class PullAction
extends ContextAction {
    private static final String CHANGESET_FILES_PREFIX = "files:";

    @Override
    protected boolean enable(Node[] nodes) {
        VCSContext context = HgUtils.getCurrentContext(nodes);
        return HgUtils.isFromHgRepository(context);
    }

    @Override
    protected String getBaseName(Node[] nodes) {
        return "CTL_MenuItem_PullLocal";
    }

    @Override
    public String getName(String role, Node[] activatedNodes) {
        VCSContext ctx = HgUtils.getCurrentContext(activatedNodes);
        Set<File> roots = HgUtils.getRepositoryRoots(ctx);
        String name = roots.size() == 1 ? "CTL_MenuItem_PullRoot" : "CTL_MenuItem_PullLocal";
        return roots.size() == 1 ? NbBundle.getMessage(PullAction.class, (String)name, (Object)roots.iterator().next().getName()) : NbBundle.getMessage(PullAction.class, (String)name);
    }

    @Override
    protected void performContextAction(Node[] nodes) {
        final VCSContext context = HgUtils.getCurrentContext(nodes);
        final Set<File> repositoryRoots = HgUtils.getRepositoryRoots(context);
        Mercurial.getInstance().getRequestProcessor().post(new Runnable(){

            @Override
            public void run() {
                Iterator i$ = repositoryRoots.iterator();
                while (i$.hasNext()) {
                    File repositoryRoot;
                    final File repository = repositoryRoot = (File)i$.next();
                    final boolean[] canceled = new boolean[1];
                    RequestProcessor rp = Mercurial.getInstance().getRequestProcessor(repository);
                    HgProgressSupport support = new HgProgressSupport(){

                        @Override
                        public void perform() {
                            PullAction.getDefaultAndPerformPull(context, repository, this.getLogger());
                            canceled[0] = this.isCanceled();
                        }
                    };
                    support.start(rp, repository, NbBundle.getMessage(PullAction.class, (String)"MSG_PULL_PROGRESS")).waitFinished();
                    if (!canceled[0]) continue;
                    break;
                }
            }
        });
    }

    public static boolean confirmWithLocalChanges(File rootFile, Class bundleLocation, String title, String query, List<String> listIncoming, OutputLogger logger) {
        FileStatusCache cache = Mercurial.getInstance().getFileStatusCache();
        File[] roots = new File[]{rootFile};
        File[] localModNewFiles = cache.listFiles(roots, 84);
        ArrayList<String> listIncomingAndLocalMod = new ArrayList<String>();
        HashSet<String> setFiles = new HashSet<String>();
        String root = rootFile.getAbsolutePath();
        for (String s : listIncoming) {
            String filesStr;
            String[] aFileStr;
            String[] arr$;
            int len$;
            int i$;
            if (s.indexOf(CHANGESET_FILES_PREFIX) != 0 || (i$ = 0) >= (len$ = (arr$ = (aFileStr = (filesStr = s.substring(CHANGESET_FILES_PREFIX.length()).trim()).split(" "))).length)) continue;
            String fileStr = arr$[i$];
            setFiles.add(root + File.separator + fileStr);
        }
        for (File f : localModNewFiles) {
            for (String s : setFiles) {
                if (!s.equals(f.getAbsolutePath())) continue;
                listIncomingAndLocalMod.add(s);
            }
        }
        if (listIncomingAndLocalMod != null && listIncomingAndLocalMod.size() > 0) {
            logger.outputInRed(NbBundle.getMessage(PullAction.class, (String)"MSG_PULL_OVERWRITE_LOCAL"));
            logger.output(listIncomingAndLocalMod);
            int response = JOptionPane.showOptionDialog(null, NbBundle.getMessage((Class)bundleLocation, (String)query), NbBundle.getMessage((Class)bundleLocation, (String)title), 0, 3, null, null, null);
            if (response == 1) {
                return false;
            }
        }
        return true;
    }

    static void annotateChangeSets(List<String> list, Class bundleLocation, String title, OutputLogger logger) {
        logger.outputInRed(NbBundle.getMessage((Class)bundleLocation, (String)title));
        for (String s : list) {
            if (s.indexOf("changeset:") == 0) {
                logger.outputInRed(s);
                continue;
            }
            if (s.equals("")) continue;
            logger.output(s);
        }
        logger.output("");
    }

    static void getDefaultAndPerformPull(VCSContext ctx, File root, OutputLogger logger) {
        PullType pullType;
        String fromPrjName;
        HgURL pullSource;
        String pullSourceString = HgRepositoryContextCache.getInstance().getPullDefault(root);
        if (HgUtils.isNullOrEmpty(pullSourceString)) {
            PullAction.notifyDefaultPullUrlNotSpecified(logger);
            return;
        }
        try {
            pullSource = new HgURL(pullSourceString);
        }
        catch (URISyntaxException ex) {
            PullAction.notifyDefaultPullUrlInvalid(pullSourceString, ex.getReason(), logger);
            return;
        }
        if (pullSource.isFile()) {
            fromPrjName = HgProjectUtils.getProjectName(new File(pullSource.getPath()));
            pullType = fromPrjName != null ? PullType.LOCAL : PullType.OTHER;
        } else {
            fromPrjName = null;
            pullType = PullType.OTHER;
        }
        String toPrjName = HgProjectUtils.getProjectName(root);
        PullAction.performPull(pullType, ctx, root, pullSource, fromPrjName, toPrjName, logger);
    }

    private static void notifyDefaultPullUrlNotSpecified(OutputLogger logger) {
        String title = PullAction.getMessage("MSG_PULL_TITLE", new String[0]);
        logger.outputInRed(title);
        logger.outputInRed(PullAction.getMessage("MSG_PULL_TITLE_SEP", new String[0]));
        logger.output(PullAction.getMessage("MSG_NO_DEFAULT_PULL_SET_MSG", new String[0]));
        logger.outputInRed(PullAction.getMessage("MSG_PULL_DONE", new String[0]));
        logger.output("");
        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)PullAction.getMessage("MSG_NO_DEFAULT_PULL_SET", new String[0])));
    }

    private static void notifyDefaultPullUrlInvalid(String pullUrl, String reason, OutputLogger logger) {
        String title = PullAction.getMessage("MSG_PULL_TITLE", new String[0]);
        String msg = PullAction.getMessage("MSG_DEFAULT_PULL_INVALID", pullUrl);
        logger.outputInRed(title);
        logger.outputInRed(PullAction.getMessage("MSG_PULL_TITLE_SEP", new String[0]));
        logger.output(msg);
        logger.outputInRed(PullAction.getMessage("MSG_PULL_DONE", new String[0]));
        logger.output("");
        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)msg));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void performPull(PullType type, VCSContext ctx, File root, HgURL pullSource, String fromPrjName, String toPrjName, OutputLogger logger) {
        if (root == null || pullSource == null) {
            return;
        }
        File bundleFile = null;
        try {
            List<String> listIncoming;
            logger.outputInRed(NbBundle.getMessage(PullAction.class, (String)"MSG_PULL_TITLE"));
            logger.outputInRed(NbBundle.getMessage(PullAction.class, (String)"MSG_PULL_TITLE_SEP"));
            if (fromPrjName != null) {
                logger.outputInRed(NbBundle.getMessage(PullAction.class, (String)"MSG_PULLING_FROM", (Object)fromPrjName, (Object)HgUtils.stripDoubleSlash(pullSource.toString())));
            } else {
                logger.outputInRed(NbBundle.getMessage(PullAction.class, (String)"MSG_PULLING_FROM_NONAME", (Object)HgUtils.stripDoubleSlash(pullSource.toString())));
            }
            if (type == PullType.LOCAL) {
                listIncoming = HgCommand.doIncoming(root, logger);
            } else {
                for (int i = 0; i < 10000; ++i) {
                    if (new File(root.getParentFile(), root.getName() + "_bundle" + i).exists()) continue;
                    bundleFile = new File(root.getParentFile(), root.getName() + "_bundle" + i);
                    break;
                }
                listIncoming = HgCommand.doIncoming(root, pullSource, bundleFile, logger, false);
            }
            if (listIncoming == null || listIncoming.isEmpty()) {
                return;
            }
            boolean bNoChanges = HgCommand.isNoChanges(listIncoming.get(listIncoming.size() - 1));
            if (!bNoChanges && !PullAction.confirmWithLocalChanges(root, PullAction.class, "MSG_PULL_LOCALMODS_CONFIRM_TITLE", "MSG_PULL_LOCALMODS_CONFIRM_QUERY", listIncoming, logger)) {
                logger.outputInRed(NbBundle.getMessage(PullAction.class, (String)"MSG_PULL_LOCALMODS_CANCEL"));
                logger.output("");
                return;
            }
            List<String> list = bNoChanges ? listIncoming : (type == PullType.LOCAL ? HgCommand.doPull(root, logger) : HgCommand.doUnbundle(root, bundleFile, logger));
            if (list != null && !list.isEmpty()) {
                List<String> headRevList;
                if (!bNoChanges) {
                    PullAction.annotateChangeSets(HgUtils.replaceHttpPassword(listIncoming), PullAction.class, "MSG_CHANGESETS_TO_PULL", logger);
                }
                logger.output(HgUtils.replaceHttpPassword(list));
                if (fromPrjName != null) {
                    logger.outputInRed(NbBundle.getMessage(PullAction.class, (String)"MSG_PULL_FROM", (Object)fromPrjName, (Object)HgUtils.stripDoubleSlash(pullSource.toString())));
                } else {
                    logger.outputInRed(NbBundle.getMessage(PullAction.class, (String)"MSG_PULL_FROM_NONAME", (Object)HgUtils.stripDoubleSlash(pullSource.toString())));
                }
                if (toPrjName != null) {
                    logger.outputInRed(NbBundle.getMessage(PullAction.class, (String)"MSG_PULL_TO", (Object)toPrjName, (Object)root));
                } else {
                    logger.outputInRed(NbBundle.getMessage(PullAction.class, (String)"MSG_PULL_TO_NONAME", (Object)root));
                }
                boolean bMergeNeededDueToPull = HgCommand.isMergeNeededMsg(list.get(list.size() - 1));
                boolean bConfirmMerge = false;
                boolean checkHeads = false;
                if (bMergeNeededDueToPull) {
                    bConfirmMerge = HgUtils.confirmDialog(PullAction.class, "MSG_PULL_MERGE_CONFIRM_TITLE", "MSG_PULL_MERGE_CONFIRM_QUERY");
                    checkHeads = !bConfirmMerge;
                } else {
                    boolean bOutStandingUncommittedMerges = HgCommand.isMergeAbortUncommittedMsg(list.get(list.size() - 1));
                    if (bOutStandingUncommittedMerges) {
                        bConfirmMerge = HgUtils.confirmDialog(PullAction.class, "MSG_PULL_MERGE_CONFIRM_TITLE", "MSG_PULL_MERGE_UNCOMMITTED_CONFIRM_QUERY");
                    }
                }
                if (bConfirmMerge) {
                    logger.output("");
                    logger.outputInRed(NbBundle.getMessage(PullAction.class, (String)"MSG_PULL_MERGE_DO"));
                    MergeAction.doMergeAction(root, null, logger);
                } else if (checkHeads && (headRevList = HgCommand.getHeadRevisions(root)) != null && headRevList.size() > 1) {
                    MergeAction.printMergeWarning(headRevList, logger);
                }
            }
            if (!bNoChanges) {
                HgUtils.notifyUpdatedFiles(root, list);
                HgUtils.forceStatusRefresh(root);
            }
        }
        catch (HgException.HgCommandCanceledException ex) {
        }
        catch (HgException ex) {
            NotifyDescriptor.Exception e = new NotifyDescriptor.Exception((Throwable)ex);
            DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)e);
        }
        finally {
            if (bundleFile != null) {
                bundleFile.delete();
            }
            logger.outputInRed(NbBundle.getMessage(PullAction.class, (String)"MSG_PULL_DONE"));
            logger.output("");
            pullSource.clearPassword();
        }
    }

    private static String getMessage(String msgKey, String ... args) {
        return NbBundle.getMessage(PullAction.class, (String)msgKey, (Object[])args);
    }

    public static enum PullType {
        LOCAL,
        OTHER;

    }
}

