/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.deployment.plugins.api;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import javax.enterprise.deploy.spi.DeploymentManager;
import org.netbeans.modules.j2ee.deployment.impl.InstancePropertiesImpl;
import org.netbeans.modules.j2ee.deployment.impl.ServerInstance;
import org.netbeans.modules.j2ee.deployment.impl.ServerRegistry;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceCreationException;

public abstract class InstanceProperties {
    public static final String URL_ATTR = "url";
    public static final String USERNAME_ATTR = "username";
    public static final String PASSWORD_ATTR = "password";
    public static final String DISPLAY_NAME_ATTR = "displayName";
    public static final String REMOVE_FORBIDDEN = "removeForbidden";
    public static final String HTTP_PORT_NUMBER = "httpportnumber";
    public static final String STARTUP_TIMEOUT = "startupTimeout";
    public static final String SHUTDOWN_TIMEOUT = "shutdownTimeout";
    public static final String REGISTERED_WITHOUT_UI = "registeredWithoutUI";
    public static final String DEPLOYMENT_TIMEOUT = "deploymentTimeout";
    private final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    public static InstanceProperties getInstanceProperties(String url) {
        ServerInstance inst = ServerRegistry.getInstance().getServerInstance(url);
        if (inst == null) {
            return null;
        }
        return inst.getInstanceProperties();
    }

    public static InstanceProperties createInstanceProperties(String url, String username, String password) throws InstanceCreationException {
        return InstanceProperties.createInstanceProperties(url, username, password, null);
    }

    public static InstanceProperties createInstanceProperties(String url, String username, String password, String displayName) throws InstanceCreationException {
        return InstanceProperties.createInstanceProperties(url, username, password, displayName, null);
    }

    public static InstanceProperties createInstanceProperties(String url, String username, String password, String displayName, Map<String, String> initialProperties) throws InstanceCreationException {
        ServerRegistry registry = ServerRegistry.getInstance();
        registry.addInstance(url, username, password, displayName, false, initialProperties);
        ServerInstance inst = registry.getServerInstance(url);
        InstancePropertiesImpl ip = inst.getInstanceProperties();
        return ip;
    }

    public static InstanceProperties createInstancePropertiesWithoutUI(String url, String username, String password, String displayName, Map<String, String> initialProperties) throws InstanceCreationException {
        ServerRegistry registry = ServerRegistry.getInstance();
        registry.addInstance(url, username, password, displayName, true, initialProperties);
        ServerInstance inst = registry.getServerInstance(url);
        InstancePropertiesImpl ip = inst.getInstanceProperties();
        return ip;
    }

    public static void removeInstance(String url) {
        ServerRegistry.getInstance().removeServerInstance(url);
    }

    public static String[] getInstanceList() {
        return ServerRegistry.getInstance().getInstanceURLs();
    }

    public abstract void setProperties(Properties var1) throws IllegalStateException;

    public abstract void setProperty(String var1, String var2) throws IllegalStateException;

    public abstract String getProperty(String var1) throws IllegalStateException;

    public abstract Enumeration propertyNames() throws IllegalStateException;

    public abstract DeploymentManager getDeploymentManager();

    public abstract void refreshServerInstance();

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    protected void firePropertyChange(PropertyChangeEvent evt) {
        this.propertyChangeSupport.firePropertyChange(evt);
    }
}

