/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.deployment.impl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.deploy.shared.CommandType;
import javax.enterprise.deploy.spi.TargetModuleID;
import org.netbeans.modules.j2ee.deployment.common.api.EjbChangeDescriptor;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeApplication;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.api.ModuleChangeReporter;
import org.netbeans.modules.j2ee.deployment.devmodules.api.ResourceChangeReporter;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.ArtifactListener;
import org.netbeans.modules.j2ee.deployment.execution.DeploymentTarget;
import org.netbeans.modules.j2ee.deployment.impl.ChangeDescriptorAccessor;
import org.netbeans.modules.j2ee.deployment.impl.ServerInstance;
import org.netbeans.modules.j2ee.deployment.impl.TargetModule;
import org.netbeans.modules.j2ee.deployment.plugins.api.AppChangeDescriptor;
import org.netbeans.modules.j2ee.deployment.plugins.api.DeploymentChangeDescriptor;
import org.netbeans.modules.j2ee.deployment.plugins.api.ServerProgress;
import org.netbeans.modules.j2ee.deployment.plugins.spi.IncrementalDeployment;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class ServerFileDistributor
extends ServerProgress {
    private final ServerInstance instance;
    private final DeploymentTarget dtarget;
    private final IncrementalDeployment incremental;
    private Iterator rootModuleFiles;
    private Map childModuleFiles;
    private Map childModuleMap;
    private static final Logger LOGGER = Logger.getLogger(ServerFileDistributor.class.getName());
    static Map j2eeTypeMap = null;

    public ServerFileDistributor(ServerInstance instance, DeploymentTarget dtarget) {
        super(instance);
        this.instance = instance;
        this.dtarget = dtarget;
        this.incremental = instance.getIncrementalDeployment();
        try {
            J2eeModule source = dtarget.getModule();
            this.rootModuleFiles = source.getArchiveContents();
            if (source instanceof J2eeApplication) {
                this.childModuleFiles = new HashMap();
                this.childModuleMap = new HashMap();
                J2eeModule[] childModules = ((J2eeApplication)source).getModules();
                for (int i = 0; i < childModules.length; ++i) {
                    Iterator contents = childModules[i].getArchiveContents();
                    if (contents != null) {
                        this.childModuleFiles.put(childModules[i].getUrl(), contents);
                    }
                    this.childModuleMap.put(childModules[i].getUrl(), childModules[i]);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static synchronized List getDescriptorPath(J2eeModule module) {
        if (j2eeTypeMap == null) {
            j2eeTypeMap = new HashMap();
            j2eeTypeMap.put(J2eeModule.Type.EJB, Arrays.asList("META-INF/ejb-jar.xml", "META-INF/webservices.xml"));
            j2eeTypeMap.put(J2eeModule.Type.WAR, Arrays.asList("WEB-INF/web.xml", "WEB-INF/webservices.xml"));
            j2eeTypeMap.put(J2eeModule.Type.CAR, Arrays.asList("META-INF/application-client.xml"));
            j2eeTypeMap.put(J2eeModule.Type.RAR, Arrays.asList("META-INF/ra.xml"));
            j2eeTypeMap.put(J2eeModule.Type.EAR, Arrays.asList("META-INF/application.xml"));
        }
        return (List)j2eeTypeMap.get(module.getType());
    }

    private J2eeModule getJ2eeModule(TargetModuleID target) {
        if (target.getParentTargetModuleID() == null) {
            return this.dtarget.getModule();
        }
        String moduleUrl = this.incremental.getModuleUrl(target);
        return (J2eeModule)this.childModuleMap.get(moduleUrl);
    }

    private AppChanges createModuleChangeDescriptor(TargetModuleID target) {
        J2eeModule module = this.getJ2eeModule(target);
        List descriptorRelativePaths = ServerFileDistributor.getDescriptorPath(module);
        J2eeModule.Type moduleType = module.getType();
        List<String> serverDescriptorRelativePaths = Arrays.asList(this.instance.getServer().getDeploymentPlanFiles(moduleType));
        return new AppChanges(descriptorRelativePaths, serverDescriptorRelativePaths, moduleType);
    }

    public DeploymentChangeDescriptor distribute(TargetModule targetModule, ModuleChangeReporter mcr, ResourceChangeReporter rcr) throws IOException {
        long lastDeployTime = targetModule.getTimestamp();
        TargetModuleID[] childModules = targetModule.getChildTargetModuleID();
        AppChanges changes = new AppChanges();
        File destDir = null;
        for (int i = 0; childModules != null && i < childModules.length; ++i) {
            String url = this.incremental.getModuleUrl(childModules[i]);
            destDir = this.incremental.getDirectoryForModule(childModules[i]);
            Iterator source = (Iterator)this.childModuleFiles.get(url);
            if (destDir == null) {
                changes.record(this._distribute(childModules[i], lastDeployTime));
                continue;
            }
            if (null == source) continue;
            changes.record(this._distribute(source, destDir, childModules[i], lastDeployTime));
        }
        destDir = this.incremental.getDirectoryForModule(targetModule.delegate());
        if (destDir == null) {
            changes.record(this._distribute(targetModule.delegate(), lastDeployTime));
        } else {
            changes.record(this._distribute(this.rootModuleFiles, destDir, targetModule.delegate(), lastDeployTime));
        }
        if (mcr != null) {
            changes.record(mcr, lastDeployTime);
        }
        DeploymentChangeDescriptor descr = ChangeDescriptorAccessor.getDefault().newDescriptor(changes);
        if (rcr != null && rcr.isServerResourceChanged(lastDeployTime)) {
            descr = ChangeDescriptorAccessor.getDefault().withChangedServerResources(descr);
        }
        this.setStatusDistributeCompleted(NbBundle.getMessage(ServerFileDistributor.class, (String)"MSG_DoneIncrementalDeploy", (Object)targetModule.getModuleID()));
        return descr;
    }

    public DeploymentChangeDescriptor distributeOnSave(TargetModule targetModule, ModuleChangeReporter mcr, ResourceChangeReporter rcr, Iterable<ArtifactListener.Artifact> artifacts) throws IOException {
        long lastDeployTime = targetModule.getTimestamp();
        TargetModuleID[] childModules = targetModule.getChildTargetModuleID();
        AppChanges changes = new AppChanges();
        File destDir = null;
        for (int i = 0; childModules != null && i < childModules.length; ++i) {
            String url = this.incremental.getModuleUrl(childModules[i]);
            destDir = this.incremental.getDirectoryForModule(childModules[i]);
            if (destDir == null) {
                changes.record(this._distributeOnSave(childModules[i], artifacts));
                continue;
            }
            Iterator source = (Iterator)this.childModuleFiles.get(url);
            if (source == null) continue;
            changes.record(this._distributeOnSave(destDir, childModules[i], artifacts));
        }
        destDir = this.incremental.getDirectoryForModule(targetModule.delegate());
        if (destDir == null) {
            changes.record(this._distributeOnSave(targetModule.delegate(), artifacts));
        } else {
            changes.record(this._distributeOnSave(destDir, targetModule.delegate(), artifacts));
        }
        if (mcr != null) {
            changes.record(mcr, lastDeployTime);
        }
        DeploymentChangeDescriptor descr = ChangeDescriptorAccessor.getDefault().newDescriptor(changes);
        if (rcr != null && rcr.isServerResourceChanged(lastDeployTime)) {
            descr = ChangeDescriptorAccessor.getDefault().withChangedServerResources(descr);
        }
        this.setStatusDistributeCompleted(NbBundle.getMessage(ServerFileDistributor.class, (String)"MSG_DoneIncrementalDeploy", (Object)targetModule.getModuleID()));
        return descr;
    }

    private AppChanges _distribute(TargetModuleID target, long lastDeployTime) throws IOException {
        AppChanges mc = this.createModuleChangeDescriptor(target);
        this.setStatusDistributeRunning(NbBundle.getMessage(ServerFileDistributor.class, (String)"MSG_RunningIncrementalDeploy", (Object)target));
        Iterator content = this.getJ2eeModule(target).getArchiveContents();
        Date lastDeployed = new Date(lastDeployTime);
        while (content.hasNext()) {
            J2eeModule.RootedEntry re = (J2eeModule.RootedEntry)content.next();
            FileObject file = re.getFileObject();
            if (file.isFolder()) continue;
            file.refresh();
            if (!file.lastModified().after(lastDeployed)) continue;
            String relativePath = re.getRelativePath();
            mc.record(relativePath);
        }
        return mc;
    }

    private AppChanges _distributeOnSave(TargetModuleID target, Iterable<ArtifactListener.Artifact> artifacts) throws IOException {
        AppChanges mc = this.createModuleChangeDescriptor(target);
        this.setStatusDistributeRunning(NbBundle.getMessage(ServerFileDistributor.class, (String)"MSG_RunningIncrementalDeploy", (Object)target));
        FileObject contentDirectory = this.getJ2eeModule(target).getContentDirectory();
        assert (contentDirectory != null);
        File destDir = FileUtil.toFile((FileObject)contentDirectory);
        assert (destDir != null);
        boolean fullMachinery = false;
        for (ArtifactListener.Artifact artifact : artifacts) {
            if (artifact.getDistributionPath() == null) continue;
            fullMachinery = true;
            break;
        }
        if (fullMachinery) {
            return this._distributeOnSave(destDir, target, artifacts);
        }
        for (ArtifactListener.Artifact artifact : artifacts) {
            String relative;
            File fsFile = artifact.getFile();
            FileObject file = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)fsFile));
            if (file == null || file.isFolder() || (relative = FileUtil.getRelativePath((FileObject)contentDirectory, (FileObject)file)) == null) continue;
            mc.record(destDir, relative);
        }
        return mc;
    }

    private AppChanges _distribute(Iterator source, File destDir, TargetModuleID target, long lastDeployTime) throws IOException {
        AppChanges mc = this.createModuleChangeDescriptor(target);
        if (source == null) {
            Logger.getLogger("global").log(Level.SEVERE, "There is no contents for " + target);
            throw new IOException(NbBundle.getMessage(ServerFileDistributor.class, (String)"MSG_NoContents", (Object)target));
        }
        this.setStatusDistributeRunning(NbBundle.getMessage(ServerFileDistributor.class, (String)"MSG_RunningIncrementalDeploy", (Object)target));
        try {
            File dir = this.incremental.getDirectoryForModule(target);
            FileObject destRoot = FileUtil.createFolder((File)destDir);
            Enumeration destFiles = destRoot.getChildren(true);
            HashMap<String, FileObject> destMap = new HashMap<String, FileObject>();
            int rootPathLen = destRoot.getPath().length();
            while (destFiles.hasMoreElements()) {
                FileObject destFO = (FileObject)destFiles.nextElement();
                destMap.put(destFO.getPath().substring(rootPathLen + 1), destFO);
            }
            Iterator j = source;
            while (j.hasNext()) {
                J2eeModule.RootedEntry entry = (J2eeModule.RootedEntry)j.next();
                String relativePath = entry.getRelativePath();
                FileObject sourceFO = entry.getFileObject();
                FileObject targetFO = (FileObject)destMap.get(relativePath);
                if (sourceFO.isFolder()) {
                    destMap.remove(relativePath);
                    continue;
                }
                ServerFileDistributor.createOrReplace(sourceFO, targetFO, destRoot, relativePath, mc, destMap, true, lastDeployTime);
            }
            J2eeModule.Type moduleType = this.dtarget.getModule().getType();
            String[] rPaths = this.instance.getServer().getDeploymentPlanFiles(moduleType);
            File configFile = this.dtarget.getConfigurationFile();
            if (rPaths == null || rPaths.length == 0) {
                return mc;
            }
            File[] paths = new File[rPaths.length];
            for (int n = 0; null != configFile && n < rPaths.length; ++n) {
                paths[n] = new File(FileUtil.toFile((FileObject)destRoot), rPaths[n]);
                if (null == paths[n] || !paths[n].exists() || paths[n].lastModified() <= configFile.lastModified()) continue;
                mc.record(rPaths[n]);
            }
            return mc;
        }
        catch (Exception e) {
            String msg = NbBundle.getMessage(ServerFileDistributor.class, (String)"MSG_IncrementalDeployFailed", (Object)e);
            this.setStatusDistributeFailed(msg);
            throw new RuntimeException(msg, e);
        }
    }

    private AppChanges _distributeOnSave(File destDir, TargetModuleID target, Iterable<ArtifactListener.Artifact> artifacts) throws IOException {
        AppChanges mc = this.createModuleChangeDescriptor(target);
        this.setStatusDistributeRunning(NbBundle.getMessage(ServerFileDistributor.class, (String)"MSG_RunningIncrementalDeploy", (Object)target));
        try {
            FileObject destRoot = FileUtil.createFolder((File)destDir);
            Enumeration destFiles = destRoot.getChildren(true);
            HashMap<String, FileObject> destMap = new HashMap<String, FileObject>();
            int rootPathLen = destRoot.getPath().length();
            while (destFiles.hasMoreElements()) {
                FileObject destFO = (FileObject)destFiles.nextElement();
                destMap.put(destFO.getPath().substring(rootPathLen + 1), destFO);
            }
            FileObject contentDirectory = this.getJ2eeModule(target).getContentDirectory();
            assert (contentDirectory != null);
            for (ArtifactListener.Artifact artifact : artifacts) {
                String relative;
                File fsFile = artifact.getFile();
                File altDistPath = artifact.getDistributionPath();
                FileObject file = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)fsFile));
                FileObject checkFile = null;
                if (altDistPath != null) {
                    checkFile = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)altDistPath));
                    if (checkFile == null && file != null) {
                        checkFile = FileUtil.createData((File)altDistPath);
                    }
                } else {
                    checkFile = file;
                }
                if (checkFile == null || file == null || (relative = FileUtil.getRelativePath((FileObject)contentDirectory, (FileObject)checkFile)) == null) continue;
                FileObject targetFO = (FileObject)destMap.get(relative);
                if (file.isFolder()) {
                    destMap.remove(relative);
                    continue;
                }
                ServerFileDistributor.createOrReplace(file, targetFO, destRoot, relative, mc, destMap, false, 0L);
            }
            J2eeModule.Type moduleType = this.dtarget.getModule().getType();
            String[] rPaths = this.instance.getServer().getDeploymentPlanFiles(moduleType);
            File configFile = this.dtarget.getConfigurationFile();
            if (rPaths == null || rPaths.length == 0) {
                return mc;
            }
            File[] paths = new File[rPaths.length];
            for (int n = 0; n < rPaths.length; ++n) {
                File dest = FileUtil.toFile((FileObject)destRoot);
                assert (dest != null);
                paths[n] = new File(dest, rPaths[n]);
                if (!paths[n].exists() || paths[n].lastModified() <= configFile.lastModified()) continue;
                mc.record(dest, rPaths[n]);
            }
            return mc;
        }
        catch (Exception e) {
            String msg = NbBundle.getMessage(ServerFileDistributor.class, (String)"MSG_IncrementalDeployFailed", (Object)e);
            this.setStatusDistributeFailed(msg);
            throw new RuntimeException(msg, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createOrReplace(FileObject sourceFO, FileObject targetFO, FileObject destRoot, String relativePath, AppChanges mc, Map destMap, boolean checkTimeStamps, long lastDeployTime) throws IOException {
        OutputStream destStream = null;
        InputStream sourceStream = null;
        File dest = FileUtil.toFile((FileObject)destRoot);
        Date ldDate = new Date(lastDeployTime);
        try {
            FileObject destFolder;
            if (null == targetFO) {
                targetFO = destRoot.getFileObject(relativePath);
            }
            if (targetFO == null) {
                destFolder = ServerFileDistributor.findOrCreateParentFolder(destRoot, relativePath);
            } else {
                destMap.remove(relativePath);
                if (targetFO.equals(sourceFO) && targetFO.lastModified().after(ldDate)) {
                    mc.record(dest, relativePath);
                }
                if (checkTimeStamps && !sourceFO.lastModified().after(targetFO.lastModified())) {
                    return;
                }
                if (targetFO.equals(sourceFO)) {
                    mc.record(dest, relativePath);
                    return;
                }
                destFolder = targetFO.getParent();
                destStream = targetFO.getOutputStream();
            }
            mc.record(dest, relativePath);
            if (null == destStream) {
                FileUtil.copyFile((FileObject)sourceFO, (FileObject)destFolder, (String)sourceFO.getName());
            } else {
                sourceStream = sourceFO.getInputStream();
                FileUtil.copy((InputStream)sourceStream, (OutputStream)destStream);
            }
        }
        finally {
            if (null != sourceStream) {
                try {
                    sourceStream.close();
                }
                catch (IOException ioe) {
                    LOGGER.log(Level.WARNING, null, ioe);
                }
            }
            if (null != destStream) {
                try {
                    destStream.close();
                }
                catch (IOException ioe) {
                    LOGGER.log(Level.WARNING, null, ioe);
                }
            }
        }
    }

    public static FileObject findOrCreateParentFolder(FileObject dest, String relativePath) throws IOException {
        File parentRelativePath = new File(relativePath).getParentFile();
        if (parentRelativePath == null) {
            return dest;
        }
        FileObject folder = FileUtil.createFolder((FileObject)dest, (String)parentRelativePath.getPath());
        if (folder.isData()) {
            Logger.getLogger(ServerFileDistributor.class.getName()).finer("found file " + folder.getPath() + "when a folder was expecetd");
            folder = null;
        }
        return folder;
    }

    private void setStatusDistributeRunning(String message) {
        this.notify(this.createRunningProgressEvent(CommandType.DISTRIBUTE, message));
    }

    private void setStatusDistributeFailed(String message) {
        this.notify(this.createFailedProgressEvent(CommandType.DISTRIBUTE, message));
    }

    private void setStatusDistributeCompleted(String message) {
        this.notify(this.createCompletedProgressEvent(CommandType.DISTRIBUTE, message));
    }

    public static final class AppChanges
    implements AppChangeDescriptor {
        private boolean descriptorChanged = false;
        private boolean serverDescriptorChanged = false;
        private boolean classesChanged = false;
        private boolean manifestChanged = false;
        private boolean ejbsChanged = false;
        private List changedEjbs = Collections.EMPTY_LIST;
        private J2eeModule.Type moduleType = null;
        private List changedFiles = new ArrayList();
        private List descriptorRelativePaths;
        private List serverDescriptorRelativePaths;

        AppChanges() {
        }

        AppChanges(List descriptorRelativePaths, List serverDescriptorRelativePaths, J2eeModule.Type moduleType) {
            this.descriptorRelativePaths = descriptorRelativePaths;
            this.serverDescriptorRelativePaths = serverDescriptorRelativePaths;
            this.moduleType = moduleType;
        }

        private void record(AppChanges changes) {
            List<String> ejbs;
            if (!this.descriptorChanged) {
                this.descriptorChanged = changes.descriptorChanged();
            }
            if (!this.serverDescriptorChanged) {
                this.serverDescriptorChanged = changes.serverDescriptorChanged();
            }
            if (!this.classesChanged) {
                this.classesChanged = changes.classesChanged();
            }
            if (!this.manifestChanged) {
                this.manifestChanged = changes.manifestChanged();
            }
            if (!this.ejbsChanged) {
                this.ejbsChanged = changes.ejbsChanged();
            }
            if ((ejbs = Arrays.asList(changes.getChangedEjbs())).size() > 0) {
                this.changedEjbs.addAll(ejbs);
            }
            this.changedFiles.addAll(changes.changedFiles);
        }

        private void record(String relativePath) {
            this.record(null, relativePath);
        }

        private void record(File destDir, String relativePath) {
            if (destDir != null) {
                this.changedFiles.add(new File(destDir, relativePath));
            } else {
                this.changedFiles.add(new File(relativePath));
            }
            if (!this.classesChanged) {
                boolean libs;
                boolean classes;
                boolean bl = classes = !J2eeModule.Type.WAR.equals(this.moduleType) && !relativePath.startsWith("META-INF") || relativePath.startsWith("WEB-INF/classes/");
                if (J2eeModule.Type.EAR.equals(this.moduleType)) {
                    classes = false;
                }
                boolean importantLib = !J2eeModule.Type.WAR.equals(this.moduleType) || relativePath.startsWith("WEB-INF/lib/");
                boolean bl2 = libs = importantLib && (relativePath.endsWith(".jar") || relativePath.endsWith(".zip"));
                if (classes || libs) {
                    this.classesChanged = true;
                    return;
                }
            }
            if (!this.descriptorChanged && (this.descriptorRelativePaths != null && this.descriptorRelativePaths.contains(relativePath) || relativePath.startsWith("WEB-INF") && (relativePath.endsWith(".tld") || relativePath.endsWith(".xml") || relativePath.endsWith(".dtd")))) {
                this.descriptorChanged = true;
                return;
            }
            if (!this.serverDescriptorChanged && this.serverDescriptorRelativePaths != null && this.serverDescriptorRelativePaths.contains(relativePath)) {
                this.serverDescriptorChanged = true;
                return;
            }
            if (!this.manifestChanged && relativePath.equals("META-INF/MANIFEST.MF")) {
                this.manifestChanged = true;
                return;
            }
        }

        private void record(ModuleChangeReporter mcr, long since) {
            EjbChangeDescriptor ecd = mcr.getEjbChanges(since);
            this.ejbsChanged = ecd.ejbsChanged();
            String[] ejbs = ecd.getChangedEjbs();
            if (ejbs != null && ejbs.length > 0) {
                this.changedEjbs.addAll(Arrays.asList(ejbs));
            }
            if (!this.manifestChanged) {
                this.manifestChanged = mcr.isManifestChanged(since);
            }
        }

        @Override
        public boolean classesChanged() {
            return this.classesChanged;
        }

        @Override
        public boolean descriptorChanged() {
            return this.descriptorChanged;
        }

        @Override
        public boolean manifestChanged() {
            return this.manifestChanged;
        }

        @Override
        public boolean serverDescriptorChanged() {
            return this.serverDescriptorChanged;
        }

        @Override
        public boolean ejbsChanged() {
            return this.ejbsChanged;
        }

        @Override
        public String[] getChangedEjbs() {
            return this.changedEjbs.toArray(new String[0]);
        }

        @Override
        public File[] getChangedFiles() {
            return this.changedFiles.toArray(new File[this.changedFiles.size()]);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append(super.toString());
            builder.append(" [");
            for (File file : this.getChangedFiles()) {
                builder.append(file.getAbsolutePath()).append(", ");
            }
            if (this.getChangedFiles().length > 0) {
                builder.setLength(builder.length() - 2);
            }
            builder.append("], ");
            builder.append("classesChanged=").append(this.classesChanged());
            builder.append(", ");
            builder.append("descriptorChanged=").append(this.descriptorChanged());
            builder.append(", ");
            builder.append("ejbsChanged=").append(this.ejbsChanged());
            builder.append(", ");
            builder.append("manifestChanged=").append(this.manifestChanged());
            builder.append(", ");
            builder.append("serverDescriptorChanged=").append(this.serverDescriptorChanged());
            return builder.toString();
        }
    }
}

