/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.deployment.impl;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.deploy.shared.ModuleType;
import javax.enterprise.deploy.shared.factories.DeploymentFactoryManager;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.exceptions.DeploymentManagerCreationException;
import javax.enterprise.deploy.spi.factories.DeploymentFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.netbeans.modules.j2ee.deployment.common.api.ValidationException;
import org.netbeans.modules.j2ee.deployment.config.J2eeModuleAccessor;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.impl.ServerInstance;
import org.netbeans.modules.j2ee.deployment.impl.ServerRegistry;
import org.netbeans.modules.j2ee.deployment.impl.gen.nbd.ConfigBean;
import org.netbeans.modules.j2ee.deployment.impl.gen.nbd.NetbeansDeployment;
import org.netbeans.modules.j2ee.deployment.impl.gen.nbd.WebContextRoot;
import org.netbeans.modules.j2ee.deployment.impl.ui.RegistryNodeProvider;
import org.netbeans.modules.j2ee.deployment.plugins.spi.J2eePlatformFactory;
import org.netbeans.modules.j2ee.deployment.plugins.spi.OptionalDeploymentManagerFactory;
import org.netbeans.modules.j2ee.deployment.plugins.spi.RegistryNodeFactory;
import org.netbeans.modules.j2ee.deployment.plugins.spi.VerifierSupport;
import org.netbeans.modules.j2ee.deployment.plugins.spi.config.ModuleConfigurationFactory;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;
import org.xml.sax.SAXException;

public class Server
implements Node.Cookie {
    private static final Logger LOGGER = Logger.getLogger(Server.class.getName());
    private static final String ATTR_NEEDS_FIND_SERVER_UI = "needsFindServerUI";
    private final NetbeansDeployment dep;
    private final Class factoryCls;
    private final String name;
    private final Lookup lkp;
    private final boolean needsFindServerUI;
    private DeploymentFactory factory = null;
    private DeploymentManager manager = null;
    private RegistryNodeProvider nodeProvider = null;
    private static final String LAYER_DEPLOYMENT_FILE_NAMES = "DeploymentFileNames";
    private Map deployConfigDescriptorMap;

    Server(FileObject fo) throws IOException, ParserConfigurationException, SAXException, ClassNotFoundException {
        this.initDeploymentConfigurationFileList(fo);
        this.name = fo.getName();
        FileObject descriptor = fo.getFileObject("Descriptor");
        assert (descriptor != null);
        this.needsFindServerUI = Server.getBooleanValue(descriptor.getAttribute(ATTR_NEEDS_FIND_SERVER_UI), false);
        this.dep = NetbeansDeployment.createGraph(descriptor.getInputStream());
        this.lkp = Lookups.forPath((String)fo.getPath());
        this.factory = (DeploymentFactory)this.lkp.lookup(DeploymentFactory.class);
        if (this.factory != null) {
            this.factoryCls = this.factory.getClass();
        } else {
            FileObject factoryinstance = fo.getFileObject("Factory.instance");
            if (factoryinstance == null) {
                String msg = NbBundle.getMessage(Server.class, (String)"MSG_NoFactoryInstanceClass", (Object)this.name);
                LOGGER.log(Level.SEVERE, msg);
                this.factoryCls = null;
                return;
            }
            DataObject dobj = DataObject.find((FileObject)factoryinstance);
            InstanceCookie cookie = (InstanceCookie)dobj.getCookie(InstanceCookie.class);
            if (cookie == null) {
                String msg = NbBundle.getMessage(Server.class, (String)"MSG_FactoryFailed", (Object)this.name);
                LOGGER.log(Level.SEVERE, msg);
                this.factoryCls = null;
                return;
            }
            this.factoryCls = cookie.instanceClass();
            try {
                this.factory = (DeploymentFactory)cookie.instanceCreate();
            }
            catch (Exception e) {
                LOGGER.log(Level.INFO, null, e);
            }
        }
    }

    private synchronized DeploymentFactory getFactory() {
        if (this.factory == null) {
            DeploymentFactory[] factories = DeploymentFactoryManager.getInstance().getDeploymentFactories();
            for (int i = 0; i < factories.length; ++i) {
                if (!this.factoryCls.isInstance(factories[i])) continue;
                this.factory = factories[i];
                break;
            }
        }
        if (this.factory == null) {
            throw new IllegalStateException("Can't acquire DeploymentFactory for " + this.name);
        }
        return this.factory;
    }

    public synchronized DeploymentManager getDisconnectedDeploymentManager() throws DeploymentManagerCreationException {
        if (this.manager == null) {
            this.manager = this.getDisconnectedDeploymentManager(this.dep.getDisconnectedString());
        }
        return this.manager;
    }

    public DeploymentManager getDisconnectedDeploymentManager(String uri) throws DeploymentManagerCreationException {
        return this.getFactory().getDisconnectedDeploymentManager(uri);
    }

    public boolean handlesUri(String uri) {
        try {
            return this.getFactory().handlesURI(uri);
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, null, e);
            return false;
        }
    }

    public DeploymentManager getDeploymentManager(String uri, String username, String password) throws DeploymentManagerCreationException {
        return this.getFactory().getDeploymentManager(uri, username, password);
    }

    public String getDisplayName() {
        return this.getFactory().getDisplayName();
    }

    public String getShortName() {
        return this.name;
    }

    public String getIconBase() {
        return this.dep.getIcon();
    }

    public boolean canDeployEars() {
        return this.dep.getContainerLimitation() == null || this.dep.getContainerLimitation().isEarDeploy();
    }

    public boolean canDeployWars() {
        return this.dep.getContainerLimitation() == null || this.dep.getContainerLimitation().isWarDeploy();
    }

    public boolean canDeployEjbJars() {
        return this.dep.getContainerLimitation() == null || this.dep.getContainerLimitation().isEjbjarDeploy();
    }

    public String getHelpId(String beanClass) {
        ConfigBean[] beans = this.dep.getConfigBean();
        for (int i = 0; i < beans.length; ++i) {
            if (!beans[i].getClassName().equals(beanClass)) continue;
            return beans[i].getHelpid();
        }
        return null;
    }

    public synchronized RegistryNodeProvider getNodeProvider() {
        if (this.nodeProvider != null) {
            return this.nodeProvider;
        }
        RegistryNodeFactory nodeFact = (RegistryNodeFactory)this.lkp.lookup(RegistryNodeFactory.class);
        if (nodeFact == null) {
            String msg = NbBundle.getMessage(Server.class, (String)"MSG_NoInstance", (Object)this.name, RegistryNodeFactory.class);
            LOGGER.log(Level.INFO, msg);
        }
        this.nodeProvider = new RegistryNodeProvider(nodeFact);
        return this.nodeProvider;
    }

    public RegistryNodeFactory getRegistryNodeFactory() {
        return (RegistryNodeFactory)this.lkp.lookup(RegistryNodeFactory.class);
    }

    public OptionalDeploymentManagerFactory getOptionalFactory() {
        OptionalDeploymentManagerFactory o = (OptionalDeploymentManagerFactory)this.lkp.lookup(OptionalDeploymentManagerFactory.class);
        return o;
    }

    public J2eePlatformFactory getJ2eePlatformFactory() {
        J2eePlatformFactory o = (J2eePlatformFactory)this.lkp.lookup(J2eePlatformFactory.class);
        return o;
    }

    public ModuleConfigurationFactory getModuleConfigurationFactory() {
        return (ModuleConfigurationFactory)this.lkp.lookup(ModuleConfigurationFactory.class);
    }

    public VerifierSupport getVerifierSupport() {
        VerifierSupport vs = (VerifierSupport)this.lkp.lookup(VerifierSupport.class);
        return vs;
    }

    public boolean canVerify(J2eeModule.Type moduleType) {
        VerifierSupport vs = this.getVerifierSupport();
        return vs != null && vs.supportsModuleType(J2eeModuleAccessor.getDefault().getJsrModuleType(moduleType));
    }

    public void verify(FileObject target, OutputStream logger) throws ValidationException {
        this.getVerifierSupport().verify(target, logger);
    }

    public ServerInstance[] getInstances() {
        ArrayList<ServerInstance> ret = new ArrayList<ServerInstance>();
        for (ServerInstance inst : ServerRegistry.getInstance().getInstances()) {
            if (!this.name.equals(inst.getServer().getShortName())) continue;
            ret.add(inst);
        }
        return ret.toArray(new ServerInstance[ret.size()]);
    }

    public WebContextRoot getWebContextRoot() {
        return this.dep.getWebContextRoot();
    }

    public DeploymentFactory getDeploymentFactory() {
        return this.getFactory();
    }

    private static boolean getBooleanValue(Object v, boolean dvalue) {
        if (v instanceof Boolean) {
            return (Boolean)v;
        }
        if (v instanceof String) {
            return Boolean.valueOf((String)v);
        }
        return dvalue;
    }

    public boolean needsFindServerUI() {
        return this.needsFindServerUI;
    }

    public String toString() {
        return this.getShortName();
    }

    public boolean supportsModuleType(J2eeModule.Type type) {
        if (J2eeModule.Type.WAR.equals(type)) {
            return this.canDeployWars();
        }
        if (J2eeModule.Type.EJB.equals(type)) {
            return this.canDeployEjbJars();
        }
        if (J2eeModule.Type.EAR.equals(type)) {
            return this.canDeployEars();
        }
        return true;
    }

    private final void initDeploymentConfigurationFileList(FileObject fo) {
        this.deployConfigDescriptorMap = new HashMap();
        FileObject deplFNames = fo.getFileObject(LAYER_DEPLOYMENT_FILE_NAMES);
        if (deplFNames != null) {
            FileObject[] mTypes = deplFNames.getChildren();
            for (int j = 0; j < mTypes.length; ++j) {
                String mTypeName = mTypes[j].getName().toUpperCase();
                FileObject[] allNames = mTypes[j].getChildren();
                if (allNames == null || allNames.length == 0) continue;
                ArrayList<String> filepaths = new ArrayList<String>();
                for (int i = 0; i < allNames.length; ++i) {
                    if (allNames[i] == null) continue;
                    String fname = allNames[i].getNameExt();
                    filepaths.add(fname.replace('\\', '/'));
                }
                this.deployConfigDescriptorMap.put(mTypeName, filepaths.toArray(new String[filepaths.size()]));
            }
        }
    }

    public String[] getDeploymentPlanFiles(J2eeModule.Type type) {
        ModuleType jsrModuleType = J2eeModuleAccessor.getDefault().getJsrModuleType(type);
        return (String[])this.deployConfigDescriptorMap.get(jsrModuleType.toString().toUpperCase());
    }
}

