/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.deployment.impl;

import java.beans.PropertyChangeEvent;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Properties;
import javax.enterprise.deploy.spi.DeploymentManager;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.InstanceListener;
import org.netbeans.modules.j2ee.deployment.impl.ServerInstance;
import org.netbeans.modules.j2ee.deployment.impl.ServerRegistry;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceProperties;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class InstancePropertiesImpl
extends InstanceProperties
implements InstanceListener {
    private final String url;
    private transient FileObject fo;

    public InstancePropertiesImpl(ServerInstance instance) {
        this(instance.getUrl());
    }

    public InstancePropertiesImpl(String url) {
        this.url = url;
    }

    private FileObject getFO() {
        if (this.fo == null) {
            ServerInstance instance = ServerRegistry.getInstance().getServerInstance(this.url);
            if (instance == null) {
                throw new IllegalStateException(NbBundle.getMessage(InstancePropertiesImpl.class, (String)"MSG_InstanceNotExists", (Object)this.url));
            }
            ServerRegistry.getInstance();
            this.fo = ServerRegistry.getInstanceFileObject(this.url);
            if (this.fo == null) {
                throw new IllegalStateException(NbBundle.getMessage(InstancePropertiesImpl.class, (String)"MSG_InstanceNotExists", (Object)this.url));
            }
        }
        return this.fo;
    }

    @Override
    public void instanceRemoved(String instance) {
        if (instance != null && this.url.equals(instance)) {
            this.fo = null;
        }
    }

    @Override
    public void instanceAdded(String instance) {
    }

    public void changeDefaultInstance(String oldInstance, String newInstance) {
    }

    @Override
    public String getProperty(String propname) throws IllegalStateException {
        Object propValue = this.getFO().getAttribute(propname);
        return propValue == null ? null : propValue.toString();
    }

    @Override
    public Enumeration propertyNames() throws IllegalStateException {
        return this.getFO().getAttributes();
    }

    @Override
    public void setProperty(String propname, String value) throws IllegalStateException {
        try {
            String oldValue = this.getProperty(propname);
            this.getFO().setAttribute(propname, (Object)value);
            this.firePropertyChange(new PropertyChangeEvent(this, propname, oldValue, value));
        }
        catch (IOException ioe) {
            String message = NbBundle.getMessage(InstancePropertiesImpl.class, (String)"MSG_InstanceNotExists", (Object)this.url);
            throw new IllegalStateException(Exceptions.attachLocalizedMessage((Throwable)ioe, (String)message));
        }
    }

    @Override
    public void setProperties(Properties props) throws IllegalStateException {
        Enumeration<?> propNames = props.propertyNames();
        while (propNames.hasMoreElements()) {
            String propName = (String)propNames.nextElement();
            String propValue = props.getProperty(propName);
            this.setProperty(propName, propValue);
        }
    }

    @Override
    public DeploymentManager getDeploymentManager() {
        ServerRegistry registry = ServerRegistry.getInstance();
        ServerInstance inst = registry.getServerInstance(this.url);
        return inst.getDeploymentManager();
    }

    @Override
    public void refreshServerInstance() {
        ServerRegistry registry = ServerRegistry.getInstance();
        ServerInstance inst = registry.getServerInstance(this.url);
        if (inst != null) {
            inst.refresh();
        }
    }
}

