/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.ui;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.DialogBinding;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.debugger.ui.Utils;
import org.netbeans.spi.debugger.ui.EditorContextDispatcher;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;
import org.openide.windows.WindowManager;

public class WatchPanel {
    private JPanel panel;
    private JTextComponent editorPane;
    private String expression;

    public WatchPanel(String expression) {
        this.expression = expression;
    }

    public JComponent getPanel() {
        if (this.panel != null) {
            return this.panel;
        }
        this.panel = new JPanel();
        ResourceBundle bundle = NbBundle.getBundle(WatchPanel.class);
        this.panel.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_WatchPanel"));
        JLabel textLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)textLabel, (String)bundle.getString("CTL_Watch_Name"));
        textLabel.setBorder(new EmptyBorder(0, 0, 5, 0));
        this.panel.setLayout(new BorderLayout());
        this.panel.setBorder(new EmptyBorder(11, 12, 1, 11));
        this.panel.add("North", textLabel);
        FileObject file = EditorContextDispatcher.getDefault().getMostRecentFile();
        int line = EditorContextDispatcher.getDefault().getMostRecentLineNumber();
        String mimeType = file != null ? file.getMIMEType() : "text/plain";
        JComponent[] editorComponents = Utilities.createSingleLineEditor((String)mimeType);
        JScrollPane sp = (JScrollPane)editorComponents[0];
        this.editorPane = (JTextComponent)editorComponents[1];
        int h = sp.getPreferredSize().height;
        int w = Math.min(70 * this.editorPane.getFontMetrics(this.editorPane.getFont()).charWidth('a'), WindowManager.getDefault().getMainWindow().getSize().width);
        sp.setPreferredSize(new Dimension(w, h));
        line = WatchPanel.adjustLine(file, line);
        if (file != null && line >= 0) {
            DialogBinding.bindComponentToFile((FileObject)file, (int)line, (int)0, (int)0, (JTextComponent)this.editorPane);
        }
        this.panel.add("Center", sp);
        this.editorPane.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_CTL_Watch_Name"));
        String t = Utils.getIdentifier();
        if (t != null) {
            this.editorPane.setText(t);
        } else {
            this.editorPane.setText(this.expression);
        }
        this.editorPane.selectAll();
        textLabel.setLabelFor(this.editorPane);
        this.editorPane.requestFocus();
        return this.panel;
    }

    public String getExpression() {
        return this.editorPane.getText().trim();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int adjustLine(FileObject fo, int theLine) {
        BufferedReader br;
        if (theLine == -1) {
            theLine = 1;
        }
        if (fo == null) {
            return theLine;
        }
        if (!"java".equalsIgnoreCase(fo.getExt())) {
            return theLine;
        }
        try {
            br = new BufferedReader(new InputStreamReader(fo.getInputStream()));
        }
        catch (FileNotFoundException ex) {
            return theLine;
        }
        try {
            int line = WatchPanel.findClassLine(br);
            line = WatchPanel.findMethodLine(line, br);
            if (theLine < line) {
                theLine = line;
            }
        }
        catch (IOException ioex) {
        }
        finally {
            try {
                br.close();
            }
            catch (IOException ex) {}
        }
        return theLine;
    }

    private static int findClassLine(BufferedReader br) throws IOException {
        String line;
        int l = 1;
        boolean comment = false;
        boolean classDecl = false;
        while ((line = br.readLine()) != null) {
            if (classDecl) {
                if (line.indexOf(123) >= 0) {
                    return l + 1;
                }
            } else {
                boolean slash = false;
                boolean asterix = false;
                for (int i = 0; i < line.length(); ++i) {
                    char c = line.charAt(i);
                    if (comment) {
                        if (asterix && c == '/') {
                            comment = false;
                            asterix = false;
                            continue;
                        }
                        asterix = c == '*';
                        continue;
                    }
                    if (slash && c == '*') {
                        comment = true;
                        slash = false;
                        continue;
                    }
                    if (c == '/') {
                        if (slash) break;
                        slash = true;
                    }
                    if (c != 'c' || line.length() <= i + "class".length() || !"lass".equals(line.substring(i + 1, i + 5)) || line.indexOf(123, i + 5) <= 0) continue;
                    return l + 1;
                }
            }
            ++l;
        }
        return 1;
    }

    private static int findMethodLine(int l, BufferedReader br) throws IOException {
        String line;
        int origLine = l;
        boolean isParenthesis = false;
        boolean isThrows = false;
        while ((line = br.readLine()) != null) {
            int i = 0;
            if (!isParenthesis && (i = line.indexOf(41)) >= 0 || isParenthesis) {
                isParenthesis = true;
                if (!isThrows) {
                    ++i;
                    while (i < line.length() && Character.isWhitespace(line.charAt(i))) {
                        ++i;
                    }
                    if (i + "throws".length() < line.length() && "throws".equals(line.substring(i, i + "throws".length()))) {
                        isThrows = true;
                    }
                }
                if (isThrows && (i = line.indexOf("{", i)) < 0) {
                    i = line.length();
                }
                if (i < line.length()) {
                    if (line.charAt(i) == '{') {
                        return l;
                    }
                    isParenthesis = false;
                }
            }
            ++l;
        }
        return origLine;
    }
}

