/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.fold;

import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.TextHitInfo;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.View;
import org.netbeans.api.editor.fold.Fold;
import org.netbeans.modules.editor.fold.FoldToolTip;
import org.netbeans.modules.editor.lib2.view.EditorView;
import org.netbeans.modules.editor.lib2.view.ViewUtils;

public class FoldView
extends EditorView {
    private static final Logger LOG = Logger.getLogger(FoldView.class.getName());
    private static final float EXTRA_MARGIN_WIDTH = 3.0f;
    private int rawOffset;
    private int length;
    private final JTextComponent textComponent;
    private final Fold fold;
    private TextLayout collapsedTextLayout;

    public FoldView(JTextComponent textComponent, Fold fold) {
        super(null);
        int offset = fold.getStartOffset();
        int len = fold.getEndOffset() - offset;
        assert (len > 0) : "length=" + len + " <= 0";
        this.rawOffset = offset;
        this.length = len;
        this.textComponent = textComponent;
        this.fold = fold;
    }

    public float getPreferredSpan(int axis) {
        TextLayout textLayout = this.getTextLayout();
        if (textLayout == null) {
            return 0.0f;
        }
        String desc = this.fold.getDescription();
        float span = axis == 0 ? (desc.length() > 0 ? textLayout.getAdvance() : 0.0f) + 6.0f : textLayout.getAscent() + textLayout.getDescent() + textLayout.getLeading();
        return span;
    }

    public int getRawOffset() {
        return this.rawOffset;
    }

    public void setRawOffset(int rawOffset) {
        this.rawOffset = rawOffset;
    }

    public int getLength() {
        return this.length;
    }

    public int getStartOffset() {
        EditorView.Parent parent = (EditorView.Parent)this.getParent();
        return parent != null ? parent.getViewOffset(this.rawOffset) : this.rawOffset;
    }

    public int getEndOffset() {
        return this.getStartOffset() + this.getLength();
    }

    public Document getDocument() {
        View parent = this.getParent();
        return parent != null ? parent.getDocument() : null;
    }

    public AttributeSet getAttributes() {
        return null;
    }

    private TextLayout getTextLayout() {
        if (this.collapsedTextLayout == null) {
            EditorView.Parent parent = (EditorView.Parent)this.getParent();
            FontRenderContext frc = parent.getFontRenderContext();
            assert (frc != null) : "Null FontRenderContext";
            Font font = this.textComponent.getFont();
            String text = this.fold.getDescription();
            if (text.length() == 0) {
                text = " ";
            }
            this.collapsedTextLayout = new TextLayout(text, font, frc);
        }
        return this.collapsedTextLayout;
    }

    public Shape modelToViewChecked(int offset, Shape alloc, Position.Bias bias) {
        return alloc;
    }

    public int viewToModelChecked(double x, double y, Shape alloc, Position.Bias[] biasReturn) {
        int startOffset = this.getStartOffset();
        return startOffset;
    }

    static TextHitInfo x2RelOffset(TextLayout textLayout, float x) {
        TextHitInfo hit = (x -= 3.0f) >= textLayout.getAdvance() ? TextHitInfo.trailing(textLayout.getCharacterCount()) : textLayout.hitTestChar(x, 0.0f);
        return hit;
    }

    public int getNextVisualPositionFromChecked(int offset, Position.Bias bias, Shape alloc, int direction, Position.Bias[] biasRet) {
        int startOffset = this.getStartOffset();
        int retOffset = -1;
        switch (direction) {
            case 7: {
                if (offset == -1) {
                    retOffset = startOffset;
                    break;
                }
                retOffset = -1;
                break;
            }
            case 3: {
                if (offset == -1) {
                    retOffset = startOffset;
                    break;
                }
                retOffset = -1;
                break;
            }
            case 1: 
            case 5: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Bad direction: " + direction);
            }
        }
        return retOffset;
    }

    public JComponent getToolTip(double x, double y, Shape allocation) {
        Container container = this.getContainer();
        if (container instanceof JEditorPane) {
            JEditorPane editorPane = (JEditorPane)this.getContainer();
            JEditorPane tooltipPane = new JEditorPane();
            EditorKit kit = editorPane.getEditorKit();
            Document doc = this.getDocument();
            if (kit != null && doc != null) {
                Element lineRootElement = doc.getDefaultRootElement();
                tooltipPane.putClientProperty("view-folds-expanded", true);
                try {
                    int lineIndex = lineRootElement.getElementIndex(this.fold.getStartOffset());
                    Position pos = doc.createPosition(lineRootElement.getElement(lineIndex).getStartOffset());
                    tooltipPane.putClientProperty("document-view-start-position", pos);
                    lineIndex = lineRootElement.getElementIndex(this.fold.getEndOffset());
                    pos = doc.createPosition(lineRootElement.getElement(lineIndex).getEndOffset());
                    tooltipPane.putClientProperty("document-view-end-position", pos);
                    tooltipPane.putClientProperty("document-view-accurate-span", true);
                    tooltipPane.setEditorKit(kit);
                    tooltipPane.setDocument(doc);
                    return new FoldToolTip(editorPane, tooltipPane);
                }
                catch (BadLocationException e) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics2D g, Shape alloc, Rectangle clipBounds) {
        Rectangle2D.Double allocBounds = ViewUtils.shape2Bounds((Shape)alloc);
        if (allocBounds.intersects(clipBounds)) {
            Font origFont = g.getFont();
            Color origColor = g.getColor();
            try {
                g.setColor(this.textComponent.getForeground());
                int xInt = (int)allocBounds.getX();
                int yInt = (int)allocBounds.getY();
                int endXInt = (int)(allocBounds.getX() + allocBounds.getWidth() - 1.0);
                int endYInt = (int)(allocBounds.getY() + allocBounds.getHeight() - 1.0);
                g.drawRect(xInt, yInt, endXInt - xInt, endYInt - yInt);
                TextLayout textLayout = this.getTextLayout();
                if (textLayout != null) {
                    String desc = this.fold.getDescription();
                    float x = (float)(allocBounds.getX() + 3.0);
                    float y = (float)allocBounds.getY();
                    if (desc.length() > 0) {
                        textLayout.draw(g, x, y + textLayout.getAscent());
                    }
                }
            }
            finally {
                g.setColor(origColor);
                g.setFont(origFont);
            }
        }
    }

    protected String getDumpName() {
        return "FV";
    }

    public String toString() {
        return this.appendViewInfo(new StringBuilder(200), 0, -1).toString();
    }
}

