/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.portlet.handler;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.portlet.PortletMode;
import javax.portlet.PortletRequest;
import org.springframework.beans.BeansException;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.web.portlet.handler.AbstractMapBasedHandlerMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortletModeHandlerMapping
extends AbstractMapBasedHandlerMapping<PortletMode> {
    private final Map<String, Object> portletModeMap = new HashMap<String, Object>();

    public void setMappings(Properties mappings) {
        CollectionUtils.mergePropertiesIntoMap((Properties)mappings, this.portletModeMap);
    }

    public void setPortletModeMap(Map<String, ?> portletModeMap) {
        this.portletModeMap.putAll(portletModeMap);
    }

    @Override
    public void initApplicationContext() throws BeansException {
        super.initApplicationContext();
        this.registerHandlersByMode(this.portletModeMap);
    }

    protected void registerHandlersByMode(Map<String, Object> portletModeMap) {
        Assert.notNull(portletModeMap, (String)"'portletModeMap' must not be null");
        for (Map.Entry<String, Object> entry : portletModeMap.entrySet()) {
            this.registerHandler(new PortletMode(entry.getKey()), entry.getValue());
        }
    }

    @Override
    protected PortletMode getLookupKey(PortletRequest request) throws Exception {
        return request.getPortletMode();
    }
}

