/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.weblogic9.config;

import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.deploy.spi.status.ProgressObject;
import org.netbeans.modules.j2ee.deployment.common.api.ConfigurationException;
import org.netbeans.modules.j2ee.deployment.common.api.Datasource;
import org.netbeans.modules.j2ee.deployment.common.api.DatasourceAlreadyExistsException;
import org.netbeans.modules.j2ee.deployment.plugins.spi.DatasourceManager;
import org.netbeans.modules.j2ee.weblogic9.ProgressObjectSupport;
import org.netbeans.modules.j2ee.weblogic9.config.WLDatasource;
import org.netbeans.modules.j2ee.weblogic9.config.WLDatasourceSupport;
import org.netbeans.modules.j2ee.weblogic9.deploy.CommandBasedDeployer;
import org.netbeans.modules.j2ee.weblogic9.deploy.WLDeploymentManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class WLDatasourceManager
implements DatasourceManager {
    private static final Logger LOGGER = Logger.getLogger(WLDatasourceManager.class.getName());
    private final WLDeploymentManager manager;

    public WLDatasourceManager(WLDeploymentManager manager) {
        this.manager = manager;
    }

    public void deployDatasources(Set<Datasource> datasources) throws ConfigurationException, DatasourceAlreadyExistsException {
        Set<Datasource> deployedDatasources = this.getDatasources();
        Map<String, Datasource> deployed = this.createMap(deployedDatasources);
        HashMap<String, WLDatasource> toDeploy = new HashMap<String, WLDatasource>();
        LinkedList<Datasource> conflictDS = new LinkedList<Datasource>();
        for (Datasource datasource : datasources) {
            if (!(datasource instanceof WLDatasource)) {
                LOGGER.log(Level.INFO, "Unable to deploy {0}", datasource);
                continue;
            }
            WLDatasource wlDatasource = (WLDatasource)datasource;
            String jndiName = wlDatasource.getJndiName();
            if (deployed.keySet().contains(jndiName)) {
                Datasource deployedDatasource = deployed.get(jndiName);
                if (deployed.get(jndiName).equals(wlDatasource)) continue;
                if (!((WLDatasource)deployedDatasource).isSystem() && !wlDatasource.isSystem()) {
                    toDeploy.put(jndiName, wlDatasource);
                    continue;
                }
                conflictDS.add(deployed.get(jndiName));
                continue;
            }
            if (jndiName != null) {
                toDeploy.put(jndiName, wlDatasource);
                continue;
            }
            LOGGER.log(Level.INFO, "JNDI name was null for {0}", datasource);
        }
        if (!conflictDS.isEmpty()) {
            throw new DatasourceAlreadyExistsException(conflictDS);
        }
        CommandBasedDeployer deployer = new CommandBasedDeployer(this.manager);
        ProgressObject po = deployer.deployDatasource(toDeploy.values());
        ProgressObjectSupport.waitFor(po);
        if (po.getDeploymentStatus().isFailed()) {
            String msg = NbBundle.getMessage(WLDatasourceManager.class, (String)"MSG_FailedToDeployDatasource");
            throw new ConfigurationException(msg);
        }
    }

    public Set<Datasource> getDatasources() throws ConfigurationException {
        String domainDir = this.manager.getInstanceProperties().getProperty("domainRoot");
        File domainPath = FileUtil.normalizeFile((File)new File(domainDir));
        FileObject domain = FileUtil.toFileObject((File)domainPath);
        FileObject domainConfig = null;
        if (domain != null) {
            domainConfig = domain.getFileObject("config/config.xml");
        }
        return new HashSet<Datasource>(WLDatasourceSupport.getDatasources(domainPath, domainConfig, true));
    }

    private Map<String, Datasource> createMap(Set<Datasource> datasources) {
        if (datasources.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, Datasource> map = new HashMap<String, Datasource>();
        for (Datasource datasource : datasources) {
            map.put(datasource.getJndiName(), datasource);
        }
        return map;
    }
}

