/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.weblogic9.config;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import org.netbeans.modules.j2ee.deployment.common.api.ConfigurationException;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.plugins.spi.config.DeploymentPlanConfiguration;
import org.netbeans.modules.j2ee.deployment.plugins.spi.config.ModuleConfiguration;
import org.netbeans.modules.j2ee.weblogic9.config.ConfigUtil;
import org.netbeans.modules.j2ee.weblogic9.config.WLDeploymentConfiguration;
import org.netbeans.modules.j2ee.weblogic9.config.WarDeploymentConfiguration;
import org.netbeans.modules.j2ee.weblogic9.config.gen.WeblogicEjbJar;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;

public class EjbDeploymentConfiguration
extends WLDeploymentConfiguration
implements ModuleConfiguration,
DeploymentPlanConfiguration {
    private final File file;
    private final J2eeModule j2eeModule;
    private final DataObject dataObject;
    private WeblogicEjbJar weblogicEjbJar;

    public EjbDeploymentConfiguration(J2eeModule j2eeModule) {
        super(j2eeModule);
        this.j2eeModule = j2eeModule;
        this.file = j2eeModule.getDeploymentConfigurationFile("META-INF/weblogic-ejb-jar.xml");
        this.getWeblogicEjbJar();
        DataObject dataObject = null;
        try {
            dataObject = DataObject.find((FileObject)FileUtil.toFileObject((File)this.file));
        }
        catch (DataObjectNotFoundException donfe) {
            Exceptions.printStackTrace((Throwable)donfe);
        }
        this.dataObject = dataObject;
    }

    public synchronized WeblogicEjbJar getWeblogicEjbJar() {
        if (this.weblogicEjbJar == null) {
            try {
                if (this.file.exists()) {
                    try {
                        this.weblogicEjbJar = WeblogicEjbJar.createGraph(this.file);
                    }
                    catch (IOException ioe) {
                        Exceptions.printStackTrace((Throwable)ioe);
                    }
                    catch (RuntimeException re) {}
                } else {
                    this.weblogicEjbJar = this.genereateWeblogicEjbJar();
                    ConfigUtil.writefile(this.file, this.weblogicEjbJar);
                }
            }
            catch (ConfigurationException ce) {
                Exceptions.printStackTrace((Throwable)ce);
            }
        }
        return this.weblogicEjbJar;
    }

    public Lookup getLookup() {
        return Lookups.fixed((Object[])new Object[]{this});
    }

    public J2eeModule getJ2eeModule() {
        return this.j2eeModule;
    }

    public void dispose() {
    }

    public void save(OutputStream os) throws ConfigurationException {
        WeblogicEjbJar weblogicEjbJar = this.getWeblogicEjbJar();
        if (weblogicEjbJar == null) {
            String msg = NbBundle.getMessage(WarDeploymentConfiguration.class, (String)"MSG_cannotSaveNotParseableConfFile", (Object)this.file.getPath());
            throw new ConfigurationException(msg);
        }
        try {
            weblogicEjbJar.write(os);
        }
        catch (IOException ioe) {
            String msg = NbBundle.getMessage(WarDeploymentConfiguration.class, (String)"MSG_CannotUpdateFile", (Object)this.file.getPath());
            throw new ConfigurationException(msg, (Throwable)ioe);
        }
    }

    private WeblogicEjbJar genereateWeblogicEjbJar() {
        return new WeblogicEjbJar();
    }
}

