/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.dd.api.web;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.j2ee.dd.api.web.WebFragment;
import org.netbeans.modules.j2ee.dd.impl.web.WebParseUtils;
import org.openide.filesystems.FileObject;
import org.openide.util.Parameters;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public final class WebFragmentProvider {
    private static final Logger LOG = Logger.getLogger(WebFragmentProvider.class.getName());
    private static WebFragmentProvider instance;

    private WebFragmentProvider() {
    }

    public static WebFragmentProvider getDefault() {
        if (instance == null) {
            instance = new WebFragmentProvider();
        }
        return instance;
    }

    public WebFragment getWebFragmentRoot(FileObject fo) throws IOException, FileNotFoundException {
        Parameters.notNull((CharSequence)"fo", (Object)fo);
        try {
            String version = WebParseUtils.getVersion(fo.getInputStream());
            SAXParseException error = WebParseUtils.parse(fo);
            if (error != null) {
                throw error;
            }
            return this.createWebFragment(fo.getInputStream(), version);
        }
        catch (SAXException ex) {
            LOG.log(Level.INFO, "Parsing failed!", ex);
            throw new IOException("Parsing failed: " + ex);
        }
    }

    private WebFragment createWebFragment(InputStream is, String version) throws IOException, SAXException {
        try {
            if ("3.0".equals(version)) {
                return org.netbeans.modules.j2ee.dd.impl.web.model_3_0_frag.WebFragment.createGraph(is);
            }
            throw new IOException("Unsupported version of web-fragment.xml found! Version: " + version);
        }
        catch (RuntimeException ex) {
            throw new SAXException(ex);
        }
    }
}

