/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor.xhtml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.html.editor.xhtml.ELEmbeddingProvider;
import org.netbeans.modules.html.editor.xhtml.XhtmlElTokenId;
import org.netbeans.modules.parsing.api.Embedding;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.spi.EmbeddingProvider;
import org.netbeans.modules.parsing.spi.SchedulerTask;
import org.netbeans.modules.parsing.spi.TaskFactory;

public class XhtmlElEmbeddingProvider
extends EmbeddingProvider {
    public static final String GENERATED_CODE = "@@@";

    public List<Embedding> getEmbeddings(Snapshot snapshot) {
        TokenHierarchy th = snapshot.getTokenHierarchy();
        TokenSequence sequence = th.tokenSequence(XhtmlElTokenId.language());
        sequence.moveStart();
        ArrayList<Embedding> embeddings = new ArrayList<Embedding>();
        boolean lastEmbeddingIsVirtual = false;
        while (sequence.moveNext()) {
            Token t = sequence.token();
            if (t.id() == XhtmlElTokenId.HTML) {
                embeddings.add(snapshot.create(sequence.offset(), t.length(), "text/html"));
                lastEmbeddingIsVirtual = false;
                continue;
            }
            if (lastEmbeddingIsVirtual) continue;
            embeddings.add(snapshot.create((CharSequence)GENERATED_CODE, "text/html"));
            lastEmbeddingIsVirtual = true;
        }
        if (embeddings.isEmpty()) {
            return Collections.emptyList();
        }
        return Collections.singletonList(Embedding.create(embeddings));
    }

    public int getPriority() {
        return 100;
    }

    public void cancel() {
    }

    public static final class Factory
    extends TaskFactory {
        public Collection<SchedulerTask> create(Snapshot snapshot) {
            return Arrays.asList(new SchedulerTask[]{new XhtmlElEmbeddingProvider(), new ELEmbeddingProvider()});
        }
    }
}

