/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.highlight.semantic;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.text.AttributeSet;
import javax.swing.text.StyleConstants;
import org.netbeans.api.editor.settings.AttributesUtilities;
import org.netbeans.api.editor.settings.EditorStyleConstants;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmMacro;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.api.model.xref.CsmReference;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceKind;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceResolver;
import org.netbeans.modules.cnd.highlight.semantic.HighlighterBase;
import org.netbeans.modules.cnd.highlight.semantic.ModelUtils;
import org.netbeans.modules.cnd.highlight.semantic.ReferenceCollector;
import org.netbeans.modules.cnd.highlight.semantic.SemanticEntity;
import org.netbeans.modules.cnd.modelutil.FontColorProvider;
import org.openide.util.NbBundle;

public final class SemanticEntitiesProvider {
    private final List<SemanticEntity> list = new ArrayList<SemanticEntity>();

    public List<SemanticEntity> get() {
        return this.list;
    }

    private SemanticEntity getInactiveCode() {
        return new AbstractSemanticEntity(FontColorProvider.Entity.INACTIVE_CODE){

            public String getName() {
                return "inactive";
            }

            @Override
            public List<? extends CsmOffsetable> getBlocks(CsmFile csmFile) {
                return ModelUtils.getInactiveCodeBlocks(csmFile);
            }
        };
    }

    private SemanticEntity getFastFields() {
        return new AbstractSemanticEntity(FontColorProvider.Entity.CLASS_FIELD){

            public String getName() {
                return "fast-class-fields";
            }

            @Override
            public List<? extends CsmOffsetable> getBlocks(CsmFile csmFile) {
                Collection references = CsmReferenceResolver.getDefault().getReferences(csmFile);
                ArrayList<CsmReference> res = new ArrayList<CsmReference>();
                for (CsmReference ref : references) {
                    if (!CsmKindUtilities.isField((CsmObject)ref.getReferencedObject())) continue;
                    res.add(ref);
                }
                return res;
            }

            @Override
            public ReferenceCollector getCollector() {
                return null;
            }
        };
    }

    private SemanticEntity getFields() {
        return new AbstractSemanticEntity(FontColorProvider.Entity.CLASS_FIELD){

            public String getName() {
                return "class-fields";
            }

            @Override
            public List<? extends CsmOffsetable> getBlocks(CsmFile csmFile) {
                return ModelUtils.collect(csmFile, this.getCollector());
            }

            @Override
            public ReferenceCollector getCollector() {
                return new ModelUtils.FieldReferenceCollector();
            }
        };
    }

    private SemanticEntity getFastFunctions() {
        return new AbstractSemanticEntity(FontColorProvider.Entity.FUNCTION){
            private AttributeSet funUsageColors;

            public String getName() {
                return "fast-functions-names";
            }

            @Override
            public List<? extends CsmOffsetable> getBlocks(CsmFile csmFile) {
                Collection references = CsmReferenceResolver.getDefault().getReferences(csmFile);
                ArrayList<CsmReference> res = new ArrayList<CsmReference>();
                for (CsmReference ref : references) {
                    if (!CsmKindUtilities.isFunction((CsmObject)ref.getReferencedObject())) continue;
                    res.add(ref);
                }
                return res;
            }

            @Override
            public ReferenceCollector getCollector() {
                return null;
            }

            @Override
            public AttributeSet getAttributes(CsmOffsetable obj) {
                CsmReference ref = (CsmReference)obj;
                CsmFunction fun = (CsmFunction)ref.getReferencedObject();
                if (fun == null) {
                    return this.color;
                }
                if (CsmReferenceResolver.getDefault().isKindOf(ref, CsmReferenceKind.FUNCTION_DECLARATION_KINDS)) {
                    return this.color;
                }
                return this.funUsageColors;
            }

            @Override
            public void updateFontColors(FontColorProvider provider) {
                super.updateFontColors(provider);
                this.funUsageColors = 4.getFontColor(provider, FontColorProvider.Entity.FUNCTION_USAGE);
            }
        };
    }

    private SemanticEntity getFunctions() {
        return new AbstractSemanticEntity(FontColorProvider.Entity.FUNCTION){
            private AttributeSet funUsageColors;

            public String getName() {
                return "functions-names";
            }

            @Override
            public List<? extends CsmOffsetable> getBlocks(CsmFile csmFile) {
                return ModelUtils.collect(csmFile, this.getCollector());
            }

            @Override
            public ReferenceCollector getCollector() {
                return new ModelUtils.FunctionReferenceCollector();
            }

            @Override
            public AttributeSet getAttributes(CsmOffsetable obj) {
                CsmReference ref = (CsmReference)obj;
                CsmFunction fun = (CsmFunction)ref.getReferencedObject();
                if (fun == null) {
                    return this.color;
                }
                if (CsmReferenceResolver.getDefault().isKindOf(ref, CsmReferenceKind.FUNCTION_DECLARATION_KINDS)) {
                    return this.color;
                }
                return this.funUsageColors;
            }

            @Override
            public void updateFontColors(FontColorProvider provider) {
                super.updateFontColors(provider);
                this.funUsageColors = 5.getFontColor(provider, FontColorProvider.Entity.FUNCTION_USAGE);
            }
        };
    }

    private SemanticEntity getMacros() {
        return new AbstractSemanticEntity(FontColorProvider.Entity.DEFINED_MACRO){
            private AttributeSet sysMacroColors;
            private AttributeSet userMacroColors;

            public String getName() {
                return "macros";
            }

            @Override
            public List<? extends CsmOffsetable> getBlocks(CsmFile csmFile) {
                return ModelUtils.getMacroBlocks(csmFile);
            }

            @Override
            public AttributeSet getAttributes(CsmOffsetable obj) {
                CsmMacro macro = (CsmMacro)((CsmReference)obj).getReferencedObject();
                if (macro == null) {
                    return this.color;
                }
                switch (macro.getKind()) {
                    case USER_SPECIFIED: {
                        return this.userMacroColors;
                    }
                    case COMPILER_PREDEFINED: 
                    case POSITION_PREDEFINED: {
                        return this.sysMacroColors;
                    }
                    case DEFINED: {
                        return this.color;
                    }
                }
                throw new IllegalArgumentException("unexpected macro kind:" + macro.getKind() + " in macro:" + macro);
            }

            @Override
            public void updateFontColors(FontColorProvider provider) {
                super.updateFontColors(provider);
                this.sysMacroColors = 6.getFontColor(provider, FontColorProvider.Entity.SYSTEM_MACRO);
                this.userMacroColors = 6.getFontColor(provider, FontColorProvider.Entity.USER_MACRO);
            }
        };
    }

    private SemanticEntity getTypedefs() {
        return new AbstractSemanticEntity(FontColorProvider.Entity.TYPEDEF){

            public String getName() {
                return "typedefs";
            }

            @Override
            public List<? extends CsmOffsetable> getBlocks(CsmFile csmFile) {
                return ModelUtils.collect(csmFile, this.getCollector());
            }

            @Override
            public ReferenceCollector getCollector() {
                return new ModelUtils.TypedefReferenceCollector();
            }
        };
    }

    private SemanticEntity getUnusedVariables() {
        return new AbstractSemanticEntity(FontColorProvider.Entity.UNUSED_VARIABLES){
            private final AttributeSet UNUSED_TOOLTIP;
            {
                this.UNUSED_TOOLTIP = AttributesUtilities.createImmutable((Object[])new Object[]{EditorStyleConstants.Tooltip, NbBundle.getMessage(SemanticEntitiesProvider.class, (String)"UNUSED_VARIABLE_TOOLTIP")});
            }

            public String getName() {
                return "unused-variables";
            }

            @Override
            public List<? extends CsmOffsetable> getBlocks(CsmFile csmFile) {
                return ModelUtils.collect(csmFile, this.getCollector());
            }

            @Override
            public ReferenceCollector getCollector() {
                return new ModelUtils.UnusedVariableCollector();
            }

            @Override
            public void updateFontColors(FontColorProvider provider) {
                super.updateFontColors(provider);
                this.color = AttributesUtilities.createComposite((AttributeSet[])new AttributeSet[]{this.UNUSED_TOOLTIP, this.color});
            }
        };
    }

    private SemanticEntitiesProvider() {
        this.list.add(this.getInactiveCode());
        if (!HighlighterBase.MINIMAL) {
            this.list.add(this.getMacros());
            this.list.add(this.getFastFields());
            this.list.add(this.getFields());
            this.list.add(this.getFastFunctions());
            this.list.add(this.getFunctions());
            this.list.add(this.getTypedefs());
            this.list.add(this.getUnusedVariables());
        }
    }

    public static SemanticEntitiesProvider instance() {
        return Instantiator.instance;
    }

    private static class Instantiator {
        static SemanticEntitiesProvider instance = new SemanticEntitiesProvider();

        private Instantiator() {
        }
    }

    private static abstract class AbstractSemanticEntity
    implements SemanticEntity {
        protected AttributeSet color;
        private final FontColorProvider.Entity entity;
        private static final AttributeSet cleanUp = AttributesUtilities.createImmutable((Object[])new Object[]{StyleConstants.Underline, null, StyleConstants.StrikeThrough, null, StyleConstants.Background, null, EditorStyleConstants.WaveUnderlineColor, null, EditorStyleConstants.Tooltip, null});

        public AbstractSemanticEntity() {
            this.entity = null;
        }

        public AbstractSemanticEntity(FontColorProvider.Entity entity) {
            this.entity = entity;
        }

        @Override
        public void updateFontColors(FontColorProvider provider) {
            assert (this.entity != null);
            this.color = AbstractSemanticEntity.getFontColor(provider, this.entity);
        }

        protected static AttributeSet getFontColor(FontColorProvider provider, FontColorProvider.Entity entity) {
            AttributeSet attributes = AttributesUtilities.createComposite((AttributeSet[])new AttributeSet[]{provider.getColor(entity), cleanUp});
            return attributes;
        }

        @Override
        public AttributeSet getAttributes(CsmOffsetable obj) {
            return this.color;
        }

        @Override
        public ReferenceCollector getCollector() {
            return null;
        }

        public boolean isEnabledByDefault() {
            return true;
        }
    }
}

