/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbcore.ui.logicalview.entries;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.lang.model.element.TypeElement;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ant.AntArtifactQuery;
import org.netbeans.modules.j2ee.api.ejbjar.EjbReference;
import org.netbeans.modules.j2ee.common.J2eeProjectCapabilities;
import org.netbeans.modules.j2ee.common.Util;
import org.netbeans.modules.j2ee.dd.api.common.EjbLocalRef;
import org.netbeans.modules.j2ee.dd.api.common.EjbRef;
import org.netbeans.modules.j2ee.dd.api.ejb.Ejb;
import org.netbeans.modules.j2ee.dd.api.ejb.EjbJar;
import org.netbeans.modules.j2ee.dd.api.ejb.EjbJarMetadata;
import org.netbeans.modules.j2ee.dd.api.ejb.EnterpriseBeans;
import org.netbeans.modules.j2ee.dd.api.ejb.EntityAndSession;
import org.netbeans.modules.j2ee.dd.api.ejb.Session;
import org.netbeans.modules.j2ee.ejbcore.Utils;
import org.netbeans.modules.j2ee.ejbcore._RetoucheUtil;
import org.netbeans.modules.j2ee.ejbcore.ui.logicalview.entries.NodeDisplayPanel;
import org.netbeans.modules.j2ee.ejbcore.ui.logicalview.entries.ServiceLocatorStrategyPanel;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModel;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelAction;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelException;
import org.openide.NotificationLineSupport;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;
import org.openide.nodes.NodeAcceptor;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class CallEjbPanel
extends JPanel {
    public static final String IS_VALID = "CallEjbPanel_isValid";
    private Set<String> refNameSet;
    private final NodeDisplayPanel nodeDisplayPanel;
    private final ServiceLocatorStrategyPanel slPanel;
    private final NodeAcceptor nodeAcceptor;
    private final Project project;
    private final String className;
    private final FileObject srcFile;
    private NotificationLineSupport statusLine;
    private JCheckBox convertToRuntime;
    private JPanel displayPanel;
    private ButtonGroup intefaceButtonGroup;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JRadioButton localRadioButton;
    private JRadioButton noInterfaceRadioButton;
    private JTextField referenceNameTextField;
    private JRadioButton remoteRadioButton;
    private JPanel serviceLocatorPanel;

    public CallEjbPanel(FileObject fileObject, Node rootNode, String lastLocator, String className) throws IOException {
        this.initComponents();
        this.srcFile = fileObject;
        this.project = FileOwnerQuery.getOwner((FileObject)this.srcFile);
        this.className = className;
        this.nodeAcceptor = new NodeAcceptorImpl();
        this.nodeDisplayPanel = new NodeDisplayPanel(rootNode);
        this.nodeDisplayPanel.setBorder(new EtchedBorder());
        this.displayPanel.add(this.nodeDisplayPanel);
        this.nodeDisplayPanel.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent pce) {
                if ("nodeChange".equals(pce.getPropertyName())) {
                    Node[] nodes = CallEjbPanel.this.nodeDisplayPanel.getSelectedNodes();
                    if (nodes.length == 0) {
                        return;
                    }
                    EjbReference ejbReference = (EjbReference)nodes[0].getLookup().lookup(EjbReference.class);
                    if (ejbReference != null) {
                        try {
                            CallEjbPanel.this.setGeneratedName(ejbReference, CallEjbPanel.this.remoteRadioButton.isSelected(), nodes[0]);
                        }
                        catch (IOException ioe) {
                            Exceptions.printStackTrace((Throwable)ioe);
                        }
                    }
                    CallEjbPanel.this.validateReferences();
                }
            }
        });
        this.referenceNameTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                CallEjbPanel.this.validateReferences();
            }
        });
        this.slPanel = new ServiceLocatorStrategyPanel(lastLocator, ClasspathInfo.create((FileObject)fileObject));
        this.slPanel.getUnreferencedServiceLocator().addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                CallEjbPanel.this.validateReferences();
            }
        });
        this.slPanel.getClassName().getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                CallEjbPanel.this.validateReferences();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                CallEjbPanel.this.validateReferences();
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                CallEjbPanel.this.validateReferences();
            }
        });
        this.serviceLocatorPanel.add((Component)this.slPanel, "Center");
    }

    public void setNotificationLine(NotificationLineSupport statusLine) {
        this.statusLine = statusLine;
    }

    public void disableServiceLocator() {
        this.serviceLocatorPanel.setVisible(false);
    }

    private Set<String> getRefNameSet() throws IOException {
        if (this.refNameSet == null) {
            this.refNameSet = new HashSet<String>();
            org.netbeans.modules.j2ee.api.ejbjar.EjbJar ejbModule = org.netbeans.modules.j2ee.api.ejbjar.EjbJar.getEjbJar((FileObject)this.srcFile);
            if (ejbModule != null) {
                MetadataModel model = ejbModule.getMetadataModel();
                model.runReadAction((MetadataModelAction)new MetadataModelAction<EjbJarMetadata, Void>(){

                    public Void run(EjbJarMetadata metadata) throws IOException {
                        EjbJar ejbJar = metadata.getRoot();
                        if (ejbJar != null) {
                            final EnterpriseBeans enterpriseBeans = ejbJar.getEnterpriseBeans();
                            JavaSource javaSource = JavaSource.forFileObject((FileObject)CallEjbPanel.this.srcFile);
                            if (enterpriseBeans != null && javaSource != null) {
                                javaSource.runUserActionTask((Task)new Task<CompilationController>(){

                                    public void run(CompilationController controller) throws IOException {
                                        controller.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                                        TypeElement beanClass = controller.getElements().getTypeElement(CallEjbPanel.this.className);
                                        for (Ejb ejb : enterpriseBeans.getEjbs()) {
                                            int j;
                                            if (!beanClass.getQualifiedName().contentEquals(ejb.getEjbClass())) continue;
                                            EjbRef[] ejbRefs = ejb.getEjbRef();
                                            EjbLocalRef[] ejbLocalRefs = ejb.getEjbLocalRef();
                                            for (j = 0; j < ejbRefs.length; ++j) {
                                                CallEjbPanel.this.refNameSet.add(ejbRefs[j].getEjbRefName());
                                            }
                                            for (j = 0; j < ejbLocalRefs.length; ++j) {
                                                CallEjbPanel.this.refNameSet.add(ejbLocalRefs[j].getEjbRefName());
                                            }
                                            return;
                                        }
                                    }
                                }, true);
                            }
                        }
                        return null;
                    }
                });
            }
        }
        return this.refNameSet;
    }

    public void validateReferences() {
        boolean nodeAccepted = this.nodeAcceptor.acceptNodes(this.nodeDisplayPanel.getSelectedNodes());
        if (this.slPanel.getUnreferencedServiceLocator().isSelected() && this.slPanel.getClassName().getText().trim().equals("") || !nodeAccepted) {
            this.firePropertyChange(IS_VALID, true, false);
        } else {
            this.firePropertyChange(IS_VALID, false, true);
        }
    }

    private void initComponents() {
        this.intefaceButtonGroup = new ButtonGroup();
        this.serviceLocatorPanel = new JPanel();
        this.convertToRuntime = new JCheckBox();
        this.displayPanel = new JPanel();
        JLabel jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.referenceNameTextField = new JTextField();
        this.noInterfaceRadioButton = new JRadioButton();
        this.localRadioButton = new JRadioButton();
        this.remoteRadioButton = new JRadioButton();
        this.setLayout(new GridBagLayout());
        this.serviceLocatorPanel.setLayout(new BorderLayout());
        this.convertToRuntime.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/j2ee/ejbcore/ui/logicalview/entries/Bundle").getString("LBL_ConvertToRuntimeMneumonic").charAt(0));
        this.convertToRuntime.setSelected(true);
        ResourceBundle bundle = ResourceBundle.getBundle("org/netbeans/modules/j2ee/ejbcore/ui/logicalview/entries/Bundle");
        this.convertToRuntime.setText(bundle.getString("LBL_ConvertToRuntime"));
        this.serviceLocatorPanel.add((Component)this.convertToRuntime, "South");
        this.convertToRuntime.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CallEjbPanel.class, (String)"ACSD_ConvertToRuntime"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        this.add((Component)this.serviceLocatorPanel, gridBagConstraints);
        this.displayPanel.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.displayPanel, gridBagConstraints);
        this.displayPanel.getAccessibleContext().setAccessibleName(bundle.getString("LBL_DisplayPanel"));
        this.displayPanel.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_DisplayPanel"));
        jLabel1.setLabelFor(this.displayPanel);
        jLabel1.setText(bundle.getString("LBL_ModuleMustBeInSameApplication"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.add((Component)jLabel1, gridBagConstraints);
        this.jLabel2.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/j2ee/ejbcore/ui/logicalview/entries/Bundle").getString("MN_ReferenceName").charAt(0));
        this.jLabel2.setLabelFor(this.referenceNameTextField);
        this.jLabel2.setText(NbBundle.getMessage(CallEjbPanel.class, (String)"LBL_ReferenceName"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        this.add((Component)this.jLabel2, gridBagConstraints);
        this.jLabel3.setText(NbBundle.getMessage(CallEjbPanel.class, (String)"LBL_ReferencedInterface"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        this.add((Component)this.jLabel3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        this.add((Component)this.referenceNameTextField, gridBagConstraints);
        this.referenceNameTextField.getAccessibleContext().setAccessibleName(bundle.getString("LBL_ReferenceName"));
        this.referenceNameTextField.getAccessibleContext().setAccessibleDescription(bundle.getString("LBL_ReferenceName"));
        this.intefaceButtonGroup.add(this.noInterfaceRadioButton);
        this.noInterfaceRadioButton.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/j2ee/ejbcore/ui/logicalview/entries/Bundle").getString("MN_NoInterface").charAt(0));
        this.noInterfaceRadioButton.setSelected(true);
        this.noInterfaceRadioButton.setText(NbBundle.getMessage(CallEjbPanel.class, (String)"LBL_NoInterface"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 5);
        this.add((Component)this.noInterfaceRadioButton, gridBagConstraints);
        this.noInterfaceRadioButton.getAccessibleContext().setAccessibleDescription("No interface");
        this.intefaceButtonGroup.add(this.localRadioButton);
        this.localRadioButton.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/j2ee/ejbcore/ui/logicalview/entries/Bundle").getString("MN_Local").charAt(0));
        this.localRadioButton.setText(NbBundle.getMessage(CallEjbPanel.class, (String)"LBL_Local"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        this.add((Component)this.localRadioButton, gridBagConstraints);
        this.localRadioButton.getAccessibleContext().setAccessibleName(bundle.getString("LBL_Local"));
        this.localRadioButton.getAccessibleContext().setAccessibleDescription(bundle.getString("LBL_Local"));
        this.intefaceButtonGroup.add(this.remoteRadioButton);
        this.remoteRadioButton.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/j2ee/ejbcore/ui/logicalview/entries/Bundle").getString("MN_Remote").charAt(0));
        this.remoteRadioButton.setText(NbBundle.getMessage(CallEjbPanel.class, (String)"LBL_Remote"));
        this.remoteRadioButton.setHorizontalAlignment(2);
        this.remoteRadioButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                CallEjbPanel.this.remoteRadioButtonItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 5);
        this.add((Component)this.remoteRadioButton, gridBagConstraints);
        this.remoteRadioButton.getAccessibleContext().setAccessibleName(bundle.getString("LBL_Remote"));
        this.remoteRadioButton.getAccessibleContext().setAccessibleDescription(bundle.getString("LBL_Remote"));
        this.getAccessibleContext().setAccessibleName(bundle.getString("ACS_CallEJBPanel"));
        this.getAccessibleContext().setAccessibleDescription(bundle.getString("ACS_CallEJBPanel"));
    }

    private void remoteRadioButtonItemStateChanged(ItemEvent evt) {
        this.validateReferences();
    }

    public boolean convertToRuntime() {
        return this.convertToRuntime.isSelected();
    }

    public Node getEjb() {
        Node[] selectedNodes = this.nodeDisplayPanel.getSelectedNodes();
        return selectedNodes.length > 0 ? selectedNodes[0] : null;
    }

    public String getServiceLocator() {
        return this.slPanel.classSelected();
    }

    public String getReferenceName() {
        return this.referenceNameTextField.getText();
    }

    public boolean isDefaultRefName() {
        EjbReference ejbReference;
        Node[] nodes = this.nodeDisplayPanel.getSelectedNodes();
        if (nodes.length > 0 && (ejbReference = (EjbReference)nodes[0].getLookup().lookup(EjbReference.class)) != null) {
            try {
                return this.getReferenceName().equals(this.generateName(ejbReference, this.remoteRadioButton.isSelected(), nodes[0]));
            }
            catch (IOException ioe) {
                Exceptions.printStackTrace((Throwable)ioe);
            }
        }
        return false;
    }

    public EjbReference.EjbRefIType getSelectedInterface() {
        if (this.noInterfaceRadioButton.isSelected()) {
            return EjbReference.EjbRefIType.NO_INTERFACE;
        }
        if (this.localRadioButton.isSelected()) {
            return EjbReference.EjbRefIType.LOCAL;
        }
        if (this.remoteRadioButton.isSelected()) {
            return EjbReference.EjbRefIType.REMOTE;
        }
        return null;
    }

    private String generateName(EjbReference ejbReference, boolean remote, Node selectedNode) throws IOException {
        String name = "";
        final ElementHandle<TypeElement> elementHandle = _RetoucheUtil.getJavaClassFromNode(selectedNode);
        assert (elementHandle != null) : "ElementHandle not found for the node: " + selectedNode;
        org.netbeans.modules.j2ee.api.ejbjar.EjbJar ejbModule = ejbReference.getEjbModule();
        if (ejbModule != null) {
            boolean targetIsJavaSE;
            Map names = (Map)ejbModule.getMetadataModel().runReadAction((MetadataModelAction)new MetadataModelAction<EjbJarMetadata, Map<String, String>>(){

                public Map<String, String> run(EjbJarMetadata metadata) throws Exception {
                    HashMap<String, String> result = new HashMap<String, String>();
                    EntityAndSession ejb = (EntityAndSession)metadata.findByEjbClass(elementHandle.getQualifiedName());
                    if (ejb != null) {
                        result.put("Home", ejb.getHome());
                        result.put("EjbName", ejb.getEjbName());
                    }
                    return result;
                }
            });
            name = remote ? ((targetIsJavaSE = Utils.isTargetJavaSE(this.srcFile, this.className)) && Util.isJavaEE5orHigher((Project)this.project) ? elementHandle.getQualifiedName() : (targetIsJavaSE ? (String)names.get("Home") : (String)names.get("EjbName"))) : (String)names.get("EjbName");
        }
        int uniquifier = 1;
        String newName = name;
        while (this.getRefNameSet().contains(newName)) {
            newName = name + String.valueOf(uniquifier++);
        }
        return name;
    }

    private void setGeneratedName(EjbReference ejbReference, boolean remote, Node selectedNode) throws IOException {
        this.referenceNameTextField.setText(this.generateName(ejbReference, remote, selectedNode));
    }

    private class NodeAcceptorImpl
    implements NodeAcceptor {
        public boolean acceptNodes(Node[] nodes) {
            CallEjbPanel.this.statusLine.clearMessages();
            if (nodes.length == 0) {
                CallEjbPanel.this.statusLine.setErrorMessage(NbBundle.getMessage(CallEjbPanel.class, (String)"LBL_SelectOneEJB"));
                return false;
            }
            if (nodes.length > 1) {
                CallEjbPanel.this.statusLine.setErrorMessage(NbBundle.getMessage(CallEjbPanel.class, (String)"LBL_MoreEJBsSelected"));
                return false;
            }
            ElementHandle<TypeElement> elementHandle = null;
            try {
                elementHandle = _RetoucheUtil.getJavaClassFromNode(nodes[0]);
            }
            catch (IOException ioe) {
                Exceptions.printStackTrace((Throwable)ioe);
            }
            if (elementHandle == null) {
                CallEjbPanel.this.statusLine.setErrorMessage(NbBundle.getMessage(CallEjbPanel.class, (String)"LBL_NodeIsNotEJB"));
                return false;
            }
            if (elementHandle.getQualifiedName().equals(CallEjbPanel.this.className)) {
                CallEjbPanel.this.statusLine.setErrorMessage(NbBundle.getMessage(CallEjbPanel.class, (String)"LBL_CannotCallItself", (Object)CallEjbPanel.this.className));
                return false;
            }
            EjbReference ejbRef = (EjbReference)nodes[0].getLookup().lookup(EjbReference.class);
            if (ejbRef == null) {
                CallEjbPanel.this.statusLine.setErrorMessage(NbBundle.getMessage(CallEjbPanel.class, (String)"LBL_ReferencesNotSupported"));
                return false;
            }
            if (!this.acceptInterfaces(nodes)) {
                return false;
            }
            if (!this.validateRefName()) {
                return false;
            }
            FileObject fileObject = (FileObject)nodes[0].getLookup().lookup(FileObject.class);
            if (fileObject == null) {
                CallEjbPanel.this.statusLine.setErrorMessage(NbBundle.getMessage(CallEjbPanel.class, (String)"LBL_NoSourcesForBean"));
                return false;
            }
            boolean isRemoteInterfaceSelected = CallEjbPanel.this.getSelectedInterface() == EjbReference.EjbRefIType.REMOTE;
            Project nodeProject = FileOwnerQuery.getOwner((FileObject)fileObject);
            if (isRemoteInterfaceSelected) {
                try {
                    if (nodeProject.equals(Utils.getProject(ejbRef, EjbReference.EjbRefIType.REMOTE))) {
                        CallEjbPanel.this.statusLine.setErrorMessage(NbBundle.getMessage(CallEjbPanel.class, (String)"LBL_RemoteNotInSeparateJar"));
                        return false;
                    }
                }
                catch (IOException ex) {}
            } else {
                if (!nodeProject.equals(CallEjbPanel.this.project) && !Utils.areInSameJ2EEApp(CallEjbPanel.this.project, nodeProject)) {
                    CallEjbPanel.this.statusLine.setErrorMessage(NbBundle.getMessage(CallEjbPanel.class, (String)"LBL_NotInSameEarOrProject"));
                    return false;
                }
                if (Utils.isAppClient(CallEjbPanel.this.project)) {
                    CallEjbPanel.this.statusLine.setErrorMessage(NbBundle.getMessage(CallEjbPanel.class, (String)"LBL_CannotCallLocalInAC"));
                    return false;
                }
                try {
                    if (Utils.isTargetJavaSE(CallEjbPanel.this.srcFile, CallEjbPanel.this.className)) {
                        CallEjbPanel.this.statusLine.setErrorMessage(NbBundle.getMessage(CallEjbPanel.class, (String)"LBL_CannotCallLocalInJSE"));
                        return false;
                    }
                }
                catch (IOException ioe) {
                    Exceptions.printStackTrace((Throwable)ioe);
                    return false;
                }
            }
            if (!Util.isJavaEE5orHigher((Project)CallEjbPanel.this.project) && Util.isJavaEE5orHigher((Project)nodeProject)) {
                CallEjbPanel.this.statusLine.setWarningMessage(NbBundle.getMessage(CallEjbPanel.class, (String)"LBL_JEESpecificationLevelsDiffer"));
            }
            return true;
        }

        private boolean acceptInterfaces(Node[] nodes) {
            EjbReference ejbReference = (EjbReference)nodes[0].getLookup().lookup(EjbReference.class);
            if (ejbReference == null) {
                return false;
            }
            boolean shouldEnableNoInterface = J2eeProjectCapabilities.forProject((Project)CallEjbPanel.this.project).isEjb31LiteSupported() && this.isNoInterfaceViewExposed(ejbReference);
            boolean shouldEnableLocal = ejbReference.getLocal() != null;
            boolean shouldEnableRemote = ejbReference.getRemote() != null;
            CallEjbPanel.this.noInterfaceRadioButton.setEnabled(shouldEnableNoInterface);
            CallEjbPanel.this.localRadioButton.setEnabled(shouldEnableLocal);
            CallEjbPanel.this.remoteRadioButton.setEnabled(shouldEnableRemote);
            if (!(shouldEnableLocal || shouldEnableRemote || shouldEnableNoInterface)) {
                CallEjbPanel.this.statusLine.setErrorMessage(NbBundle.getMessage(CallEjbPanel.class, (String)"LBL_ReferencesNotSupported"));
                return false;
            }
            if (!CallEjbPanel.this.intefaceButtonGroup.getSelection().isEnabled()) {
                if (shouldEnableNoInterface) {
                    CallEjbPanel.this.noInterfaceRadioButton.setSelected(true);
                } else if (shouldEnableLocal) {
                    CallEjbPanel.this.localRadioButton.setSelected(true);
                } else if (shouldEnableRemote) {
                    CallEjbPanel.this.remoteRadioButton.setSelected(true);
                }
            }
            CallEjbPanel.this.statusLine.clearMessages();
            return true;
        }

        private boolean isNoInterfaceViewExposed(final EjbReference ejbRef) {
            if (ejbRef.getLocal() == null && ejbRef.getRemote() == null) {
                return true;
            }
            Boolean result = Boolean.FALSE;
            try {
                result = (Boolean)ejbRef.getEjbModule().getMetadataModel().runReadAction((MetadataModelAction)new MetadataModelAction<EjbJarMetadata, Boolean>(){

                    public Boolean run(EjbJarMetadata metadata) throws Exception {
                        Ejb ejb = metadata.findByEjbClass(ejbRef.getEjbClass());
                        if (ejb instanceof Session) {
                            return ((Session)ejb).isLocalBean();
                        }
                        return Boolean.FALSE;
                    }
                });
            }
            catch (MetadataModelException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            return result;
        }

        private boolean hasJarArtifact() {
            Project nodeProject = FileOwnerQuery.getOwner((FileObject)CallEjbPanel.this.srcFile);
            if (nodeProject.equals(CallEjbPanel.this.project)) {
                return true;
            }
            return AntArtifactQuery.findArtifactsByType((Project)nodeProject, (String)"jar").length > 0;
        }

        private boolean validateRefName() {
            String refName = CallEjbPanel.this.referenceNameTextField.getText();
            if (refName.trim().length() < 1) {
                CallEjbPanel.this.statusLine.setErrorMessage(NbBundle.getMessage(CallEjbPanel.class, (String)"ERR_ReferenceNameEmpty", (Object)refName));
                return false;
            }
            if (CallEjbPanel.this.refNameSet.contains(refName)) {
                CallEjbPanel.this.statusLine.setErrorMessage(NbBundle.getMessage(CallEjbPanel.class, (String)"ERR_ReferenceNameExists", (Object)refName));
                return false;
            }
            return true;
        }
    }
}

