/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.diff;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.diff.DiffController;
import org.netbeans.api.diff.Difference;
import org.netbeans.api.diff.StreamSource;
import org.netbeans.modules.subversion.FileInformation;
import org.netbeans.modules.subversion.FileStatusCache;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.SvnFileNode;
import org.netbeans.modules.subversion.SvnModuleConfig;
import org.netbeans.modules.subversion.client.PropertiesClient;
import org.netbeans.modules.subversion.client.SvnClientExceptionHandler;
import org.netbeans.modules.subversion.client.SvnProgressSupport;
import org.netbeans.modules.subversion.ui.actions.ContextAction;
import org.netbeans.modules.subversion.ui.commit.CommitAction;
import org.netbeans.modules.subversion.ui.diff.DiffFileTable;
import org.netbeans.modules.subversion.ui.diff.DiffNode;
import org.netbeans.modules.subversion.ui.diff.DiffSetupSource;
import org.netbeans.modules.subversion.ui.diff.Setup;
import org.netbeans.modules.subversion.ui.status.StatusAction;
import org.netbeans.modules.subversion.ui.update.UpdateAction;
import org.netbeans.modules.subversion.util.Context;
import org.netbeans.modules.subversion.util.SvnUtils;
import org.netbeans.modules.versioning.diff.AbstractDiffSetup;
import org.netbeans.modules.versioning.diff.DiffLookup;
import org.netbeans.modules.versioning.diff.DiffUtils;
import org.netbeans.modules.versioning.diff.EditorSaveCookie;
import org.netbeans.modules.versioning.diff.SaveBeforeClosingDiffConfirmation;
import org.netbeans.modules.versioning.diff.SaveBeforeCommitConfirmation;
import org.netbeans.modules.versioning.util.CollectionUtils;
import org.netbeans.modules.versioning.util.DelegatingUndoRedo;
import org.netbeans.modules.versioning.util.NoContentPanel;
import org.netbeans.modules.versioning.util.PlaceholderPanel;
import org.netbeans.modules.versioning.util.Utils;
import org.netbeans.modules.versioning.util.VersioningEvent;
import org.netbeans.modules.versioning.util.VersioningListener;
import org.netbeans.spi.diff.DiffProvider;
import org.openide.LifecycleManager;
import org.openide.awt.UndoRedo;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.Node;
import org.openide.util.Cancellable;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.TopComponent;
import org.tigris.subversion.svnclientadapter.ISVNStatus;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class MultiDiffPanel
extends JPanel
implements ActionListener,
VersioningListener,
DiffSetupSource,
PropertyChangeListener,
PreferenceChangeListener {
    private Setup[] setups;
    private EditorCookie[] editorCookies;
    private final DelegatingUndoRedo delegatingUndoRedo = new DelegatingUndoRedo();
    private final DiffLookup lookup = new DiffLookup();
    private final Context context;
    private final File diffedFile;
    private int displayStatuses;
    private final String contextName;
    private int currentType;
    private int currentIndex = -1;
    private int currentModelIndex = -1;
    private RequestProcessor.Task prepareTask;
    private DiffPrepareTask dpt;
    private AbstractAction nextAction;
    private AbstractAction prevAction;
    private RequestProcessor.Task refreshTask;
    private JComponent diffView;
    private DiffFileTable fileTable;
    private boolean dividerSet;
    private boolean remoteStatusCalled;
    private boolean initialRefreshDisabled;
    private final PlaceholderPanel diffViewPanel;
    private JComponent infoPanelLoadingFromRepo;
    private SvnProgressSupport executeStatusSupport;
    private boolean fileTableSetSelectedIndexContext;
    private JToggleButton allToggle;
    private JButton commitButton;
    private JToolBar controlsToolBar;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JToggleButton localToggle;
    private JButton nextButton;
    private JButton prevButton;
    private JButton refreshButton;
    private JToggleButton remoteToggle;
    private JSplitPane splitPane;
    private JButton updateButton;

    public MultiDiffPanel(Context context, int initialType, String contextName, boolean initialRefreshDisabled) {
        assert (EventQueue.isDispatchThread());
        this.context = context;
        this.diffedFile = null;
        this.contextName = contextName;
        this.initialRefreshDisabled = initialRefreshDisabled;
        this.currentType = initialType;
        this.initComponents();
        this.aquaBackgroundWorkaround();
        this.initFileTable();
        this.initToolbarButtons();
        this.initNextPrevActions();
        this.diffViewPanel = null;
        this.refreshComponents();
        this.refreshTask = Utils.createTask((Runnable)new RefreshViewTask());
        if (initialRefreshDisabled) {
            this.refreshTask.schedule(0);
        } else {
            this.onRefreshButton();
        }
    }

    private void aquaBackgroundWorkaround() {
        if ("Aqua".equals(UIManager.getLookAndFeel().getID())) {
            Color color = UIManager.getColor("NbExplorerView.background");
            this.setBackground(color);
            this.controlsToolBar.setBackground(color);
            this.jPanel1.setBackground(color);
            this.jPanel2.setBackground(color);
            this.jPanel4.setBackground(color);
            this.jPanel5.setBackground(color);
        }
    }

    public MultiDiffPanel(File file, String rev1, String rev2, boolean forceNonEditable) {
        assert (EventQueue.isDispatchThread());
        this.context = null;
        this.diffedFile = file;
        this.contextName = file.getName();
        this.initComponents();
        this.initToolbarButtons();
        this.initNextPrevActions();
        this.diffViewPanel = new PlaceholderPanel();
        this.diffViewPanel.setComponent((Component)this.getInfoPanelLoading());
        this.replaceVerticalSplitPane((JComponent)this.diffViewPanel);
        AbstractDiffSetup[] localSetups = new Setup[]{new Setup(file, rev1, rev2, forceNonEditable)};
        this.setSetups((Setup[])localSetups, DiffUtils.setupsToEditorCookies((AbstractDiffSetup[])localSetups));
        this.setDiffIndex(0, 0, false);
        this.dpt = new DiffPrepareTask(this.setups);
        this.prepareTask = Subversion.getInstance().getRequestProcessor().post((Runnable)this.dpt);
    }

    public MultiDiffPanel(File file, ISVNStatus status) {
        assert (EventQueue.isDispatchThread());
        this.context = null;
        this.diffedFile = file;
        this.contextName = file.getName();
        this.initComponents();
        this.initToolbarButtons();
        this.initNextPrevActions();
        this.diffViewPanel = new PlaceholderPanel();
        this.diffViewPanel.setComponent((Component)this.getInfoPanelLoading());
        this.replaceVerticalSplitPane((JComponent)this.diffViewPanel);
        this.refreshButton.setVisible(false);
        AbstractDiffSetup[] localSetups = new Setup[]{new Setup(file, status)};
        this.setSetups((Setup[])localSetups, DiffUtils.setupsToEditorCookies((AbstractDiffSetup[])localSetups));
        this.setDiffIndex(0, 0, false);
        this.dpt = new DiffPrepareTask(this.setups);
        this.prepareTask = Subversion.getInstance().getRequestProcessor().post((Runnable)this.dpt);
    }

    private void replaceVerticalSplitPane(JComponent replacement) {
        this.removeAll();
        this.splitPane = null;
        this.setLayout(new BorderLayout());
        this.controlsToolBar.setPreferredSize(new Dimension(Short.MAX_VALUE, 25));
        this.add((Component)this.controlsToolBar, "North");
        this.add((Component)replacement, "Center");
    }

    private void setSetups(Setup[] setups, EditorCookie[] cookies) {
        this.setups = setups;
        this.editorCookies = cookies;
    }

    void tableRowSelected(int viewIndex) {
        if (this.fileTableSetSelectedIndexContext) {
            return;
        }
        this.setDiffIndex(viewIndex, 0, true);
    }

    UndoRedo getUndoRedo() {
        return this.delegatingUndoRedo;
    }

    private void cancelBackgroundTasks() {
        if (this.prepareTask != null) {
            this.prepareTask.cancel();
        }
        if (this.executeStatusSupport != null) {
            this.executeStatusSupport.cancel();
        }
    }

    public Lookup getLookup() {
        return this.lookup;
    }

    boolean canClose() {
        if (this.setups == null) {
            return true;
        }
        SaveCookie[] saveCookies = this.getSaveCookies(true);
        return saveCookies.length == 0 || SaveBeforeClosingDiffConfirmation.allSaved((SaveCookie[])saveCookies);
    }

    public SaveCookie[] getSaveCookies(boolean ommitOpened) {
        EditorCookie[] editorCookiesCopy = this.getEditorCookiesIntern(ommitOpened);
        SaveCookie[] saveCookies = MultiDiffPanel.getSaveCookies(this.setups, editorCookiesCopy);
        return saveCookies;
    }

    public EditorCookie[] getEditorCookies(boolean ommitOpened) {
        EditorCookie[] editorCookiesCopy = this.getEditorCookiesIntern(ommitOpened);
        int count = 0;
        int length = editorCookiesCopy.length;
        Object[] editorCookiesShorten = new EditorCookie[length];
        for (int i = 0; i < length; ++i) {
            EditorCookie editorCookie = editorCookiesCopy[i];
            if (editorCookie == null) continue;
            editorCookiesShorten[count++] = editorCookie;
        }
        return (EditorCookie[])CollectionUtils.shortenArray((Object[])editorCookiesShorten, (int)count);
    }

    private EditorCookie[] getEditorCookiesIntern(boolean ommitOpened) {
        EditorCookie[] editorCookiesCopy = (EditorCookie[])CollectionUtils.copyArray((Object[])this.editorCookies);
        DiffUtils.cleanThoseUnmodified((EditorCookie[])editorCookiesCopy);
        if (ommitOpened) {
            DiffUtils.cleanThoseWithEditorPaneOpen((EditorCookie[])editorCookiesCopy);
        }
        return editorCookiesCopy;
    }

    private static SaveCookie[] getSaveCookies(Setup[] setups, EditorCookie[] editorCookies) {
        assert (setups.length == editorCookies.length);
        int length = setups.length;
        Object[] proResult = new SaveCookie[length];
        int count = 0;
        for (int i = 0; i < length; ++i) {
            FileObject fileObj;
            File baseFile;
            EditorCookie editorCookie = editorCookies[i];
            if (editorCookie == null || (baseFile = setups[i].getBaseFile()) == null || (fileObj = FileUtil.toFileObject((File)baseFile)) == null) continue;
            proResult[count++] = new EditorSaveCookie(editorCookie, fileObj.getNameExt());
        }
        return (SaveCookie[])CollectionUtils.shortenArray((Object[])proResult, (int)count);
    }

    void componentClosed() {
        this.setSetups(null, null);
        this.prevAction.setEnabled(false);
        this.nextAction.setEnabled(false);
        this.cancelBackgroundTasks();
    }

    void requestActive() {
        if (this.fileTable != null) {
            this.fileTable.getTable().requestFocusInWindow();
        } else if (this.diffView != null) {
            this.diffView.requestFocusInWindow();
        }
    }

    private void initFileTable() {
        this.fileTable = new DiffFileTable(this);
        this.splitPane.setTopComponent(this.fileTable.getComponent());
        this.splitPane.setBottomComponent(this.getInfoPanelLoading());
    }

    private void initToolbarButtons() {
        if (this.context != null) {
            this.commitButton.addActionListener(this);
            this.localToggle.addActionListener(this);
            this.remoteToggle.addActionListener(this);
            this.allToggle.addActionListener(this);
            this.commitButton.setToolTipText(NbBundle.getMessage(MultiDiffPanel.class, (String)"CTL_DiffPanel_Commit_Tooltip"));
            this.updateButton.setToolTipText(NbBundle.getMessage(MultiDiffPanel.class, (String)"CTL_DiffPanel_Update_Tooltip"));
            ButtonGroup grp = new ButtonGroup();
            grp.add(this.localToggle);
            grp.add(this.remoteToggle);
            grp.add(this.allToggle);
            if (this.currentType == 0) {
                this.localToggle.setSelected(true);
            } else if (this.currentType == 1) {
                this.remoteToggle.setSelected(true);
            } else if (this.currentType == 2) {
                this.allToggle.setSelected(true);
            }
            this.commitButton.setEnabled(false);
        } else {
            this.commitButton.setVisible(false);
            this.updateButton.setVisible(false);
            this.localToggle.setVisible(false);
            this.remoteToggle.setVisible(false);
            this.allToggle.setVisible(false);
            this.refreshButton.setVisible(false);
        }
    }

    private void initNextPrevActions() {
        this.nextAction = new AbstractAction(null, new ImageIcon(this.getClass().getResource("/org/netbeans/modules/subversion/resources/icons/diff-next.png"))){
            {
                this.putValue("ShortDescription", ResourceBundle.getBundle("org/netbeans/modules/subversion/ui/diff/Bundle").getString("CTL_DiffPanel_Next_Tooltip"));
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                MultiDiffPanel.this.onNextButton();
            }
        };
        this.prevAction = new AbstractAction(null, new ImageIcon(this.getClass().getResource("/org/netbeans/modules/subversion/resources/icons/diff-prev.png"))){
            {
                this.putValue("ShortDescription", ResourceBundle.getBundle("org/netbeans/modules/subversion/ui/diff/Bundle").getString("CTL_DiffPanel_Prev_Tooltip"));
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                MultiDiffPanel.this.onPrevButton();
            }
        };
        this.nextButton.setAction(this.nextAction);
        this.prevButton.setAction(this.prevAction);
    }

    private JComponent getInfoPanelLoading() {
        if (this.infoPanelLoadingFromRepo == null) {
            this.infoPanelLoadingFromRepo = new NoContentPanel(NbBundle.getMessage(MultiDiffPanel.class, (String)"MSG_DiffPanel_NoContent"));
        }
        return this.infoPanelLoadingFromRepo;
    }

    private void refreshComponents() {
        int currentDifferenceIndex;
        assert (EventQueue.isDispatchThread());
        DiffController view = this.setups != null && this.currentModelIndex != -1 ? this.setups[this.currentModelIndex].getView() : null;
        int n = currentDifferenceIndex = view != null ? view.getDifferenceIndex() : -1;
        if (view != null) {
            this.nextAction.setEnabled(this.currentIndex < this.setups.length - 1 || currentDifferenceIndex < view.getDifferenceCount() - 1);
        } else {
            this.nextAction.setEnabled(false);
        }
        this.prevAction.setEnabled(this.currentIndex > 0 || currentDifferenceIndex > 0);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (this.refreshTask != null) {
            Subversion.getInstance().getStatusCache().addVersioningListener(this);
            SvnModuleConfig.getDefault().getPreferences().addPreferenceChangeListener(this);
        }
        JComponent parent = (JComponent)this.getParent();
        parent.getActionMap().put("jumpNext", this.nextAction);
        parent.getActionMap().put("jumpPrev", this.prevAction);
    }

    private void updateSplitLocation() {
        Dimension dim;
        if (this.dividerSet) {
            return;
        }
        JComponent parent = (JComponent)this.getParent();
        Dimension dimension = dim = parent == null ? new Dimension() : parent.getSize();
        if (dim.width <= 0 || dim.height <= 0) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MultiDiffPanel.this.updateSplitLocation();
                }
            });
            return;
        }
        this.dividerSet = true;
        JTable jt = this.fileTable.getTable();
        int optimalLocation = jt.getPreferredSize().height + jt.getTableHeader().getPreferredSize().height;
        if (optimalLocation > dim.height / 3) {
            optimalLocation = dim.height / 3;
        }
        if (optimalLocation <= jt.getTableHeader().getPreferredSize().height) {
            optimalLocation = jt.getTableHeader().getPreferredSize().height * 3;
        }
        this.splitPane.setDividerLocation(optimalLocation);
    }

    @Override
    public void removeNotify() {
        Subversion.getInstance().getStatusCache().removeVersioningListener(this);
        if (this.refreshTask != null) {
            SvnModuleConfig.getDefault().getPreferences().removePreferenceChangeListener(this);
        }
        super.removeNotify();
    }

    public void versioningEvent(VersioningEvent event) {
        if (event.getId() == FileStatusCache.EVENT_FILE_STATUS_CHANGED) {
            if (!this.affectsView(event)) {
                return;
            }
            this.refreshTask.schedule(200);
        }
    }

    private boolean affectsView(VersioningEvent event) {
        File file = (File)event.getParams()[0];
        FileInformation oldInfo = (FileInformation)event.getParams()[1];
        FileInformation newInfo = (FileInformation)event.getParams()[2];
        if (oldInfo == null ? (newInfo.getStatus() & this.displayStatuses) == 0 : (oldInfo.getStatus() & this.displayStatuses) + (newInfo.getStatus() & this.displayStatuses) == 0) {
            return false;
        }
        return this.context.contains(file);
    }

    private void setDiffIndex(int idx, int location, boolean restartPrepareTask) {
        assert (EventQueue.isDispatchThread());
        this.currentIndex = idx;
        DiffController view = null;
        if (this.currentIndex != -1) {
            EditorCookie editorCookie;
            TopComponent tc;
            if (restartPrepareTask && this.dpt != null) {
                this.prepareTask.cancel();
                this.dpt.setTableIndex(this.currentIndex);
                this.prepareTask.schedule(100);
            }
            this.currentModelIndex = this.showingFileTable() ? this.fileTable.getModelIndex(this.currentIndex) : 0;
            view = this.setups[this.currentModelIndex].getView();
            FileObject fileObj = null;
            EditorCookie.Observable observableEditorCookie = null;
            File baseFile = this.setups[this.currentModelIndex].getBaseFile();
            if (baseFile != null) {
                fileObj = FileUtil.toFileObject((File)baseFile);
            }
            if ((tc = (TopComponent)this.getClientProperty(TopComponent.class)) != null) {
                DiffNode node = this.setups[this.currentModelIndex].getNode();
                tc.setActivatedNodes(new Node[]{node == null ? Node.EMPTY : node});
            }
            if ((editorCookie = this.editorCookies[this.currentModelIndex]) instanceof EditorCookie.Observable) {
                observableEditorCookie = (EditorCookie.Observable)editorCookie;
            }
            this.diffView = null;
            if (view != null) {
                if (this.showingFileTable()) {
                    this.fileTableSetSelectedIndexContext = true;
                    this.fileTable.setSelectedIndex(this.currentIndex);
                    this.fileTableSetSelectedIndexContext = false;
                }
                this.diffView = view.getJComponent();
                this.diffView.getActionMap().put("jumpNext", this.nextAction);
                this.diffView.getActionMap().put("jumpPrev", this.prevAction);
                this.displayDiffView();
                if (location == -1) {
                    location = view.getDifferenceCount() - 1;
                }
                if (location >= 0 && location < view.getDifferenceCount()) {
                    view.setLocation(DiffController.DiffPane.Modified, DiffController.LocationType.DifferenceIndex, location);
                }
            } else {
                this.diffView = new NoContentPanel(NbBundle.getMessage(MultiDiffPanel.class, (String)"MSG_DiffPanel_NoContent"));
                this.displayDiffView();
            }
            this.lookup.setData(new Object[]{fileObj, observableEditorCookie, this.diffView.getActionMap()});
        } else {
            this.currentModelIndex = -1;
            this.lookup.setData(new Object[0]);
            this.diffView = new NoContentPanel(NbBundle.getMessage(MultiDiffPanel.class, (String)"MSG_DiffPanel_NoFileSelected"));
            this.lookup.setData(new Object[]{this.diffView.getActionMap()});
            this.displayDiffView();
        }
        this.delegatingUndoRedo.setDiffView(this.diffView);
        this.refreshComponents();
    }

    private boolean showingFileTable() {
        return this.fileTable != null;
    }

    private void displayDiffView() {
        if (this.splitPane != null) {
            int gg = this.splitPane.getDividerLocation();
            this.splitPane.setBottomComponent(this.diffView);
            this.splitPane.setDividerLocation(gg);
        } else {
            this.diffViewPanel.setComponent((Component)this.diffView);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.commitButton) {
            this.onCommitButton();
        } else if (source == this.localToggle || source == this.remoteToggle || source == this.allToggle) {
            this.onDiffTypeChanged();
        }
    }

    private void onRefreshButton() {
        SVNUrl url;
        if (this.context == null || this.context.getRoots().isEmpty()) {
            return;
        }
        if (this.executeStatusSupport != null) {
            this.executeStatusSupport.cancel();
            this.executeStatusSupport = null;
        }
        LifecycleManager.getDefault().saveAll();
        RequestProcessor rp = Subversion.getInstance().getRequestProcessor();
        this.executeStatusSupport = new SvnProgressSupport(){

            @Override
            public void perform() {
                MultiDiffPanel.this.remoteStatusCalled = (byte)(MultiDiffPanel.this.remoteStatusCalled | (MultiDiffPanel.this.currentType != 0 ? 1 : 0));
                StatusAction.executeStatus(MultiDiffPanel.this.context, this, MultiDiffPanel.this.remoteStatusCalled);
                if (!this.isCanceled()) {
                    MultiDiffPanel.this.refreshTask.schedule(50);
                }
            }
        };
        try {
            url = ContextAction.getSvnUrl(this.context);
        }
        catch (SVNClientException ex) {
            SvnClientExceptionHandler.notifyException((Exception)((Object)ex), true, true);
            return;
        }
        this.executeStatusSupport.start(rp, url, NbBundle.getMessage(MultiDiffPanel.class, (String)"MSG_Refresh_Progress"));
    }

    private void onUpdateButton() {
        if (this.context != null) {
            UpdateAction.performUpdate(this.context, this.contextName);
        } else if (this.diffedFile != null) {
            UpdateAction.performUpdate(this.diffedFile);
        }
    }

    private void onCommitButton() {
        EditorCookie[] editorCookiesCopy = (EditorCookie[])CollectionUtils.copyArray((Object[])this.editorCookies);
        DiffUtils.cleanThoseUnmodified((EditorCookie[])editorCookiesCopy);
        SaveCookie[] saveCookies = MultiDiffPanel.getSaveCookies(this.setups, editorCookiesCopy);
        if (saveCookies.length == 0 || SaveBeforeCommitConfirmation.allSaved((SaveCookie[])saveCookies)) {
            CommitAction.commit(this.contextName, this.context, false);
        }
    }

    private void onNextButton() {
        DiffController view;
        assert (this.setups != null) : "setups is null";
        assert (this.setups[this.currentModelIndex] != null) : "setups[" + this.currentModelIndex + "] is null";
        if (this.setups == null || this.setups[this.currentModelIndex] == null) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MultiDiffPanel.this.nextButton.setEnabled(false);
                }
            });
            return;
        }
        if (this.showingFileTable()) {
            this.currentIndex = this.fileTable.getSelectedIndex();
            this.currentModelIndex = this.fileTable.getSelectedModelIndex();
        }
        if ((view = this.setups[this.currentModelIndex].getView()) != null) {
            int currentDifferenceIndex = view.getDifferenceIndex();
            if (++currentDifferenceIndex >= view.getDifferenceCount()) {
                if (++this.currentIndex >= this.setups.length) {
                    --this.currentIndex;
                } else {
                    this.setDiffIndex(this.currentIndex, 0, true);
                }
            } else {
                view.setLocation(DiffController.DiffPane.Modified, DiffController.LocationType.DifferenceIndex, currentDifferenceIndex);
            }
        } else {
            if (++this.currentIndex >= this.setups.length) {
                this.currentIndex = 0;
            }
            this.setDiffIndex(this.currentIndex, 0, true);
        }
        this.refreshComponents();
    }

    private void onPrevButton() {
        DiffController view = this.setups[this.currentModelIndex].getView();
        if (view != null) {
            int currentDifferenceIndex = view.getDifferenceIndex();
            if (--currentDifferenceIndex < 0) {
                if (--this.currentIndex < 0) {
                    ++this.currentIndex;
                } else {
                    this.setDiffIndex(this.currentIndex, -1, true);
                }
            } else if (currentDifferenceIndex < view.getDifferenceCount()) {
                view.setLocation(DiffController.DiffPane.Modified, DiffController.LocationType.DifferenceIndex, currentDifferenceIndex);
            }
        } else {
            if (--this.currentIndex < 0) {
                this.currentIndex = this.setups.length - 1;
            }
            this.setDiffIndex(this.currentIndex, -1, true);
        }
        this.refreshComponents();
    }

    @Override
    public Collection<Setup> getSetups() {
        if (this.setups == null) {
            return Collections.emptySet();
        }
        return Arrays.asList(this.setups);
    }

    @Override
    public String getSetupDisplayName() {
        return this.contextName;
    }

    @Override
    public void preferenceChange(PreferenceChangeEvent evt) {
        if (evt.getKey().startsWith("commitExclusions")) {
            this.repaint();
        }
    }

    private void addPropertiesSetups(File base, List<Setup> newSetups, int displayStatus) {
        if (this.currentType == 1) {
            return;
        }
        DiffProvider diffAlgorithm = (DiffProvider)Lookup.getDefault().lookup(DiffProvider.class);
        PropertiesClient client = new PropertiesClient(base);
        try {
            Map<String, byte[]> baseProps = client.getBaseProperties(this.currentType == 2);
            Map<String, byte[]> localProps = client.getProperties();
            TreeSet<String> allProps = new TreeSet<String>(localProps.keySet());
            allProps.addAll(baseProps.keySet());
            for (String key : allProps) {
                boolean isBase = baseProps.containsKey(key);
                boolean isLocal = localProps.containsKey(key);
                boolean propertiesDiffer = true;
                if (isBase && isLocal) {
                    Property p1 = new Property(baseProps.get(key));
                    Property p2 = new Property(localProps.get(key));
                    Difference[] diffs = diffAlgorithm.computeDiff(p1.toReader(), p2.toReader());
                    boolean bl = propertiesDiffer = diffs.length != 0;
                }
                if (!propertiesDiffer) continue;
                Setup setup = new Setup(base, key, this.currentType);
                setup.setNode(new DiffNode(setup, new SvnFileNode(base), displayStatus));
                newSetups.add(setup);
            }
        }
        catch (IOException e) {
            FileInformation parentInfo = Subversion.getInstance().getStatusCache().getCachedStatus(base.getParentFile());
            Level logLevel = parentInfo != null && (parentInfo.getStatus() & 4) != 0 ? Level.FINE : Level.INFO;
            Subversion.LOG.log(logLevel, null, e);
        }
    }

    private void onDiffTypeChanged() {
        assert (EventQueue.isDispatchThread());
        if (this.localToggle.isSelected()) {
            if (this.currentType == 0) {
                return;
            }
            this.currentType = 0;
        } else if (this.remoteToggle.isSelected()) {
            if (this.currentType == 1) {
                return;
            }
            this.currentType = 1;
        } else if (this.allToggle.isSelected()) {
            if (this.currentType == 2) {
                return;
            }
            this.currentType = 2;
        }
        SvnModuleConfig.getDefault().setLastUsedModificationContext(this.currentType);
        if (!this.initialRefreshDisabled && !this.remoteStatusCalled && this.currentType != 0) {
            this.onRefreshButton();
        } else {
            this.refreshTask.schedule(0);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("(void) differencesChanged".equals(evt.getPropertyName())) {
            this.refreshComponents();
        }
    }

    private void initComponents() {
        this.controlsToolBar = new JToolBar();
        this.allToggle = new JToggleButton();
        this.jPanel3 = new JPanel();
        this.localToggle = new JToggleButton();
        this.jPanel4 = new JPanel();
        this.remoteToggle = new JToggleButton();
        this.jPanel1 = new JPanel();
        this.nextButton = new JButton();
        this.prevButton = new JButton();
        this.jPanel2 = new JPanel();
        this.refreshButton = new JButton();
        this.updateButton = new JButton();
        this.jPanel5 = new JPanel();
        this.commitButton = new JButton();
        this.splitPane = new JSplitPane();
        this.controlsToolBar.setFloatable(false);
        this.controlsToolBar.setRollover(true);
        this.allToggle.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/subversion/resources/icons/remote_vs_local.png")));
        this.allToggle.setToolTipText(NbBundle.getMessage(MultiDiffPanel.class, (String)"CTL_DiffPanel_All_Tooltip"));
        this.allToggle.setFocusable(false);
        this.allToggle.setHorizontalTextPosition(0);
        this.allToggle.setVerticalTextPosition(3);
        this.controlsToolBar.add(this.allToggle);
        this.jPanel3.setMaximumSize(new Dimension(12, Short.MAX_VALUE));
        GroupLayout jPanel3Layout = new GroupLayout((Container)this.jPanel3);
        this.jPanel3.setLayout((LayoutManager)jPanel3Layout);
        jPanel3Layout.setHorizontalGroup((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add(0, 12, Short.MAX_VALUE));
        jPanel3Layout.setVerticalGroup((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add(0, 23, Short.MAX_VALUE));
        this.controlsToolBar.add(this.jPanel3);
        this.localToggle.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/subversion/resources/icons/local_vs_local.png")));
        this.localToggle.setToolTipText(NbBundle.getMessage(MultiDiffPanel.class, (String)"CTL_DiffPanel_Local_Tooltip"));
        this.localToggle.setFocusable(false);
        this.localToggle.setHorizontalTextPosition(0);
        this.localToggle.setVerticalTextPosition(3);
        this.controlsToolBar.add(this.localToggle);
        this.jPanel4.setMaximumSize(new Dimension(12, Short.MAX_VALUE));
        GroupLayout jPanel4Layout = new GroupLayout((Container)this.jPanel4);
        this.jPanel4.setLayout((LayoutManager)jPanel4Layout);
        jPanel4Layout.setHorizontalGroup((GroupLayout.Group)jPanel4Layout.createParallelGroup(1).add(0, 12, Short.MAX_VALUE));
        jPanel4Layout.setVerticalGroup((GroupLayout.Group)jPanel4Layout.createParallelGroup(1).add(0, 23, Short.MAX_VALUE));
        this.controlsToolBar.add(this.jPanel4);
        this.remoteToggle.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/subversion/resources/icons/remote_vs_remote.png")));
        this.remoteToggle.setToolTipText(NbBundle.getMessage(MultiDiffPanel.class, (String)"CTL_DiffPanel_Remote_Tooltip"));
        this.remoteToggle.setFocusable(false);
        this.remoteToggle.setHorizontalTextPosition(0);
        this.remoteToggle.setVerticalTextPosition(3);
        this.controlsToolBar.add(this.remoteToggle);
        this.jPanel1.setMaximumSize(new Dimension(80, Short.MAX_VALUE));
        GroupLayout jPanel1Layout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)jPanel1Layout);
        jPanel1Layout.setHorizontalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add(0, 80, Short.MAX_VALUE));
        jPanel1Layout.setVerticalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add(0, 23, Short.MAX_VALUE));
        this.controlsToolBar.add(this.jPanel1);
        this.nextButton.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/subversion/resources/icons/diff-next.png")));
        this.nextButton.setToolTipText(NbBundle.getMessage(MultiDiffPanel.class, (String)"CTL_DiffPanel_Next_Tooltip"));
        this.nextButton.setFocusable(false);
        this.nextButton.setHorizontalTextPosition(0);
        this.nextButton.setVerticalTextPosition(3);
        this.controlsToolBar.add(this.nextButton);
        this.prevButton.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/subversion/resources/icons/diff-prev.png")));
        this.prevButton.setToolTipText(NbBundle.getMessage(MultiDiffPanel.class, (String)"CTL_DiffPanel_Prev_Tooltip"));
        this.prevButton.setFocusable(false);
        this.prevButton.setHorizontalTextPosition(0);
        this.prevButton.setVerticalTextPosition(3);
        this.controlsToolBar.add(this.prevButton);
        this.jPanel2.setMaximumSize(new Dimension(30, Short.MAX_VALUE));
        GroupLayout jPanel2Layout = new GroupLayout((Container)this.jPanel2);
        this.jPanel2.setLayout((LayoutManager)jPanel2Layout);
        jPanel2Layout.setHorizontalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add(0, 30, Short.MAX_VALUE));
        jPanel2Layout.setVerticalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add(0, 23, Short.MAX_VALUE));
        this.controlsToolBar.add(this.jPanel2);
        this.refreshButton.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/subversion/resources/icons/refresh.png")));
        this.refreshButton.setToolTipText(NbBundle.getMessage(MultiDiffPanel.class, (String)"refreshButton.toolTipText"));
        this.refreshButton.setFocusable(false);
        this.refreshButton.setHorizontalTextPosition(0);
        this.refreshButton.setVerticalTextPosition(3);
        this.refreshButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MultiDiffPanel.this.refreshButtonActionPerformed(evt);
            }
        });
        this.controlsToolBar.add(this.refreshButton);
        this.updateButton.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/subversion/resources/icons/update.png")));
        this.updateButton.setFocusable(false);
        this.updateButton.setHorizontalTextPosition(0);
        this.updateButton.setVerticalTextPosition(3);
        this.updateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MultiDiffPanel.this.updateButtonActionPerformed(evt);
            }
        });
        this.controlsToolBar.add(this.updateButton);
        this.jPanel5.setMaximumSize(new Dimension(20, Short.MAX_VALUE));
        GroupLayout jPanel5Layout = new GroupLayout((Container)this.jPanel5);
        this.jPanel5.setLayout((LayoutManager)jPanel5Layout);
        jPanel5Layout.setHorizontalGroup((GroupLayout.Group)jPanel5Layout.createParallelGroup(1).add(0, 20, Short.MAX_VALUE));
        jPanel5Layout.setVerticalGroup((GroupLayout.Group)jPanel5Layout.createParallelGroup(1).add(0, 23, Short.MAX_VALUE));
        this.controlsToolBar.add(this.jPanel5);
        this.commitButton.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/subversion/resources/icons/commit.png")));
        this.commitButton.setToolTipText(NbBundle.getMessage(MultiDiffPanel.class, (String)"MSG_CommitDiff_Tooltip"));
        this.commitButton.setFocusable(false);
        this.commitButton.setHorizontalTextPosition(0);
        this.commitButton.setVerticalTextPosition(3);
        this.controlsToolBar.add(this.commitButton);
        this.splitPane.setOrientation(0);
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.controlsToolBar, -1, 716, Short.MAX_VALUE).add((Component)this.splitPane, -1, 716, Short.MAX_VALUE));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.controlsToolBar, -2, 25, -2).addPreferredGap(0).add((Component)this.splitPane, -1, 331, Short.MAX_VALUE)));
    }

    private void updateButtonActionPerformed(ActionEvent evt) {
        this.onUpdateButton();
    }

    private void refreshButtonActionPerformed(ActionEvent evt) {
        this.remoteStatusCalled = true;
        this.onRefreshButton();
    }

    static final class Property {
        final byte[] value;

        Property(Object value) {
            this.value = (byte[])value;
        }

        String getMIME() {
            return "text/plain";
        }

        Reader toReader() {
            if (SvnUtils.isBinary(this.value)) {
                return new StringReader(NbBundle.getMessage(MultiDiffPanel.class, (String)"LBL_Diff_NoBinaryDiff"));
            }
            try {
                return new InputStreamReader((InputStream)new ByteArrayInputStream(this.value), "utf8");
            }
            catch (UnsupportedEncodingException ex) {
                Subversion.LOG.log(Level.SEVERE, null, ex);
                return new StringReader("[ERROR: " + ex.getLocalizedMessage() + "]");
            }
        }
    }

    private class RefreshViewTask
    implements Runnable {
        private RefreshViewTask() {
        }

        @Override
        public void run() {
            new SetupsPrepareSupport().start(Subversion.getInstance().getRequestProcessor(), null, NbBundle.getMessage(MultiDiffPanel.class, (String)"MSG_PrepareSetups_Progress")).waitFinished();
        }
    }

    private static class SetupsComparator
    implements Comparator<Setup> {
        private SvnUtils.ByImportanceComparator delegate = new SvnUtils.ByImportanceComparator();
        private FileStatusCache cache = Subversion.getInstance().getStatusCache();

        @Override
        public int compare(Setup setup1, Setup setup2) {
            int cmp = this.delegate.compare(this.cache.getStatus(setup1.getBaseFile()), this.cache.getStatus(setup2.getBaseFile()));
            if (cmp == 0) {
                return setup1.getBaseFile().getName().compareToIgnoreCase(setup2.getBaseFile().getName());
            }
            return cmp;
        }
    }

    private class DiffPrepareTask
    implements Runnable,
    Cancellable {
        private final Setup[] prepareSetups;
        private int tableIndex;
        private boolean canceled;

        public DiffPrepareTask(Setup[] prepareSetups) {
            this.prepareSetups = prepareSetups;
            this.tableIndex = 0;
        }

        @Override
        public void run() {
            int[] indexes;
            this.canceled = false;
            IOException exception = null;
            for (int i : indexes = this.prepareIndexesToRefresh()) {
                int modelIndex;
                if (this.prepareSetups != MultiDiffPanel.this.setups || Thread.interrupted()) {
                    return;
                }
                int n = modelIndex = MultiDiffPanel.this.fileTable == null ? i : MultiDiffPanel.this.fileTable.getModelIndex(i);
                if (this.prepareSetups[modelIndex].getView() != null) continue;
                try {
                    this.prepareSetups[modelIndex].initSources();
                    final int fi = modelIndex;
                    if (Thread.interrupted() || this.canceled) {
                        return;
                    }
                    StreamSource ss1 = this.prepareSetups[fi].getFirstSource();
                    StreamSource ss2 = this.prepareSetups[fi].getSecondSource();
                    DiffController view = DiffController.createEnhanced((StreamSource)ss1, (StreamSource)ss2);
                    view.addPropertyChangeListener((PropertyChangeListener)MultiDiffPanel.this);
                    if (Thread.interrupted() || this.canceled) {
                        return;
                    }
                    this.prepareSetups[fi].setView(view);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (DiffPrepareTask.this.prepareSetups != MultiDiffPanel.this.setups) {
                                return;
                            }
                            if (MultiDiffPanel.this.currentModelIndex == fi) {
                                MultiDiffPanel.this.setDiffIndex(MultiDiffPanel.this.currentIndex, 0, false);
                            }
                            if (MultiDiffPanel.this.splitPane != null) {
                                MultiDiffPanel.this.updateSplitLocation();
                            }
                        }
                    });
                }
                catch (IOException e) {
                    Subversion.LOG.log(Level.INFO, null, e);
                    if (exception != null) continue;
                    exception = e;
                }
            }
            if (exception != null) {
                final IOException e = exception;
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SvnClientExceptionHandler.notifyException(e, true, true);
                    }
                });
            }
        }

        private int[] prepareIndexesToRefresh() {
            int index = this.tableIndex;
            int min = Math.max(0, index - 2);
            int max = Math.min(this.prepareSetups.length - 1, index + 2);
            int[] indexes = new int[max - min + 1];
            int i = index;
            int k = 0;
            for (int j = index + 1; i >= min || j <= max; --i, ++j) {
                if (i >= min) {
                    indexes[k++] = i;
                }
                if (j > max) continue;
                indexes[k++] = j;
            }
            return indexes;
        }

        private void setTableIndex(int index) {
            this.tableIndex = index;
        }

        public boolean cancel() {
            this.canceled = true;
            return true;
        }
    }

    private class SetupsPrepareSupport
    extends SvnProgressSupport {
        private SetupsPrepareSupport() {
        }

        @Override
        protected void perform() {
            int status;
            if (MultiDiffPanel.this.dpt != null) {
                MultiDiffPanel.this.prepareTask.cancel();
            }
            switch (MultiDiffPanel.this.currentType) {
                case 0: {
                    status = 22996;
                    break;
                }
                case 1: {
                    status = 1696;
                    break;
                }
                case 2: {
                    status = 24564;
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown DIFF type:" + MultiDiffPanel.this.currentType);
                }
            }
            File[] files = SvnUtils.getModifiedFiles(MultiDiffPanel.this.context, status);
            if (this.isCanceled()) {
                return;
            }
            final int localDisplayStatuses = status;
            AbstractDiffSetup[] localSetups = this.computeSetups(files, status);
            if (localSetups == null) {
                return;
            }
            EditorCookie[] cookies = DiffUtils.setupsToEditorCookies((AbstractDiffSetup[])localSetups);
            Runnable runnable = new Runnable((Setup[])localSetups, cookies){
                final /* synthetic */ Setup[] val$localSetups;
                final /* synthetic */ EditorCookie[] val$cookies;
                {
                    this.val$localSetups = setupArray;
                    this.val$cookies = editorCookieArray;
                }

                @Override
                public void run() {
                    String[] stringArray;
                    MultiDiffPanel.this.dividerSet = false;
                    MultiDiffPanel.this.displayStatuses = localDisplayStatuses;
                    MultiDiffPanel.this.setSetups(this.val$localSetups, this.val$cookies);
                    boolean propertyColumnVisible = false;
                    for (Setup setup : MultiDiffPanel.this.setups) {
                        if (setup.getPropertyName() == null) continue;
                        propertyColumnVisible = true;
                        break;
                    }
                    DiffFileTable diffFileTable = MultiDiffPanel.this.fileTable;
                    if (propertyColumnVisible) {
                        String[] stringArray2 = new String[4];
                        stringArray2[0] = "name";
                        stringArray2[1] = "property";
                        stringArray2[2] = "status";
                        stringArray = stringArray2;
                        stringArray2[3] = "location";
                    } else {
                        String[] stringArray3 = new String[3];
                        stringArray3[0] = "name";
                        stringArray3[1] = "status";
                        stringArray = stringArray3;
                        stringArray3[2] = "location";
                    }
                    diffFileTable.setColumns(stringArray);
                    MultiDiffPanel.this.fileTable.setTableModel(MultiDiffPanel.this.setups, MultiDiffPanel.this.editorCookies);
                    if (MultiDiffPanel.this.setups.length == 0) {
                        String noContentLabel;
                        switch (MultiDiffPanel.this.currentType) {
                            case 0: {
                                noContentLabel = NbBundle.getMessage(MultiDiffPanel.class, (String)"MSG_DiffPanel_NoLocalChanges");
                                break;
                            }
                            case 1: {
                                noContentLabel = NbBundle.getMessage(MultiDiffPanel.class, (String)"MSG_DiffPanel_NoRemoteChanges");
                                break;
                            }
                            case 2: {
                                noContentLabel = NbBundle.getMessage(MultiDiffPanel.class, (String)"MSG_DiffPanel_NoAllChanges");
                                break;
                            }
                            default: {
                                throw new IllegalStateException("Unknown DIFF type:" + MultiDiffPanel.this.currentType);
                            }
                        }
                        MultiDiffPanel.this.setSetups(null, null);
                        MultiDiffPanel.this.fileTable.getComponent().setEnabled(false);
                        MultiDiffPanel.this.fileTable.getComponent().setPreferredSize(null);
                        Dimension dim = MultiDiffPanel.this.fileTable.getComponent().getPreferredSize();
                        MultiDiffPanel.this.fileTable.getComponent().setPreferredSize(new Dimension(dim.width + 1, dim.height));
                        MultiDiffPanel.this.diffView = null;
                        MultiDiffPanel.this.diffView = (JComponent)new NoContentPanel(noContentLabel);
                        MultiDiffPanel.this.displayDiffView();
                        MultiDiffPanel.this.nextAction.setEnabled(false);
                        MultiDiffPanel.this.prevAction.setEnabled(false);
                        MultiDiffPanel.this.commitButton.setEnabled(false);
                        MultiDiffPanel.this.revalidate();
                        MultiDiffPanel.this.repaint();
                    } else {
                        MultiDiffPanel.this.fileTable.getComponent().setEnabled(true);
                        MultiDiffPanel.this.fileTable.getComponent().setPreferredSize(null);
                        Dimension dim = MultiDiffPanel.this.fileTable.getComponent().getPreferredSize();
                        MultiDiffPanel.this.fileTable.getComponent().setPreferredSize(new Dimension(dim.width + 1, dim.height));
                        MultiDiffPanel.this.setDiffIndex(0, 0, false);
                        MultiDiffPanel.this.commitButton.setEnabled(true);
                        MultiDiffPanel.this.dpt = new DiffPrepareTask(MultiDiffPanel.this.setups);
                        MultiDiffPanel.this.prepareTask = Subversion.getInstance().getRequestProcessor().post((Runnable)MultiDiffPanel.this.dpt);
                    }
                }
            };
            if (EventQueue.isDispatchThread()) {
                runnable.run();
            } else {
                try {
                    SwingUtilities.invokeAndWait(runnable);
                }
                catch (InterruptedException ex) {
                    Subversion.LOG.log(Level.FINE, null, ex);
                }
                catch (InvocationTargetException ex) {
                    Subversion.LOG.log(Level.FINE, null, ex);
                }
            }
        }

        private Setup[] computeSetups(File[] files, int displayStatus) {
            ArrayList<Setup> newSetups = new ArrayList<Setup>(files.length);
            for (int i = 0; i < files.length; ++i) {
                File file = files[i];
                if (!file.isDirectory()) {
                    Setup setup = new Setup(file, null, MultiDiffPanel.this.currentType);
                    setup.setNode(new DiffNode(setup, new SvnFileNode(file), displayStatus));
                    newSetups.add(setup);
                }
                MultiDiffPanel.this.addPropertiesSetups(file, newSetups, displayStatus);
                if (!this.isCanceled()) continue;
                return null;
            }
            Collections.sort(newSetups, new SetupsComparator());
            return newSetups.toArray(new Setup[newSetups.size()]);
        }
    }
}

