/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.projects;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ErroneousTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.Scope;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeParameterTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import com.sun.source.util.Trees;
import java.awt.Color;
import java.awt.EventQueue;
import java.awt.IllegalComponentStateException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.DebuggerManagerAdapter;
import org.netbeans.api.debugger.DebuggerManagerListener;
import org.netbeans.api.debugger.Properties;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.jpda.InvalidExpressionException;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.api.debugger.jpda.LineBreakpoint;
import org.netbeans.api.editor.settings.AttributesUtilities;
import org.netbeans.api.editor.settings.EditorStyleConstants;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.ElementUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.editor.JumpList;
import org.netbeans.modules.debugger.jpda.projects.AST2Bytecode;
import org.netbeans.modules.debugger.jpda.projects.ClassScanner;
import org.netbeans.modules.debugger.jpda.projects.DebuggerAnnotation;
import org.netbeans.modules.debugger.jpda.projects.DebuggerBreakpointAnnotation;
import org.netbeans.modules.debugger.jpda.projects.ExpressionScanner;
import org.netbeans.modules.debugger.jpda.projects.LineTranslations;
import org.netbeans.modules.debugger.jpda.projects.MethodArgumentsScanner;
import org.netbeans.modules.java.preprocessorbridge.api.JavaSourceUtil;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.spi.debugger.jpda.EditorContext;
import org.netbeans.spi.debugger.jpda.SourcePathProvider;
import org.netbeans.spi.debugger.ui.EditorContextDispatcher;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.ErrorManager;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.Annotation;
import org.openide.text.Line;
import org.openide.text.NbDocument;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;

public class EditorContextImpl
extends EditorContext {
    private static String fronting = System.getProperty("netbeans.debugger.fronting");
    private PropertyChangeSupport pcs;
    private Map annotationToURL = new HashMap();
    private PropertyChangeListener dispatchListener;
    private EditorContextDispatcher contextDispatcher;
    private final Map<JavaSource, JavaSourceUtil.Handle> sourceHandles = new WeakHashMap<JavaSource, JavaSourceUtil.Handle>();
    private final Map<JavaSource, Date> sourceModifStamps = new WeakHashMap<JavaSource, Date>();
    private DebuggerManagerListener sessionsListener;
    private static RequestProcessor scanningProcessor = new RequestProcessor("Debugger Context Scanning", 1);

    public EditorContextImpl() {
        this.pcs = new PropertyChangeSupport((Object)this);
        this.dispatchListener = new EditorContextDispatchListener();
        this.contextDispatcher = EditorContextDispatcher.getDefault();
        this.contextDispatcher.addPropertyChangeListener("text/x-java", WeakListeners.propertyChange((PropertyChangeListener)this.dispatchListener, (Object)this.contextDispatcher));
        this.sessionsListener = new SessionsListener();
        DebuggerManager.getDebuggerManager().addDebuggerListener("sessions", (DebuggerManagerListener)WeakListeners.create(DebuggerManagerListener.class, (EventListener)this.sessionsListener, (Object)new SessionsListenerRemoval()));
    }

    public boolean showSource(String url, int lineNumber, Object timeStamp) {
        Line l = EditorContextImpl.showSourceLine(url, lineNumber, timeStamp);
        if (l != null) {
            this.addPositionToJumpList(url, l, 0);
        }
        return l != null;
    }

    static Line showSourceLine(String url, int lineNumber, Object timeStamp) {
        Line l = LineTranslations.getTranslations().getLine(url, lineNumber, timeStamp);
        if (l == null) {
            ErrorManager.getDefault().log(16, "Show Source: Have no line for URL = " + url + ", line number = " + lineNumber);
            return null;
        }
        Properties p = Properties.getDefault().getProperties("debugger.options.JPDA");
        boolean reuseEditorTabs = p.getBoolean("ReuseEditorTabs", true);
        if ("true".equalsIgnoreCase(fronting) || Utilities.isWindows()) {
            if (reuseEditorTabs) {
                l.show(Line.ShowOpenType.REUSE, Line.ShowVisibilityType.FOCUS);
            }
            l.show(Line.ShowOpenType.OPEN, Line.ShowVisibilityType.FRONT);
        } else if (reuseEditorTabs) {
            l.show(Line.ShowOpenType.REUSE, Line.ShowVisibilityType.FOCUS);
        } else {
            l.show(Line.ShowOpenType.OPEN, Line.ShowVisibilityType.FOCUS);
        }
        return l;
    }

    public boolean showSource(String url, int lineNumber, int column, int length, Object timeStamp) {
        Line l = LineTranslations.getTranslations().getLine(url, lineNumber, timeStamp);
        if (l == null) {
            ErrorManager.getDefault().log(16, "Show Source: Have no line for URL = " + url + ", line number = " + lineNumber);
            return false;
        }
        if ("true".equalsIgnoreCase(fronting) || Utilities.isWindows()) {
            l.show(Line.ShowOpenType.OPEN, Line.ShowVisibilityType.FRONT, column);
        } else {
            l.show(Line.ShowOpenType.OPEN, Line.ShowVisibilityType.FOCUS, column);
        }
        this.addPositionToJumpList(url, l, column);
        return true;
    }

    private void addPositionToJumpList(String url, Line l, int column) {
        EditorCookie ec;
        DataObject dataObject = EditorContextImpl.getDataObject(url);
        if (dataObject != null && (ec = (EditorCookie)dataObject.getLookup().lookup(EditorCookie.class)) != null) {
            try {
                StyledDocument doc = ec.openDocument();
                JEditorPane[] eps = ec.getOpenedPanes();
                if (eps != null && eps.length > 0) {
                    JumpList.addEntry((JTextComponent)eps[0], (int)(NbDocument.findLineOffset((StyledDocument)doc, (int)l.getLineNumber()) + column));
                }
            }
            catch (IOException ioex) {
                ErrorManager.getDefault().notify((Throwable)ioex);
            }
        }
    }

    public void createTimeStamp(Object timeStamp) {
        LineTranslations.getTranslations().createTimeStamp(timeStamp);
    }

    public void disposeTimeStamp(Object timeStamp) {
        LineTranslations.getTranslations().disposeTimeStamp(timeStamp);
    }

    public Object annotate(String url, int lineNumber, String annotationType, Object timeStamp) {
        return this.annotate(url, lineNumber, annotationType, timeStamp, null);
    }

    public Object annotate(String url, int lineNumber, String annotationType, Object timeStamp, JPDAThread thread) {
        Line l = LineTranslations.getTranslations().getLine(url, lineNumber, timeStamp instanceof Breakpoint ? null : timeStamp);
        if (l == null) {
            return null;
        }
        Object annotation = timeStamp instanceof Breakpoint ? new DebuggerBreakpointAnnotation(annotationType, l, (Breakpoint)timeStamp) : new DebuggerAnnotation(annotationType, l, thread);
        this.annotationToURL.put(annotation, url);
        return annotation;
    }

    public Object annotate(String url, int startPosition, int endPosition, String annotationType, Object timeStamp) {
        DebuggerAnnotation annotation;
        AttributeSet attrs = "LastOperation".equals(annotationType) ? AttributesUtilities.createImmutable((Object[])new Object[]{EditorStyleConstants.WaveUnderlineColor, EditorContextImpl.getColor(annotationType)}) : AttributesUtilities.createImmutable((Object[])new Object[]{StyleConstants.Background, EditorContextImpl.getColor(annotationType)});
        try {
            annotation = new DebuggerAnnotation(annotationType, attrs, startPosition, endPosition, URLMapper.findFileObject((URL)new URL(url)));
        }
        catch (MalformedURLException ex) {
            RuntimeException rex = new RuntimeException("Bad URL: " + url);
            rex.initCause(ex);
            throw rex;
        }
        this.annotationToURL.put(annotation, url);
        return annotation;
    }

    private static Color getColor(String annotationType) {
        if (annotationType.endsWith("_broken")) {
            annotationType = annotationType.substring(0, annotationType.length() - "_broken".length());
        }
        if ("Breakpoint".equals(annotationType)) {
            return new Color(16555423);
        }
        if ("CurrentPC".equals(annotationType) || "StepOutOperation".equals(annotationType)) {
            return new Color(12445354);
        }
        if ("CurrentExpressionLine".equals(annotationType)) {
            return new Color(15335398);
        }
        if ("LastOperation".equals(annotationType)) {
            return new Color(10075018);
        }
        return new Color(255);
    }

    public void removeAnnotation(Object a) {
        if (a instanceof Collection) {
            Collection annotations = (Collection)a;
            Iterator it = annotations.iterator();
            while (it.hasNext()) {
                this.removeAnnotation((Annotation)it.next());
            }
        } else {
            this.removeAnnotation((Annotation)a);
        }
    }

    private void removeAnnotation(Annotation annotation) {
        annotation.detach();
        this.annotationToURL.remove(annotation);
    }

    public int getLineNumber(Object annotation, Object timeStamp) {
        if (annotation instanceof LineBreakpoint) {
            LineBreakpoint lb = (LineBreakpoint)annotation;
            return LineTranslations.getTranslations().getOriginalLineNumber(lb, timeStamp);
        }
        Line line = annotation instanceof DebuggerBreakpointAnnotation ? ((DebuggerBreakpointAnnotation)((Object)annotation)).getLine() : ((DebuggerAnnotation)((Object)annotation)).getLine();
        if (timeStamp == null) {
            return line.getLineNumber() + 1;
        }
        String url = (String)this.annotationToURL.get(annotation);
        Line.Set lineSet = LineTranslations.getTranslations().getLineSet(url, timeStamp);
        return lineSet.getOriginalLineNumber(line) + 1;
    }

    public void updateTimeStamp(Object timeStamp, String url) {
        LineTranslations.getTranslations().updateTimeStamp(timeStamp, url);
    }

    public int getCurrentLineNumber() {
        return this.contextDispatcher.getCurrentLineNumber();
    }

    public int getCurrentOffset() {
        JEditorPane ep = this.contextDispatcher.getCurrentEditor();
        if (ep == null) {
            return -1;
        }
        Caret caret = ep.getCaret();
        if (caret == null) {
            return -1;
        }
        return caret.getDot();
    }

    public String getCurrentClassName() {
        String currentClass = this.getCurrentElement(ElementKind.CLASS);
        if (currentClass == null) {
            return "";
        }
        return currentClass;
    }

    public String getMostRecentClassName() {
        String clazz = this.getMostRecentElement(ElementKind.CLASS);
        if (clazz == null) {
            return "";
        }
        return clazz;
    }

    public String getCurrentURL() {
        return this.contextDispatcher.getCurrentURLAsString();
    }

    public String getCurrentMethodName() {
        String currentMethod = this.getCurrentElement(ElementKind.METHOD);
        if (currentMethod == null) {
            return "";
        }
        return currentMethod;
    }

    public String getMostRecentMethodName() {
        String method = this.getMostRecentElement(ElementKind.METHOD);
        if (method == null) {
            return "";
        }
        return method;
    }

    public String getCurrentMethodSignature() {
        final javax.lang.model.element.Element[] elementPtr = new javax.lang.model.element.Element[]{null};
        try {
            this.getCurrentElement(ElementKind.METHOD, elementPtr);
        }
        catch (IllegalComponentStateException icse) {
            throw new IllegalComponentStateException(){

                @Override
                public String getMessage() {
                    icse.getMessage();
                    return EditorContextImpl.createSignature((ExecutableElement)elementPtr[0]);
                }
            };
        }
        if (elementPtr[0] != null) {
            return EditorContextImpl.createSignature((ExecutableElement)elementPtr[0]);
        }
        return null;
    }

    public String getMostRecentMethodSignature() {
        final javax.lang.model.element.Element[] elementPtr = new javax.lang.model.element.Element[]{null};
        try {
            this.getMostRecentElement(ElementKind.METHOD, elementPtr);
        }
        catch (IllegalComponentStateException icse) {
            throw new IllegalComponentStateException(){

                @Override
                public String getMessage() {
                    icse.getMessage();
                    return EditorContextImpl.createSignature((ExecutableElement)elementPtr[0]);
                }
            };
        }
        if (elementPtr[0] != null) {
            return EditorContextImpl.createSignature((ExecutableElement)elementPtr[0]);
        }
        return null;
    }

    public String getCurrentFieldName() {
        String currentField = this.getCurrentElement(ElementKind.FIELD);
        if (currentField == null) {
            return "";
        }
        return currentField;
    }

    public String getMostRecentFieldName() {
        String field = this.getMostRecentElement(ElementKind.FIELD);
        if (field == null) {
            return "";
        }
        return field;
    }

    public String getSelectedIdentifier() {
        JEditorPane ep = this.contextDispatcher.getCurrentEditor();
        if (ep == null) {
            return null;
        }
        String s = ep.getSelectedText();
        if (s == null) {
            return null;
        }
        if (Utilities.isJavaIdentifier((String)s)) {
            return s;
        }
        return null;
    }

    public String getSelectedMethodName() {
        if (SwingUtilities.isEventDispatchThread()) {
            return this.getSelectedMethodName_();
        }
        final String[] mn = new String[1];
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    mn[0] = EditorContextImpl.this.getSelectedMethodName_();
                }
            });
        }
        catch (InvocationTargetException ex) {
            ErrorManager.getDefault().notify(ex.getTargetException());
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return mn[0];
    }

    private String getSelectedMethodName_() {
        JEditorPane ep = this.contextDispatcher.getCurrentEditor();
        if (ep == null) {
            return "";
        }
        StyledDocument doc = (StyledDocument)ep.getDocument();
        if (doc == null) {
            return "";
        }
        int offset = ep.getCaret().getDot();
        String t = null;
        int line = NbDocument.findLineNumber((StyledDocument)doc, (int)offset);
        int col = NbDocument.findLineColumn((StyledDocument)doc, (int)offset);
        try {
            int identEnd;
            int identStart;
            Element lineElem = NbDocument.findLineRootElement((StyledDocument)doc).getElement(line);
            if (lineElem == null) {
                return "";
            }
            int lineStartOffset = lineElem.getStartOffset();
            int lineLen = lineElem.getEndOffset() - lineStartOffset;
            t = doc.getText(lineStartOffset, lineLen);
            for (identStart = col; identStart > 0 && Character.isJavaIdentifierPart(t.charAt(identStart - 1)); --identStart) {
            }
            for (identEnd = col; identEnd < lineLen && Character.isJavaIdentifierPart(t.charAt(identEnd)); ++identEnd) {
            }
            int i = t.indexOf(40, identEnd);
            if (i < 0) {
                return "";
            }
            if (t.substring(identEnd, i).trim().length() > 0) {
                return "";
            }
            if (identStart == identEnd) {
                return "";
            }
            return t.substring(identStart, identEnd);
        }
        catch (BadLocationException ex) {
            return "";
        }
    }

    private static TypeElement getTypeElement(CompilationController ci, String binaryName, String[] classExcludeNames) {
        ClassScanner cs = new ClassScanner(ci.getTrees(), ci.getElements(), binaryName, classExcludeNames);
        TypeElement te = (TypeElement)cs.scan(ci.getCompilationUnit(), null);
        if (te != null) {
            return te;
        }
        return null;
    }

    public int getFieldLineNumber(String url, String className, String fieldName) {
        DataObject dataObject = EditorContextImpl.getDataObject(url);
        if (dataObject == null) {
            return -1;
        }
        Future<Integer> fi = EditorContextImpl.getFieldLineNumber(dataObject.getPrimaryFile(), className, fieldName);
        if (fi == null) {
            return -1;
        }
        try {
            return fi.get();
        }
        catch (InterruptedException ex) {
            return -1;
        }
        catch (ExecutionException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return -1;
        }
    }

    static Future<Integer> getFieldLineNumber(FileObject fo, final String className, final String fieldName) {
        JavaSource js = JavaSource.forFileObject((FileObject)fo);
        if (js == null) {
            return null;
        }
        final int[] result = new int[]{-1};
        final StyledDocument doc = EditorContextImpl.findDocument(fo);
        if (doc == null) {
            return null;
        }
        try {
            final Future<Void> f = EditorContextImpl.parseWhenScanFinishedReallyLazy(Collections.singleton(Source.create((Document)doc)), new UserTask(){

                /*
                 * WARNING - void declaration
                 */
                public void run(ResultIterator resultIterator) throws Exception {
                    CompilationController ci = EditorContextImpl.retrieveController(resultIterator, doc);
                    if (ci == null) {
                        return;
                    }
                    if (ci.toPhase(JavaSource.Phase.RESOLVED).compareTo((Enum)JavaSource.Phase.RESOLVED) < 0) {
                        ErrorManager.getDefault().log(16, "Unable to resolve " + ci.getFileObject() + " to phase " + JavaSource.Phase.RESOLVED + ", current phase = " + ci.getPhase() + "\nDiagnostics = " + ci.getDiagnostics() + "\nFree memory = " + Runtime.getRuntime().freeMemory());
                        return;
                    }
                    Elements elms = ci.getElements();
                    TypeElement classElement = EditorContextImpl.getTypeElement(ci, className, null);
                    if (classElement == null) {
                        return;
                    }
                    if (fieldName == null) {
                        void var7_10;
                        SourcePositions positions = ci.getTrees().getSourcePositions();
                        ClassTree tree = ci.getTrees().getTree(classElement);
                        int n = (int)positions.getStartPosition(ci.getCompilationUnit(), tree);
                        if ((long)n == -1L) {
                            ErrorManager.getDefault().log(16, "No position for tree " + tree + " in " + className);
                            return;
                        }
                        int l = doc.getLength();
                        while (var7_10 < l && doc.getText((int)var7_10, 1).charAt(0) != '{') {
                            ++var7_10;
                        }
                        result[0] = NbDocument.findLineNumber((StyledDocument)doc, (int)var7_10) + 2;
                        return;
                    }
                    List<? extends javax.lang.model.element.Element> classMemberElements = elms.getAllMembers(classElement);
                    for (javax.lang.model.element.Element element : classMemberElements) {
                        String name;
                        if (element.getKind() != ElementKind.FIELD || !(name = ((VariableElement)element).getSimpleName().toString()).equals(fieldName)) continue;
                        SourcePositions positions = ci.getTrees().getSourcePositions();
                        Tree tree = ci.getTrees().getTree(element);
                        int pos = (int)positions.getStartPosition(ci.getCompilationUnit(), tree);
                        if ((long)pos == -1L) {
                            ErrorManager.getDefault().log(16, "No position for tree " + tree + " of element " + element + " in " + className);
                            continue;
                        }
                        result[0] = NbDocument.findLineNumber((StyledDocument)doc, (int)pos) + 1;
                    }
                }
            });
            if (!f.isDone()) {
                return new Future<Integer>(){

                    @Override
                    public boolean cancel(boolean mayInterruptIfRunning) {
                        return f.cancel(mayInterruptIfRunning);
                    }

                    @Override
                    public boolean isCancelled() {
                        return f.isCancelled();
                    }

                    @Override
                    public boolean isDone() {
                        return f.isDone();
                    }

                    @Override
                    public Integer get() throws InterruptedException, ExecutionException {
                        f.get();
                        return result[0];
                    }

                    @Override
                    public Integer get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                        f.get(timeout, unit);
                        return result[0];
                    }
                };
            }
        }
        catch (ParseException pex) {
            ErrorManager.getDefault().notify((Throwable)pex);
            return null;
        }
        return new DoneFuture<Integer>(result[0]);
    }

    public int getMethodLineNumber(String url, String className, String methodName, String methodSignature) {
        int[] lns;
        DataObject dataObject = EditorContextImpl.getDataObject(url);
        if (dataObject == null) {
            return -1;
        }
        Future<int[]> flns = EditorContextImpl.getMethodLineNumbers(dataObject.getPrimaryFile(), className, null, methodName, methodSignature);
        if (flns == null) {
            return -1;
        }
        try {
            lns = flns.get();
        }
        catch (InterruptedException ex) {
            return -1;
        }
        catch (ExecutionException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return -1;
        }
        if (lns.length == 0) {
            return -1;
        }
        return lns[0];
    }

    static Future<int[]> getMethodLineNumbers(FileObject fo, final String className, final String[] classExcludeNames, final String methodName, final String methodSignature) {
        JavaSource js = JavaSource.forFileObject((FileObject)fo);
        if (js == null) {
            return null;
        }
        final ArrayList result = new ArrayList();
        final StyledDocument doc = EditorContextImpl.findDocument(fo);
        if (doc == null) {
            return null;
        }
        try {
            final Future<Void> f = EditorContextImpl.parseWhenScanFinishedReallyLazy(Collections.singleton(Source.create((Document)doc)), new UserTask(){

                public void run(ResultIterator resultIterator) throws Exception {
                    CompilationController ci = EditorContextImpl.retrieveController(resultIterator, doc);
                    if (ci == null) {
                        return;
                    }
                    if (ci.toPhase(JavaSource.Phase.RESOLVED).compareTo((Enum)JavaSource.Phase.RESOLVED) < 0) {
                        ErrorManager.getDefault().log(16, "Unable to resolve " + ci.getFileObject() + " to phase " + JavaSource.Phase.RESOLVED + ", current phase = " + ci.getPhase() + "\nDiagnostics = " + ci.getDiagnostics() + "\nFree memory = " + Runtime.getRuntime().freeMemory());
                        return;
                    }
                    TypeElement classElement = EditorContextImpl.getTypeElement(ci, className, classExcludeNames);
                    if (classElement == null) {
                        return;
                    }
                    List<? extends javax.lang.model.element.Element> classMemberElements = ci.getElements().getAllMembers(classElement);
                    for (javax.lang.model.element.Element element : classMemberElements) {
                        List<? extends AnnotationTree> annotations;
                        MethodTree mt;
                        ModifiersTree modt;
                        String name;
                        if (element.getKind() != ElementKind.METHOD && element.getKind() != ElementKind.CONSTRUCTOR || !(name = element.getKind() == ElementKind.CONSTRUCTOR && !methodName.equals("<init>") ? element.getEnclosingElement().getSimpleName().toString() : element.getSimpleName().toString()).equals(methodName) || methodSignature != null && !EditorContextImpl.egualMethodSignatures(methodSignature, EditorContextImpl.createSignature((ExecutableElement)element))) continue;
                        SourcePositions positions = ci.getTrees().getSourcePositions();
                        Tree tree = ci.getTrees().getTree(element);
                        if (tree == null) {
                            ErrorManager.getDefault().log(16, "Null tree for element " + element + " in " + className);
                            continue;
                        }
                        int pos = (int)positions.getStartPosition(ci.getCompilationUnit(), tree);
                        if ((long)pos == -1L) {
                            ErrorManager.getDefault().log(16, "No position for tree " + tree + " of element " + element + " in " + className);
                            continue;
                        }
                        int origPos = pos;
                        if (tree.getKind() == Tree.Kind.METHOD && (modt = (mt = (MethodTree)tree).getModifiers()) != null && (annotations = modt.getAnnotations()) != null && annotations.size() > 0 && (long)(pos = (int)positions.getEndPosition(ci.getCompilationUnit(), annotations.get(annotations.size() - 1))) == -1L) {
                            ErrorManager.getDefault().log(16, "No position for tree " + annotations.get(annotations.size() - 1) + " in " + className);
                            continue;
                        }
                        String text = ci.getText();
                        int l = text.length();
                        char c = '\u0000';
                        while (pos < l && (c = text.charAt(pos)) != '(' && c != ')') {
                            ++pos;
                        }
                        if (pos >= l) {
                            c = '\u0000';
                            pos = origPos;
                        }
                        if (c == '(') {
                            --pos;
                            while (pos > 0 && Character.isWhitespace(text.charAt(pos))) {
                                --pos;
                            }
                        }
                        result.add(new Integer(NbDocument.findLineNumber((StyledDocument)doc, (int)pos) + 1));
                    }
                }
            });
            if (!f.isDone()) {
                return new Future<int[]>(){

                    @Override
                    public boolean cancel(boolean mayInterruptIfRunning) {
                        return f.cancel(mayInterruptIfRunning);
                    }

                    @Override
                    public boolean isCancelled() {
                        return f.isCancelled();
                    }

                    @Override
                    public boolean isDone() {
                        return f.isDone();
                    }

                    @Override
                    public int[] get() throws InterruptedException, ExecutionException {
                        f.get();
                        return this.getResultArray();
                    }

                    @Override
                    public int[] get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                        f.get(timeout, unit);
                        return this.getResultArray();
                    }

                    private int[] getResultArray() {
                        int[] resultArray = new int[result.size()];
                        for (int i = 0; i < resultArray.length; ++i) {
                            resultArray[i] = (Integer)result.get(i);
                        }
                        return resultArray;
                    }
                };
            }
        }
        catch (ParseException pex) {
            ErrorManager.getDefault().notify((Throwable)pex);
            return null;
        }
        int[] resultArray = new int[result.size()];
        for (int i = 0; i < resultArray.length; ++i) {
            resultArray[i] = (Integer)result.get(i);
        }
        return new DoneFuture<int[]>(resultArray);
    }

    private static boolean egualMethodSignatures(String s1, String s2) {
        int i = s1.lastIndexOf(")");
        if (i > 0) {
            s1 = s1.substring(0, i);
        }
        if ((i = s2.lastIndexOf(")")) > 0) {
            s2 = s2.substring(0, i);
        }
        return s1.equals(s2);
    }

    static Future<Integer> getClassLineNumber(FileObject fo, final String className, final String[] classExcludeNames) {
        JavaSource js = JavaSource.forFileObject((FileObject)fo);
        if (js == null) {
            return null;
        }
        final Integer[] result = new Integer[]{null};
        final StyledDocument doc = EditorContextImpl.findDocument(fo);
        if (doc == null) {
            return null;
        }
        try {
            final Future<Void> f = EditorContextImpl.parseWhenScanFinishedReallyLazy(Collections.singleton(Source.create((Document)doc)), new UserTask(){

                public void run(ResultIterator resultIterator) throws Exception {
                    CompilationController ci = EditorContextImpl.retrieveController(resultIterator, doc);
                    if (ci == null) {
                        return;
                    }
                    if (ci.toPhase(JavaSource.Phase.RESOLVED).compareTo((Enum)JavaSource.Phase.RESOLVED) < 0) {
                        ErrorManager.getDefault().log(16, "Unable to resolve " + ci.getFileObject() + " to phase " + JavaSource.Phase.RESOLVED + ", current phase = " + ci.getPhase() + "\nDiagnostics = " + ci.getDiagnostics() + "\nFree memory = " + Runtime.getRuntime().freeMemory());
                        return;
                    }
                    TypeElement classElement = EditorContextImpl.getTypeElement(ci, className, classExcludeNames);
                    if (classElement == null) {
                        return;
                    }
                    SourcePositions positions = ci.getTrees().getSourcePositions();
                    ClassTree tree = ci.getTrees().getTree(classElement);
                    if (tree == null) {
                        ErrorManager.getDefault().log(16, "Null tree for element " + classElement + " in " + className);
                        return;
                    }
                    int pos = (int)positions.getStartPosition(ci.getCompilationUnit(), tree);
                    if ((long)pos == -1L) {
                        ErrorManager.getDefault().log(16, "No position for tree " + tree + " of element " + classElement + " (" + className + ")");
                        return;
                    }
                    if (TreeUtilities.CLASS_TREE_KINDS.contains((Object)tree.getKind())) {
                        boolean shifted = false;
                        ModifiersTree mtree = tree.getModifiers();
                        for (AnnotationTree annotationTree : mtree.getAnnotations()) {
                            int aend = (int)positions.getEndPosition(ci.getCompilationUnit(), annotationTree);
                            if ((long)aend == -1L || pos >= aend) continue;
                            shifted = true;
                            pos = aend + 1;
                        }
                        if (shifted) {
                            String text = ci.getText();
                            int n = text.length();
                            while (pos < n && Character.isWhitespace(text.charAt(pos))) {
                                ++pos;
                            }
                        }
                    }
                    result[0] = new Integer(NbDocument.findLineNumber((StyledDocument)doc, (int)pos) + 1);
                }
            });
            if (!f.isDone()) {
                return new Future<Integer>(){

                    @Override
                    public boolean cancel(boolean mayInterruptIfRunning) {
                        return f.cancel(mayInterruptIfRunning);
                    }

                    @Override
                    public boolean isCancelled() {
                        return f.isCancelled();
                    }

                    @Override
                    public boolean isDone() {
                        return f.isDone();
                    }

                    @Override
                    public Integer get() throws InterruptedException, ExecutionException {
                        f.get();
                        return result[0];
                    }

                    @Override
                    public Integer get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                        f.get(timeout, unit);
                        return result[0];
                    }
                };
            }
        }
        catch (ParseException pex) {
            ErrorManager.getDefault().notify((Throwable)pex);
            return null;
        }
        return new DoneFuture<Integer>(result[0]);
    }

    public String getCurrentClassDeclaration() {
        String[] currentClassPtr;
        block8: {
            FileObject fo = this.contextDispatcher.getCurrentFile();
            if (fo == null) {
                return null;
            }
            JEditorPane ep = this.contextDispatcher.getCurrentEditor();
            JavaSource js = JavaSource.forFileObject((FileObject)fo);
            if (js == null) {
                return null;
            }
            final int currentOffset = ep == null ? 0 : ep.getCaretPosition();
            currentClassPtr = new String[]{null};
            try {
                final Future<Void> scanFinished = EditorContextImpl.runWhenScanFinishedReallyLazy(js, (Task<CompilationController>)new CancellableTask<CompilationController>(){

                    public void cancel() {
                    }

                    public void run(CompilationController ci) throws Exception {
                        Tree tree;
                        int offset;
                        if (ci.toPhase(JavaSource.Phase.RESOLVED).compareTo((Enum)JavaSource.Phase.RESOLVED) < 0) {
                            ErrorManager.getDefault().log(16, "Unable to resolve " + ci.getFileObject() + " to phase " + JavaSource.Phase.RESOLVED + ", current phase = " + ci.getPhase() + "\nDiagnostics = " + ci.getDiagnostics() + "\nFree memory = " + Runtime.getRuntime().freeMemory());
                            return;
                        }
                        String text = ci.getText();
                        int l = text.length();
                        char c = '\u0000';
                        for (offset = currentOffset; offset < l && (c = text.charAt(offset)) != '{' && c != '}' && c != '\n' && c != '\r'; ++offset) {
                        }
                        if (offset >= l) {
                            return;
                        }
                        TreePath path = ci.getTreeUtilities().pathFor(--offset);
                        while (!TreeUtilities.CLASS_TREE_KINDS.contains((Object)(tree = path.getLeaf()).getKind()) && (path = path.getParentPath()) != null) {
                        }
                        if (TreeUtilities.CLASS_TREE_KINDS.contains((Object)tree.getKind())) {
                            SourcePositions positions = ci.getTrees().getSourcePositions();
                            int pos = (int)positions.getStartPosition(ci.getCompilationUnit(), tree);
                            if ((long)pos == -1L) {
                                return;
                            }
                            if (offset < pos) {
                                return;
                            }
                            int hend = this.getHeaderEnd((ClassTree)tree, positions, ci.getCompilationUnit());
                            if (hend > 0) {
                                pos = hend;
                            }
                            while (pos < l && text.charAt(pos) != '{') {
                                ++pos;
                            }
                            if (pos < offset) {
                                return;
                            }
                            javax.lang.model.element.Element el = ci.getTrees().getElement(ci.getTrees().getPath(ci.getCompilationUnit(), tree));
                            if (el != null && (el.getKind() == ElementKind.CLASS || el.getKind() == ElementKind.INTERFACE)) {
                                currentClassPtr[0] = ElementUtilities.getBinaryName((TypeElement)((TypeElement)el));
                            }
                        }
                    }

                    private int getHeaderEnd(ClassTree classTree, SourcePositions positions, CompilationUnitTree compilationUnit) {
                        int max = -1;
                        int pos = (int)positions.getEndPosition(compilationUnit, classTree.getExtendsClause());
                        if ((long)pos != -1L) {
                            max = Math.max(max, pos);
                        }
                        if ((long)(pos = (int)positions.getEndPosition(compilationUnit, classTree.getModifiers())) != -1L) {
                            max = Math.max(max, pos);
                        }
                        for (Tree tree : classTree.getImplementsClause()) {
                            pos = (int)positions.getEndPosition(compilationUnit, tree);
                            if ((long)pos == -1L) continue;
                            max = Math.max(max, pos);
                        }
                        for (TypeParameterTree typeParameterTree : classTree.getTypeParameters()) {
                            pos = (int)positions.getEndPosition(compilationUnit, typeParameterTree);
                            if ((long)pos == -1L) continue;
                            max = Math.max(max, pos);
                        }
                        return max;
                    }
                }, true);
                if (scanFinished.isDone()) break block8;
                if (EventQueue.isDispatchThread()) {
                    throw new IllegalComponentStateException(){

                        private void waitScanFinished() {
                            try {
                                scanFinished.get();
                            }
                            catch (InterruptedException iex) {
                            }
                            catch (ExecutionException eex) {
                                ErrorManager.getDefault().notify((Throwable)eex);
                            }
                        }

                        @Override
                        public String getMessage() {
                            this.waitScanFinished();
                            return currentClassPtr[0];
                        }
                    };
                }
                try {
                    scanFinished.get();
                }
                catch (InterruptedException iex) {
                    return null;
                }
                catch (ExecutionException eex) {
                    ErrorManager.getDefault().notify((Throwable)eex);
                    return null;
                }
            }
            catch (IOException ioex) {
                ErrorManager.getDefault().notify((Throwable)ioex);
                return null;
            }
        }
        return currentClassPtr[0];
    }

    public String[] getCurrentMethodDeclaration() {
        String[] currentMethodPtr;
        block9: {
            FileObject fo = this.contextDispatcher.getCurrentFile();
            if (fo == null) {
                return null;
            }
            JEditorPane ep = this.contextDispatcher.getCurrentEditor();
            JavaSource js = JavaSource.forFileObject((FileObject)fo);
            if (js == null) {
                return null;
            }
            final int currentOffset = ep == null ? 0 : ep.getCaretPosition();
            currentMethodPtr = new String[]{null, null, null};
            try {
                final Future<Void> scanFinished = EditorContextImpl.runWhenScanFinishedReallyLazy(js, (Task<CompilationController>)new CancellableTask<CompilationController>(){

                    public void cancel() {
                    }

                    public void run(CompilationController ci) throws Exception {
                        javax.lang.model.element.Element el;
                        Tree tree;
                        int offset;
                        if (ci.toPhase(JavaSource.Phase.RESOLVED).compareTo((Enum)JavaSource.Phase.RESOLVED) < 0) {
                            ErrorManager.getDefault().log(16, "Unable to resolve " + ci.getFileObject() + " to phase " + JavaSource.Phase.RESOLVED + ", current phase = " + ci.getPhase() + "\nDiagnostics = " + ci.getDiagnostics() + "\nFree memory = " + Runtime.getRuntime().freeMemory());
                            return;
                        }
                        String text = ci.getText();
                        int l = text.length();
                        char c = '\u0000';
                        for (offset = currentOffset; offset < l && (c = text.charAt(offset)) != '(' && c != ')' && c != '\n' && c != '\r'; ++offset) {
                        }
                        if (offset >= l) {
                            return;
                        }
                        if (c == '(') {
                            --offset;
                        }
                        if ((tree = ci.getTreeUtilities().pathFor(offset).getLeaf()).getKind() == Tree.Kind.METHOD && (el = ci.getTrees().getElement(ci.getTrees().getPath(ci.getCompilationUnit(), tree))) != null && (el.getKind() == ElementKind.METHOD || el.getKind() == ElementKind.CONSTRUCTOR)) {
                            currentMethodPtr[0] = el.getSimpleName().toString();
                            if (currentMethodPtr[0].equals("<init>")) {
                                currentMethodPtr[0] = el.getEnclosingElement().getSimpleName().toString();
                            }
                            currentMethodPtr[1] = EditorContextImpl.createSignature((ExecutableElement)el);
                            TypeElement te = null;
                            for (javax.lang.model.element.Element enclosingClassElement = el; enclosingClassElement != null; enclosingClassElement = enclosingClassElement.getEnclosingElement()) {
                                ElementKind kind = enclosingClassElement.getKind();
                                if (kind != ElementKind.CLASS && kind != ElementKind.INTERFACE) continue;
                                te = (TypeElement)enclosingClassElement;
                                break;
                            }
                            if (te != null) {
                                currentMethodPtr[2] = ElementUtilities.getBinaryName(te);
                            }
                        }
                    }
                }, true);
                if (scanFinished.isDone()) break block9;
                if (EventQueue.isDispatchThread()) {
                    throw new IllegalComponentStateException(){

                        private void waitScanFinished() {
                            try {
                                scanFinished.get();
                            }
                            catch (InterruptedException iex) {
                            }
                            catch (ExecutionException eex) {
                                ErrorManager.getDefault().notify((Throwable)eex);
                            }
                        }

                        @Override
                        public String getMessage() {
                            this.waitScanFinished();
                            return currentMethodPtr[0];
                        }

                        @Override
                        public String getLocalizedMessage() {
                            this.waitScanFinished();
                            return currentMethodPtr[1];
                        }
                    };
                }
                try {
                    scanFinished.get();
                }
                catch (InterruptedException iex) {
                    return null;
                }
                catch (ExecutionException eex) {
                    ErrorManager.getDefault().notify((Throwable)eex);
                    return null;
                }
            }
            catch (IOException ioex) {
                ErrorManager.getDefault().notify((Throwable)ioex);
                return null;
            }
        }
        if (currentMethodPtr[0] != null) {
            return currentMethodPtr;
        }
        return null;
    }

    private static String createSignature(ExecutableElement elm) {
        StringBuilder signature = new StringBuilder("(");
        for (VariableElement variableElement : elm.getParameters()) {
            String paramType = ((Object)variableElement.asType()).toString();
            signature.append(EditorContextImpl.getSignature(paramType));
        }
        signature.append(')');
        String returnType = ((Object)elm.getReturnType()).toString();
        signature.append(EditorContextImpl.getSignature(returnType));
        return signature.toString();
    }

    private static String getSignature(String javaType) {
        if (javaType.equals("boolean")) {
            return "Z";
        }
        if (javaType.equals("byte")) {
            return "B";
        }
        if (javaType.equals("char")) {
            return "C";
        }
        if (javaType.equals("short")) {
            return "S";
        }
        if (javaType.equals("int")) {
            return "I";
        }
        if (javaType.equals("long")) {
            return "J";
        }
        if (javaType.equals("float")) {
            return "F";
        }
        if (javaType.equals("double")) {
            return "D";
        }
        if (javaType.endsWith("[]")) {
            return "[" + EditorContextImpl.getSignature(javaType.substring(0, javaType.length() - 2));
        }
        return "L" + javaType.replace('.', '/') + ";";
    }

    public String getClassName(String url, int lineNumber) {
        DataObject dataObject = EditorContextImpl.getDataObject(url);
        if (dataObject == null) {
            return null;
        }
        JavaSource js = JavaSource.forFileObject((FileObject)dataObject.getPrimaryFile());
        if (js == null) {
            return "";
        }
        final StyledDocument doc = EditorContextImpl.findDocument(dataObject);
        if (doc == null) {
            return "";
        }
        try {
            final int offset = NbDocument.findLineOffset((StyledDocument)doc, (int)(lineNumber - 1));
            final String[] result = new String[]{""};
            ParserManager.parse(Collections.singleton(Source.create((Document)doc)), (UserTask)new UserTask(){

                public void run(ResultIterator resultIterator) throws Exception {
                    TypeElement te;
                    TreePath p;
                    CompilationController ci = EditorContextImpl.retrieveController(resultIterator, doc);
                    if (ci == null) {
                        return;
                    }
                    if (ci.toPhase(JavaSource.Phase.RESOLVED).compareTo((Enum)JavaSource.Phase.RESOLVED) < 0) {
                        ErrorManager.getDefault().log(16, "Unable to resolve " + ci.getFileObject() + " to phase " + JavaSource.Phase.RESOLVED + ", current phase = " + ci.getPhase() + "\nDiagnostics = " + ci.getDiagnostics() + "\nFree memory = " + Runtime.getRuntime().freeMemory());
                        return;
                    }
                    for (p = ci.getTreeUtilities().pathFor(offset); p != null && !TreeUtilities.CLASS_TREE_KINDS.contains((Object)p.getLeaf().getKind()); p = p.getParentPath()) {
                    }
                    if (p != null) {
                        te = (TypeElement)ci.getTrees().getElement(p);
                    } else {
                        Scope scope = ci.getTreeUtilities().scopeFor(offset);
                        te = scope.getEnclosingClass();
                    }
                    if (te != null) {
                        result[0] = ElementUtilities.getBinaryName((TypeElement)te);
                    } else {
                        ErrorManager.getDefault().log(16, "No enclosing class for " + ci.getFileObject() + ", offset = " + offset);
                    }
                }
            });
            return result[0];
        }
        catch (ParseException pex) {
            ErrorManager.getDefault().notify((Throwable)pex);
            return "";
        }
        catch (IndexOutOfBoundsException ioobex) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompilationController getPreferredCompilationController(FileObject fo, JavaSource js) throws IOException {
        CompilationController preferredCI;
        if (fo != null) {
            JavaSourceUtil.Handle handle;
            if (JavaSource.forFileObject((FileObject)fo) == null) {
                return null;
            }
            Date lastModified = fo.lastModified();
            Date storedStamp = null;
            Map<JavaSource, JavaSourceUtil.Handle> map = this.sourceHandles;
            synchronized (map) {
                handle = this.sourceHandles.get(js);
                storedStamp = this.sourceModifStamps.get(js);
            }
            if (handle == null || storedStamp != null && lastModified.after(storedStamp)) {
                handle = JavaSourceUtil.createControllerHandle((FileObject)fo, (JavaSourceUtil.Handle)handle);
                map = this.sourceHandles;
                synchronized (map) {
                    this.sourceHandles.put(js, handle);
                    this.sourceModifStamps.put(js, lastModified);
                }
            }
            preferredCI = (CompilationController)handle.getCompilationController();
        } else {
            preferredCI = null;
        }
        return preferredCI;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EditorContext.Operation[] getOperations(String url, final int lineNumber, final EditorContext.BytecodeProvider bytecodeProvider) {
        StyledDocument doc;
        DataObject dataObject = EditorContextImpl.getDataObject(url);
        if (dataObject == null) {
            return null;
        }
        JavaSource js = JavaSource.forFileObject((FileObject)dataObject.getPrimaryFile());
        if (js == null) {
            return null;
        }
        EditorCookie ec = (EditorCookie)dataObject.getCookie(EditorCookie.class);
        if (ec == null) {
            return null;
        }
        try {
            doc = ec.openDocument();
        }
        catch (IOException ex) {
            ErrorManager.getDefault().notify((Throwable)ex);
            return null;
        }
        final int offset = EditorContextImpl.findLineOffset(doc, lineNumber);
        final Object[] result = new Object[1];
        if (SourceUtils.isScanInProgress()) {
            try {
                ParserManager.parse(Collections.singleton(Source.create((Document)doc)), (UserTask)new UserTask(){

                    public void run(ResultIterator resultIterator) throws Exception {
                        CompilationController ci = EditorContextImpl.retrieveController(resultIterator, doc);
                        if (ci == null) {
                            return;
                        }
                        result[0] = EditorContextImpl.this.computeOperations(ci, offset, lineNumber, bytecodeProvider);
                    }
                });
            }
            catch (ParseException pex) {
                ErrorManager.getDefault().notify((Throwable)pex);
                return null;
            }
        }
        try {
            CompilationController ci = this.getPreferredCompilationController(dataObject.getPrimaryFile(), js);
            if (ci == null) {
                return new EditorContext.Operation[0];
            }
            CompilationController compilationController = ci;
            synchronized (compilationController) {
                result[0] = this.computeOperations(ci, offset, lineNumber, bytecodeProvider);
            }
        }
        catch (IOException ioex) {
            ErrorManager.getDefault().notify((Throwable)ioex);
            return null;
        }
        return (EditorContext.Operation[])result[0];
    }

    private void assignNextOperations(Tree methodTree, CompilationUnitTree cu, CompilationController ci, EditorContext.BytecodeProvider bytecodeProvider, List<Tree> treeNodes, ExpressionScanner.ExpressionsInfo info, Map<Tree, EditorContext.Operation> nodeOperations) {
        int length = treeNodes.size();
        for (int treeIndex = 0; treeIndex < length; ++treeIndex) {
            Tree node = treeNodes.get(treeIndex);
            Set<Tree> nextNodes = info.getNextExpressions(node);
            if (nextNodes == null) continue;
            EditorContext.Operation op = nodeOperations.get(node);
            if (op == null) {
                for (int backIndex = treeIndex - 1; backIndex >= 0 && (op = nodeOperations.get(node = treeNodes.get(backIndex))) == null; --backIndex) {
                }
            }
            if (op == null) continue;
            for (Tree t : nextNodes) {
                EditorContext.Operation nextOp = nodeOperations.get(t);
                if (nextOp == null) {
                    ExpressionScanner.ExpressionsInfo newInfo;
                    ExpressionScanner scanner;
                    List<Tree> newExpTrees;
                    SourcePositions sp = ci.getTrees().getSourcePositions();
                    int treeStartLine = (int)cu.getLineMap().getLineNumber(sp.getStartPosition(cu, t));
                    if ((long)treeStartLine == -1L || (newExpTrees = methodTree.accept(scanner = new ExpressionScanner(treeStartLine, cu, ci.getTrees().getSourcePositions()), newInfo = new ExpressionScanner.ExpressionsInfo())) == null) continue;
                    treeStartLine = (int)cu.getLineMap().getLineNumber(sp.getStartPosition(cu, newExpTrees.get(0)));
                    int treeEndLine = (int)cu.getLineMap().getLineNumber(sp.getEndPosition(cu, newExpTrees.get(newExpTrees.size() - 1)));
                    if ((long)treeStartLine == -1L || (long)treeEndLine == -1L) continue;
                    int[] indexes = bytecodeProvider.indexAtLines(treeStartLine, treeEndLine);
                    HashMap<Tree, EditorContext.Operation> newNodeOperations = new HashMap<Tree, EditorContext.Operation>();
                    EditorContext.Operation[] newOps = AST2Bytecode.matchSourceTree2Bytecode(cu, ci, newExpTrees, newInfo, bytecodeProvider.byteCodes(), indexes, bytecodeProvider.constantPool(), new OperationCreationDelegateImpl(), newNodeOperations);
                    nextOp = (EditorContext.Operation)newNodeOperations.get(t);
                    if (nextOp == null) {
                        System.err.println("Next operation not found!");
                        continue;
                    }
                }
                this.addNextOperationTo(op, nextOp);
            }
        }
    }

    private static int findLineOffset(StyledDocument doc, int lineNumber) {
        int offset;
        try {
            offset = NbDocument.findLineOffset((StyledDocument)doc, (int)(lineNumber - 1));
            int offset2 = NbDocument.findLineOffset((StyledDocument)doc, (int)lineNumber);
            try {
                String lineStr = doc.getText(offset, offset2 - offset);
                for (int i = 0; i < lineStr.length(); ++i) {
                    if (Character.isWhitespace(lineStr.charAt(i))) continue;
                    offset += i;
                    break;
                }
            }
            catch (BadLocationException ex) {
            }
        }
        catch (IndexOutOfBoundsException ioobex) {
            return -1;
        }
        return offset;
    }

    public EditorContext.MethodArgument[] getArguments(String url, final EditorContext.Operation operation) {
        DataObject dataObject = EditorContextImpl.getDataObject(url);
        if (dataObject == null) {
            return null;
        }
        JavaSource js = JavaSource.forFileObject((FileObject)dataObject.getPrimaryFile());
        if (js == null) {
            return null;
        }
        final StyledDocument doc = EditorContextImpl.findDocument(dataObject);
        if (doc == null) {
            return null;
        }
        final EditorContext.MethodArgument[][] args = new EditorContext.MethodArgument[1][];
        try {
            ParserManager.parse(Collections.singleton(Source.create((Document)doc)), (UserTask)new UserTask(){

                public void run(ResultIterator resultIterator) throws Exception {
                    CompilationController ci = EditorContextImpl.retrieveController(resultIterator, doc);
                    if (ci == null) {
                        return;
                    }
                    if (ci.toPhase(JavaSource.Phase.RESOLVED).compareTo((Enum)JavaSource.Phase.RESOLVED) < 0) {
                        ErrorManager.getDefault().log(16, "Unable to resolve " + ci.getFileObject() + " to phase " + JavaSource.Phase.RESOLVED + ", current phase = " + ci.getPhase() + "\nDiagnostics = " + ci.getDiagnostics() + "\nFree memory = " + Runtime.getRuntime().freeMemory());
                        return;
                    }
                    int offset = operation.getMethodEndPosition().getOffset();
                    Scope scope = ci.getTreeUtilities().scopeFor(offset);
                    ExecutableElement method = scope.getEnclosingMethod();
                    if (method == null) {
                        return;
                    }
                    Tree methodTree = ci.getTrees().getTree((javax.lang.model.element.Element)method);
                    CompilationUnitTree cu = ci.getCompilationUnit();
                    MethodArgumentsScanner scanner = new MethodArgumentsScanner(offset, cu, ci.getTrees().getSourcePositions(), true, new OperationCreationDelegateImpl());
                    args[0] = methodTree.accept(scanner, null);
                    args[0] = scanner.getArguments();
                }
            });
        }
        catch (ParseException pex) {
            ErrorManager.getDefault().notify((Throwable)pex);
            return null;
        }
        return args[0];
    }

    public EditorContext.MethodArgument[] getArguments(String url, final int methodLineNumber) {
        DataObject dataObject = EditorContextImpl.getDataObject(url);
        if (dataObject == null) {
            return null;
        }
        JavaSource js = JavaSource.forFileObject((FileObject)dataObject.getPrimaryFile());
        if (js == null) {
            return null;
        }
        final StyledDocument doc = EditorContextImpl.findDocument(dataObject);
        if (doc == null) {
            return null;
        }
        final int offset = EditorContextImpl.findLineOffset(doc, methodLineNumber);
        final EditorContext.MethodArgument[][] args = new EditorContext.MethodArgument[1][];
        try {
            ParserManager.parse(Collections.singleton(Source.create((Document)doc)), (UserTask)new UserTask(){

                public void run(ResultIterator resultIterator) throws Exception {
                    CompilationController ci = EditorContextImpl.retrieveController(resultIterator, doc);
                    if (ci == null) {
                        return;
                    }
                    if (ci.toPhase(JavaSource.Phase.RESOLVED).compareTo((Enum)JavaSource.Phase.RESOLVED) < 0) {
                        ErrorManager.getDefault().log(16, "Unable to resolve " + ci.getFileObject() + " to phase " + JavaSource.Phase.RESOLVED + ", current phase = " + ci.getPhase() + "\nDiagnostics = " + ci.getDiagnostics() + "\nFree memory = " + Runtime.getRuntime().freeMemory());
                        return;
                    }
                    Scope scope = ci.getTreeUtilities().scopeFor(offset);
                    TypeElement clazz = scope.getEnclosingClass();
                    if (clazz == null) {
                        return;
                    }
                    Tree methodTree = ci.getTrees().getTree((javax.lang.model.element.Element)clazz);
                    CompilationUnitTree cu = ci.getCompilationUnit();
                    MethodArgumentsScanner scanner = new MethodArgumentsScanner(methodLineNumber, cu, ci.getTrees().getSourcePositions(), false, new OperationCreationDelegateImpl());
                    args[0] = methodTree.accept(scanner, null);
                    args[0] = scanner.getArguments();
                }
            });
        }
        catch (ParseException pex) {
            ErrorManager.getDefault().notify((Throwable)pex);
            return null;
        }
        return args[0];
    }

    public String[] getImports(String url) {
        DataObject dataObject = EditorContextImpl.getDataObject(url);
        if (dataObject == null) {
            return new String[0];
        }
        JavaSource js = JavaSource.forFileObject((FileObject)dataObject.getPrimaryFile());
        if (js == null) {
            return new String[0];
        }
        final StyledDocument doc = EditorContextImpl.findDocument(dataObject);
        if (doc == null) {
            return null;
        }
        if (doc == null) {
            return new String[0];
        }
        final ArrayList imports = new ArrayList();
        try {
            ParserManager.parse(Collections.singleton(Source.create((Document)doc)), (UserTask)new UserTask(){

                public void run(ResultIterator resultIterator) throws Exception {
                    CompilationController ci = EditorContextImpl.retrieveController(resultIterator, doc);
                    if (ci == null) {
                        return;
                    }
                    if (ci.toPhase(JavaSource.Phase.PARSED).compareTo((Enum)JavaSource.Phase.PARSED) < 0) {
                        ErrorManager.getDefault().log(16, "Unable to resolve " + ci.getFileObject() + " to phase " + JavaSource.Phase.RESOLVED + ", current phase = " + ci.getPhase() + "\nDiagnostics = " + ci.getDiagnostics() + "\nFree memory = " + Runtime.getRuntime().freeMemory());
                        return;
                    }
                    List<? extends ImportTree> importDecl = ci.getCompilationUnit().getImports();
                    int i = 0;
                    for (ImportTree importTree : importDecl) {
                        String importStr = importTree.getQualifiedIdentifier().toString();
                        imports.add(importStr);
                        ++i;
                    }
                }
            });
        }
        catch (ParseException pex) {
            ErrorManager.getDefault().notify((Throwable)pex);
            return new String[0];
        }
        return imports.toArray(new String[0]);
    }

    private JavaSource getJavaSource(SourcePathProvider sp) {
        String[] roots = sp.getOriginalSourceRoots();
        ArrayList<FileObject> sourcePathFiles = new ArrayList<FileObject>();
        for (String root : roots) {
            FileObject fo = FileUtil.toFileObject((File)new File(root));
            if (fo != null && FileUtil.isArchiveFile((FileObject)fo)) {
                fo = FileUtil.getArchiveRoot((FileObject)fo);
            }
            sourcePathFiles.add(fo);
        }
        ClassPath bootPath = ClassPathSupport.createClassPath((FileObject[])new FileObject[0]);
        ClassPath classPath = ClassPathSupport.createClassPath((FileObject[])new FileObject[0]);
        ClassPath sourcePath = ClassPathSupport.createClassPath((FileObject[])sourcePathFiles.toArray(new FileObject[0]));
        return JavaSource.create((ClasspathInfo)ClasspathInfo.create((ClassPath)bootPath, (ClassPath)classPath, (ClassPath)sourcePath), (FileObject[])new FileObject[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R, D> R parseExpression(String expression, String url, int line, TreePathScanner<R, D> visitor, D context, SourcePathProvider sp) throws InvalidExpressionException {
        JavaSource js = null;
        FileObject fo = null;
        if (url != null) {
            try {
                fo = URLMapper.findFileObject((URL)new URL(url));
                if (fo != null) {
                    js = JavaSource.forFileObject((FileObject)fo);
                }
            }
            catch (MalformedURLException ex) {
                ErrorManager.getDefault().notify(16, (Throwable)ex);
            }
        }
        if (js == null) {
            js = this.getJavaSource(sp);
        }
        try {
            R retValue;
            StyledDocument doc;
            CompilationController ci = this.getPreferredCompilationController(fo, js);
            final ParseExpressionTask<D> task = new ParseExpressionTask<D>(expression, line, context);
            if (fo != null && SourceUtils.isScanInProgress()) {
                doc = EditorContextImpl.findDocument(fo);
                if (doc == null) {
                    return null;
                }
                try {
                    ParserManager.parse(Collections.singleton(Source.create((Document)doc)), (UserTask)new UserTask(){

                        public void run(ResultIterator resultIterator) throws Exception {
                            CompilationController ci = EditorContextImpl.retrieveController(resultIterator, doc);
                            if (ci != null) {
                                task.run(ci);
                            }
                        }
                    });
                }
                catch (ParseException pex) {
                    ErrorManager.getDefault().notify((Throwable)pex);
                    return null;
                }
            }
            if (ci == null) {
                js.runUserActionTask(task, false);
            } else {
                try {
                    doc = ci;
                    synchronized (doc) {
                        task.run(ci);
                    }
                }
                catch (Exception ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                    return null;
                }
            }
            TreePath treePath = task.getTreePath();
            Tree tree = task.getTree();
            if (treePath != null) {
                retValue = visitor.scan(treePath, context);
            } else {
                if (tree == null) {
                    throw new InvalidExpressionException(NbBundle.getMessage(EditorContextImpl.class, (String)"MSG_NoParseNoEval"));
                }
                retValue = tree.accept(visitor, context);
            }
            return retValue;
        }
        catch (IOException ioex) {
            ErrorManager.getDefault().notify((Throwable)ioex);
            return null;
        }
    }

    private static boolean isErroneous(Tree tree) {
        class TreeChecker
        extends TreePathScanner<Boolean, Void> {
            TreeChecker() {
            }

            @Override
            public Boolean scan(Tree tree, Void p) {
                if (tree == null) {
                    return Boolean.FALSE;
                }
                if (tree.getKind() == Tree.Kind.ERRONEOUS) {
                    return Boolean.TRUE;
                }
                return tree.accept(this, p);
            }

            public Boolean visitErrorneous(ErroneousTree tree, Void p) {
                return Boolean.TRUE;
            }
        }
        Boolean result = new TreeChecker().scan(tree, null);
        return result != null && result != false;
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.pcs.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.pcs.removePropertyChangeListener(l);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener l) {
        this.pcs.addPropertyChangeListener(propertyName, l);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener l) {
        this.pcs.removePropertyChangeListener(propertyName, l);
    }

    private String getCurrentElement(ElementKind kind) {
        return this.getCurrentElement(kind, null);
    }

    private String getMostRecentElement(ElementKind kind) {
        return this.getMostRecentElement(kind, null);
    }

    private String getCurrentElement(ElementKind kind, javax.lang.model.element.Element[] elementPtr) throws IllegalComponentStateException {
        return this.getCurrentElement(this.contextDispatcher.getCurrentFile(), this.contextDispatcher.getCurrentEditor(), kind, elementPtr);
    }

    private String getMostRecentElement(ElementKind kind, javax.lang.model.element.Element[] elementPtr) throws IllegalComponentStateException {
        return this.getCurrentElement(this.contextDispatcher.getMostRecentFile(), this.contextDispatcher.getMostRecentEditor(), kind, elementPtr);
    }

    private String getCurrentElement(FileObject fo, JEditorPane ep, final ElementKind kind, final javax.lang.model.element.Element[] elementPtr) throws IllegalComponentStateException {
        String[] currentElementPtr;
        block11: {
            String selectedIdentifier;
            int currentOffset;
            if (fo == null) {
                return null;
            }
            JavaSource js = JavaSource.forFileObject((FileObject)fo);
            if (js == null) {
                return null;
            }
            if (ep != null) {
                String s = ep.getSelectedText();
                currentOffset = ep.getCaretPosition();
                if (ep.getSelectionStart() > currentOffset || ep.getSelectionEnd() < currentOffset) {
                    s = null;
                }
                selectedIdentifier = s != null && Utilities.isJavaIdentifier((String)s) ? s : null;
            } else {
                selectedIdentifier = null;
                currentOffset = 0;
            }
            currentElementPtr = new String[]{null};
            try {
                final Future<Void> scanFinished = EditorContextImpl.runWhenScanFinishedReallyLazy(js, (Task<CompilationController>)new CancellableTask<CompilationController>(){

                    public void cancel() {
                    }

                    public void run(CompilationController ci) throws Exception {
                        if (ci.toPhase(JavaSource.Phase.RESOLVED).compareTo((Enum)JavaSource.Phase.RESOLVED) < 0) {
                            ErrorManager.getDefault().log(16, "Unable to resolve " + ci.getFileObject() + " to phase " + JavaSource.Phase.RESOLVED + ", current phase = " + ci.getPhase() + "\nDiagnostics = " + ci.getDiagnostics() + "\nFree memory = " + Runtime.getRuntime().freeMemory());
                            return;
                        }
                        javax.lang.model.element.Element el = null;
                        if (kind == ElementKind.CLASS) {
                            Tree tree;
                            boolean isMemberClass = false;
                            if (selectedIdentifier != null && (tree = ci.getTreeUtilities().pathFor(currentOffset).getLeaf()).getKind() == Tree.Kind.MEMBER_SELECT) {
                                TypeMirror tm;
                                MemberSelectTree mst = (MemberSelectTree)tree;
                                el = ci.getTrees().getElement(ci.getTrees().getPath(ci.getCompilationUnit(), mst.getExpression()));
                                if (el != null && (tm = el.asType()).getKind().equals((Object)TypeKind.DECLARED)) {
                                    currentElementPtr[0] = ((Object)tm).toString();
                                    isMemberClass = true;
                                }
                            }
                            if (!isMemberClass) {
                                TypeElement te;
                                TreePath currentPath = ci.getTreeUtilities().pathFor(currentOffset);
                                Tree tree2 = currentPath.getLeaf();
                                if (TreeUtilities.CLASS_TREE_KINDS.contains((Object)tree2.getKind())) {
                                    te = (TypeElement)ci.getTrees().getElement(currentPath);
                                } else {
                                    Scope scope = ci.getTreeUtilities().scopeFor(currentOffset);
                                    te = scope.getEnclosingClass();
                                }
                                if (te != null) {
                                    currentElementPtr[0] = ElementUtilities.getBinaryName((TypeElement)te);
                                }
                                el = te;
                            }
                        } else if (kind == ElementKind.METHOD) {
                            Scope scope = ci.getTreeUtilities().scopeFor(currentOffset);
                            el = scope.getEnclosingMethod();
                            if (el != null) {
                                currentElementPtr[0] = el.getSimpleName().toString();
                                if (currentElementPtr[0].equals("<init>")) {
                                    currentElementPtr[0] = el.getEnclosingElement().getSimpleName().toString();
                                }
                            } else {
                                Tree tree;
                                TreePath path = ci.getTreeUtilities().pathFor(currentOffset);
                                Tree tree2 = tree = path != null ? path.getLeaf() : null;
                                while (tree != null && !(tree instanceof MethodTree) && !(tree instanceof ClassTree)) {
                                    tree = (path = path.getParentPath()) != null ? path.getLeaf() : null;
                                }
                                if (tree instanceof MethodTree) {
                                    String name = ((MethodTree)tree).getName().toString();
                                    if (name.equals("<init>") && scope.getEnclosingClass() != null) {
                                        name = scope.getEnclosingClass().getSimpleName().toString();
                                    }
                                    currentElementPtr[0] = name;
                                }
                            }
                        } else if (kind == ElementKind.FIELD) {
                            Tree tree;
                            int offset;
                            if (selectedIdentifier == null) {
                                String text = ci.getText();
                                int l = text.length();
                                char c = '\u0000';
                                for (offset = currentOffset; offset < l && (c = text.charAt(offset)) != ';' && c != ',' && c != '\n' && c != '\r'; ++offset) {
                                }
                                if (offset < l && c == ';' || c == ',') {
                                    int endOffset = --offset;
                                    int setOffset = -1;
                                    while (offset >= 0 && (c = text.charAt(offset)) != ';' && c != ',' && c != '\n' && c != '\r') {
                                        if (c == '=') {
                                            setOffset = offset;
                                        }
                                        --offset;
                                    }
                                    for (offset = setOffset > -1 ? setOffset : endOffset; offset >= 0 && Character.isWhitespace(text.charAt(offset)); --offset) {
                                    }
                                }
                                if (offset < 0) {
                                    offset = 0;
                                }
                            }
                            if ((tree = ci.getTreeUtilities().pathFor(offset).getLeaf()).getKind() == Tree.Kind.VARIABLE) {
                                el = ci.getTrees().getElement(ci.getTrees().getPath(ci.getCompilationUnit(), tree));
                                if (el != null && (el.getKind() == ElementKind.FIELD || el.getKind() == ElementKind.ENUM_CONSTANT)) {
                                    currentElementPtr[0] = ((VariableTree)tree).getName().toString();
                                }
                            } else if (tree.getKind() == Tree.Kind.IDENTIFIER && selectedIdentifier != null) {
                                IdentifierTree it = (IdentifierTree)tree;
                                String fieldName = it.getName().toString();
                                Scope scope = ci.getTreeUtilities().scopeFor(offset);
                                TypeElement te = scope.getEnclosingClass();
                                List<? extends javax.lang.model.element.Element> list = te.getEnclosedElements();
                                for (javax.lang.model.element.Element element : list) {
                                    if (!element.getKind().equals((Object)ElementKind.FIELD) || !element.getSimpleName().contentEquals(fieldName)) continue;
                                    currentElementPtr[0] = fieldName;
                                    break;
                                }
                            } else if (tree.getKind() == Tree.Kind.MEMBER_SELECT && selectedIdentifier != null) {
                                MemberSelectTree mst = (MemberSelectTree)tree;
                                String fieldName = mst.getIdentifier().toString();
                                el = ci.getTrees().getElement(ci.getTrees().getPath(ci.getCompilationUnit(), mst.getExpression()));
                                if (el != null && el.asType().getKind().equals((Object)TypeKind.DECLARED)) {
                                    List<? extends javax.lang.model.element.Element> enclosedElms = ((DeclaredType)el.asType()).asElement().getEnclosedElements();
                                    for (javax.lang.model.element.Element element : enclosedElms) {
                                        if (!element.getKind().equals((Object)ElementKind.FIELD) || !element.getSimpleName().contentEquals(fieldName)) continue;
                                        currentElementPtr[0] = fieldName;
                                        break;
                                    }
                                }
                            }
                        }
                        if (elementPtr != null) {
                            elementPtr[0] = el;
                        }
                    }
                }, true);
                if (scanFinished.isDone()) break block11;
                if (EventQueue.isDispatchThread()) {
                    throw new IllegalComponentStateException(){

                        private void waitScanFinished() {
                            try {
                                scanFinished.get();
                            }
                            catch (InterruptedException iex) {
                            }
                            catch (ExecutionException eex) {
                                ErrorManager.getDefault().notify((Throwable)eex);
                            }
                        }

                        @Override
                        public String getMessage() {
                            this.waitScanFinished();
                            return currentElementPtr[0];
                        }
                    };
                }
                try {
                    scanFinished.get();
                }
                catch (InterruptedException iex) {
                    return null;
                }
                catch (ExecutionException eex) {
                    ErrorManager.getDefault().notify((Throwable)eex);
                    return null;
                }
            }
            catch (IOException ioex) {
                ErrorManager.getDefault().notify((Throwable)ioex);
                return null;
            }
        }
        return currentElementPtr[0];
    }

    private static DataObject getDataObject(String url) {
        FileObject file;
        try {
            file = URLMapper.findFileObject((URL)new URL(url));
        }
        catch (MalformedURLException e) {
            return null;
        }
        if (file == null) {
            return null;
        }
        try {
            return DataObject.find((FileObject)file);
        }
        catch (DataObjectNotFoundException ex) {
            return null;
        }
    }

    private static StyledDocument findDocument(FileObject fo) {
        StyledDocument doc;
        DataObject dataObject;
        try {
            dataObject = DataObject.find((FileObject)fo);
        }
        catch (DataObjectNotFoundException ex) {
            return null;
        }
        EditorCookie ec = (EditorCookie)dataObject.getCookie(EditorCookie.class);
        if (ec == null) {
            return null;
        }
        try {
            doc = ec.openDocument();
        }
        catch (IOException ex) {
            return null;
        }
        return doc;
    }

    private static StyledDocument findDocument(DataObject dataObject) {
        StyledDocument doc;
        EditorCookie ec = (EditorCookie)dataObject.getCookie(EditorCookie.class);
        if (ec == null) {
            return null;
        }
        try {
            doc = ec.openDocument();
        }
        catch (IOException ex) {
            return null;
        }
        return doc;
    }

    private static CompilationController retrieveController(ResultIterator resIt, StyledDocument doc) throws ParseException {
        CompilationController ci;
        Parser.Result res = resIt.getParserResult();
        CompilationController compilationController = ci = res != null ? CompilationController.get((Parser.Result)res) : null;
        if (ci == null) {
            ErrorManager.getDefault().log(16, "Unable to get compilation controller " + doc);
        }
        return ci;
    }

    private EditorContext.Operation[] computeOperations(CompilationController ci, int offset, int lineNumber, EditorContext.BytecodeProvider bytecodeProvider) throws IOException {
        ExpressionScanner.ExpressionsInfo info;
        if (ci.toPhase(JavaSource.Phase.RESOLVED).compareTo((Enum)JavaSource.Phase.RESOLVED) < 0) {
            ErrorManager.getDefault().log(16, "Unable to resolve " + ci.getFileObject() + " to phase " + JavaSource.Phase.RESOLVED + ", current phase = " + ci.getPhase() + "\nDiagnostics = " + ci.getDiagnostics() + "\nFree memory = " + Runtime.getRuntime().freeMemory());
            return new EditorContext.Operation[0];
        }
        Scope scope = ci.getTreeUtilities().scopeFor(offset);
        ExecutableElement method = scope.getEnclosingMethod();
        if (method == null) {
            return new EditorContext.Operation[0];
        }
        Tree methodTree = ci.getTrees().getTree((javax.lang.model.element.Element)method);
        if (methodTree == null) {
            return new EditorContext.Operation[0];
        }
        CompilationUnitTree cu = ci.getCompilationUnit();
        ExpressionScanner scanner = new ExpressionScanner(lineNumber, cu, ci.getTrees().getSourcePositions());
        List<Tree> expTrees = methodTree.accept(scanner, info = new ExpressionScanner.ExpressionsInfo());
        if (expTrees == null || expTrees.size() == 0) {
            return new EditorContext.Operation[0];
        }
        SourcePositions sp = ci.getTrees().getSourcePositions();
        int treeStartLine = (int)cu.getLineMap().getLineNumber(sp.getStartPosition(cu, expTrees.get(0)));
        int treeEndLine = (int)cu.getLineMap().getLineNumber(sp.getEndPosition(cu, expTrees.get(expTrees.size() - 1)));
        if ((long)treeStartLine == -1L || (long)treeEndLine == -1L) {
            return null;
        }
        int[] indexes = bytecodeProvider.indexAtLines(treeStartLine, treeEndLine);
        if (indexes == null) {
            return null;
        }
        HashMap<Tree, EditorContext.Operation> nodeOperations = new HashMap<Tree, EditorContext.Operation>();
        EditorContext.Operation[] ops = AST2Bytecode.matchSourceTree2Bytecode(cu, ci, expTrees, info, bytecodeProvider.byteCodes(), indexes, bytecodeProvider.constantPool(), new OperationCreationDelegateImpl(), nodeOperations);
        if (ops != null) {
            this.assignNextOperations(methodTree, cu, ci, bytecodeProvider, expTrees, info, nodeOperations);
        }
        return ops;
    }

    private static Future<Void> runWhenScanFinishedReallyLazy(final JavaSource js, final Task<CompilationController> task, final boolean shared) throws IOException {
        return EditorContextImpl.scanReallyLazy(new ScanRunnable<IOException>(IOException.class){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void run(Future<Void>[] resultPtr, IOException[] excPtr) {
                try {
                    Future result = js.runWhenScanFinished(task, shared);
                    Future<Void>[] futureArray = resultPtr;
                    synchronized (resultPtr) {
                        resultPtr[0] = result;
                        // ** MonitorExit[var4_5] (shouldn't be in output)
                        return;
                    }
                }
                catch (IOException ex) {
                    Future<Void>[] futureArray = resultPtr;
                    synchronized (resultPtr) {
                        excPtr[0] = ex;
                        // ** MonitorExit[var4_6] (shouldn't be in output)
                        return;
                    }
                }
            }
        });
    }

    private static Future<Void> parseWhenScanFinishedReallyLazy(final Collection<Source> sources, final UserTask userTask) throws ParseException {
        return EditorContextImpl.scanReallyLazy(new ScanRunnable<ParseException>(ParseException.class){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void run(Future<Void>[] resultPtr, ParseException[] excPtr) {
                try {
                    Future result = ParserManager.parseWhenScanFinished((Collection)sources, (UserTask)userTask);
                    Future<Void>[] futureArray = resultPtr;
                    synchronized (resultPtr) {
                        resultPtr[0] = result;
                        // ** MonitorExit[var4_5] (shouldn't be in output)
                        return;
                    }
                }
                catch (ParseException ex) {
                    Future<Void>[] futureArray = resultPtr;
                    synchronized (resultPtr) {
                        excPtr[0] = ex;
                        // ** MonitorExit[var4_6] (shouldn't be in output)
                        return;
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <E extends Throwable> Future<Void> scanReallyLazy(ScanRunnable<E> run) throws E {
        final Future[] resultPtr = new Future[]{null};
        final Throwable[] excPtr = (Throwable[])Array.newInstance(((ScanRunnable)run).exceptionType, 1);
        ((ScanRunnable)run).setParam(resultPtr, excPtr);
        final RequestProcessor.Task scanning = scanningProcessor.post(run);
        try {
            scanning.waitFinished(200L);
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        Future[] futureArray = resultPtr;
        synchronized (resultPtr) {
            if (excPtr[0] != null) {
                throw excPtr[0];
            }
            if (resultPtr[0] != null) {
                // ** MonitorExit[var4_5] (shouldn't be in output)
                return resultPtr[0];
            }
            // ** MonitorExit[var4_5] (shouldn't be in output)
            return new Future<Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                private Future<Void> getDelegate() {
                    Future[] futureArray = resultPtr;
                    synchronized (resultPtr) {
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return resultPtr[0];
                    }
                }

                @Override
                public boolean cancel(boolean mayInterruptIfRunning) {
                    Future<Void> d = this.getDelegate();
                    if (d != null) {
                        return d.cancel(mayInterruptIfRunning);
                    }
                    return false;
                }

                @Override
                public boolean isCancelled() {
                    Future<Void> d = this.getDelegate();
                    if (d != null) {
                        return d.isCancelled();
                    }
                    return false;
                }

                @Override
                public boolean isDone() {
                    Future<Void> d = this.getDelegate();
                    if (d != null) {
                        return d.isDone();
                    }
                    return false;
                }

                @Override
                public Void get() throws InterruptedException, ExecutionException {
                    scanning.waitFinished();
                    Future<Void> d = this.getDelegate();
                    if (d != null) {
                        return d.get();
                    }
                    if (excPtr[0] != null) {
                        throw new ExecutionException(excPtr[0]);
                    }
                    throw new ExecutionException("Task failed", new RuntimeException("Task Failed"));
                }

                @Override
                public Void get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                    Future<Void> d;
                    long mstimeout = unit.toMillis(timeout);
                    if (mstimeout == 0L) {
                        if (!scanning.isFinished()) {
                            throw new TimeoutException("Task timeout");
                        }
                    } else {
                        long s1 = System.nanoTime();
                        boolean finished = scanning.waitFinished(mstimeout);
                        if (!finished) {
                            throw new TimeoutException("Task timeout");
                        }
                        long s2 = System.nanoTime();
                        if ((timeout -= unit.convert(s2 - s1, TimeUnit.NANOSECONDS)) < 0L) {
                            timeout = 1L;
                        }
                    }
                    if ((d = this.getDelegate()) != null) {
                        return d.get(timeout, unit);
                    }
                    if (excPtr[0] != null) {
                        throw new ExecutionException(excPtr[0]);
                    }
                    throw new ExecutionException("Task failed", new RuntimeException("Task Failed"));
                }
            };
        }
    }

    private static class SessionsListenerRemoval {
        private SessionsListenerRemoval() {
        }

        public void removeDebuggerListener(DebuggerManagerListener l) {
            DebuggerManager.getDebuggerManager().removeDebuggerListener("sessions", l);
        }
    }

    private class SessionsListener
    extends DebuggerManagerAdapter {
        private SessionsListener() {
        }

        public void sessionRemoved(Session session) {
            int numSession = DebuggerManager.getDebuggerManager().getSessions().length;
            if (numSession > 0) {
                EditorContextImpl.this.sourceHandles.size();
                EditorContextImpl.this.sourceModifStamps.size();
            } else {
                EditorContextImpl.this.sourceHandles.clear();
                EditorContextImpl.this.sourceModifStamps.clear();
            }
        }
    }

    private class OperationCreationDelegateImpl
    implements AST2Bytecode.OperationCreationDelegate {
        private OperationCreationDelegateImpl() {
        }

        @Override
        public EditorContext.Operation createMethodOperation(EditorContext.Position startPosition, EditorContext.Position endPosition, EditorContext.Position methodStartPosition, EditorContext.Position methodEndPosition, String methodName, String methodClassType, int bytecodeIndex) {
            return EditorContextImpl.this.createMethodOperation(startPosition, endPosition, methodStartPosition, methodEndPosition, methodName, methodClassType, bytecodeIndex);
        }

        @Override
        public EditorContext.Position createPosition(int offset, int line, int column) {
            return EditorContextImpl.this.createPosition(offset, line, column);
        }

        @Override
        public void addNextOperationTo(EditorContext.Operation operation, EditorContext.Operation next) {
            EditorContextImpl.this.addNextOperationTo(operation, next);
        }
    }

    private class EditorContextDispatchListener
    implements PropertyChangeListener {
        private EditorContextDispatchListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            EditorContextImpl.this.pcs.firePropertyChange("currentNodes", null, null);
        }
    }

    private static final class DoneFuture<T>
    implements Future<T> {
        private final T result;

        public DoneFuture(T result) {
            this.result = result;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return false;
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        @Override
        public boolean isDone() {
            return true;
        }

        @Override
        public T get() throws InterruptedException, ExecutionException {
            return this.result;
        }

        @Override
        public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return this.result;
        }
    }

    private static abstract class ScanRunnable<E extends Throwable>
    implements Runnable {
        private Future<Void>[] resultPtr;
        private E[] excPtr;
        private Class<E> exceptionType;

        public ScanRunnable(Class<E> exceptionType) {
            this.exceptionType = exceptionType;
        }

        private void setParam(Future<Void>[] resultPtr, E[] excPtr) {
            this.resultPtr = resultPtr;
            this.excPtr = excPtr;
        }

        @Override
        public final void run() {
            this.run(this.resultPtr, (Throwable[])this.excPtr);
        }

        public abstract void run(Future<Void>[] var1, E[] var2);
    }

    private static class ParseExpressionTask<D>
    implements Task<CompilationController> {
        private int line;
        private String expression;
        private D context;
        private TreePath treePath;
        private Tree tree;

        public ParseExpressionTask(String expression, int line, D context) {
            this.expression = expression;
            this.line = line;
            this.context = context;
        }

        private StyledDocument getDocument(CompilationController ci) {
            FileObject file = ci.getFileObject();
            if (file == null || !file.isValid()) {
                return null;
            }
            try {
                DataObject od = DataObject.find((FileObject)file);
                EditorCookie ec = (EditorCookie)od.getCookie(EditorCookie.class);
                if (ec != null) {
                    return ec.openDocument();
                }
                return null;
            }
            catch (DataObjectNotFoundException e) {
                return null;
            }
            catch (IOException ioex) {
                return null;
            }
        }

        public void run(CompilationController ci) throws Exception {
            if (ci.toPhase(JavaSource.Phase.PARSED).compareTo((Enum)JavaSource.Phase.PARSED) < 0) {
                return;
            }
            Scope scope = null;
            int offset = 0;
            StyledDocument doc = this.getDocument(ci);
            if (doc != null) {
                offset = EditorContextImpl.findLineOffset(doc, this.line);
                scope = ci.getTreeUtilities().scopeFor(offset);
            }
            SourcePositions[] sourcePtr = new SourcePositions[]{null};
            this.tree = ci.getTreeUtilities().parseStatement("{\n" + this.expression + ";\n}", sourcePtr);
            if (EditorContextImpl.isErroneous(this.tree)) {
                Tree asBlockTree = this.tree;
                this.tree = ci.getTreeUtilities().parseExpression(this.expression, sourcePtr);
                if (EditorContextImpl.isErroneous(this.tree)) {
                    this.tree = asBlockTree;
                }
            }
            if (scope != null) {
                ci.getTreeUtilities().attributeTree(this.tree, scope);
            }
            try {
                Method setTreesMethod = this.context.getClass().getMethod("setTrees", Trees.class);
                setTreesMethod.invoke(this.context, ci.getTrees());
            }
            catch (Exception ex) {
                // empty catch block
            }
            try {
                Method setCompilationUnitMethod = this.context.getClass().getMethod("setCompilationUnit", CompilationUnitTree.class);
                setCompilationUnitMethod.invoke(this.context, ci.getCompilationUnit());
            }
            catch (Exception ex) {
                // empty catch block
            }
            this.treePath = null;
            try {
                Method setTreePathMethod = this.context.getClass().getMethod("setTreePath", TreePath.class);
                if (doc != null) {
                    this.treePath = ci.getTreeUtilities().pathFor(offset);
                    this.treePath = new TreePath(this.treePath, this.tree);
                    setTreePathMethod.invoke(this.context, this.treePath);
                }
            }
            catch (Exception ex) {
                return;
            }
        }

        public TreePath getTreePath() {
            return this.treePath;
        }

        public Tree getTree() {
            return this.tree;
        }
    }
}

