/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.cldcplatform.startup;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;

public class Util {
    private Util() {
    }

    public static void deleteDirectory(File dir) {
        Util.deleteDirectory(dir, null);
    }

    public static void deleteDirectory(File dir, FileFilter filter) {
        if (!dir.exists()) {
            return;
        }
        if (!dir.delete()) {
            if (dir.isDirectory()) {
                File[] list = filter == null ? dir.listFiles() : dir.listFiles(filter);
                for (int i = 0; i < list.length; ++i) {
                    Util.deleteDirectory(list[i]);
                }
            }
            dir.delete();
        }
    }

    public static long getFileSize(File filepath) {
        long size = 0L;
        if (!filepath.exists()) {
            return size;
        }
        File[] list = filepath.listFiles();
        if (list == null || list.length == 0) {
            return size;
        }
        for (int i = 0; i < list.length; ++i) {
            if (list[i].isDirectory()) {
                size += Util.getFileSize(list[i]);
                continue;
            }
            size += list[i].length();
        }
        return size;
    }

    public static String arrayToString(Object[] array, String delimiter) {
        try {
            if (array == null) {
                return null;
            }
            StringBuffer buf = new StringBuffer();
            buf.append(array[0]);
            for (int i = 1; i < array.length; ++i) {
                buf.append(delimiter);
                buf.append(array[i]);
            }
            return buf.toString();
        }
        catch (Exception ex) {
            return array.toString();
        }
    }

    public static String getStackTrace(Exception ex) {
        StringWriter sw = new StringWriter(500);
        PrintWriter pw = new PrintWriter(sw);
        ex.printStackTrace(pw);
        return sw.toString();
    }

    public static void copyFile(File src, File dest) throws Exception {
        try {
            int c;
            FileInputStream in = new FileInputStream(src);
            FileOutputStream out = new FileOutputStream(dest);
            while ((c = in.read()) != -1) {
                out.write(c);
            }
            in.close();
            out.close();
        }
        catch (FileNotFoundException notFound) {
            throw new Exception("Source or Destination file not found: " + notFound);
        }
        catch (IOException ioerr) {
            throw new Exception("IO Error copying file " + src.getName());
        }
    }
}

