/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.parser.apt;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.logging.Level;
import org.netbeans.modules.cnd.apt.structure.APTFile;
import org.netbeans.modules.cnd.apt.structure.APTInclude;
import org.netbeans.modules.cnd.apt.support.APTAbstractWalker;
import org.netbeans.modules.cnd.apt.support.APTFileCacheEntry;
import org.netbeans.modules.cnd.apt.support.APTIncludeHandler;
import org.netbeans.modules.cnd.apt.support.APTPreprocHandler;
import org.netbeans.modules.cnd.apt.support.PostIncludeData;
import org.netbeans.modules.cnd.apt.support.ResolvedPath;
import org.netbeans.modules.cnd.apt.utils.APTUtils;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.LibraryManager;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.modelimpl.debug.DiagnosticExceptoins;
import org.netbeans.modules.cnd.utils.CndUtils;

public abstract class APTProjectFileBasedWalker
extends APTAbstractWalker {
    private final FileImpl file;
    private final ProjectBase startProject;
    private int mode = 0;

    public APTProjectFileBasedWalker(ProjectBase projectBase, APTFile aPTFile, FileImpl fileImpl, APTPreprocHandler aPTPreprocHandler, APTFileCacheEntry aPTFileCacheEntry) {
        super(aPTFile, aPTPreprocHandler, aPTFileCacheEntry);
        this.file = fileImpl;
        this.startProject = projectBase;
        assert (projectBase != null) : "null start project for " + fileImpl.getAbsolutePath();
    }

    protected boolean include(ResolvedPath resolvedPath, APTInclude aPTInclude, PostIncludeData postIncludeData) {
        APTIncludeHandler.IncludeState includeState;
        FileImpl fileImpl = null;
        boolean bl = false;
        if (resolvedPath != null) {
            CharSequence charSequence = resolvedPath.getPath();
            includeState = this.getIncludeHandler().pushInclude(charSequence, aPTInclude, resolvedPath.getIndex());
            if (includeState == APTIncludeHandler.IncludeState.Success) {
                ProjectBase projectBase = this.getStartProject();
                if (projectBase != null) {
                    if (projectBase.isValid()) {
                        ProjectBase projectBase2 = LibraryManager.getInstance().resolveFileProjectOnInclude(projectBase, this.getFile(), resolvedPath);
                        CndUtils.assertTrue((projectBase2.getFileSystem() == resolvedPath.getFileSystem() ? 1 : 0) != 0, (String)("Different FS for " + charSequence + ": " + projectBase2.getFileSystem() + " vs " + resolvedPath.getFileSystem()));
                        try {
                            fileImpl = this.includeAction(projectBase2, charSequence, this.mode, aPTInclude, postIncludeData);
                        }
                        catch (FileNotFoundException fileNotFoundException) {
                            APTUtils.LOG.log(Level.WARNING, "APTProjectFileBasedWalker: file {0} not found", new Object[]{charSequence});
                            DiagnosticExceptoins.register(fileNotFoundException);
                        }
                        catch (IOException iOException) {
                            APTUtils.LOG.log(Level.SEVERE, "APTProjectFileBasedWalker: error on including {0}:\n{1}", new Object[]{charSequence, iOException});
                            DiagnosticExceptoins.register(iOException);
                        }
                    } else {
                        this.getIncludeHandler().popInclude();
                    }
                } else {
                    APTUtils.LOG.log(Level.SEVERE, "APTProjectFileBasedWalker: file {0} without project!!!", new Object[]{this.file});
                    this.getIncludeHandler().popInclude();
                }
            } else {
                bl = true;
            }
        } else {
            includeState = APTIncludeHandler.IncludeState.Fail;
        }
        this.postInclude(aPTInclude, fileImpl, includeState);
        return (postIncludeData == null || !postIncludeData.hasPostIncludeMacroState()) && !bl;
    }

    protected abstract FileImpl includeAction(ProjectBase var1, CharSequence var2, int var3, APTInclude var4, PostIncludeData var5) throws IOException;

    protected void postInclude(APTInclude aPTInclude, FileImpl fileImpl, APTIncludeHandler.IncludeState includeState) {
    }

    protected FileImpl getFile() {
        return this.file;
    }

    protected ProjectBase getStartProject() {
        return this.startProject;
    }

    protected void setMode(int n) {
        this.mode = n;
    }
}

