/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.impl.services;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.CsmVariable;
import org.netbeans.modules.cnd.api.model.services.CsmIncludeResolver;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.api.model.xref.CsmIncludeHierarchyResolver;
import org.netbeans.modules.cnd.api.project.NativeFileItem;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.utils.CndPathUtilitities;
import org.netbeans.modules.cnd.utils.FSPath;

public final class IncludeResolverImpl
extends CsmIncludeResolver {
    private final Set<String> standardHeaders = new HashSet<String>();

    public IncludeResolverImpl() {
        this.standardHeaders.add("algorithm");
        this.standardHeaders.add("bitset");
        this.standardHeaders.add("complex");
        this.standardHeaders.add("deque");
        this.standardHeaders.add("exception");
        this.standardHeaders.add("fstream");
        this.standardHeaders.add("functional");
        this.standardHeaders.add("iomanip");
        this.standardHeaders.add("ios");
        this.standardHeaders.add("iosfwd");
        this.standardHeaders.add("iostream");
        this.standardHeaders.add("iterator");
        this.standardHeaders.add("limits");
        this.standardHeaders.add("list");
        this.standardHeaders.add("locale");
        this.standardHeaders.add("map");
        this.standardHeaders.add("memory");
        this.standardHeaders.add("new");
        this.standardHeaders.add("numeric");
        this.standardHeaders.add("queue");
        this.standardHeaders.add("set");
        this.standardHeaders.add("sstream");
        this.standardHeaders.add("stack");
        this.standardHeaders.add("stdexcept");
        this.standardHeaders.add("streambuf");
        this.standardHeaders.add("string");
        this.standardHeaders.add("typeinfo");
        this.standardHeaders.add("utility");
        this.standardHeaders.add("valarray");
        this.standardHeaders.add("vector");
        this.standardHeaders.add("cassert");
        this.standardHeaders.add("cctype");
        this.standardHeaders.add("cerrno");
        this.standardHeaders.add("cfloat");
        this.standardHeaders.add("ciso646");
        this.standardHeaders.add("climits");
        this.standardHeaders.add("clocale");
        this.standardHeaders.add("cmath");
        this.standardHeaders.add("csetjmp");
        this.standardHeaders.add("csignal");
        this.standardHeaders.add("cstdarg");
        this.standardHeaders.add("cstddef");
        this.standardHeaders.add("cstdio");
        this.standardHeaders.add("cstdlib");
        this.standardHeaders.add("cstring");
        this.standardHeaders.add("ctime");
        this.standardHeaders.add("cwchar");
        this.standardHeaders.add("cwctype");
        this.standardHeaders.add("assert.h");
        this.standardHeaders.add("ctype.h");
        this.standardHeaders.add("errno.h");
        this.standardHeaders.add("float.h");
        this.standardHeaders.add("iso646.h");
        this.standardHeaders.add("limits.h");
        this.standardHeaders.add("locale.h");
        this.standardHeaders.add("math.h");
        this.standardHeaders.add("setjmp.h");
        this.standardHeaders.add("signal.h");
        this.standardHeaders.add("stdarg.h");
        this.standardHeaders.add("stddef.h");
        this.standardHeaders.add("stdio.h");
        this.standardHeaders.add("stdlib.h");
        this.standardHeaders.add("string.h");
        this.standardHeaders.add("time.h");
        this.standardHeaders.add("wchar.h");
        this.standardHeaders.add("wctype.h");
    }

    public String getIncludeDirective(CsmFile csmFile, CsmObject csmObject) {
        if (CsmKindUtilities.isOffsetable((Object)csmObject)) {
            CsmFile csmFile2 = ((CsmOffsetable)csmObject).getContainingFile();
            if (csmFile2 != null) {
                Collection collection;
                if (csmFile2.equals(csmFile) || csmFile2.isHeaderFile()) {
                    return this.getIncludeDirectiveByFile(csmFile, csmObject).replace('\\', '/');
                }
                if (csmFile2.isSourceFile() && CsmKindUtilities.isGlobalVariable((CsmObject)csmObject) && !(collection = csmFile2.getProject().findDeclarations((CharSequence)(((CsmVariable)csmObject).getUniqueName() + " (EXTERN)"))).isEmpty()) {
                    return this.getIncludeDirectiveByFile(csmFile, (CsmObject)collection.iterator().next()).replace('\\', '/');
                }
            } else {
                System.err.println("can not find for item " + csmObject);
            }
        } else if (!CsmKindUtilities.isNamespace((Object)csmObject)) {
            System.err.println("not yet handled object " + csmObject);
        }
        return "";
    }

    private boolean isStandardHeader(List<FSPath> list, CsmFile csmFile) {
        String string = this.getRelativePath(list, ((Object)csmFile.getAbsolutePath()).toString());
        return this.standardHeaders.contains(((Object)csmFile.getAbsolutePath()).toString().substring(string.length() + 1));
    }

    private CsmFile getStandardHeaderIfExists(CsmFile csmFile, List<FSPath> list, CsmFile csmFile2, HashSet<CsmFile> hashSet) {
        if (hashSet.contains(csmFile2) || !this.isSystemHeader(csmFile, csmFile2)) {
            return null;
        }
        hashSet.add(csmFile2);
        if (this.isStandardHeader(list, csmFile2)) {
            return csmFile2;
        }
        CsmIncludeHierarchyResolver csmIncludeHierarchyResolver = CsmIncludeHierarchyResolver.getDefault();
        Collection collection = csmIncludeHierarchyResolver.getFiles(csmFile2);
        for (CsmFile csmFile3 : collection) {
            CsmFile csmFile4 = this.getStandardHeaderIfExists(csmFile, list, csmFile3, hashSet);
            if (csmFile4 == null) continue;
            return csmFile4;
        }
        return null;
    }

    private String getIncludeDirectiveByFile(CsmFile csmFile, CsmObject csmObject) {
        if (CsmKindUtilities.isOffsetable((Object)csmObject)) {
            if (csmFile instanceof FileImpl) {
                NativeFileItem nativeFileItem = ((FileImpl)csmFile).getNativeFileItem();
                CsmFile csmFile2 = ((CsmOffsetable)csmObject).getContainingFile();
                String string = ((Object)csmFile2.getAbsolutePath()).toString();
                StringBuilder stringBuilder = new StringBuilder("#include ");
                if (nativeFileItem != null) {
                    if (this.isSystemHeader(csmFile, ((CsmOffsetable)csmObject).getContainingFile())) {
                        String string2;
                        HashSet<CsmFile> hashSet = new HashSet<CsmFile>();
                        CsmFile csmFile3 = this.getStandardHeaderIfExists(csmFile, nativeFileItem.getSystemIncludePaths(), ((CsmOffsetable)csmObject).getContainingFile(), hashSet);
                        if (csmFile3 != null) {
                            string = ((Object)csmFile3.getAbsolutePath()).toString();
                        }
                        if (!(string2 = this.getRelativePath(nativeFileItem.getSystemIncludePaths(), string)).equals("")) {
                            stringBuilder.append("<");
                            stringBuilder.append(CndPathUtilitities.toRelativePath((String)string2, (String)string));
                            stringBuilder.append(">");
                            return stringBuilder.toString();
                        }
                    } else {
                        String string3;
                        stringBuilder.append("\"");
                        String string4 = ((Object)csmFile.getAbsolutePath()).toString().substring(0, ((Object)csmFile.getAbsolutePath()).toString().length() - ((Object)csmFile.getName()).toString().length() - 1);
                        if (!string.startsWith(string4)) {
                            string4 = "";
                        }
                        if ((string3 = this.getRelativePath(nativeFileItem.getUserIncludePaths(), string)).length() < string4.length()) {
                            stringBuilder.append(CndPathUtilitities.toRelativePath((String)string4, (String)string));
                        } else {
                            stringBuilder.append(CndPathUtilitities.toRelativePath((String)string3, (String)string));
                        }
                        if (!string3.equals("") || !string4.equals("")) {
                            stringBuilder.append("\"");
                            return stringBuilder.toString();
                        }
                    }
                } else {
                    String string5 = ((Object)csmFile.getAbsolutePath()).toString().substring(0, ((Object)csmFile.getAbsolutePath()).toString().length() - ((Object)csmFile.getName()).toString().length());
                    if (string.startsWith(string5)) {
                        stringBuilder.append("\"");
                        stringBuilder.append(string.substring(string5.length()));
                        stringBuilder.append("\"");
                        return stringBuilder.toString();
                    }
                }
            } else {
                System.err.println("not handled file instance " + csmFile);
            }
        } else if (!CsmKindUtilities.isNamespace((Object)csmObject)) {
            System.err.println("not yet handled object " + csmObject);
        }
        return "";
    }

    public String getLocalIncludeDerectiveByFilePath(String string, CsmObject csmObject) {
        if (CsmKindUtilities.isOffsetable((Object)csmObject)) {
            CsmFile csmFile = ((CsmOffsetable)csmObject).getContainingFile();
            if (csmFile != null) {
                if (csmFile.isHeaderFile()) {
                    return this.getLocalIncludeDerectiveByHeaderFilePath(string, csmObject).replace('\\', '/');
                }
                if (csmFile.isSourceFile() && CsmKindUtilities.isGlobalVariable((CsmObject)csmObject)) {
                    Collection collection = csmFile.getProject().findDeclarations((CharSequence)(((CsmVariable)csmObject).getUniqueName() + " (EXTERN)"));
                    if (!collection.isEmpty()) {
                        return this.getLocalIncludeDerectiveByHeaderFilePath(string, (CsmObject)collection.iterator().next()).replace('\\', '/');
                    }
                } else if (csmFile.isSourceFile() && CsmKindUtilities.isFunctionDefinition((CsmObject)csmObject)) {
                    return this.getLocalIncludeDerectiveByHeaderFilePath(string, (CsmObject)((CsmFunction)csmObject).getDeclaration()).replace('\\', '/');
                }
            } else {
                System.err.println("can not find for item " + csmObject);
            }
        } else if (!CsmKindUtilities.isNamespace((Object)csmObject)) {
            System.err.println("not yet handled object " + csmObject);
        }
        return "";
    }

    public String getLocalIncludeDerectiveByHeaderFilePath(String string, CsmObject csmObject) {
        CsmFile csmFile = ((CsmOffsetable)csmObject).getContainingFile();
        if (csmFile.isHeaderFile()) {
            String string2 = ((Object)csmFile.getAbsolutePath()).toString();
            StringBuilder stringBuilder = new StringBuilder("#include ");
            stringBuilder.append("\"");
            String string3 = string;
            if (!string2.startsWith(string3)) {
                string3 = "";
            }
            stringBuilder.append(CndPathUtilitities.toRelativePath((String)string3, (String)string2));
            if (!string3.equals("")) {
                stringBuilder.append("\"");
                return stringBuilder.toString();
            }
        }
        return "";
    }

    private String getRelativePath(List<FSPath> list, String string) {
        String string2 = "";
        for (FSPath fSPath : list) {
            String string3 = fSPath.getPath();
            if (!string.startsWith(string3) || string2.length() >= string3.length()) continue;
            string2 = string3;
        }
        return string2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isObjectVisible(CsmFile csmFile, CsmObject csmObject) {
        if (CsmKindUtilities.isOffsetable((Object)csmObject)) {
            CsmFile csmFile2 = ((CsmOffsetable)csmObject).getContainingFile();
            if (csmFile2 == null) return false;
            if (csmFile2.equals(csmFile)) return true;
            if (csmFile2.isHeaderFile()) {
                if (!((ProjectBase)csmFile.getProject()).getGraphStorage().isFileIncluded(csmFile, csmFile2)) return false;
                return true;
            }
            if (!csmFile2.isSourceFile() || !CsmKindUtilities.isGlobalVariable((CsmObject)csmObject)) return false;
            HashSet<CsmProject> hashSet = new HashSet<CsmProject>();
            if (!this.isVariableVisible(csmFile, csmFile2.getProject(), (CsmVariable)csmObject, hashSet)) return false;
            return true;
        }
        if (CsmKindUtilities.isNamespace((Object)csmObject)) return false;
        System.err.println("not yet handled object " + csmObject);
        return false;
    }

    private boolean isVariableVisible(CsmFile csmFile, CsmProject csmProject, CsmVariable csmVariable, HashSet<CsmProject> hashSet) {
        if (hashSet.contains(csmProject)) {
            return false;
        }
        hashSet.add(csmProject);
        if (this.isVariableDeclarationsVisible(csmFile, csmProject.findDeclarations((CharSequence)(csmVariable.getUniqueName() + " (EXTERN)")))) {
            return true;
        }
        if (this.isVariableDeclarationsVisible(csmFile, csmProject.findDeclarations(csmVariable.getUniqueName()))) {
            return true;
        }
        for (CsmProject csmProject2 : csmProject.getLibraries()) {
            if (!this.isVariableVisible(csmFile, csmProject2, csmVariable, hashSet)) continue;
            return true;
        }
        return false;
    }

    private boolean isVariableDeclarationsVisible(CsmFile csmFile, Collection<CsmOffsetableDeclaration> collection) {
        for (CsmOffsetableDeclaration csmOffsetableDeclaration : collection) {
            if (csmOffsetableDeclaration.getContainingFile().equals(csmFile)) {
                return true;
            }
            if (!((ProjectBase)csmFile.getProject()).getGraphStorage().isFileIncluded(csmFile, csmOffsetableDeclaration.getContainingFile())) continue;
            return true;
        }
        return false;
    }

    private boolean isSystemHeader(CsmFile csmFile, CsmFile csmFile2) {
        return !csmFile.getProject().equals(csmFile2.getProject());
    }
}

